/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.UIBundle;
import java.awt.event.MouseListener;
import java.io.File;
import javax.swing.KeyStroke;
import javax.swing.text.JTextComponent;
import org.jetbrains.annotations.NotNull;

public class InsertPathAction
extends AnAction {
    private static final Logger LOG = Logger.getInstance(InsertPathAction.class);
    protected final JTextComponent myTextField;
    protected static final CustomShortcutSet CTRL_F = new CustomShortcutSet(KeyStroke.getKeyStroke(70, 128));
    protected final FileChooserDescriptor myDescriptor;
    protected final boolean myInsertSystemDependentPaths;
    private MouseListener myPopupHandler;
    protected static final Key INSERT_PATH_ACTION = Key.create("insertPathAction");

    private InsertPathAction(JTextComponent textField2, FileChooserDescriptor descriptor2, boolean insertSystemDependentPaths) {
        super(UIBundle.messagePointer("insert.file.path.to.text.action.name", new Object[0]));
        this.myTextField = textField2;
        this.myInsertSystemDependentPaths = insertSystemDependentPaths;
        this.registerCustomShortcutSet(CTRL_F, this.myTextField);
        this.myDescriptor = descriptor2;
    }

    @Override
    public void actionPerformed(@NotNull AnActionEvent e) {
        String selectedText;
        if (e == null) {
            InsertPathAction.$$$reportNull$$$0(0);
        }
        VirtualFile virtualFile2 = (selectedText = this.myTextField.getSelectedText()) != null ? LocalFileSystem.getInstance().findFileByPath(selectedText.replace(File.separatorChar, '/')) : null;
        VirtualFile[] files2 = FileChooser.chooseFiles(this.myDescriptor, this.myTextField, InsertPathAction.getEventProject(e), virtualFile2);
        if (files2.length != 0) {
            String path2 = files2[0].getPath();
            this.myTextField.replaceSelection(this.myInsertSystemDependentPaths ? FileUtil.toSystemDependentName(path2) : path2);
        }
    }

    private void uninstall() {
        this.uninstallPopupHandler();
        this.unregisterCustomShortcutSet(this.myTextField);
        this.myTextField.putClientProperty(INSERT_PATH_ACTION, null);
    }

    private void savePopupHandler(MouseListener popupHandler) {
        if (this.myPopupHandler != null) {
            LOG.error("Installed twice");
            this.uninstallPopupHandler();
        }
        this.myPopupHandler = popupHandler;
    }

    private void uninstallPopupHandler() {
        if (this.myPopupHandler == null) {
            return;
        }
        this.myTextField.removeMouseListener(this.myPopupHandler);
        this.myPopupHandler = null;
    }

    public static void addTo(JTextComponent textField2) {
        InsertPathAction.addTo(textField2, null);
    }

    public static void addTo(JTextComponent textField2, FileChooserDescriptor descriptor2) {
        InsertPathAction.addTo(textField2, descriptor2, true);
    }

    public static void addTo(JTextComponent textField2, FileChooserDescriptor descriptor2, boolean insertSystemDependentPaths) {
        if (ApplicationManager.getApplication() != null) {
            InsertPathAction.removeFrom(textField2);
            if (textField2.getClientProperty(INSERT_PATH_ACTION) != null) {
                return;
            }
            DefaultActionGroup actionGroup = new DefaultActionGroup();
            InsertPathAction action2 = new InsertPathAction(textField2, descriptor2 != null ? descriptor2 : FileChooserDescriptorFactory.createSingleLocalFileDescriptor(), insertSystemDependentPaths);
            actionGroup.add(action2);
            MouseListener popupHandler = PopupHandler.installUnknownPopupHandler(textField2, actionGroup, ActionManager.getInstance());
            action2.savePopupHandler(popupHandler);
            textField2.putClientProperty(INSERT_PATH_ACTION, action2);
        }
    }

    public static void removeFrom(JTextComponent textComponent) {
        InsertPathAction action2 = InsertPathAction.getFrom(textComponent);
        if (action2 == null) {
            return;
        }
        action2.uninstall();
    }

    public static void copyFromTo(JTextComponent original, JTextComponent target2) {
        InsertPathAction action2 = InsertPathAction.getFrom(original);
        if (action2 == null) {
            return;
        }
        InsertPathAction.removeFrom(target2);
        InsertPathAction.addTo(target2, action2.myDescriptor);
    }

    private static InsertPathAction getFrom(JTextComponent textComponent) {
        Object property = textComponent.getClientProperty(INSERT_PATH_ACTION);
        if (!(property instanceof InsertPathAction)) {
            return null;
        }
        return (InsertPathAction)property;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ui/InsertPathAction", "actionPerformed"));
    }
}

