/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.ide.ui.UINumericRange;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;

public class JBIntSpinner
extends JSpinner {
    public JBIntSpinner(UINumericRange range2) {
        this(range2.initial, range2.min, range2.max);
    }

    public JBIntSpinner(int value2, int minValue, int maxValue) {
        this(value2, minValue, maxValue, 1);
    }

    public JBIntSpinner(int value2, int minValue, int maxValue, int stepSize) {
        this.setModel(new SpinnerNumberModel(value2, minValue, maxValue, stepSize));
        JSpinner.NumberEditor editor = new JSpinner.NumberEditor((JSpinner)this, "#");
        JFormattedTextField textField2 = editor.getTextField();
        textField2.setColumns(Math.max(4, textField2.getColumns()));
        if (UIUtil.isUnderWin10LookAndFeel()) {
            textField2.setHorizontalAlignment(2);
        }
        this.setEditor(editor);
        MyListener listener2 = new MyListener();
        this.addMouseWheelListener(listener2);
        textField2.addFocusListener(listener2);
        textField2.addMouseListener(listener2);
        this.addMouseListener(listener2);
    }

    @Override
    public void setEditor(JComponent editor) {
        if (!(editor instanceof JSpinner.NumberEditor)) {
            throw new IllegalArgumentException("JBSpinner allows NumberEditor only");
        }
        super.setEditor(editor);
    }

    @NotNull
    private JTextField getTextField() {
        JFormattedTextField jFormattedTextField = ((JSpinner.NumberEditor)this.getEditor()).getTextField();
        if (jFormattedTextField == null) {
            JBIntSpinner.$$$reportNull$$$0(0);
        }
        return jFormattedTextField;
    }

    private SpinnerNumberModel getNumberModel() {
        return (SpinnerNumberModel)super.getModel();
    }

    public void setMin(int value2) {
        this.getNumberModel().setMinimum(Integer.valueOf(value2));
    }

    public void setMax(int value2) {
        this.getNumberModel().setMaximum(Integer.valueOf(value2));
    }

    public int getMin() {
        return ((Number)((Object)this.getNumberModel().getMinimum())).intValue();
    }

    public int getMax() {
        return ((Number)((Object)this.getNumberModel().getMaximum())).intValue();
    }

    public void setNumber(int value2) {
        this.setValue(Math.max(this.getMin(), Math.min(this.getMax(), value2)));
    }

    public int getNumber() {
        return this.getNumberModel().getNumber().intValue();
    }

    private static Number calculateNewValue(SpinnerNumberModel model, int steps) {
        int newValue = ((Number)model.getValue()).intValue() + model.getStepSize().intValue() * steps;
        Comparable<?> minimum = model.getMinimum();
        Comparable<?> maximum = model.getMaximum();
        if (minimum instanceof Number && minimum.compareTo(newValue) > 0) {
            return (Number)((Object)minimum);
        }
        if (maximum instanceof Number && maximum.compareTo(newValue) < 0) {
            return (Number)((Object)maximum);
        }
        return newValue;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/JBIntSpinner", "getTextField"));
    }

    private class MyListener
    extends MouseAdapter
    implements FocusListener {
        private boolean mySelect = true;

        private MyListener() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            JTextField textField2;
            this.mySelect = false;
            Component component2 = e.getComponent();
            if (component2 == JBIntSpinner.this && (textField2 = JBIntSpinner.this.getTextField()).isEnabled()) {
                MouseEvent event = SwingUtilities.convertMouseEvent(component2, e, textField2);
                IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus(textField2, true));
                SwingUtilities.invokeLater(() -> textField2.dispatchEvent(event));
            }
        }

        @Override
        public void focusGained(FocusEvent e) {
            if (!this.mySelect) {
                this.mySelect = true;
                return;
            }
            SwingUtilities.invokeLater(() -> JBIntSpinner.this.getTextField().selectAll());
        }

        @Override
        public void focusLost(FocusEvent e) {
            this.mySelect = true;
        }

        @Override
        public void mouseWheelMoved(MouseWheelEvent e) {
            if (e.getUnitsToScroll() == 0) {
                return;
            }
            JTextField field = JBIntSpinner.this.getTextField();
            SpinnerNumberModel model = JBIntSpinner.this.getNumberModel();
            if (field.hasFocus() && JBIntSpinner.this.isEnabled()) {
                model.setValue(JBIntSpinner.calculateNewValue(model, e.getUnitsToScroll()));
            }
        }
    }
}

