/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.ide.highlighter.HighlighterFactory;
import com.intellij.lang.Language;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.ui.EditorTextField;
import com.intellij.util.LocalTimeCounter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LanguageTextField
extends EditorTextField {
    private final Language myLanguage;
    private final Project myProject;

    public LanguageTextField() {
        this(null, null, "");
    }

    public LanguageTextField(Language language2, @Nullable Project project2, @NotNull String value2) {
        if (value2 == null) {
            LanguageTextField.$$$reportNull$$$0(0);
        }
        this(language2, project2, value2, true);
    }

    public LanguageTextField(Language language2, @Nullable Project project2, @NotNull String value2, boolean oneLineMode) {
        if (value2 == null) {
            LanguageTextField.$$$reportNull$$$0(1);
        }
        this(language2, project2, value2, new SimpleDocumentCreator(), oneLineMode);
    }

    public LanguageTextField(@Nullable Language language2, @Nullable Project project2, @NotNull String value2, @NotNull DocumentCreator documentCreator) {
        if (value2 == null) {
            LanguageTextField.$$$reportNull$$$0(2);
        }
        if (documentCreator == null) {
            LanguageTextField.$$$reportNull$$$0(3);
        }
        this(language2, project2, value2, documentCreator, true);
    }

    public LanguageTextField(@Nullable Language language2, @Nullable Project project2, @NotNull String value2, @NotNull DocumentCreator documentCreator, boolean oneLineMode) {
        if (value2 == null) {
            LanguageTextField.$$$reportNull$$$0(4);
        }
        if (documentCreator == null) {
            LanguageTextField.$$$reportNull$$$0(5);
        }
        super(documentCreator.createDocument(value2, language2, project2), project2, language2 != null ? language2.getAssociatedFileType() : StdFileTypes.PLAIN_TEXT, language2 == null, oneLineMode);
        this.myLanguage = language2;
        this.myProject = project2;
        this.setEnabled(language2 != null);
    }

    public static Document createDocument(String value2, @Nullable Language language2, @Nullable Project project2, @NotNull SimpleDocumentCreator documentCreator) {
        if (documentCreator == null) {
            LanguageTextField.$$$reportNull$$$0(6);
        }
        if (language2 != null) {
            if (project2 == null) {
                project2 = ProjectManager.getInstance().getDefaultProject();
            }
            PsiFileFactory factory = PsiFileFactory.getInstance(project2);
            LanguageFileType fileType = language2.getAssociatedFileType();
            assert (fileType != null);
            long stamp = LocalTimeCounter.currentTime();
            PsiFile psiFile = factory.createFileFromText("Dummy." + fileType.getDefaultExtension(), fileType, (CharSequence)value2, stamp, true, false);
            documentCreator.customizePsiFile(psiFile);
            Document document = PsiDocumentManager.getInstance(project2).getDocument(psiFile);
            assert (document != null);
            return document;
        }
        return EditorFactory.getInstance().createDocument(value2);
    }

    @Override
    protected EditorEx createEditor() {
        EditorEx ex = super.createEditor();
        if (this.myLanguage != null) {
            LanguageFileType fileType = this.myLanguage.getAssociatedFileType();
            ex.setHighlighter(HighlighterFactory.createHighlighter(this.myProject, fileType));
        }
        ex.setEmbeddedIntoDialogWrapper(true);
        return ex;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 3: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "documentCreator";
                break;
            }
        }
        objectArray2[1] = "com/intellij/ui/LanguageTextField";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "createDocument";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class SimpleDocumentCreator
    implements DocumentCreator {
        @Override
        public Document createDocument(String value2, @Nullable Language language2, Project project2) {
            return LanguageTextField.createDocument(value2, language2, project2, this);
        }

        public void customizePsiFile(PsiFile file2) {
        }
    }

    public static interface DocumentCreator {
        public Document createDocument(String var1, @Nullable Language var2, Project var3);
    }
}

