/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.openapi.util.Pair;
import com.intellij.ui.AnchorableComponent;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.PanelWithAnchor;
import com.intellij.ui.border.IdeaTitledBorder;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.Nullable;

public class OptionGroup
implements PanelWithAnchor {
    private final String myTitle;
    private final List<Object> myOptions = new ArrayList<Object>();
    private final BitSet myIndented = new BitSet();
    private JComponent myAnchor;

    public OptionGroup() {
        this(null);
    }

    public OptionGroup(@Nullable String title) {
        this.myTitle = title;
    }

    public void add(JComponent component2) {
        this.add(component2, false);
    }

    public void add(JComponent component2, boolean indented) {
        this.myOptions.add(component2);
        this.myIndented.set(this.myOptions.size() - 1, indented);
    }

    public void add(JComponent leftComponent, JComponent rightComponent) {
        this.add(leftComponent, rightComponent, false);
    }

    public void add(JComponent leftComponent, JComponent rightComponent, boolean indented) {
        this.myOptions.add(Pair.pair(leftComponent, rightComponent));
        this.myIndented.set(this.myOptions.size() - 1, indented);
    }

    public JPanel createPanel() {
        JPanel panel2 = new JPanel();
        panel2.setLayout(new GridBagLayout());
        for (int i = 0; i < this.myOptions.size(); ++i) {
            int top = i == 0 ? 0 : 4;
            int left = this.myIndented.get(i) ? 20 : 0;
            Object option2 = this.myOptions.get(i);
            if (option2 instanceof JComponent) {
                JComponent component2 = (JComponent)option2;
                panel2.add((Component)component2, new GridBagConstraints(0, i, 0, 1, 1.0, 0.0, 17, OptionGroup.getFill(component2), JBUI.insets(top, left, 0, 0), 0, 0));
                continue;
            }
            JComponent first = (JComponent)((Pair)option2).first;
            panel2.add((Component)first, new GridBagConstraints(0, i, 1, 1, 1.0, 0.0, 17, OptionGroup.getFill(first), JBUI.insets(top, left, 0, 0), 0, 0));
            JComponent second = (JComponent)((Pair)option2).second;
            panel2.add((Component)second, new GridBagConstraints(1, i, 1, 1, 1.0, 0.0, 13, 2, JBUI.insets(top, 10, 0, 0), 0, 0));
            if (!(first instanceof JLabel)) continue;
            ((JLabel)first).setLabelFor(second);
        }
        JPanel p = new JPanel();
        p.setPreferredSize(new Dimension(0, 0));
        panel2.add((Component)p, new GridBagConstraints(0, this.myOptions.size(), 0, 1, 0.0, 1.0, 11, 0, JBUI.emptyInsets(), 0, 0));
        if (this.myTitle != null) {
            IdeaTitledBorder titledBorder = IdeBorderFactory.createTitledBorder(this.myTitle, true);
            panel2.setBorder(titledBorder);
            titledBorder.acceptMinimumSize(panel2);
        }
        return panel2;
    }

    private static int getFill(JComponent component2) {
        return component2 instanceof JCheckBox ? 0 : 2;
    }

    @Override
    public JComponent getAnchor() {
        return this.myAnchor;
    }

    @Override
    public void setAnchor(@Nullable JComponent anchor2) {
        this.myAnchor = anchor2;
        for (Object o : this.myOptions) {
            if (!(o instanceof Pair) || !(((Pair)o).first instanceof AnchorableComponent)) continue;
            ((AnchorableComponent)((Pair)o).first).setAnchor(anchor2);
        }
    }

    public JComponent[] getComponents() {
        ArrayList<JComponent> components = new ArrayList<JComponent>();
        for (Object o : this.myOptions) {
            if (o instanceof Pair) {
                components.add((JComponent)((Pair)o).first);
                components.add((JComponent)((Pair)o).second);
                continue;
            }
            components.add((JComponent)o);
        }
        return components.toArray(new JComponent[0]);
    }

    @Nullable
    public JComponent findAnchor() {
        double maxWidth = -1.0;
        JComponent anchor2 = null;
        for (Object o : this.myOptions) {
            JComponent component2;
            if (!(o instanceof Pair) || !(((Pair)o).first instanceof AnchorableComponent) || !(((Pair)o).first instanceof JComponent) || !((component2 = (JComponent)((Pair)o).first).getPreferredSize().getWidth() > maxWidth)) continue;
            maxWidth = component2.getPreferredSize().getWidth();
            anchor2 = component2;
        }
        return anchor2;
    }
}

