/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.OrderPanelListener;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.TableUtil;
import com.intellij.ui.UIBundle;
import com.intellij.ui.table.JBTable;
import com.intellij.util.containers.ContainerUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;

public abstract class OrderPanel<T>
extends JPanel {
    private String CHECKBOX_COLUMN_NAME;
    private final Class<T> myEntryClass;
    private final JTable myEntryTable;
    private final List<OrderPanelListener> myListeners = ContainerUtil.createLockFreeCopyOnWriteList();
    private boolean myEntryEditable = false;
    private int myInsideMove = 0;

    protected OrderPanel(Class<T> entryClass) {
        this(entryClass, true);
    }

    protected OrderPanel(Class<T> entryClass, boolean showCheckboxes) {
        super(new BorderLayout());
        this.myEntryClass = entryClass;
        this.myEntryTable = new JBTable(new MyTableModel(showCheckboxes));
        this.myEntryTable.setShowGrid(false);
        this.myEntryTable.setDragEnabled(false);
        this.myEntryTable.setShowHorizontalLines(false);
        this.myEntryTable.setShowVerticalLines(false);
        this.myEntryTable.setIntercellSpacing(new Dimension(0, 0));
        this.myEntryTable.getSelectionModel().setSelectionMode(2);
        this.myEntryTable.registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (OrderPanel.this.getCheckboxColumn() == -1) {
                    return;
                }
                int[] selectedRows = OrderPanel.this.myEntryTable.getSelectedRows();
                boolean currentlyMarked = true;
                for (int selectedRow : selectedRows) {
                    if (selectedRow < 0 || !OrderPanel.this.myEntryTable.isCellEditable(selectedRow, OrderPanel.this.getCheckboxColumn())) {
                        return;
                    }
                    currentlyMarked &= ((Boolean)OrderPanel.this.myEntryTable.getValueAt(selectedRow, OrderPanel.this.getCheckboxColumn())).booleanValue();
                }
                for (int selectedRow : selectedRows) {
                    OrderPanel.this.myEntryTable.setValueAt(currentlyMarked ? Boolean.FALSE : Boolean.TRUE, selectedRow, OrderPanel.this.getCheckboxColumn());
                }
            }
        }, KeyStroke.getKeyStroke(32, 0), 0);
        this.add((Component)ScrollPaneFactory.createScrollPane(this.myEntryTable), "Center");
        if (this.myEntryTable.getRowCount() > 0) {
            this.myEntryTable.getSelectionModel().setSelectionInterval(0, 0);
        }
    }

    public void setEntriesEditable(boolean entryEditable) {
        this.myEntryEditable = entryEditable;
    }

    public void setCheckboxColumnName(String name) {
        TableColumn checkboxColumn = this.myEntryTable.getColumnModel().getColumn(this.getCheckboxColumn());
        if (StringUtil.isEmpty(name)) {
            this.CHECKBOX_COLUMN_NAME = "";
            TableUtil.setupCheckboxColumn(checkboxColumn);
        } else {
            this.CHECKBOX_COLUMN_NAME = name;
            FontMetrics fontMetrics = this.myEntryTable.getFontMetrics(this.myEntryTable.getFont());
            int width = fontMetrics.stringWidth(" " + name + " ") + 4;
            checkboxColumn.setWidth(width);
            checkboxColumn.setPreferredWidth(width);
            checkboxColumn.setMaxWidth(width);
            checkboxColumn.setMinWidth(width);
        }
    }

    public void moveSelectedItemsUp() {
        IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus(this.myEntryTable, true));
        try {
            ++this.myInsideMove;
            TableUtil.moveSelectedItemsUp(this.myEntryTable);
        }
        finally {
            --this.myInsideMove;
        }
        for (OrderPanelListener orderPanelListener : this.myListeners) {
            orderPanelListener.entryMoved();
        }
    }

    public void moveSelectedItemsDown() {
        IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus(this.myEntryTable, true));
        try {
            ++this.myInsideMove;
            TableUtil.moveSelectedItemsDown(this.myEntryTable);
        }
        finally {
            --this.myInsideMove;
        }
        for (OrderPanelListener orderPanelListener : this.myListeners) {
            orderPanelListener.entryMoved();
        }
    }

    private boolean isInsideMove() {
        return this.myInsideMove != 0;
    }

    public void addListener(OrderPanelListener listener2) {
        this.myListeners.add(listener2);
    }

    public void removeListener(OrderPanelListener listener2) {
        this.myListeners.remove(listener2);
    }

    public JTable getEntryTable() {
        return this.myEntryTable;
    }

    public void clear() {
        MyTableModel model = this.getModel();
        while (model.getRowCount() > 0) {
            model.removeRow(0);
        }
    }

    public void remove(T orderEntry) {
        MyTableModel model = this.getModel();
        int rowCount = model.getRowCount();
        for (int i = 0; i < rowCount; ++i) {
            if (this.getValueAt(i) != orderEntry) continue;
            model.removeRow(i);
            return;
        }
    }

    public void add(T orderEntry) {
        MyTableModel model = this.getModel();
        if (this.getCheckboxColumn() == -1) {
            model.addRow(new Object[]{orderEntry});
        } else {
            model.addRow(new Object[]{this.isChecked(orderEntry) ? Boolean.TRUE : Boolean.FALSE, orderEntry});
        }
    }

    public void addAll(Collection<? extends T> orderEntries) {
        for (T orderEntry : orderEntries) {
            this.add(orderEntry);
        }
    }

    protected int getEntryColumn() {
        return this.getModel().getEntryColumn();
    }

    private int getCheckboxColumn() {
        return this.getModel().getCheckboxColumn();
    }

    private MyTableModel getModel() {
        MyTableModel model = (MyTableModel)this.myEntryTable.getModel();
        return model;
    }

    public T getValueAt(int row) {
        Object t = this.myEntryTable.getModel().getValueAt(row, this.getEntryColumn());
        return (T)t;
    }

    public abstract boolean isCheckable(T var1);

    public abstract boolean isChecked(T var1);

    public abstract void setChecked(T var1, boolean var2);

    public String getCheckboxColumnName() {
        if (this.CHECKBOX_COLUMN_NAME == null) {
            this.CHECKBOX_COLUMN_NAME = UIBundle.message("order.entries.panel.export.column.name", new Object[0]);
        }
        return this.CHECKBOX_COLUMN_NAME;
    }

    public List<T> getEntries() {
        TableModel model = this.myEntryTable.getModel();
        int size = model.getRowCount();
        ArrayList<T> result2 = new ArrayList<T>(size);
        for (int idx = 0; idx < size; ++idx) {
            result2.add(this.getValueAt(idx));
        }
        return result2;
    }

    private class MyTableModel
    extends DefaultTableModel {
        private final boolean myShowCheckboxes;

        MyTableModel(boolean showCheckboxes) {
            this.myShowCheckboxes = showCheckboxes;
        }

        private int getEntryColumn() {
            return this.getColumnCount() - 1;
        }

        private int getCheckboxColumn() {
            return this.getColumnCount() - 2;
        }

        @Override
        public String getColumnName(int column) {
            if (column == this.getEntryColumn()) {
                return "";
            }
            if (column == this.getCheckboxColumn()) {
                return OrderPanel.this.getCheckboxColumnName();
            }
            return null;
        }

        public Class getColumnClass(int column) {
            if (column == this.getEntryColumn()) {
                return OrderPanel.this.myEntryClass;
            }
            if (column == this.getCheckboxColumn()) {
                return Boolean.class;
            }
            return super.getColumnClass(column);
        }

        @Override
        public int getColumnCount() {
            return this.myShowCheckboxes ? 2 : 1;
        }

        @Override
        public boolean isCellEditable(int row, int column) {
            if (column == this.getCheckboxColumn()) {
                return OrderPanel.this.isCheckable(OrderPanel.this.getValueAt(row));
            }
            return OrderPanel.this.myEntryEditable;
        }

        @Override
        public void setValueAt(Object aValue, int row, int column) {
            super.setValueAt(aValue, row, column);
            if (!OrderPanel.this.isInsideMove() && column == this.getCheckboxColumn()) {
                OrderPanel.this.setChecked(OrderPanel.this.getValueAt(row), (Boolean)aValue);
            }
        }
    }
}

