/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Factory;
import com.intellij.ui.ListUtil;
import com.intellij.ui.ScrollingUtil;
import com.intellij.ui.SortedListModel;
import com.intellij.ui.UIBundle;
import com.intellij.util.IconUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.ListModel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ReorderableListController<T> {
    private final JList myList;
    private static final Icon REMOVE_ICON = IconUtil.getRemoveIcon();

    protected ReorderableListController(JList list2) {
        this.myList = list2;
    }

    public JList getList() {
        return this.myList;
    }

    public RemoveActionDescription addRemoveAction(String actionName) {
        RemoveActionDescription description = new RemoveActionDescription(actionName);
        this.addActionDescription(description);
        return description;
    }

    protected abstract void addActionDescription(ActionDescription var1);

    public AddActionDescription addAddAction(String actionName, Factory<? extends T> creator, boolean createShortcut) {
        AddActionDescription description = new AddActionDescription(actionName, creator, createShortcut);
        this.addActionDescription(description);
        return description;
    }

    public AddMultipleActionDescription addAddMultipleAction(String actionName, Factory<? extends Collection<T>> creator, boolean createShortcut) {
        AddMultipleActionDescription description = new AddMultipleActionDescription(actionName, creator, createShortcut);
        this.addActionDescription(description);
        return description;
    }

    public void addMoveUpAction() {
        this.addAction(new AnAction(UIBundle.messagePointer("move.up.action.name", new Object[0]), Presentation.NULL_STRING, IconUtil.getMoveUpIcon()){

            @Override
            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                ListUtil.moveSelectedItemsUp(ReorderableListController.this.myList);
            }

            @Override
            public void update(@NotNull AnActionEvent e) {
                if (e == null) {
                    1.$$$reportNull$$$0(1);
                }
                e.getPresentation().setEnabled(ListUtil.canMoveSelectedItemsUp(ReorderableListController.this.myList));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "e";
                objectArray2[1] = "com/intellij/ui/ReorderableListController$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "actionPerformed";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "update";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    public void addMoveDownAction() {
        this.addAction(new AnAction(UIBundle.messagePointer("move.down.action.name", new Object[0]), Presentation.NULL_STRING, AllIcons.Actions.MoveDown){

            @Override
            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    2.$$$reportNull$$$0(0);
                }
                ListUtil.moveSelectedItemsDown(ReorderableListController.this.myList);
            }

            @Override
            public void update(@NotNull AnActionEvent e) {
                if (e == null) {
                    2.$$$reportNull$$$0(1);
                }
                e.getPresentation().setEnabled(ListUtil.canMoveSelectedItemsDown(ReorderableListController.this.myList));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "e";
                objectArray2[1] = "com/intellij/ui/ReorderableListController$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "actionPerformed";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "update";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    public void addAction(AnAction action2) {
        this.addActionDescription(new FixedActionDescription(action2));
    }

    private void handleNewElement(T element2) {
        ListModel listModel = this.myList.getModel();
        if (listModel instanceof SortedListModel) {
            ((SortedListModel)listModel).add(element2);
        } else {
            ((DefaultListModel)listModel).addElement(element2);
        }
        this.myList.clearSelection();
        ScrollingUtil.selectItem(this.myList, element2);
    }

    public static <T> ReorderableListController<T> create(final JList list2, final DefaultActionGroup actionGroup) {
        return new ReorderableListController<T>(list2){

            @Override
            protected void addActionDescription(ActionDescription description) {
                actionGroup.add(description.createAction(list2));
            }
        };
    }

    private static class FixedActionDescription
    extends ActionDescription {
        private final AnAction myAction;

        FixedActionDescription(AnAction action2) {
            this.myAction = action2;
        }

        @Override
        public AnAction createAction(JComponent component2) {
            return this.myAction;
        }
    }

    public class AddMultipleActionDescription
    extends AddActionDescriptionBase<Collection<T>> {
        public AddMultipleActionDescription(String actionDescription, Factory<? extends Collection<T>> addHandler, boolean createShortcut) {
            super(actionDescription, addHandler, createShortcut);
        }

        @Override
        protected Collection<T> addInternal(Collection<T> t) {
            if (t != null) {
                for (Object element2 : t) {
                    ReorderableListController.this.handleNewElement(element2);
                }
            }
            return t;
        }
    }

    public class AddActionDescription
    extends AddActionDescriptionBase<T> {
        public AddActionDescription(String actionDescription, Factory<? extends T> addHandler, boolean createShortcut) {
            super(actionDescription, addHandler, createShortcut);
        }

        @Override
        protected T addInternal(T t) {
            if (t != null) {
                ReorderableListController.this.handleNewElement(t);
            }
            return t;
        }
    }

    public static abstract class AddActionDescriptionBase<V>
    extends CustomActionDescription<V> {
        private final String myActionDescription;
        private final Factory<? extends V> myAddHandler;
        private final boolean myCreateShortcut;
        private Icon myIcon = IconUtil.getAddIcon();

        public AddActionDescriptionBase(String actionDescription, Factory<? extends V> addHandler, boolean createShortcut) {
            this.myActionDescription = actionDescription;
            this.myAddHandler = addHandler;
            this.myCreateShortcut = createShortcut;
        }

        @Override
        public CustomActionDescription.BaseAction createAction(JComponent component2) {
            ActionBehaviour behaviour = new ActionBehaviour<V>(){

                @Override
                public V performAction(@NotNull AnActionEvent e) {
                    if (e == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return this.addInternal(myAddHandler.create());
                }

                @Override
                public void updateAction(@NotNull AnActionEvent e) {
                    if (e == null) {
                        1.$$$reportNull$$$0(1);
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    objectArray2[0] = "e";
                    objectArray2[1] = "com/intellij/ui/ReorderableListController$AddActionDescriptionBase$1";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "performAction";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[2] = "updateAction";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            };
            CustomActionDescription.BaseAction action2 = this.createAction(behaviour);
            if (this.myCreateShortcut) {
                action2.registerCustomShortcutSet(CommonShortcuts.INSERT, component2);
            }
            return action2;
        }

        @Nullable
        protected abstract V addInternal(V var1);

        @Override
        public Icon getActionIcon() {
            return this.myIcon;
        }

        @Override
        public String getActionName() {
            return this.myActionDescription;
        }

        public void setIcon(Icon icon2) {
            this.myIcon = icon2;
        }
    }

    public class RemoveActionDescription
    extends CustomActionDescription<List<T>> {
        private final String myActionName;
        private Condition<? super List<T>> myConfirmation;
        private Condition<? super T> myEnableCondition;

        public RemoveActionDescription(String actionName) {
            this.myActionName = actionName;
        }

        @Override
        public CustomActionDescription.BaseAction createAction(JComponent component2) {
            ActionBehaviour behaviour = new ActionBehaviour<List<T>>(){

                @Override
                public List<T> performAction(@NotNull AnActionEvent e) {
                    if (e == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (RemoveActionDescription.this.myConfirmation != null && !RemoveActionDescription.this.myConfirmation.value(Arrays.asList(ReorderableListController.this.myList.getSelectedValues()))) {
                        return Collections.emptyList();
                    }
                    return ListUtil.removeSelectedItems(ReorderableListController.this.myList, RemoveActionDescription.this.myEnableCondition);
                }

                @Override
                public void updateAction(@NotNull AnActionEvent e) {
                    if (e == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    e.getPresentation().setEnabled(ListUtil.canRemoveSelectedItems(ReorderableListController.this.myList, RemoveActionDescription.this.myEnableCondition));
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    objectArray2[0] = "e";
                    objectArray2[1] = "com/intellij/ui/ReorderableListController$RemoveActionDescription$1";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "performAction";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[2] = "updateAction";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            };
            CustomActionDescription.BaseAction action2 = this.createAction(behaviour);
            action2.registerCustomShortcutSet(CommonShortcuts.getDelete(), component2);
            return action2;
        }

        @Override
        protected Icon getActionIcon() {
            return REMOVE_ICON;
        }

        @Override
        protected String getActionName() {
            return this.myActionName;
        }

        public void setConfirmation(Condition<? super List<T>> confirmation) {
            this.myConfirmation = confirmation;
        }

        public void setEnableCondition(Condition<? super T> enableCondition) {
            this.myEnableCondition = enableCondition;
        }

        public JList getList() {
            return ReorderableListController.this.myList;
        }
    }

    static interface ActionBehaviour<T> {
        public T performAction(@NotNull AnActionEvent var1);

        public void updateAction(@NotNull AnActionEvent var1);
    }

    public static abstract class CustomActionDescription<V>
    extends ActionDescription {
        private final ArrayList<ActionNotification<V>> myPostHandlers = new ArrayList(1);
        private boolean myShowText = false;

        public void addPostHandler(ActionNotification<V> runnable2) {
            this.myPostHandlers.add(runnable2);
        }

        protected void runPostHandlers(V change) {
            for (ActionNotification<V> runnable2 : this.myPostHandlers) {
                runnable2.afterActionPerformed(change);
            }
        }

        @Override
        public abstract BaseAction createAction(JComponent var1);

        BaseAction createAction(ActionBehaviour behaviour) {
            return this.myShowText ? new ActionWithText(this, this.getActionName(), null, this.getActionIcon(), behaviour) : new BaseAction(this, this.getActionName(), null, this.getActionIcon(), behaviour);
        }

        protected abstract Icon getActionIcon();

        protected abstract String getActionName();

        public void setShowText(boolean showText) {
            this.myShowText = showText;
        }

        private static class ActionWithText<V>
        extends BaseAction {
            ActionWithText(CustomActionDescription<? super V> customActionDescription, String text2, String description, Icon icon2, ActionBehaviour<? extends V> behaviour) {
                super(customActionDescription, text2, description, icon2, behaviour);
            }

            @Override
            public boolean displayTextInToolbar() {
                return true;
            }
        }

        protected static class BaseAction<V>
        extends DumbAwareAction {
            private final ActionBehaviour<? extends V> myBehaviour;
            private final CustomActionDescription<? super V> myCustomActionDescription;

            public BaseAction(CustomActionDescription<? super V> customActionDescription, String text2, String description, Icon icon2, ActionBehaviour<? extends V> behaviour) {
                super(text2, description, icon2);
                this.myBehaviour = behaviour;
                this.myCustomActionDescription = customActionDescription;
            }

            @Override
            public void actionPerformed(@NotNull AnActionEvent e) {
                V change;
                if (e == null) {
                    BaseAction.$$$reportNull$$$0(0);
                }
                if ((change = this.myBehaviour.performAction(e)) == null) {
                    return;
                }
                this.myCustomActionDescription.runPostHandlers(change);
            }

            @Override
            public void update(@NotNull AnActionEvent e) {
                if (e == null) {
                    BaseAction.$$$reportNull$$$0(1);
                }
                this.myBehaviour.updateAction(e);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "e";
                objectArray2[1] = "com/intellij/ui/ReorderableListController$CustomActionDescription$BaseAction";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "actionPerformed";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "update";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }
    }

    public static interface ActionNotification<T> {
        public void afterActionPerformed(T var1);
    }

    protected static abstract class ActionDescription {
        protected ActionDescription() {
        }

        public abstract AnAction createAction(JComponent var1);
    }
}

