/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.ide.dnd.DnDDragStartBean;
import com.intellij.ide.dnd.DnDDropHandler;
import com.intellij.ide.dnd.DnDEvent;
import com.intellij.ide.dnd.DnDSupport;
import com.intellij.ide.dnd.DnDTargetChecker;
import com.intellij.ui.awt.RelativeRectangle;
import com.intellij.util.ui.EditableModel;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.TransferHandler;
import org.jetbrains.annotations.NotNull;

public class RowsDnDSupport {
    private RowsDnDSupport() {
    }

    public static void install(@NotNull JTable table, @NotNull EditableModel model) {
        if (table == null) {
            RowsDnDSupport.$$$reportNull$$$0(0);
        }
        if (model == null) {
            RowsDnDSupport.$$$reportNull$$$0(1);
        }
        table.setDragEnabled(true);
        RowsDnDSupport.installImpl(table, model);
    }

    public static void install(@NotNull JList list2, @NotNull EditableModel model) {
        if (list2 == null) {
            RowsDnDSupport.$$$reportNull$$$0(2);
        }
        if (model == null) {
            RowsDnDSupport.$$$reportNull$$$0(3);
        }
        list2.setDragEnabled(true);
        RowsDnDSupport.installImpl(list2, model);
    }

    public static void install(@NotNull JTree tree, @NotNull EditableModel model) {
        if (tree == null) {
            RowsDnDSupport.$$$reportNull$$$0(4);
        }
        if (model == null) {
            RowsDnDSupport.$$$reportNull$$$0(5);
        }
        tree.setDragEnabled(true);
        RowsDnDSupport.installImpl(tree, model);
    }

    private static void installImpl(final @NotNull JComponent component2, final @NotNull EditableModel model) {
        if (component2 == null) {
            RowsDnDSupport.$$$reportNull$$$0(6);
        }
        if (model == null) {
            RowsDnDSupport.$$$reportNull$$$0(7);
        }
        component2.setTransferHandler(new TransferHandler(null));
        DnDSupport.createBuilder(component2).setBeanProvider(info -> {
            Point p = info.getPoint();
            return new DnDDragStartBean(new RowDragInfo(component2, RowsDnDSupport.getRow(component2, p)));
        }).setTargetChecker(new DnDTargetChecker(){

            @Override
            public boolean update(DnDEvent event) {
                Object o = event.getAttachedObject();
                if (!(o instanceof RowDragInfo) || ((RowDragInfo)o).component != component2) {
                    event.setDropPossible(false, "");
                    return true;
                }
                event.setDropPossible(true);
                int oldIndex = ((RowDragInfo)o).row;
                int newIndex = RowsDnDSupport.getRow(component2, event.getPoint());
                if (newIndex == -1) {
                    event.setDropPossible(false, "");
                    return true;
                }
                Rectangle cellBounds = RowsDnDSupport.getCellBounds(component2, newIndex);
                if (model instanceof RefinedDropSupport) {
                    RefinedDropSupport.Position position = ((RefinedDropSupport)((Object)model)).isDropInto(component2, oldIndex, newIndex) ? RefinedDropSupport.Position.INTO : (event.getPoint().y < cellBounds.y + cellBounds.height / 2 ? RefinedDropSupport.Position.ABOVE : RefinedDropSupport.Position.BELOW);
                    boolean canDrop = ((RefinedDropSupport)((Object)model)).canDrop(oldIndex, newIndex, position);
                    event.setDropPossible(canDrop);
                    if (canDrop && oldIndex != newIndex) {
                        if (position == RefinedDropSupport.Position.BELOW) {
                            cellBounds.y += cellBounds.height - 2;
                        }
                        RelativeRectangle rectangle = new RelativeRectangle(component2, cellBounds);
                        switch (position) {
                            case INTO: {
                                event.setHighlighting(rectangle, 1);
                                break;
                            }
                            case ABOVE: 
                            case BELOW: {
                                rectangle.getDimension().height = 2;
                                event.setHighlighting(rectangle, 2);
                            }
                        }
                    } else {
                        event.hideHighlighter();
                    }
                } else if (oldIndex != newIndex) {
                    boolean canExchange = model.canExchangeRows(oldIndex, newIndex);
                    if (canExchange) {
                        if (oldIndex < newIndex) {
                            cellBounds.y += cellBounds.height - 2;
                        }
                        RelativeRectangle rectangle = new RelativeRectangle(component2, cellBounds);
                        rectangle.getDimension().height = 2;
                        event.setDropPossible(true);
                        event.setHighlighting(rectangle, 2);
                    } else {
                        event.setDropPossible(false);
                    }
                }
                return true;
            }
        }).setDropHandler(new DnDDropHandler(){

            @Override
            public void drop(DnDEvent event) {
                Object o = event.getAttachedObject();
                Point p = event.getPoint();
                if (o instanceof RowDragInfo && ((RowDragInfo)o).component == component2) {
                    int oldIndex = ((RowDragInfo)o).row;
                    if (oldIndex == -1) {
                        return;
                    }
                    int newIndex = RowsDnDSupport.getRow(component2, p);
                    if (newIndex == -1) {
                        newIndex = RowsDnDSupport.getRowCount(component2) - 1;
                    }
                    if (oldIndex != newIndex) {
                        if (model instanceof RefinedDropSupport) {
                            RefinedDropSupport.Position position;
                            Rectangle cellBounds = RowsDnDSupport.getCellBounds(component2, newIndex);
                            RefinedDropSupport.Position position2 = ((RefinedDropSupport)((Object)model)).isDropInto(component2, oldIndex, newIndex) ? RefinedDropSupport.Position.INTO : (position = event.getPoint().y < cellBounds.y + cellBounds.height / 2 ? RefinedDropSupport.Position.ABOVE : RefinedDropSupport.Position.BELOW);
                            if (((RefinedDropSupport)((Object)model)).canDrop(oldIndex, newIndex, position)) {
                                ((RefinedDropSupport)((Object)model)).drop(oldIndex, newIndex, position);
                            }
                        } else if (model.canExchangeRows(oldIndex, newIndex)) {
                            model.exchangeRows(oldIndex, newIndex);
                            RowsDnDSupport.setSelectedRow(component2, newIndex);
                        }
                    }
                }
                event.hideHighlighter();
            }
        }).install();
    }

    private static int getRow(JComponent component2, Point point) {
        if (component2 instanceof JTable) {
            return ((JTable)component2).rowAtPoint(point);
        }
        if (component2 instanceof JList) {
            return ((JList)component2).locationToIndex(point);
        }
        if (component2 instanceof JTree) {
            return ((JTree)component2).getClosestRowForLocation(point.x, point.y);
        }
        throw new IllegalArgumentException("Unsupported component: " + component2);
    }

    private static int getRowCount(JComponent component2) {
        if (component2 instanceof JTable) {
            return ((JTable)component2).getRowCount();
        }
        if (component2 instanceof JList) {
            return ((JList)component2).getModel().getSize();
        }
        if (component2 instanceof JTree) {
            return ((JTree)component2).getRowCount();
        }
        throw new IllegalArgumentException("Unsupported component: " + component2);
    }

    private static Rectangle getCellBounds(JComponent component2, int row) {
        if (component2 instanceof JTable) {
            Rectangle rectangle = ((JTable)component2).getCellRect(row, 0, true);
            rectangle.width = component2.getWidth();
            return rectangle;
        }
        if (component2 instanceof JList) {
            return ((JList)component2).getCellBounds(row, row);
        }
        if (component2 instanceof JTree) {
            return ((JTree)component2).getRowBounds(row);
        }
        throw new IllegalArgumentException("Unsupported component: " + component2);
    }

    private static void setSelectedRow(JComponent component2, int row) {
        if (component2 instanceof JTable) {
            ((JTable)component2).getSelectionModel().setSelectionInterval(row, row);
        } else if (component2 instanceof JList) {
            ((JList)component2).setSelectedIndex(row);
        } else if (component2 instanceof JTree) {
            ((JTree)component2).setSelectionRow(row);
        } else {
            throw new IllegalArgumentException("Unsupported component: " + component2);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "table";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tree";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
        }
        objectArray2[1] = "com/intellij/ui/RowsDnDSupport";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "install";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "installImpl";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static interface RefinedDropSupport {
        public boolean isDropInto(JComponent var1, int var2, int var3);

        public boolean canDrop(int var1, int var2, @NotNull Position var3);

        public void drop(int var1, int var2, @NotNull Position var3);

        public static enum Position {
            ABOVE,
            INTO,
            BELOW;

        }
    }

    private static class RowDragInfo {
        public final JComponent component;
        public final int row;

        RowDragInfo(JComponent component2, int row) {
            this.component = component2;
            this.row = row;
        }
    }
}

