/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.Patches;
import com.intellij.openapi.util.Pair;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBInsets;
import java.awt.Component;
import java.awt.Container;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.geom.Area;
import java.util.Map;
import javax.swing.JRootPane;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ScreenUtil {
    public static final String DISPOSE_TEMPORARY = "dispose.temporary";
    @Nullable
    private static final Map<GraphicsConfiguration, Pair<Insets, Long>> ourInsetsCache = Patches.isJdkBugId8004103() ? ContainerUtil.createWeakMap() : null;
    private static final int ourInsetsTimeout = 5000;

    private ScreenUtil() {
    }

    public static boolean isVisible(@NotNull Point location2) {
        if (location2 == null) {
            ScreenUtil.$$$reportNull$$$0(0);
        }
        return ScreenUtil.getScreenRectangle(location2).contains(location2);
    }

    public static boolean isVisible(@NotNull Rectangle bounds2) {
        Rectangle[] allScreenBounds;
        if (bounds2 == null) {
            ScreenUtil.$$$reportNull$$$0(1);
        }
        if (bounds2.isEmpty()) {
            return false;
        }
        for (Rectangle screenBounds : allScreenBounds = ScreenUtil.getAllScreenBounds()) {
            int sq2;
            int sq1;
            double visibleFraction;
            Rectangle intersection = screenBounds.intersection(bounds2);
            if (intersection.isEmpty() || !((visibleFraction = (double)(sq1 = intersection.width * intersection.height) / (double)(sq2 = bounds2.width * bounds2.height)) > 0.1)) continue;
            return true;
        }
        return false;
    }

    public static Rectangle getMainScreenBounds() {
        return ScreenUtil.getScreenRectangle(GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice());
    }

    private static Rectangle[] getAllScreenBounds() {
        GraphicsDevice[] devices = GraphicsEnvironment.getLocalGraphicsEnvironment().getScreenDevices();
        Rectangle[] result2 = new Rectangle[devices.length];
        for (int i = 0; i < devices.length; ++i) {
            result2[i] = ScreenUtil.getScreenRectangle(devices[i]);
        }
        return result2;
    }

    public static Shape getAllScreensShape() {
        GraphicsDevice[] devices = GraphicsEnvironment.getLocalGraphicsEnvironment().getScreenDevices();
        if (devices.length == 0) {
            return new Rectangle();
        }
        if (devices.length == 1) {
            return ScreenUtil.getScreenRectangle(devices[0]);
        }
        Area area = new Area();
        for (GraphicsDevice device : devices) {
            area.add(new Area(ScreenUtil.getScreenRectangle(device)));
        }
        return area;
    }

    public static Rectangle getAllScreensRectangle() {
        GraphicsDevice[] devices = GraphicsEnvironment.getLocalGraphicsEnvironment().getScreenDevices();
        if (devices.length == 0) {
            return new Rectangle();
        }
        if (devices.length == 1) {
            return ScreenUtil.getScreenRectangle(devices[0]);
        }
        int minX = 0;
        int maxX = 0;
        int minY = 0;
        int maxY = 0;
        for (GraphicsDevice device : devices) {
            int y;
            Rectangle rectangle = ScreenUtil.getScreenRectangle(device);
            int x = rectangle.x;
            if (minX > x) {
                minX = x;
            }
            if (maxX < (x += rectangle.width)) {
                maxX = x;
            }
            if (minY > (y = rectangle.y)) {
                minY = y;
            }
            if (maxY >= (y += rectangle.height)) continue;
            maxY = y;
        }
        return new Rectangle(minX, minY, maxX - minX, maxY - minY);
    }

    public static Rectangle getScreenRectangle(@NotNull Point p) {
        if (p == null) {
            ScreenUtil.$$$reportNull$$$0(2);
        }
        return ScreenUtil.getScreenRectangle(p.x, p.y);
    }

    public static Rectangle getScreenRectangle(@NotNull Component component2) {
        GraphicsConfiguration configuration;
        if (component2 == null) {
            ScreenUtil.$$$reportNull$$$0(3);
        }
        if ((configuration = component2.getGraphicsConfiguration()) != null) {
            return ScreenUtil.getScreenRectangle(configuration);
        }
        Point p = new Point();
        SwingUtilities.convertPointToScreen(p, component2);
        return ScreenUtil.getScreenRectangle(p);
    }

    public static GraphicsDevice getScreenDevice(Rectangle bounds2) {
        GraphicsDevice candidate = null;
        int maxIntersection = 0;
        for (GraphicsDevice device : GraphicsEnvironment.getLocalGraphicsEnvironment().getScreenDevices()) {
            GraphicsConfiguration config2 = device.getDefaultConfiguration();
            Rectangle rect = config2.getBounds();
            Rectangle intersection = rect.intersection(bounds2);
            if (intersection.isEmpty() || intersection.width * intersection.height <= maxIntersection) continue;
            maxIntersection = intersection.width * intersection.height;
            candidate = device;
        }
        return candidate;
    }

    public static boolean isStandardAddRemoveNotify(Component component2) {
        JRootPane rootPane = ScreenUtil.findMainRootPane(component2);
        return rootPane == null || rootPane.getClientProperty(DISPOSE_TEMPORARY) == null;
    }

    private static JRootPane findMainRootPane(Component component2) {
        while (component2 != null) {
            Container parent = component2.getParent();
            if (parent == null) {
                return component2 instanceof RootPaneContainer ? ((RootPaneContainer)((Object)component2)).getRootPane() : null;
            }
            component2 = parent;
        }
        return null;
    }

    private static Rectangle applyInsets(Rectangle rect, Insets i) {
        rect = new Rectangle(rect);
        JBInsets.removeFrom(rect, i);
        return rect;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Insets getScreenInsets(GraphicsConfiguration gc) {
        if (ourInsetsCache == null) {
            return ScreenUtil.calcInsets(gc);
        }
        Map<GraphicsConfiguration, Pair<Insets, Long>> map2 = ourInsetsCache;
        synchronized (map2) {
            Pair<Insets, Long> data2 = ourInsetsCache.get(gc);
            long now = System.currentTimeMillis();
            if (data2 == null || now > (Long)data2.second + 5000L) {
                data2 = Pair.create(ScreenUtil.calcInsets(gc), now);
                ourInsetsCache.put(gc, data2);
            }
            return (Insets)data2.first;
        }
    }

    private static Insets calcInsets(GraphicsConfiguration gc) {
        if (Patches.SUN_BUG_ID_8020443 && GraphicsEnvironment.getLocalGraphicsEnvironment().getScreenDevices().length > 1) {
            return new Insets(0, 0, 0, 0);
        }
        return Toolkit.getDefaultToolkit().getScreenInsets(gc);
    }

    private static Rectangle getScreenRectangle(GraphicsDevice device) {
        return ScreenUtil.getScreenRectangle(device.getDefaultConfiguration());
    }

    public static Rectangle getScreenRectangle(GraphicsConfiguration configuration) {
        return ScreenUtil.applyInsets(configuration.getBounds(), ScreenUtil.getScreenInsets(configuration));
    }

    public static Rectangle getScreenRectangle(int x, int y) {
        GraphicsDevice[] devices = GraphicsEnvironment.getLocalGraphicsEnvironment().getScreenDevices();
        if (devices.length == 0) {
            return new Rectangle(x, y, 0, 0);
        }
        if (devices.length == 1) {
            return ScreenUtil.getScreenRectangle(devices[0]);
        }
        Rectangle[] rectangles = new Rectangle[devices.length];
        for (int i = 0; i < devices.length; ++i) {
            GraphicsConfiguration configuration = devices[i].getDefaultConfiguration();
            Rectangle bounds2 = configuration.getBounds();
            rectangles[i] = ScreenUtil.applyInsets(bounds2, ScreenUtil.getScreenInsets(configuration));
            if (!bounds2.contains(x, y)) continue;
            return rectangles[i];
        }
        Rectangle bounds3 = rectangles[0];
        int minimum = ScreenUtil.distance(bounds3, x, y);
        if (bounds3.width == 0 || bounds3.height == 0) {
            minimum = Integer.MAX_VALUE;
        }
        for (int i = 1; i < rectangles.length; ++i) {
            int distance2;
            if (rectangles[i].width == 0 || rectangles[i].height == 0 || minimum <= (distance2 = ScreenUtil.distance(rectangles[i], x, y))) continue;
            minimum = distance2;
            bounds3 = rectangles[i];
        }
        if (bounds3.width == 0 || bounds3.height == 0) {
            return new Rectangle(x, y, 0, 0);
        }
        return bounds3;
    }

    private static int normalize(int value2, int min, int max) {
        return value2 < min ? min : Math.min(value2, max);
    }

    private static int distance(Rectangle bounds2, int x, int y) {
        x -= ScreenUtil.normalize(x, bounds2.x, bounds2.x + bounds2.width);
        y -= ScreenUtil.normalize(y, bounds2.y, bounds2.y + bounds2.height);
        return x * x + y * y;
    }

    public static void moveRectangleToFitTheScreen(Rectangle aRectangle) {
        int screenX = aRectangle.x + aRectangle.width / 2;
        int screenY = aRectangle.y + aRectangle.height / 2;
        Rectangle screen = ScreenUtil.getScreenRectangle(screenX, screenY);
        ScreenUtil.moveToFit(aRectangle, screen, null);
    }

    public static void moveToFit(Rectangle rectangle, Rectangle container2, @Nullable Insets padding) {
        Rectangle move = new Rectangle(rectangle);
        JBInsets.addTo(move, padding);
        if (move.getMaxX() > container2.getMaxX()) {
            move.x = (int)container2.getMaxX() - move.width;
        }
        if (move.getMinX() < container2.getMinX()) {
            move.x = (int)container2.getMinX();
        }
        if (move.getMaxY() > container2.getMaxY()) {
            move.y = (int)container2.getMaxY() - move.height;
        }
        if (move.getMinY() < container2.getMinY()) {
            move.y = (int)container2.getMinY();
        }
        JBInsets.removeFrom(move, padding);
        rectangle.setBounds(move);
    }

    public static void fitToScreenVertical(Rectangle rectangle, int top, int bottom, boolean rightAligned) {
        Rectangle screen = ScreenUtil.getScreenRectangle(rectangle.x, rectangle.y);
        if (rectangle.width > screen.width) {
            rectangle.width = screen.width;
        }
        if (rightAligned) {
            rectangle.x -= rectangle.width;
        }
        if (rectangle.x < screen.x) {
            rectangle.x = screen.x;
        } else {
            int max = screen.x + screen.width;
            if (rectangle.x > max) {
                rectangle.x = max - rectangle.width;
            }
        }
        int above = rectangle.y - screen.y - top;
        int below = screen.height - above - top - bottom;
        if (below > rectangle.height) {
            rectangle.y += bottom;
        } else if (above > rectangle.height) {
            rectangle.y -= rectangle.height + top;
        } else if (below > above) {
            rectangle.y += bottom;
            rectangle.height = below;
        } else {
            rectangle.y -= rectangle.height + top;
            rectangle.height = above;
        }
    }

    public static void fitToScreen(Rectangle r) {
        int yOverdraft;
        Rectangle screen = ScreenUtil.getScreenRectangle(r.x, r.y);
        int xOverdraft = r.x + r.width - screen.x - screen.width;
        if (xOverdraft > 0) {
            int shift = Math.min(xOverdraft, r.x - screen.x);
            r.x -= shift;
            if ((xOverdraft -= shift) > 0) {
                r.width -= xOverdraft;
            }
        }
        if ((yOverdraft = r.y + r.height - screen.y - screen.height) > 0) {
            int shift = Math.min(yOverdraft, r.y - screen.y);
            r.y -= shift;
            if ((yOverdraft -= shift) > 0) {
                r.height -= yOverdraft;
            }
        }
    }

    public static Point findNearestPointOnBorder(Rectangle rect, Point p) {
        Point[] variants;
        int x0 = rect.x;
        int y0 = rect.y;
        int x1 = x0 + rect.width;
        int y1 = y0 + rect.height;
        double distance2 = -1.0;
        Point best = null;
        for (Point variant : variants = new Point[]{new Point(p.x, y0), new Point(p.x, y1), new Point(x0, p.y), new Point(x1, p.y)}) {
            double d = variant.distance(p.x, p.y);
            if (best != null && !(distance2 > d)) continue;
            best = variant;
            distance2 = d;
        }
        return best;
    }

    public static void cropRectangleToFitTheScreen(Rectangle rect) {
        int screenX = rect.x;
        int screenY = rect.y;
        Rectangle screen = ScreenUtil.getScreenRectangle(screenX, screenY);
        if (rect.getMaxX() > screen.getMaxX()) {
            rect.width = (int)screen.getMaxX() - rect.x;
        }
        if (rect.getMinX() < screen.getMinX()) {
            rect.x = (int)screen.getMinX();
        }
        if (rect.getMaxY() > screen.getMaxY()) {
            rect.height = (int)screen.getMaxY() - rect.y;
        }
        if (rect.getMinY() < screen.getMinY()) {
            rect.y = (int)screen.getMinY();
        }
    }

    public static boolean isMovementTowards(Point prevLocation, Point location2, Rectangle bounds2) {
        if (bounds2 == null) {
            return false;
        }
        if (prevLocation == null || prevLocation.equals(location2)) {
            return true;
        }
        if (bounds2.contains(location2)) {
            return true;
        }
        int dx = prevLocation.x - location2.x;
        int dy = prevLocation.y - location2.y;
        if (dx > 0 && bounds2.x >= prevLocation.x) {
            return false;
        }
        if (dx < 0 && bounds2.x + bounds2.width <= prevLocation.x) {
            return false;
        }
        if (dy < 0 && bounds2.y + bounds2.height <= prevLocation.y) {
            return false;
        }
        if (dy > 0 && bounds2.y >= prevLocation.y) {
            return false;
        }
        if (dx == 0) {
            return location2.x >= bounds2.x && location2.x < bounds2.x + bounds2.width && dy > 0 ^ bounds2.y > location2.y;
        }
        if (dy == 0) {
            return location2.y >= bounds2.y && location2.y < bounds2.y + bounds2.height && dx > 0 ^ bounds2.x > location2.x;
        }
        float a = (float)dy / (float)dx;
        float b = (float)location2.y - a * (float)location2.x;
        float crossY = a * (float)bounds2.x + b;
        if (crossY >= (float)bounds2.y && crossY < (float)(bounds2.y + bounds2.height)) {
            return true;
        }
        crossY = a * (float)(bounds2.x + bounds2.width) + b;
        if (crossY >= (float)bounds2.y && crossY < (float)(bounds2.y + bounds2.height)) {
            return true;
        }
        float crossX = ((float)bounds2.y - b) / a;
        if (crossX >= (float)bounds2.x && crossX < (float)(bounds2.x + bounds2.width)) {
            return true;
        }
        crossX = ((float)(bounds2.y + bounds2.height) - b) / a;
        return crossX >= (float)bounds2.x && crossX < (float)(bounds2.x + bounds2.width);
    }

    public static boolean intersectsVisibleScreen(Window window) {
        return window.getGraphicsConfiguration().getBounds().intersects(window.getBounds());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "location";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bounds";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "p";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
        }
        objectArray2[1] = "com/intellij/ui/ScreenUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isVisible";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getScreenRectangle";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

