/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.util.Couple;
import com.intellij.ui.speedSearch.SpeedSearchSupply;
import com.intellij.util.ui.UIUtil;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.ListModel;
import javax.swing.ListSelectionModel;
import javax.swing.text.JTextComponent;
import org.intellij.lang.annotations.JdkConstants;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ScrollingUtil {
    private static final Logger LOG = Logger.getInstance(ScrollingUtil.class);
    @NonNls
    protected static final String SCROLLUP_ACTION_ID = "scrollUp";
    @NonNls
    protected static final String SCROLLDOWN_ACTION_ID = "scrollDown";
    @NonNls
    protected static final String SELECT_PREVIOUS_ROW_ACTION_ID = "selectPreviousRow";
    @NonNls
    protected static final String SELECT_NEXT_ROW_ACTION_ID = "selectNextRow";
    @NonNls
    protected static final String SELECT_LAST_ROW_ACTION_ID = "selectLastRow";
    @NonNls
    protected static final String SELECT_FIRST_ROW_ACTION_ID = "selectFirstRow";
    @NonNls
    protected static final String MOVE_HOME_ID = "MOVE_HOME";
    @NonNls
    protected static final String MOVE_END_ID = "MOVE_END";
    public static final int ROW_PADDING = 2;

    public static void selectItem(JList list2, int index) {
        LOG.assertTrue(index >= 0);
        LOG.assertTrue(index < list2.getModel().getSize());
        ScrollingUtil.ensureIndexIsVisible(list2, index, 0);
        list2.setSelectedIndex(index);
    }

    public static void ensureSelectionExists(JList list2) {
        int size = list2.getModel().getSize();
        if (size == 0) {
            list2.clearSelection();
            return;
        }
        int selectedIndex = list2.getSelectedIndex();
        if (selectedIndex < 0 || selectedIndex >= size) {
            selectedIndex = 0;
        }
        ScrollingUtil.selectItem(list2, selectedIndex);
    }

    public static boolean selectItem(JList list2, @NotNull Object item) {
        if (item == null) {
            ScrollingUtil.$$$reportNull$$$0(0);
        }
        ListModel model = list2.getModel();
        for (int i = 0; i < model.getSize(); ++i) {
            Object anItem = model.getElementAt(i);
            if (!item.equals(anItem)) continue;
            ScrollingUtil.selectItem(list2, i);
            return true;
        }
        return false;
    }

    public static void movePageUp(JList list2) {
        Rectangle cellBounds;
        int bottom;
        int visible = ScrollingUtil.getVisibleRowCount(list2);
        ListSelectionModel selectionModel = list2.getSelectionModel();
        if (visible <= 0) {
            ScrollingUtil.moveHome(list2);
            return;
        }
        int size = list2.getModel().getSize();
        int decrement = visible - 1;
        int index = Math.max(list2.getSelectedIndex() - decrement, 0);
        int top = list2.getFirstVisibleIndex() - decrement;
        if (top < 0) {
            top = 0;
        }
        if ((bottom = top + visible - 1) >= size) {
            bottom = size - 1;
        }
        if ((cellBounds = list2.getCellBounds(top, bottom)) == null) {
            ScrollingUtil.moveHome(list2);
            return;
        }
        list2.scrollRectToVisible(cellBounds);
        selectionModel.setSelectionInterval(index, index);
        list2.ensureIndexIsVisible(index);
    }

    public static void movePageDown(JList list2) {
        Rectangle cellBounds;
        int visible = ScrollingUtil.getVisibleRowCount(list2);
        if (visible <= 0) {
            ScrollingUtil.moveEnd(list2);
            return;
        }
        int size = list2.getModel().getSize();
        int increment = visible - 1;
        int index = Math.min(list2.getSelectedIndex() + increment, size - 1);
        int top = list2.getFirstVisibleIndex() + increment;
        int bottom = top + visible - 1;
        if (bottom >= size) {
            bottom = size - 1;
        }
        if ((cellBounds = list2.getCellBounds(top, bottom)) == null) {
            ScrollingUtil.moveEnd(list2);
            return;
        }
        list2.scrollRectToVisible(cellBounds);
        list2.setSelectedIndex(index);
        list2.ensureIndexIsVisible(index);
    }

    public static void moveHome(JList list2) {
        list2.setSelectedIndex(0);
        list2.ensureIndexIsVisible(0);
    }

    public static void moveEnd(JList list2) {
        int index = list2.getModel().getSize() - 1;
        list2.setSelectedIndex(index);
        list2.ensureIndexIsVisible(index);
    }

    public static void ensureIndexIsVisible(JList list2, int index, int moveDirection) {
        ScrollingUtil._ensureIndexIsVisible(list2, index, moveDirection, list2.getModel().getSize());
    }

    public static void ensureIndexIsVisible(JTable table, int index, int moveDirection) {
        ScrollingUtil._ensureIndexIsVisible(table, index, moveDirection, table.getRowCount());
    }

    private static void _ensureIndexIsVisible(JComponent c, int index, int moveDirection, int size) {
        int bottom;
        int top;
        int visible = ScrollingUtil.visibleRowCount(c);
        if (moveDirection == 0) {
            top = index - (visible - 1) / 2;
            bottom = top + visible - 1;
        } else if (moveDirection < 0) {
            top = index - 2;
            bottom = index;
        } else {
            top = index;
            bottom = index + 2;
        }
        if (top < 0) {
            top = 0;
        }
        if (bottom >= size) {
            bottom = size - 1;
        }
        ScrollingUtil._ensureRangeIsVisible(c, top, bottom);
    }

    public static void ensureRangeIsVisible(JList list2, int top, int bottom) {
        Rectangle cellBounds;
        int size = list2.getModel().getSize();
        if (top < 0) {
            top = 0;
        }
        if (bottom >= size) {
            bottom = size - 1;
        }
        if ((cellBounds = list2.getCellBounds(top, bottom)) != null) {
            cellBounds.x = 0;
            list2.scrollRectToVisible(cellBounds);
        }
    }

    private static void _ensureRangeIsVisible(JComponent c, int top, int bottom) {
        if (c instanceof JList) {
            ScrollingUtil.ensureRangeIsVisible((JList)c, top, bottom);
        } else if (c instanceof JTable) {
            JTable table = (JTable)c;
            Rectangle cellBounds = ScrollingUtil.getCellBounds(table, top, bottom);
            cellBounds.x = 0;
            table.scrollRectToVisible(cellBounds);
        }
    }

    public static boolean isIndexFullyVisible(JList list2, int index) {
        int first = list2.getFirstVisibleIndex();
        int last = list2.getLastVisibleIndex();
        if (index < 0 || first < 0 || last < 0 || index < first || index > last) {
            return false;
        }
        if (index > first && index < last) {
            return true;
        }
        return list2.getVisibleRect().contains(list2.getCellBounds(index, index));
    }

    private static int getVisibleRowCount(JList list2) {
        return list2.getLastVisibleIndex() - list2.getFirstVisibleIndex() + 1;
    }

    public static void moveDown(JList list2, @JdkConstants.InputEventMask int modifiers) {
        ScrollingUtil._moveDown(list2, list2.getSelectionModel(), modifiers, list2.getModel().getSize(), UISettings.getInstance().getCycleScrolling());
    }

    private static void selectOrAddSelection(ListSelectionModel selectionModel, int indexToSelect, @JdkConstants.InputEventMask int modifiers) {
        if (selectionModel.getSelectionMode() == 0) {
            selectionModel.setSelectionInterval(indexToSelect, indexToSelect);
        } else {
            if ((modifiers & 0x40) == 0) {
                selectionModel.removeSelectionInterval(selectionModel.getMinSelectionIndex(), selectionModel.getMaxSelectionIndex());
            }
            selectionModel.addSelectionInterval(indexToSelect, indexToSelect);
        }
    }

    public static void installActions(JList list2) {
        ScrollingUtil.installActions(list2, null);
    }

    public static void installActions(JList list2, @Nullable JComponent focusParent) {
        ActionMap actionMap = list2.getActionMap();
        actionMap.put(SCROLLUP_ACTION_ID, new MoveAction(SCROLLUP_ACTION_ID, list2));
        actionMap.put(SCROLLDOWN_ACTION_ID, new MoveAction(SCROLLDOWN_ACTION_ID, list2));
        actionMap.put(SELECT_PREVIOUS_ROW_ACTION_ID, new MoveAction(SELECT_PREVIOUS_ROW_ACTION_ID, list2));
        actionMap.put(SELECT_NEXT_ROW_ACTION_ID, new MoveAction(SELECT_NEXT_ROW_ACTION_ID, list2));
        actionMap.put(SELECT_LAST_ROW_ACTION_ID, new MoveAction(SELECT_LAST_ROW_ACTION_ID, list2));
        actionMap.put(SELECT_FIRST_ROW_ACTION_ID, new MoveAction(SELECT_FIRST_ROW_ACTION_ID, list2));
        actionMap.put(MOVE_HOME_ID, new MoveAction(MOVE_HOME_ID, list2));
        actionMap.put(MOVE_END_ID, new MoveAction(MOVE_END_ID, list2));
        ScrollingUtil.maybeInstallDefaultShortcuts(list2);
        ScrollingUtil.installMoveUpAction(list2, focusParent);
        ScrollingUtil.installMoveDownAction(list2, focusParent);
        ScrollingUtil.installMovePageUpAction(list2, focusParent);
        ScrollingUtil.installMovePageDownAction(list2, focusParent);
        if (!(focusParent instanceof JTextComponent)) {
            ScrollingUtil.installMoveHomeAction(list2, focusParent);
            ScrollingUtil.installMoveEndAction(list2, focusParent);
        }
    }

    public static void redirectExpandSelection(final JList list2, @Nullable JComponent focusParent) {
        if (focusParent != null && focusParent != list2) {
            focusParent.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent e) {
                    if (e.isShiftDown()) {
                        if (e.getKeyCode() == 40) {
                            list2.dispatchEvent(e);
                            e.consume();
                        }
                        if (e.getKeyCode() == 38) {
                            list2.dispatchEvent(e);
                            e.consume();
                        }
                    }
                }
            });
        }
    }

    public static void installMoveEndAction(final JList list2, @Nullable JComponent focusParent) {
        new ListScrollAction(CommonShortcuts.getMoveEnd(), focusParent == null ? list2 : focusParent){

            @Override
            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    2.$$$reportNull$$$0(0);
                }
                ScrollingUtil.moveEnd(list2);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ui/ScrollingUtil$2", "actionPerformed"));
            }
        };
    }

    public static void installMoveHomeAction(final JList list2, @Nullable JComponent focusParent) {
        new ListScrollAction(CommonShortcuts.getMoveHome(), focusParent == null ? list2 : focusParent){

            @Override
            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    3.$$$reportNull$$$0(0);
                }
                ScrollingUtil.moveHome(list2);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ui/ScrollingUtil$3", "actionPerformed"));
            }
        };
    }

    public static void installMovePageDownAction(final JList list2, @Nullable JComponent focusParent) {
        new ListScrollAction(CommonShortcuts.getMovePageDown(), focusParent == null ? list2 : focusParent){

            @Override
            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    4.$$$reportNull$$$0(0);
                }
                ScrollingUtil.movePageDown(list2);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ui/ScrollingUtil$4", "actionPerformed"));
            }
        };
    }

    public static void installMovePageUpAction(final JList list2, @Nullable JComponent focusParent) {
        new ListScrollAction(CommonShortcuts.getMovePageUp(), focusParent == null ? list2 : focusParent){

            @Override
            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    5.$$$reportNull$$$0(0);
                }
                ScrollingUtil.movePageUp(list2);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ui/ScrollingUtil$5", "actionPerformed"));
            }
        };
    }

    public static void installMoveDownAction(final JList list2, @Nullable JComponent focusParent) {
        new ListScrollAction(CommonShortcuts.getMoveDown(), focusParent == null ? list2 : focusParent){

            @Override
            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    6.$$$reportNull$$$0(0);
                }
                ScrollingUtil.moveDown(list2, 0);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ui/ScrollingUtil$6", "actionPerformed"));
            }
        };
    }

    public static void installMoveUpAction(final JList list2, @Nullable JComponent focusParent) {
        new ListScrollAction(CommonShortcuts.getMoveUp(), focusParent == null ? list2 : focusParent){

            @Override
            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    7.$$$reportNull$$$0(0);
                }
                ScrollingUtil.moveUp(list2, 0);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ui/ScrollingUtil$7", "actionPerformed"));
            }
        };
    }

    static void maybeInstallDefaultShortcuts(JComponent component2) {
        InputMap map2 = component2.getInputMap(0);
        UIUtil.maybeInstall(map2, SCROLLUP_ACTION_ID, KeyStroke.getKeyStroke(33, 0));
        UIUtil.maybeInstall(map2, SCROLLDOWN_ACTION_ID, KeyStroke.getKeyStroke(34, 0));
        UIUtil.maybeInstall(map2, SELECT_PREVIOUS_ROW_ACTION_ID, KeyStroke.getKeyStroke(38, 0));
        UIUtil.maybeInstall(map2, SELECT_NEXT_ROW_ACTION_ID, KeyStroke.getKeyStroke(40, 0));
        UIUtil.maybeInstall(map2, SELECT_FIRST_ROW_ACTION_ID, KeyStroke.getKeyStroke(36, 0));
        UIUtil.maybeInstall(map2, SELECT_LAST_ROW_ACTION_ID, KeyStroke.getKeyStroke(35, 0));
        UIUtil.maybeInstall(map2, MOVE_HOME_ID, KeyStroke.getKeyStroke(37, 0));
        UIUtil.maybeInstall(map2, MOVE_END_ID, KeyStroke.getKeyStroke(39, 0));
    }

    public static void ensureSelectionExists(@NotNull JTable table) {
        int size;
        if (table == null) {
            ScrollingUtil.$$$reportNull$$$0(1);
        }
        if ((size = table.getModel().getRowCount()) == 0) {
            table.clearSelection();
            return;
        }
        int selectedIndex = table.getSelectedRow();
        boolean reselect = false;
        if (selectedIndex < 0 || selectedIndex >= size) {
            selectedIndex = 0;
            reselect = true;
        }
        ScrollingUtil.ensureIndexIsVisible(table, selectedIndex, 0);
        if (reselect) {
            table.getSelectionModel().setSelectionInterval(selectedIndex, selectedIndex);
        }
    }

    @NotNull
    private static Rectangle getCellBounds(JTable table, int top, int bottom) {
        Rectangle rectangle = table.getCellRect(top, 0, true).union(table.getCellRect(bottom, 0, true));
        if (rectangle == null) {
            ScrollingUtil.$$$reportNull$$$0(2);
        }
        return rectangle;
    }

    private static int visibleRowCount(JComponent c) {
        if (c instanceof JList) {
            return ScrollingUtil.getVisibleRowCount((JList)c);
        }
        if (c instanceof JTable) {
            return ScrollingUtil.getVisibleRowCount((JTable)c);
        }
        return -1;
    }

    private static int getVisibleRowCount(JTable table) {
        Rectangle visibleRect = table.getVisibleRect();
        return ScrollingUtil.getTrailingRow(table, visibleRect) - ScrollingUtil.getLeadingRow(table, visibleRect) + 1;
    }

    public static Couple<Integer> getVisibleRows(JTable table) {
        Rectangle visibleRect = table.getVisibleRect();
        return Couple.of(ScrollingUtil.getLeadingRow(table, visibleRect), ScrollingUtil.getTrailingRow(table, visibleRect));
    }

    private static int getLeadingRow(JTable table, Rectangle visibleRect) {
        int row = table.rowAtPoint(ScrollingUtil.getLeadingPoint(table, visibleRect));
        if (row >= 0) {
            return row;
        }
        return 0 < table.getRowCount() ? 0 : -1;
    }

    private static Point getLeadingPoint(JTable table, Rectangle visibleRect) {
        if (table.getComponentOrientation().isLeftToRight()) {
            return new Point(visibleRect.x, visibleRect.y);
        }
        return new Point(visibleRect.x + visibleRect.width, visibleRect.y);
    }

    public static int getReadableRow(JTable table, int maximumHiddenPart) {
        int column;
        Rectangle visibleRect = table.getVisibleRect();
        Point leadingPoint = ScrollingUtil.getLeadingPoint(table, visibleRect);
        int row = table.rowAtPoint(leadingPoint);
        if ((double)leadingPoint.y - table.getCellRect(row, column = table.columnAtPoint(leadingPoint), true).getY() <= (double)maximumHiddenPart) {
            return row;
        }
        return Math.min(row + 1, table.getRowCount() - 1);
    }

    public static boolean isVisible(JTable table, int row) {
        Rectangle visibleRect = table.getVisibleRect();
        int start2 = ScrollingUtil.getLeadingRow(table, visibleRect);
        int end = ScrollingUtil.getTrailingRow(table, visibleRect);
        return row >= start2 && row <= end;
    }

    private static int getTrailingRow(JTable table, Rectangle visibleRect) {
        Point trailingPoint = table.getComponentOrientation().isLeftToRight() ? new Point(visibleRect.x, visibleRect.y + visibleRect.height - 1) : new Point(visibleRect.x + visibleRect.width, visibleRect.y + visibleRect.height - 1);
        int row = table.rowAtPoint(trailingPoint);
        if (row >= 0) {
            return row;
        }
        return table.getRowCount() - 1;
    }

    public static void moveDown(JTable table, @JdkConstants.InputEventMask int modifiers, boolean cycleScrolling) {
        ScrollingUtil._moveDown(table, table.getSelectionModel(), modifiers, table.getRowCount(), cycleScrolling);
    }

    public static void moveUp(JList list2, @JdkConstants.InputEventMask int modifiers) {
        ScrollingUtil._moveUp(list2, list2.getSelectionModel(), list2.getModel().getSize(), modifiers, UISettings.getInstance().getCycleScrolling());
    }

    public static void moveUp(JTable table, @JdkConstants.InputEventMask int modifiers, boolean cycleScrolling) {
        ScrollingUtil._moveUp(table, table.getSelectionModel(), table.getModel().getRowCount(), modifiers, cycleScrolling);
    }

    private static void _moveDown(JComponent c, ListSelectionModel selectionModel, @JdkConstants.InputEventMask int modifiers, int size, boolean cycleScrolling) {
        ScrollingUtil._move(c, selectionModel, modifiers, size, cycleScrolling, 1);
    }

    private static void _move(JComponent c, ListSelectionModel selectionModel, @JdkConstants.InputEventMask int modifiers, int size, boolean cycleScrolling, int direction) {
        if (size == 0) {
            return;
        }
        int index = selectionModel.getLeadSelectionIndex();
        int indexToSelect = index + direction;
        if (indexToSelect < 0 || indexToSelect >= size) {
            if (cycleScrolling) {
                indexToSelect = indexToSelect < 0 ? size - 1 : 0;
            } else {
                return;
            }
        }
        ScrollingUtil._ensureIndexIsVisible(c, indexToSelect, -1, size);
        ScrollingUtil.selectOrAddSelection(selectionModel, indexToSelect, modifiers);
    }

    private static void _moveUp(JComponent c, ListSelectionModel selectionModel, int size, @JdkConstants.InputEventMask int modifiers, boolean cycleScrolling) {
        ScrollingUtil._move(c, selectionModel, modifiers, size, cycleScrolling, -1);
    }

    public static void moveHome(JTable table) {
        table.getSelectionModel().setSelectionInterval(0, 0);
        ScrollingUtil.ensureIndexIsVisible(table, 0, 0);
    }

    public static void moveEnd(JTable table) {
        int index = table.getModel().getRowCount() - 1;
        table.getSelectionModel().setSelectionInterval(index, index);
        ScrollingUtil.ensureIndexIsVisible(table, index, 0);
    }

    public static void movePageUp(JTable table) {
        int visible = ScrollingUtil.getVisibleRowCount(table);
        if (visible <= 0) {
            ScrollingUtil.moveHome(table);
            return;
        }
        int step = visible - 1;
        ListSelectionModel selectionModel = table.getSelectionModel();
        int index = Math.max(selectionModel.getMinSelectionIndex() - step, 0);
        int visibleIndex = ScrollingUtil.getLeadingRow(table, table.getVisibleRect());
        int top = visibleIndex - step;
        if (top < 0) {
            top = 0;
        }
        int bottom = top + visible - 1;
        ScrollingUtil._scrollAfterPageMove(table, top, bottom, index);
    }

    public static void movePageDown(JTable table) {
        int visible = ScrollingUtil.getVisibleRowCount(table);
        if (visible <= 0) {
            ScrollingUtil.moveEnd(table);
            return;
        }
        ListSelectionModel selectionModel = table.getSelectionModel();
        int step = visible - 1;
        int firstVisibleRow = ScrollingUtil.getLeadingRow(table, table.getVisibleRect());
        int top = firstVisibleRow + step;
        int bottom = top + visible - 1;
        int size = table.getModel().getRowCount();
        int index = Math.min(selectionModel.getMinSelectionIndex() + step, size - 1);
        ScrollingUtil._scrollAfterPageMove(table, top, bottom, index);
    }

    private static void _scrollAfterPageMove(JTable table, int top, int bottom, int index) {
        int size = table.getModel().getRowCount();
        if (bottom >= size) {
            bottom = size - 1;
        }
        Rectangle cellBounds = ScrollingUtil.getCellBounds(table, top, bottom);
        table.scrollRectToVisible(cellBounds);
        table.getSelectionModel().setSelectionInterval(index, index);
        ScrollingUtil.ensureIndexIsVisible(table, index, 0);
    }

    public static void installActions(JTable table) {
        ScrollingUtil.installActions(table, UISettings.getInstance().getCycleScrolling());
    }

    public static boolean isEmpty(JComponent component2) {
        if (component2 instanceof JTable) {
            return ((JTable)component2).getRowCount() < 1;
        }
        if (component2 instanceof JList) {
            return ((JList)component2).getModel().getSize() < 1;
        }
        return false;
    }

    public static void installActions(JTable table, boolean cycleScrolling) {
        ScrollingUtil.installActions(table, cycleScrolling, null);
    }

    public static void installActions(final JTable table, final boolean cycleScrolling, JComponent focusParent) {
        ActionMap actionMap = table.getActionMap();
        actionMap.put(SCROLLUP_ACTION_ID, new MoveAction(SCROLLUP_ACTION_ID, table, cycleScrolling));
        actionMap.put(SCROLLDOWN_ACTION_ID, new MoveAction(SCROLLDOWN_ACTION_ID, table, cycleScrolling));
        actionMap.put(SELECT_PREVIOUS_ROW_ACTION_ID, new MoveAction(SELECT_PREVIOUS_ROW_ACTION_ID, table, cycleScrolling));
        actionMap.put(SELECT_NEXT_ROW_ACTION_ID, new MoveAction(SELECT_NEXT_ROW_ACTION_ID, table, cycleScrolling));
        actionMap.put(SELECT_LAST_ROW_ACTION_ID, new MoveAction(SELECT_LAST_ROW_ACTION_ID, table, cycleScrolling));
        actionMap.put(SELECT_FIRST_ROW_ACTION_ID, new MoveAction(SELECT_FIRST_ROW_ACTION_ID, table, cycleScrolling));
        ScrollingUtil.maybeInstallDefaultShortcuts(table);
        final JComponent target2 = focusParent == null ? table : focusParent;
        new MyScrollingAction(table){

            @Override
            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    8.$$$reportNull$$$0(0);
                }
                ScrollingUtil.moveHome(table);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ui/ScrollingUtil$8", "actionPerformed"));
            }
        }.registerCustomShortcutSet(new CustomShortcutSet(KeyStroke.getKeyStroke(37, 0)), table);
        new MyScrollingAction(table){

            @Override
            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    9.$$$reportNull$$$0(0);
                }
                ScrollingUtil.moveEnd(table);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ui/ScrollingUtil$9", "actionPerformed"));
            }
        }.registerCustomShortcutSet(new CustomShortcutSet(KeyStroke.getKeyStroke(39, 0)), table);
        if (!(focusParent instanceof JTextComponent)) {
            new MyScrollingAction(table){

                @Override
                public void actionPerformed(@NotNull AnActionEvent e) {
                    if (e == null) {
                        10.$$$reportNull$$$0(0);
                    }
                    ScrollingUtil.moveHome(table);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ui/ScrollingUtil$10", "actionPerformed"));
                }
            }.registerCustomShortcutSet(CommonShortcuts.getMoveHome(), target2);
            new MyScrollingAction(table){

                @Override
                public void actionPerformed(@NotNull AnActionEvent e) {
                    if (e == null) {
                        11.$$$reportNull$$$0(0);
                    }
                    ScrollingUtil.moveEnd(table);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ui/ScrollingUtil$11", "actionPerformed"));
                }
            }.registerCustomShortcutSet(CommonShortcuts.getMoveEnd(), target2);
        }
        new MyScrollingAction(table){

            @Override
            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    12.$$$reportNull$$$0(0);
                }
                ScrollingUtil.moveDown(table, e.getModifiers(), cycleScrolling);
            }

            @Override
            protected boolean isEnabled() {
                return super.isEnabled() && !ScrollingUtil.isMultiline(target2);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ui/ScrollingUtil$12", "actionPerformed"));
            }
        }.registerCustomShortcutSet(CommonShortcuts.getMoveDown(), target2);
        new MyScrollingAction(table){

            @Override
            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    13.$$$reportNull$$$0(0);
                }
                ScrollingUtil.moveUp(table, e.getModifiers(), cycleScrolling);
            }

            @Override
            protected boolean isEnabled() {
                return super.isEnabled() && !ScrollingUtil.isMultiline(target2);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ui/ScrollingUtil$13", "actionPerformed"));
            }
        }.registerCustomShortcutSet(CommonShortcuts.getMoveUp(), target2);
        new MyScrollingAction(table){

            @Override
            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    14.$$$reportNull$$$0(0);
                }
                ScrollingUtil.movePageUp(table);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ui/ScrollingUtil$14", "actionPerformed"));
            }
        }.registerCustomShortcutSet(CommonShortcuts.getMovePageUp(), target2);
        new MyScrollingAction(table){

            @Override
            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    15.$$$reportNull$$$0(0);
                }
                ScrollingUtil.movePageDown(table);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ui/ScrollingUtil$15", "actionPerformed"));
            }
        }.registerCustomShortcutSet(CommonShortcuts.getMovePageDown(), target2);
    }

    private static boolean isMultiline(JComponent component2) {
        return component2 instanceof JTextArea && ((JTextArea)component2).getText().contains("\n");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "item";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "table";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ui/ScrollingUtil";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ui/ScrollingUtil";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getCellBounds";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "selectItem";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "ensureSelectionExists";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static class MoveAction
    extends AbstractAction {
        private final String myId;
        private final JComponent myComponent;
        private final Boolean myCycleScrolling;

        MoveAction(String id2, JComponent component2, Boolean cycleScrolling) {
            this.myId = id2;
            this.myComponent = component2;
            this.myCycleScrolling = cycleScrolling;
        }

        MoveAction(String id2, JComponent component2) {
            this(id2, component2, null);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int modifiers = e.getModifiers();
            if (ScrollingUtil.SCROLLUP_ACTION_ID.equals(this.myId)) {
                this.doPageUp();
            } else if (ScrollingUtil.SCROLLDOWN_ACTION_ID.equals(this.myId)) {
                this.doPageDown();
            } else if (ScrollingUtil.SELECT_PREVIOUS_ROW_ACTION_ID.equals(this.myId)) {
                this.doMoveUp(modifiers);
            } else if (ScrollingUtil.SELECT_NEXT_ROW_ACTION_ID.equals(this.myId)) {
                this.doMoveDown(modifiers);
            } else if (ScrollingUtil.SELECT_LAST_ROW_ACTION_ID.equals(this.myId)) {
                this.doMoveEnd();
            } else if (ScrollingUtil.SELECT_FIRST_ROW_ACTION_ID.equals(this.myId)) {
                this.doMoveHome();
            } else if (ScrollingUtil.MOVE_END_ID.equals(this.myId)) {
                this.doMoveEnd();
            } else if (ScrollingUtil.MOVE_HOME_ID.equals(this.myId)) {
                this.doMoveHome();
            }
        }

        private void doMoveEnd() {
            if (this.myComponent instanceof JList) {
                ScrollingUtil.moveEnd((JList)this.myComponent);
            } else if (this.myComponent instanceof JTable) {
                ScrollingUtil.moveEnd((JTable)this.myComponent);
            } else {
                throw new IllegalArgumentException("MoveEnd is not implemented for " + this.myComponent.getClass());
            }
        }

        private void doMoveHome() {
            if (this.myComponent instanceof JList) {
                ScrollingUtil.moveHome((JList)this.myComponent);
            } else if (this.myComponent instanceof JTable) {
                ScrollingUtil.moveHome((JTable)this.myComponent);
            } else {
                throw new IllegalArgumentException("MoveHome is not implemented for " + this.myComponent.getClass());
            }
        }

        private void doMoveUp(@JdkConstants.InputEventMask int modifiers) {
            if (this.myComponent instanceof JList) {
                ScrollingUtil.moveUp((JList)this.myComponent, modifiers);
            } else if (this.myComponent instanceof JTable) {
                ScrollingUtil.moveUp((JTable)this.myComponent, modifiers, this.isCycleScrolling());
            } else {
                throw new IllegalArgumentException("MoveUp is not implemented for " + this.myComponent.getClass());
            }
        }

        private void doMoveDown(@JdkConstants.InputEventMask int modifiers) {
            if (this.myComponent instanceof JList) {
                ScrollingUtil.moveDown((JList)this.myComponent, modifiers);
            } else if (this.myComponent instanceof JTable) {
                ScrollingUtil.moveDown((JTable)this.myComponent, modifiers, this.isCycleScrolling());
            } else {
                throw new IllegalArgumentException("MoveDown is not implemented for " + this.myComponent.getClass());
            }
        }

        private void doPageUp() {
            if (this.myComponent instanceof JList) {
                ScrollingUtil.movePageUp((JList)this.myComponent);
            } else if (this.myComponent instanceof JTable) {
                ScrollingUtil.movePageUp((JTable)this.myComponent);
            } else {
                throw new IllegalArgumentException("PageUp is not implemented for " + this.myComponent.getClass());
            }
        }

        private void doPageDown() {
            if (this.myComponent instanceof JList) {
                ScrollingUtil.movePageDown((JList)this.myComponent);
            } else if (this.myComponent instanceof JTable) {
                ScrollingUtil.movePageDown((JTable)this.myComponent);
            } else {
                throw new IllegalArgumentException("PageDown is not implemented for " + this.myComponent.getClass());
            }
        }

        private boolean isCycleScrolling() {
            return this.myCycleScrolling == null ? UISettings.getInstance().getCycleScrolling() : this.myCycleScrolling.booleanValue();
        }
    }

    private static abstract class MyScrollingAction
    extends DumbAwareAction
    implements ScrollingAction {
        private final JComponent myComponent;

        MyScrollingAction(JComponent component2) {
            this.myComponent = component2;
        }

        @Override
        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                MyScrollingAction.$$$reportNull$$$0(0);
            }
            e.getPresentation().setEnabled(this.isEnabled());
        }

        protected boolean isEnabled() {
            return SpeedSearchSupply.getSupply(this.myComponent) == null && !ScrollingUtil.isEmpty(this.myComponent);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ui/ScrollingUtil$MyScrollingAction", "update"));
        }
    }

    public static abstract class ListScrollAction
    extends MyScrollingAction {
        protected ListScrollAction(ShortcutSet shortcutSet, JComponent component2) {
            super(component2);
            this.registerCustomShortcutSet(shortcutSet, component2);
        }
    }

    public static interface ScrollingAction
    extends DumbAware {
    }
}

