/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.ide.DataManager;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.TextCopyProvider;
import com.intellij.ide.ui.LafManager;
import com.intellij.ide.ui.UITheme;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.actionSystem.ActionToolbarPosition;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.InputValidator;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.codeStyle.MinusculeMatcher;
import com.intellij.psi.codeStyle.NameUtil;
import com.intellij.ui.ColorPicker;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.Gray;
import com.intellij.ui.ScrollingUtil;
import com.intellij.ui.TableSpeedSearch;
import com.intellij.ui.TableUtil;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBTextField;
import com.intellij.ui.speedSearch.FilteringTableModel;
import com.intellij.ui.table.JBTable;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.JBEmptyBorder;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UI;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.components.BorderLayoutPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.EventObject;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.plaf.ColorUIResource;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ShowUIDefaultsAction
extends AnAction
implements DumbAware {
    @Override
    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            ShowUIDefaultsAction.$$$reportNull$$$0(0);
        }
        Project project2 = ShowUIDefaultsAction.getEventProject(e);
        this.perform(project2);
    }

    public void perform(final Project project2) {
        new DialogWrapper(project2, true){
            public JBTable myTable;
            public JBTextField mySearchField;
            public JBCheckBox myColorsOnly;
            {
                super(arg0, arg1);
                this.setTitle(IdeBundle.message("dialog.title.edit.laf.defaults", new Object[0]));
                this.setModal(false);
                this.init();
            }

            @Override
            @Nullable
            public JComponent getPreferredFocusedComponent() {
                return this.mySearchField;
            }

            @Override
            @Nullable
            protected String getDimensionServiceKey() {
                return project2 == null ? null : "UI.Defaults.Dialog";
            }

            @Override
            protected JComponent createCenterPanel() {
                this.mySearchField = new JBTextField(40);
                JPanel top = UI.PanelFactory.panel(this.mySearchField).withLabel(IdeBundle.message("label.ui.filter", new Object[0])).createPanel();
                JBTable table = new JBTable(ShowUIDefaultsAction.createFilteringModel()){

                    @Override
                    public boolean editCellAt(int row, int column, EventObject e) {
                        if (this.isCellEditable(row, column) && e instanceof MouseEvent) {
                            Font newValue;
                            Pair pair = (Pair)this.getValueAt(row, 0);
                            Object key = pair.first;
                            Object value2 = pair.second;
                            boolean changed2 = false;
                            if (value2 instanceof Color) {
                                Color newColor = ColorPicker.showDialog(this, "Choose Color", (Color)value2, true, null, true);
                                if (newColor != null) {
                                    ColorUIResource colorUIResource = new ColorUIResource(newColor);
                                    this.updateValue(pair, colorUIResource, row, column);
                                    changed2 = true;
                                }
                            } else if (value2 instanceof Boolean) {
                                this.updateValue(pair, (Boolean)value2 == false, row, column);
                                changed2 = true;
                            } else if (value2 instanceof Integer) {
                                Integer newValue2 = this.editNumber(key.toString(), value2.toString());
                                if (newValue2 != null) {
                                    this.updateValue(pair, newValue2, row, column);
                                    changed2 = true;
                                }
                            } else if (value2 instanceof EmptyBorder) {
                                Insets i = ((Border)value2).getBorderInsets(null);
                                String oldInsets = String.format("%d,%d,%d,%d", i.top, i.left, i.bottom, i.right);
                                Insets newInsets = this.editInsets(key.toString(), oldInsets);
                                if (newInsets != null) {
                                    this.updateValue(pair, new JBEmptyBorder(newInsets), row, column);
                                    changed2 = true;
                                }
                            } else if (value2 instanceof Insets) {
                                Insets i = (Insets)value2;
                                String oldInsets = String.format("%d,%d,%d,%d", i.top, i.left, i.bottom, i.right);
                                Insets newInsets = this.editInsets(key.toString(), oldInsets);
                                if (newInsets != null) {
                                    this.updateValue(pair, newInsets, row, column);
                                    changed2 = true;
                                }
                            } else if (value2 instanceof UIUtil.GrayFilter) {
                                UIUtil.GrayFilter f = (UIUtil.GrayFilter)value2;
                                String oldFilter = String.format("%d,%d,%d", f.getBrightness(), f.getContrast(), f.getAlpha());
                                UIUtil.GrayFilter newValue3 = this.editGrayFilter(key.toString(), oldFilter);
                                if (newValue3 != null) {
                                    this.updateValue(pair, newValue3, row, column);
                                    changed2 = true;
                                }
                            } else if (value2 instanceof Font && (newValue = this.editFontSize(key.toString(), (Font)value2)) != null) {
                                UIManager.getDefaults().remove(key);
                                UIManager.getDefaults().put(key, newValue);
                                this.setValueAt(newValue, row, column);
                                changed2 = true;
                            }
                            if (changed2) {
                                ApplicationManager.getApplication().invokeLater(() -> {
                                    LafManager.getInstance().updateUI();
                                    LafManager.getInstance().repaintUI();
                                });
                            }
                        }
                        return false;
                    }

                    void updateValue(Pair value2, Object newValue, int row, int col) {
                        UIManager.getDefaults().remove(value2.first);
                        UIManager.getDefaults().put(value2.first, newValue);
                        this.setValueAt(Pair.create(value2.first, newValue), row, col);
                    }
                };
                table.setDefaultRenderer(Object.class, new DefaultTableCellRenderer(){

                    @Override
                    public Component getTableCellRendererComponent(JTable table, Object value2, boolean isSelected, boolean hasFocus, int row, int column) {
                        TableCellRenderer renderer;
                        Object object = value2 = column == 0 ? ((Pair)value2).first : ((Pair)value2).second;
                        if (value2 instanceof Boolean && (renderer = table.getDefaultRenderer(Boolean.class)) != null) {
                            JCheckBox box = (JCheckBox)renderer.getTableCellRendererComponent(table, value2, isSelected, hasFocus, row, column);
                            box.setHorizontalAlignment(2);
                            return box;
                        }
                        JPanel panel2 = new JPanel(new BorderLayout());
                        JLabel label2 = new JLabel(value2 == null ? "" : value2.toString());
                        panel2.add((Component)label2, "Center");
                        if (value2 instanceof Color) {
                            Color c = (Color)value2;
                            label2.setText(String.format("  [%d,%d,%d] #%s", c.getRed(), c.getGreen(), c.getBlue(), StringUtil.toUpperCase(ColorUtil.toHex(c))));
                            Gray fg = ColorUtil.isDark(c) ? Gray.xFF : Gray.x00;
                            label2.setForeground(fg);
                            panel2.setBackground(c);
                            return panel2;
                        }
                        if (value2 instanceof Icon) {
                            try {
                                IconWrap icon2 = new IconWrap((Icon)value2);
                                if (icon2.getIconHeight() <= 20) {
                                    label2.setIcon(icon2);
                                }
                                label2.setText(String.format("(%dx%d) %s)", icon2.getIconWidth(), icon2.getIconHeight(), label2.getText()));
                            }
                            catch (Throwable icon2) {
                                // empty catch block
                            }
                            return panel2;
                        }
                        if (value2 instanceof Border) {
                            try {
                                Insets i = ((Border)value2).getBorderInsets(null);
                                label2.setText(String.format("[%d, %d, %d, %d] %s", i.top, i.left, i.bottom, i.right, label2.getText()));
                                return panel2;
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                        return super.getTableCellRendererComponent(table, value2, isSelected, hasFocus, row, column);
                    }
                });
                new TableSpeedSearch((JTable)table, (o, cell) -> cell.column == 1 ? null : String.valueOf(o));
                table.setShowGrid(false);
                this.myTable = table;
                TableUtil.ensureSelectionExists(this.myTable);
                this.mySearchField.getDocument().addDocumentListener(new DocumentAdapter(){

                    @Override
                    protected void textChanged(@NotNull DocumentEvent e) {
                        if (e == null) {
                            3.$$$reportNull$$$0(0);
                        }
                        this.updateFilter();
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ui/ShowUIDefaultsAction$1$3", "textChanged"));
                    }
                });
                ScrollingUtil.installActions(this.myTable, true, this.mySearchField);
                this.myColorsOnly = new JBCheckBox(IdeBundle.message("checkbox.colors.only", new Object[0]), PropertiesComponent.getInstance().getBoolean("LaFDialog.ColorsOnly", false)){

                    @Override
                    public void addNotify() {
                        super.addNotify();
                        this.updateFilter();
                    }
                };
                this.myColorsOnly.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        PropertiesComponent.getInstance().setValue("LaFDialog.ColorsOnly", myColorsOnly.isSelected(), false);
                        this.updateFilter();
                    }
                });
                JPanel pane2 = ToolbarDecorator.createDecorator(this.myTable).setToolbarPosition(ActionToolbarPosition.BOTTOM).setAddAction(x -> this.addNewValue()).createPanel();
                BorderLayoutPanel panel2 = JBUI.Panels.simplePanel((Component)((Object)JBUI.Panels.simplePanel(pane2).withBorder(JBUI.Borders.empty(5, 0)))).addToTop(top).addToBottom(this.myColorsOnly);
                DataProvider provider = dataId -> {
                    int row;
                    if (PlatformDataKeys.COPY_PROVIDER.is(dataId) && (this.mySearchField.hasFocus() && StringUtil.isEmpty(this.mySearchField.getSelectedText()) || this.myTable.hasFocus()) && (row = this.myTable.getSelectedRow()) != -1) {
                        final Pair pair = (Pair)this.myTable.getModel().getValueAt(row, 0);
                        if (pair.second instanceof Color) {
                            return new TextCopyProvider(){

                                @Override
                                public Collection<String> getTextLinesToCopy() {
                                    return Collections.singletonList("\"" + pair.first.toString() + "\": \"" + ColorUtil.toHtmlColor((Color)pair.second) + "\"");
                                }
                            };
                        }
                    }
                    return null;
                };
                DataManager.registerDataProvider(this.myTable, provider);
                DataManager.registerDataProvider(this.mySearchField, provider);
                return panel2;
            }

            private void addNewValue() {
                ApplicationManager.getApplication().invokeLater(() -> new DialogWrapper(this.myTable, true){
                    final JBTextField name;
                    final JBTextField value;
                    {
                        this.name = new JBTextField(40);
                        this.value = new JBTextField(40);
                        this.setTitle(IdeBundle.message("dialog.title.add.new.value", new Object[0]));
                        this.init();
                    }

                    @Override
                    protected JComponent createCenterPanel() {
                        return UI.PanelFactory.grid().add(UI.PanelFactory.panel(this.name).withLabel(IdeBundle.message("label.ui.name", new Object[0]))).add(UI.PanelFactory.panel(this.value).withLabel(IdeBundle.message("label.ui.value", new Object[0]))).createPanel();
                    }

                    @Override
                    @Nullable
                    public JComponent getPreferredFocusedComponent() {
                        return this.name;
                    }

                    @Override
                    protected void doOKAction() {
                        String key = this.name.getText().trim();
                        String val = this.value.getText().trim();
                        if (!key.isEmpty() && !val.isEmpty()) {
                            UIManager.put(key, UITheme.parseValue(key, val));
                            myTable.setModel(ShowUIDefaultsAction.createFilteringModel());
                            this.updateFilter();
                        }
                        super.doOKAction();
                    }
                }.show());
            }

            private void updateFilter() {
                FilteringTableModel model = (FilteringTableModel)this.myTable.getModel();
                if (StringUtil.isEmpty(this.mySearchField.getText()) && !this.myColorsOnly.isSelected()) {
                    model.setFilter(null);
                    return;
                }
                MinusculeMatcher matcher = NameUtil.buildMatcher("*" + this.mySearchField.getText(), NameUtil.MatchingCaseSensitivity.NONE);
                model.setFilter(pair -> {
                    Object obj = ((Pair)pair).second;
                    String value2 = obj == null ? "null" : (obj instanceof Color ? ColorUtil.toHtmlColor((Color)obj) : obj.toString());
                    value2 = ((Pair)pair).first.toString() + " " + value2;
                    return (!this.myColorsOnly.isSelected() || obj instanceof Color) && matcher.matches(value2);
                });
            }

            @Nullable
            private Integer editNumber(String key, String value2) {
                String newValue = Messages.showInputDialog(this.getRootPane(), IdeBundle.message("dialog.message.enter.new.value.for.0", key), IdeBundle.message("dialog.title.number.editor", new Object[0]), null, value2, new InputValidator(){

                    @Override
                    public boolean checkInput(String inputString) {
                        try {
                            Integer.parseInt(inputString);
                            return true;
                        }
                        catch (NumberFormatException nfe) {
                            return false;
                        }
                    }

                    @Override
                    public boolean canClose(String inputString) {
                        return this.checkInput(inputString);
                    }
                });
                return newValue != null ? Integer.valueOf(newValue) : null;
            }

            @Nullable
            private Insets editInsets(String key, String value2) {
                String newValue = Messages.showInputDialog(this.getRootPane(), IdeBundle.message("dialog.message.enter.new.value.for.0.in.form.top.left.bottom.right", key), IdeBundle.message("dialog.title.insets.editor", new Object[0]), null, value2, new InputValidator(){

                    @Override
                    public boolean checkInput(String inputString) {
                        return this.parseInsets(inputString) != null;
                    }

                    @Override
                    public boolean canClose(String inputString) {
                        return this.checkInput(inputString);
                    }
                });
                return newValue != null ? this.parseInsets(newValue) : null;
            }

            @Nullable
            private Insets parseInsets(String value2) {
                String[] parts = value2.split(",");
                if (parts.length != 4) {
                    return null;
                }
                try {
                    List<Integer> v = ContainerUtil.map(parts, p -> Integer.parseInt(p));
                    return JBUI.insets(v.get(0), v.get(1), v.get(2), v.get(3));
                }
                catch (NumberFormatException nex) {
                    return null;
                }
            }

            @Nullable
            private UIUtil.GrayFilter editGrayFilter(String key, String value2) {
                String newValue = Messages.showInputDialog(this.getRootPane(), IdeBundle.message("dialog.message.enter.new.value.for.0.in.form.brightness.contrast.alpha", key), IdeBundle.message("dialog.title.gray.filter.editor", new Object[0]), null, value2, new InputValidator(){

                    @Override
                    public boolean checkInput(String inputString) {
                        return this.parseGrayFilter(inputString) != null;
                    }

                    @Override
                    public boolean canClose(String inputString) {
                        return this.checkInput(inputString);
                    }
                });
                return newValue != null ? this.parseGrayFilter(newValue) : null;
            }

            @Nullable
            private UIUtil.GrayFilter parseGrayFilter(String value2) {
                String[] parts = value2.split(",");
                if (parts.length != 3) {
                    return null;
                }
                try {
                    List<Integer> v = ContainerUtil.map(parts, p -> Integer.parseInt(p));
                    return new UIUtil.GrayFilter(v.get(0), v.get(1), v.get(2));
                }
                catch (NumberFormatException nex) {
                    return null;
                }
            }

            @Nullable
            private Font editFontSize(String key, final Font font) {
                String newValue = Messages.showInputDialog(this.getRootPane(), IdeBundle.message("label.enter.new.font.size.for.0", key), IdeBundle.message("dialog.title.font.size.editor", new Object[0]), null, Integer.toString(font.getSize()), new InputValidator(){

                    @Override
                    public boolean checkInput(String inputString) {
                        return this.parseFontSize(font, inputString) != null;
                    }

                    @Override
                    public boolean canClose(String inputString) {
                        return this.checkInput(inputString);
                    }
                });
                return newValue != null ? this.parseFontSize(font, newValue) : null;
            }

            @Nullable
            private Font parseFontSize(Font font, String value2) {
                try {
                    int newSize = Integer.parseInt(value2);
                    return newSize > 0 ? font.deriveFont((float)newSize) : null;
                }
                catch (NumberFormatException nex) {
                    return null;
                }
            }
        }.show();
    }

    private static Object[] @NotNull [] getUIDefaultsData() {
        UIDefaults defaults = UIManager.getDefaults();
        Enumeration keys2 = defaults.keys();
        Object[][] data2 = new Object[defaults.size()][2];
        int i = 0;
        while (keys2.hasMoreElements()) {
            Pair row;
            Object key = keys2.nextElement();
            data2[i][0] = row = Pair.create(key, defaults.get(key));
            data2[i][1] = row;
            ++i;
        }
        Arrays.sort(data2, (o1, o2) -> StringUtil.naturalCompare(((Pair)o1[0]).first.toString(), ((Pair)o2[0]).first.toString()));
        return data2;
    }

    @NotNull
    private static FilteringTableModel<Object> createFilteringModel() {
        DefaultTableModel model = new DefaultTableModel(ShowUIDefaultsAction.getUIDefaultsData(), new Object[]{"Name", "Value"}){

            @Override
            public boolean isCellEditable(int row, int column) {
                if (column != 1) {
                    return false;
                }
                Object value2 = ((Pair)this.getValueAt((int)row, (int)column)).second;
                return value2 instanceof Color || value2 instanceof Boolean || value2 instanceof Integer || value2 instanceof EmptyBorder || value2 instanceof Insets || value2 instanceof UIUtil.GrayFilter || value2 instanceof Font;
            }
        };
        FilteringTableModel<Object> filteringTableModel = new FilteringTableModel<Object>(model, Object.class);
        filteringTableModel.setFilter(null);
        FilteringTableModel<Object> filteringTableModel2 = filteringTableModel;
        if (filteringTableModel2 == null) {
            ShowUIDefaultsAction.$$$reportNull$$$0(1);
        }
        return filteringTableModel2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ui/ShowUIDefaultsAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ui/ShowUIDefaultsAction";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createFilteringModel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class IconWrap
    implements Icon {
        private final Icon myIcon;

        IconWrap(Icon icon2) {
            this.myIcon = icon2;
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            try {
                this.myIcon.paintIcon(c, g, x, y);
            }
            catch (Exception e) {
                EmptyIcon.ICON_0.paintIcon(c, g, x, y);
            }
        }

        @Override
        public int getIconWidth() {
            return this.myIcon.getIconWidth();
        }

        @Override
        public int getIconHeight() {
            return this.myIcon.getIconHeight();
        }
    }
}

