/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.ide.BrowserUtil;
import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.ui.GraphicsConfig;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.ColoredTextContainer;
import com.intellij.ui.Gray;
import com.intellij.ui.JBColor;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.SuitableFontProvider;
import com.intellij.ui.paint.EffectPainter;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ui.GraphicsUtil;
import com.intellij.util.ui.JBEmptyBorder;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.StartupUiUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.font.FontRenderContext;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.awt.geom.RoundRectangle2D;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.tree.TreeCellRenderer;
import org.intellij.lang.annotations.JdkConstants;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SimpleColoredComponent
extends JComponent
implements Accessible,
ColoredTextContainer {
    private static final Logger LOG = Logger.getInstance(SimpleColoredComponent.class);
    public static final int FRAGMENT_ICON = -2;
    private final List<ColoredFragment> myFragments;
    private ColoredFragment myCurrentFragment;
    private Font myLayoutFont;
    private FontRenderContext myLayoutFRC;
    private Icon myIcon;
    private Insets myIpad;
    protected int myIconTextGap;
    private boolean myPaintFocusBorder;
    private boolean myFocusBorderAroundIcon;
    private Border myBorder;
    private int myMainTextLastIndex = -1;
    @JdkConstants.HorizontalAlignment
    private int myTextAlign = 2;
    private boolean myIconOpaque;
    private boolean myAutoInvalidate = !(this instanceof TreeCellRenderer);
    private boolean myIconOnTheRight;
    private boolean myTransparentIconBackground;

    public SimpleColoredComponent() {
        this.myFragments = new ArrayList<ColoredFragment>(3);
        this.myIpad = JBInsets.create(1, 2);
        this.myIconTextGap = JBUIScale.scale(2);
        this.myBorder = JBUI.Borders.empty(1, UIUtil.isUnderWin10LookAndFeel() ? 0 : 1);
        this.setOpaque(true);
        this.updateUI();
    }

    @Override
    public void updateUI() {
        UISettings.setupComponentAntialiasing(this);
        Object value2 = UIManager.getDefaults().get(RenderingHints.KEY_FRACTIONALMETRICS);
        if (value2 == null) {
            value2 = RenderingHints.VALUE_FRACTIONALMETRICS_OFF;
        }
        this.putClientProperty(RenderingHints.KEY_FRACTIONALMETRICS, value2);
    }

    private void updateFractionalMetrics() {
        if (SystemInfo.isMacOSCatalina) {
            Object value2;
            Object object = value2 = this.hasSearchMatch() ? null : UIManager.getDefaults().get(RenderingHints.KEY_FRACTIONALMETRICS);
            if (value2 == null) {
                value2 = RenderingHints.VALUE_FRACTIONALMETRICS_OFF;
            }
            this.putClientProperty(RenderingHints.KEY_FRACTIONALMETRICS, value2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean hasSearchMatch() {
        List<ColoredFragment> list2 = this.myFragments;
        synchronized (list2) {
            for (ColoredFragment fragment : this.myFragments) {
                if (64 != fragment.attributes.getStyle()) continue;
                return true;
            }
        }
        return false;
    }

    @NotNull
    public ColoredIterator iterator() {
        return new MyIterator();
    }

    @NotNull
    public ColoredIterator iterator(int fromIndex) {
        MyIterator iterator2 = new MyIterator();
        iterator2.myIndex = fromIndex - 1;
        MyIterator myIterator = iterator2;
        if (myIterator == null) {
            SimpleColoredComponent.$$$reportNull$$$0(0);
        }
        return myIterator;
    }

    public boolean isIconOnTheRight() {
        return this.myIconOnTheRight;
    }

    public void setIconOnTheRight(boolean iconOnTheRight) {
        this.myIconOnTheRight = iconOnTheRight;
    }

    @NotNull
    public final SimpleColoredComponent append(@NotNull String fragment) {
        if (fragment == null) {
            SimpleColoredComponent.$$$reportNull$$$0(1);
        }
        this.append(fragment, SimpleTextAttributes.REGULAR_ATTRIBUTES);
        SimpleColoredComponent simpleColoredComponent = this;
        if (simpleColoredComponent == null) {
            SimpleColoredComponent.$$$reportNull$$$0(2);
        }
        return simpleColoredComponent;
    }

    public final void append(@NotNull String fragment, @NotNull SimpleTextAttributes attributes) {
        if (fragment == null) {
            SimpleColoredComponent.$$$reportNull$$$0(3);
        }
        if (attributes == null) {
            SimpleColoredComponent.$$$reportNull$$$0(4);
        }
        this.append(fragment, attributes, this.myMainTextLastIndex < 0);
    }

    public final void append(@NotNull String fragment, @NotNull SimpleTextAttributes attributes, int padding, @JdkConstants.HorizontalAlignment int align) {
        if (fragment == null) {
            SimpleColoredComponent.$$$reportNull$$$0(5);
        }
        if (attributes == null) {
            SimpleColoredComponent.$$$reportNull$$$0(6);
        }
        this.append(fragment, attributes, this.myMainTextLastIndex < 0);
        this.appendTextPadding(padding, align);
    }

    public void append(@NotNull String fragment, @NotNull SimpleTextAttributes attributes, boolean isMainText) {
        if (fragment == null) {
            SimpleColoredComponent.$$$reportNull$$$0(7);
        }
        if (attributes == null) {
            SimpleColoredComponent.$$$reportNull$$$0(8);
        }
        this._append(fragment, attributes, isMainText);
        this.revalidateAndRepaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _append(@NotNull String fragment, @NotNull SimpleTextAttributes attributes, boolean isMainText) {
        if (fragment == null) {
            SimpleColoredComponent.$$$reportNull$$$0(9);
        }
        if (attributes == null) {
            SimpleColoredComponent.$$$reportNull$$$0(10);
        }
        List<ColoredFragment> list2 = this.myFragments;
        synchronized (list2) {
            this.myCurrentFragment = new ColoredFragment(fragment, attributes);
            this.myFragments.add(this.myCurrentFragment);
            if (isMainText) {
                this.myMainTextLastIndex = this.myFragments.size() - 1;
            }
        }
    }

    void revalidateAndRepaint() {
        if (this.myAutoInvalidate) {
            this.revalidate();
        }
        this.repaint();
    }

    public void append(@NotNull String fragment, @NotNull SimpleTextAttributes attributes, Object tag2) {
        if (fragment == null) {
            SimpleColoredComponent.$$$reportNull$$$0(11);
        }
        if (attributes == null) {
            SimpleColoredComponent.$$$reportNull$$$0(12);
        }
        this._append(fragment, attributes, tag2);
        this.revalidateAndRepaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _append(String fragment, SimpleTextAttributes attributes, Object tag2) {
        List<ColoredFragment> list2 = this.myFragments;
        synchronized (list2) {
            this.append(fragment, attributes);
            if (tag2 != null) {
                this.myCurrentFragment.tag = tag2;
            }
        }
    }

    public void appendTextPadding(int padding) {
        this.appendTextPadding(padding, 2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void appendTextPadding(int padding, @JdkConstants.HorizontalAlignment int align) {
        List<ColoredFragment> list2 = this.myFragments;
        synchronized (list2) {
            if (this.myCurrentFragment != null) {
                this.myCurrentFragment.padding = padding;
                this.myCurrentFragment.alignment = align;
            }
        }
    }

    public void setTextAlign(@JdkConstants.HorizontalAlignment int align) {
        this.myTextAlign = align;
    }

    public void clear() {
        this._clear();
        this.revalidateAndRepaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _clear() {
        List<ColoredFragment> list2 = this.myFragments;
        synchronized (list2) {
            this.myIcon = null;
            this.myPaintFocusBorder = false;
            this.myFragments.clear();
            this.myCurrentFragment = null;
            this.myMainTextLastIndex = -1;
        }
    }

    public final Icon getIcon() {
        return this.myIcon;
    }

    public final void setIcon(@Nullable Icon icon2) {
        this.myIcon = icon2;
        this.revalidateAndRepaint();
    }

    @NotNull
    public Insets getIpad() {
        Insets insets = this.myIpad;
        if (insets == null) {
            SimpleColoredComponent.$$$reportNull$$$0(13);
        }
        return insets;
    }

    public void setIpad(@NotNull Insets ipad) {
        if (ipad == null) {
            SimpleColoredComponent.$$$reportNull$$$0(14);
        }
        this.myIpad = ipad;
        this.revalidateAndRepaint();
    }

    public int getIconTextGap() {
        return this.myIconTextGap;
    }

    public void setIconTextGap(int iconTextGap) {
        if (iconTextGap < 0) {
            throw new IllegalArgumentException("wrong iconTextGap: " + iconTextGap);
        }
        this.myIconTextGap = iconTextGap;
        this.revalidateAndRepaint();
    }

    public Border getMyBorder() {
        return this.myBorder;
    }

    public void setMyBorder(@Nullable Border border) {
        this.myBorder = border;
    }

    protected final void setPaintFocusBorder(boolean paintFocusBorder) {
        this.myPaintFocusBorder = paintFocusBorder;
        this.repaint();
    }

    protected final void setFocusBorderAroundIcon(boolean focusBorderAroundIcon) {
        this.myFocusBorderAroundIcon = focusBorderAroundIcon;
        this.repaint();
    }

    public boolean isIconOpaque() {
        return this.myIconOpaque;
    }

    public void setIconOpaque(boolean iconOpaque) {
        this.myIconOpaque = iconOpaque;
        this.repaint();
    }

    @Override
    @NotNull
    public Dimension getPreferredSize() {
        return this.computePreferredSize(false);
    }

    @Override
    @NotNull
    public Dimension getMinimumSize() {
        return this.computePreferredSize(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public Object getFragmentTag(int index) {
        List<ColoredFragment> list2 = this.myFragments;
        synchronized (list2) {
            if (0 <= index && index < this.myFragments.size()) {
                return this.myFragments.get((int)index).tag;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    public final Dimension computePreferredSize(boolean mainTextOnly) {
        this.updateFractionalMetrics();
        List<ColoredFragment> list2 = this.myFragments;
        // MONITORENTER : list2
        float width = this.myIpad.left;
        if (this.myIcon != null) {
            width += (float)(this.myIcon.getIconWidth() + this.myIconTextGap);
        }
        JBInsets borderInsets = this.myBorder != null ? this.myBorder.getBorderInsets(this) : JBUI.emptyInsets();
        width += (float)borderInsets.left;
        Font font = this.getBaseFont();
        width += this.computeTextWidth(font, mainTextOnly);
        width += (float)(this.myIpad.right + borderInsets.right);
        Insets insets = this.getInsets();
        if (insets != null) {
            width += (float)(insets.left + insets.right);
        }
        int height = this.computePreferredHeight();
        Dimension dimension = new Dimension((int)Math.ceil(width), height);
        // MONITOREXIT : list2
        if (dimension != null) return dimension;
        SimpleColoredComponent.$$$reportNull$$$0(15);
        return dimension;
    }

    final synchronized int computePreferredHeight() {
        int height = this.myIpad.top + this.myIpad.bottom;
        Font font = this.getBaseFont();
        FontMetrics metrics = this.getFontMetrics(font);
        int textHeight = Math.max(this.getMinHeight(), metrics.getHeight());
        JBInsets borderInsets = this.myBorder != null ? this.myBorder.getBorderInsets(this) : JBUI.emptyInsets();
        height += this.myIcon == null ? textHeight : Math.max(this.myIcon.getIconHeight(), textHeight += borderInsets.top + borderInsets.bottom);
        Insets insets = this.getInsets();
        if (insets != null) {
            height += insets.top + insets.bottom;
        }
        return height;
    }

    protected int getMinHeight() {
        return JBUIScale.scale(16);
    }

    private Rectangle computePaintArea() {
        Rectangle area = new Rectangle(this.getWidth(), this.getHeight());
        JBInsets.removeFrom(area, this.getInsets());
        JBInsets.removeFrom(area, this.myIpad);
        return area;
    }

    private float computeTextWidth(@NotNull Font font, boolean mainTextOnly) {
        if (font == null) {
            SimpleColoredComponent.$$$reportNull$$$0(16);
        }
        float result2 = 0.0f;
        int baseSize = font.getSize();
        boolean wasSmaller = false;
        for (int i = 0; i < this.myFragments.size(); ++i) {
            ColoredFragment fragment = this.myFragments.get(i);
            SimpleTextAttributes attributes = fragment.attributes;
            boolean isSmaller = attributes.isSmaller();
            if (font.getStyle() != attributes.getFontStyle() || isSmaller != wasSmaller) {
                font = font.deriveFont(attributes.getFontStyle(), isSmaller ? UIUtil.getFontSize(UIUtil.FontSize.SMALL) : (float)baseSize);
            }
            wasSmaller = isSmaller;
            result2 += this.computeStringWidth(fragment, font);
            int fixedWidth = fragment.padding;
            if (fixedWidth > 0 && result2 < (float)fixedWidth) {
                result2 = fixedWidth;
            }
            if (mainTextOnly && this.myMainTextLastIndex >= 0 && i == this.myMainTextLastIndex) break;
        }
        return result2;
    }

    @NotNull
    private Font getBaseFont() {
        Font font = this.getFont();
        if (font == null) {
            font = StartupUiUtil.getLabelFont();
        }
        Font font2 = font;
        if (font2 == null) {
            SimpleColoredComponent.$$$reportNull$$$0(17);
        }
        return font2;
    }

    private TextRenderer getTextRenderer(@NotNull ColoredFragment fragment, Font font) {
        if (fragment == null) {
            SimpleColoredComponent.$$$reportNull$$$0(18);
        }
        FontRenderContext frc = this.getFontMetrics(font).getFontRenderContext();
        Font baseFont = this.getBaseFont();
        if (!baseFont.equals(this.myLayoutFont) || !frc.equals(this.myLayoutFRC)) {
            this.myFragments.forEach(ColoredFragment::invalidateLayout);
            this.myLayoutFont = baseFont;
            this.myLayoutFRC = frc;
        }
        return fragment.getAndCacheRenderer(font, frc);
    }

    private void doDrawString(Graphics2D g, @NotNull ColoredFragment fragment, float x, float y) {
        String text2;
        if (fragment == null) {
            SimpleColoredComponent.$$$reportNull$$$0(19);
        }
        if (StringUtil.isEmpty(text2 = fragment.text)) {
            return;
        }
        this.getTextRenderer(fragment, g.getFont()).draw(g, x, y);
    }

    private float computeStringWidth(@NotNull ColoredFragment fragment, Font font) {
        String text2;
        if (fragment == null) {
            SimpleColoredComponent.$$$reportNull$$$0(20);
        }
        if (StringUtil.isEmpty(text2 = fragment.text)) {
            return 0.0f;
        }
        return this.getTextRenderer(fragment, font).getWidth();
    }

    @NotNull
    private static TextLayout createTextLayout(String text2, Font basefont, FontRenderContext fontRenderContext) {
        AttributedString string = new AttributedString(text2);
        int start2 = 0;
        int end = text2.length();
        AttributedCharacterIterator it = string.getIterator(new AttributedCharacterIterator.Attribute[0], start2, end);
        Font currentFont = basefont;
        int currentIndex = start2;
        char c = it.first();
        while (c != '\uffff') {
            Font font = basefont;
            if (!font.canDisplay(c)) {
                SuitableFontProvider provider;
                SuitableFontProvider[] suitableFontProviderArray = SuitableFontProvider.EP_NAME.getExtensions();
                int n = suitableFontProviderArray.length;
                for (int i = 0; i < n && (font = (provider = suitableFontProviderArray[i]).getFontAbleToDisplay(c, basefont.getSize(), basefont.getStyle(), basefont.getFamily())) == null; ++i) {
                }
            }
            int i = it.getIndex();
            if (!Comparing.equal(currentFont, font)) {
                if (i > currentIndex) {
                    string.addAttribute(TextAttribute.FONT, currentFont, currentIndex, i);
                }
                currentFont = font;
                currentIndex = i;
            }
            c = it.next();
        }
        if (currentIndex < end) {
            string.addAttribute(TextAttribute.FONT, currentFont, currentIndex, end);
        }
        return new TextLayout(string.getIterator(), fontRenderContext);
    }

    private static boolean needFontFallback(Font font, String text2) {
        return font.canDisplayUpTo(text2) != -1 && text2.indexOf(65535) == -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int findFragmentAt(int x) {
        this.updateFractionalMetrics();
        float curX = this.myIpad.left;
        if (this.myBorder != null) {
            curX += (float)this.myBorder.getBorderInsets((Component)this).left;
        }
        curX += (float)this.getInsets().left;
        if (this.myIcon != null && !this.myIconOnTheRight) {
            int iconRight = this.myIcon.getIconWidth() + this.myIconTextGap;
            if (x < iconRight) {
                return -2;
            }
            curX += (float)iconRight;
        }
        Font font = this.getBaseFont();
        int baseSize = font.getSize();
        boolean wasSmaller = false;
        List<ColoredFragment> list2 = this.myFragments;
        synchronized (list2) {
            curX += (float)this.computeTextAlignShift();
            for (int i = 0; i < this.myFragments.size(); ++i) {
                ColoredFragment fragment = this.myFragments.get(i);
                SimpleTextAttributes attributes = fragment.attributes;
                boolean isSmaller = attributes.isSmaller();
                if (font.getStyle() != attributes.getFontStyle() || isSmaller != wasSmaller) {
                    font = font.deriveFont(attributes.getFontStyle(), isSmaller ? UIUtil.getFontSize(UIUtil.FontSize.SMALL) : (float)baseSize);
                }
                wasSmaller = isSmaller;
                float curWidth = this.computeStringWidth(fragment, font);
                if ((float)x >= curX && (float)x < curX + curWidth) {
                    return i;
                }
                curX += curWidth;
                int fragmentPadding = fragment.padding;
                if (fragmentPadding <= 0 || !(curX < (float)fragmentPadding)) continue;
                curX = fragmentPadding;
            }
        }
        if (this.myIcon != null && this.myIconOnTheRight && (float)x >= (curX += (float)this.myIconTextGap) && (float)x < curX + (float)this.myIcon.getIconWidth()) {
            return -2;
        }
        return -1;
    }

    @Nullable
    public Object getFragmentTagAt(int x) {
        int index = this.findFragmentAt(x);
        return index < 0 ? null : this.getFragmentTag(index);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    protected JLabel formatToLabel(@NotNull JLabel label2) {
        if (label2 == null) {
            SimpleColoredComponent.$$$reportNull$$$0(21);
        }
        label2.setIcon(this.myIcon);
        List<ColoredFragment> list2 = this.myFragments;
        synchronized (list2) {
            if (!this.myFragments.isEmpty()) {
                StringBuilder sb = new StringBuilder();
                sb.append("<html><body style=\"white-space:nowrap\">");
                for (ColoredFragment fragment : this.myFragments) {
                    String text2 = fragment.text;
                    SimpleTextAttributes attributes = fragment.attributes;
                    Object tag2 = fragment.tag;
                    if (tag2 instanceof BrowserLauncherTag) {
                        SimpleColoredComponent.formatLink(sb, text2, attributes, ((BrowserLauncherTag)tag2).myUrl);
                        continue;
                    }
                    SimpleColoredComponent.formatText(sb, text2, attributes);
                }
                sb.append("</body></html>");
                label2.setText(sb.toString());
            }
        }
        JLabel jLabel = label2;
        if (jLabel == null) {
            SimpleColoredComponent.$$$reportNull$$$0(22);
        }
        return jLabel;
    }

    static void formatText(@NotNull StringBuilder builder2, @NotNull String fragment, @NotNull SimpleTextAttributes attributes) {
        if (builder2 == null) {
            SimpleColoredComponent.$$$reportNull$$$0(23);
        }
        if (fragment == null) {
            SimpleColoredComponent.$$$reportNull$$$0(24);
        }
        if (attributes == null) {
            SimpleColoredComponent.$$$reportNull$$$0(25);
        }
        if (!fragment.isEmpty()) {
            builder2.append("<span");
            SimpleColoredComponent.formatStyle(builder2, attributes);
            builder2.append('>').append(SimpleColoredComponent.convertFragment(fragment)).append("</span>");
        }
    }

    static void formatLink(@NotNull StringBuilder builder2, @NotNull String fragment, @NotNull SimpleTextAttributes attributes, @NotNull String url) {
        if (builder2 == null) {
            SimpleColoredComponent.$$$reportNull$$$0(26);
        }
        if (fragment == null) {
            SimpleColoredComponent.$$$reportNull$$$0(27);
        }
        if (attributes == null) {
            SimpleColoredComponent.$$$reportNull$$$0(28);
        }
        if (url == null) {
            SimpleColoredComponent.$$$reportNull$$$0(29);
        }
        if (!fragment.isEmpty()) {
            builder2.append("<a href=\"").append(StringUtil.replace(url, "\"", "%22")).append("\"");
            SimpleColoredComponent.formatStyle(builder2, attributes);
            builder2.append('>').append(SimpleColoredComponent.convertFragment(fragment)).append("</a>");
        }
    }

    private static String convertFragment(@NotNull String fragment) {
        if (fragment == null) {
            SimpleColoredComponent.$$$reportNull$$$0(30);
        }
        return StringUtil.escapeXmlEntities(fragment).replaceAll("\\\\n", "<br>");
    }

    private static void formatStyle(StringBuilder builder2, SimpleTextAttributes attributes) {
        Color fgColor = attributes.getFgColor();
        Color bgColor = attributes.getBgColor();
        int style = attributes.getStyle();
        int pos = builder2.length();
        if (fgColor != null) {
            builder2.append("color:").append(ColorUtil.toHtmlColor(fgColor)).append(';');
        }
        if (bgColor != null) {
            builder2.append("background-color:").append(ColorUtil.toHtmlColor(bgColor)).append(';');
        }
        if ((style & 1) != 0) {
            builder2.append("font-weight:bold;");
        }
        if ((style & 2) != 0) {
            builder2.append("font-style:italic;");
        }
        if ((style & 0x10) != 0) {
            builder2.append("text-decoration:underline;");
        } else if ((style & 4) != 0) {
            builder2.append("text-decoration:line-through;");
        }
        if (builder2.length() > pos) {
            builder2.insert(pos, " style=\"");
            builder2.append('\"');
        }
    }

    @Override
    protected void paintComponent(Graphics g) {
        try {
            this.doPaint((Graphics2D)g);
        }
        catch (RuntimeException e) {
            LOG.error(this.logSwingPath(), e);
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doPaint(Graphics2D g) {
        List<ColoredFragment> list2 = this.myFragments;
        synchronized (list2) {
            int offset = 0;
            Icon icon2 = this.myIcon;
            if (icon2 != null && !this.myIconOnTheRight) {
                this.doPaintIcon(g, icon2, 0);
                offset += this.myIpad.left + icon2.getIconWidth() + this.myIconTextGap;
            }
            this.doPaintTextBackground(g, offset);
            offset = this.doPaintText(g, offset, this.myFocusBorderAroundIcon || icon2 == null) + this.myIconTextGap;
            if (icon2 != null && this.myIconOnTheRight) {
                this.doPaintIcon(g, icon2, offset);
            }
        }
    }

    private void doPaintTextBackground(Graphics2D g, int offset) {
        if (this.isOpaque() || this.shouldDrawBackground()) {
            this.paintBackground(g, offset, this.getWidth() - offset, this.getHeight());
        }
    }

    protected void paintBackground(Graphics2D g, int x, int width, int height) {
        g.setColor(this.getBackground());
        g.fillRect(x, 0, width, height);
    }

    protected void doPaintIcon(@NotNull Graphics2D g, @NotNull Icon icon2, int offset) {
        if (g == null) {
            SimpleColoredComponent.$$$reportNull$$$0(31);
        }
        if (icon2 == null) {
            SimpleColoredComponent.$$$reportNull$$$0(32);
        }
        Container parent = this.getParent();
        Color iconBackgroundColor = null;
        if ((this.isOpaque() || this.isIconOpaque()) && !this.isTransparentIconBackground()) {
            iconBackgroundColor = parent != null && !this.myFocusBorderAroundIcon && !UIUtil.isFullRowSelectionLAF() ? parent.getBackground() : this.getBackground();
        }
        if (iconBackgroundColor != null) {
            g.setColor(iconBackgroundColor);
            g.fillRect(offset, 0, icon2.getIconWidth() + this.myIpad.left + this.myIconTextGap, this.getHeight());
        }
        this.paintIcon(g, icon2, offset + this.myIpad.left);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int doPaintText(Graphics2D g, int textStart, boolean focusAroundIcon) {
        this.updateFractionalMetrics();
        List<ColoredFragment> list2 = this.myFragments;
        synchronized (list2) {
            if (textStart == 0) {
                textStart = this.myIpad.left;
            }
            float offset = textStart;
            if (this.myBorder != null) {
                offset += (float)this.myBorder.getBorderInsets((Component)this).left;
            }
            offset += (float)this.getInsets().left;
            int height = this.getHeight();
            this.applyAdditionalHints(g);
            Font baseFont = this.getBaseFont();
            g.setFont(baseFont);
            offset += (float)this.computeTextAlignShift();
            int baseSize = baseFont.getSize();
            FontMetrics baseMetrics = g.getFontMetrics();
            Rectangle area = this.computePaintArea();
            int textBaseline = area.y + SimpleColoredComponent.getTextBaseLine(baseMetrics, area.height);
            boolean wasSmaller = false;
            class Frag {
                private final int index;
                private final float start;
                private final float end;
                private final float baseLine;
                private final Font font;
                private final Frag next;

                Frag(int index, float start2, float end, @NotNull float baseLine, Font font, Frag next) {
                    if (font == null) {
                        Frag.$$$reportNull$$$0(0);
                    }
                    this.index = index;
                    this.start = start2;
                    this.end = end;
                    this.baseLine = baseLine;
                    this.font = font;
                    this.next = next;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "font", "com/intellij/ui/SimpleColoredComponent$1Frag", "<init>"));
                }
            }
            Frag secondPassFrag = null;
            for (int i = 0; i < this.myFragments.size(); ++i) {
                float endOffset;
                Color bgColor;
                ColoredFragment fragment = this.myFragments.get(i);
                SimpleTextAttributes attributes = fragment.attributes;
                Font font = g.getFont();
                boolean isSmaller = attributes.isSmaller();
                if (font.getStyle() != attributes.getFontStyle() || isSmaller != wasSmaller) {
                    font = font.deriveFont(attributes.getFontStyle(), isSmaller ? UIUtil.getFontSize(UIUtil.FontSize.SMALL) : (float)baseSize);
                }
                wasSmaller = isSmaller;
                g.setFont(font);
                FontMetrics metrics = g.getFontMetrics(font);
                float fragmentWidth = this.computeStringWidth(fragment, font);
                int fragmentPadding = fragment.padding;
                boolean secondPass = attributes.isSearchMatch() || attributes.isClickable();
                Color color = bgColor = secondPass ? null : attributes.getBgColor();
                if ((attributes.isOpaque() || this.isOpaque()) && bgColor != null) {
                    this.doPaintFragmentBackground(g, i, bgColor, (int)offset, 0, (int)fragmentWidth, height);
                }
                Color color2 = this.isEnabled() ? this.getActiveTextColor(attributes.getFgColor()) : UIUtil.getInactiveTextColor();
                g.setColor(color2);
                int fragmentAlignment = fragment.alignment;
                if (fragmentPadding > 0 && (float)fragmentPadding > fragmentWidth) {
                    endOffset = fragmentPadding;
                    if (fragmentAlignment == 4 || fragmentAlignment == 11) {
                        offset = (float)fragmentPadding - fragmentWidth;
                    }
                } else {
                    endOffset = offset + fragmentWidth;
                }
                if ((double)offset < area.getMaxX()) {
                    if (!secondPass) {
                        if (this.shouldDrawDimmed()) {
                            color2 = ColorUtil.dimmer(color2);
                        }
                        g.setColor(color2);
                        this.doDrawString(g, fragment, offset, textBaseline);
                        g.setStroke(g.getStroke());
                        this.drawTextAttributes(g, attributes, (int)offset, textBaseline, (int)fragmentWidth, metrics, font);
                    }
                    if (secondPass) {
                        secondPassFrag = new Frag(i, offset, offset + fragmentWidth, textBaseline, font, secondPassFrag);
                    }
                }
                offset = endOffset;
            }
            if (this.myPaintFocusBorder && this.myBorder != null) {
                int width = this.getWidth();
                if (focusAroundIcon) {
                    this.myBorder.paintBorder(this, g, 0, 0, width, height);
                } else {
                    this.myBorder.paintBorder(this, g, textStart, 0, width - textStart, height);
                }
            }
            Frag frag = secondPassFrag;
            while (frag != null) {
                block25: {
                    Color fgColor;
                    SimpleTextAttributes attributes;
                    String text2;
                    float baseline;
                    float x2;
                    float x1;
                    block24: {
                        block23: {
                            x1 = frag.start;
                            x2 = frag.end;
                            baseline = frag.baseLine;
                            ColoredFragment fragment = this.myFragments.get(frag.index);
                            text2 = fragment.text;
                            attributes = fragment.attributes;
                            if (!attributes.isSearchMatch()) break block23;
                            fgColor = new JBColor(Gray._50, Gray._0);
                            UIUtil.drawSearchMatch(g, x1, x2, height);
                            break block24;
                        }
                        if (!attributes.isClickable()) break block25;
                        boolean selected2 = UIUtil.getTreeSelectionBackground(true) == this.getBackground();
                        fgColor = ObjectUtils.notNull(attributes.getFgColor(), UIUtil.getLabelForeground());
                        SimpleColoredComponent.drawClickableFrag(g, x1, x2, height, selected2, attributes.isHovered(), attributes.isNoBorder());
                    }
                    g.setFont(frag.font);
                    g.setColor(fgColor);
                    g.drawString(text2, x1, baseline);
                    int fragmentWidth = (int)(x2 - x1);
                    this.drawTextAttributes(g, attributes, (int)x1, (int)baseline, fragmentWidth, g.getFontMetrics(), g.getFont());
                }
                frag = frag.next;
            }
            return (int)offset;
        }
    }

    protected Color getActiveTextColor(Color attributesColor) {
        return attributesColor != null ? attributesColor : this.getForeground();
    }

    protected void doPaintFragmentBackground(@NotNull Graphics2D g, int index, @NotNull Color bgColor, int x, int y, int width, int height) {
        if (g == null) {
            SimpleColoredComponent.$$$reportNull$$$0(33);
        }
        if (bgColor == null) {
            SimpleColoredComponent.$$$reportNull$$$0(34);
        }
        g.setColor(bgColor);
        g.fillRect(x, y, width, height);
    }

    private static void drawClickableFrag(Graphics2D g, float x1, float x2, int height, boolean selected2, boolean hovered, boolean noBorder) {
        if (noBorder) {
            return;
        }
        GraphicsConfig c = GraphicsUtil.setupRoundedBorderAntialiasing(g);
        RoundRectangle2D.Float shape = new RoundRectangle2D.Float(x1 + 1.0f, 2.0f, x2 - x1 - 2.0f, height - 4, 6.0f, 6.0f);
        g.setColor(JBUI.CurrentTheme.ActionButton.hoverBackground());
        if (hovered && !selected2) {
            g.fill(shape);
        } else {
            g.draw(shape);
        }
        c.restore();
    }

    private void drawTextAttributes(@NotNull Graphics2D g, @NotNull SimpleTextAttributes attributes, int offset, int textBaseline, int fragmentWidth, @NotNull FontMetrics metrics, Font font) {
        if (g == null) {
            SimpleColoredComponent.$$$reportNull$$$0(35);
        }
        if (attributes == null) {
            SimpleColoredComponent.$$$reportNull$$$0(36);
        }
        if (metrics == null) {
            SimpleColoredComponent.$$$reportNull$$$0(37);
        }
        if (attributes.isStrikeout()) {
            EffectPainter.STRIKE_THROUGH.paint(g, offset, textBaseline, fragmentWidth, SimpleColoredComponent.getCharHeight(g), font);
        }
        if (attributes.isWaved()) {
            if (attributes.getWaveColor() != null) {
                g.setColor(attributes.getWaveColor());
            }
            EffectPainter.WAVE_UNDERSCORE.paint(g, offset, textBaseline + 1, fragmentWidth, Math.max(2, metrics.getDescent()), font);
        }
        if (attributes.isUnderline()) {
            EffectPainter.LINE_UNDERSCORE.paint(g, offset, textBaseline, fragmentWidth, metrics.getDescent(), font);
        }
        if (attributes.isBoldDottedLine()) {
            int dottedAt = SystemInfo.isMac ? textBaseline : textBaseline + 1;
            Color lineColor = attributes.getWaveColor();
            UIUtil.drawBoldDottedLine(g, offset, offset + fragmentWidth, dottedAt, attributes.getBgColor(), lineColor, this.isOpaque());
        }
    }

    private static int getCharHeight(Graphics g) {
        return g.getFontMetrics().charWidth('a');
    }

    private int computeTextAlignShift() {
        if (this.myTextAlign == 2 || this.myTextAlign == 10) {
            return 0;
        }
        int componentWidth = this.getSize().width;
        int excessiveWidth = componentWidth - this.computePreferredSize((boolean)false).width;
        if (excessiveWidth <= 0) {
            return 0;
        }
        if (this.myTextAlign == 0) {
            return excessiveWidth / 2;
        }
        if (this.myTextAlign == 4 || this.myTextAlign == 11) {
            return excessiveWidth;
        }
        return 0;
    }

    @Deprecated
    protected boolean shouldDrawMacShadow() {
        return false;
    }

    protected boolean shouldDrawDimmed() {
        return false;
    }

    protected boolean shouldDrawBackground() {
        return false;
    }

    protected void paintIcon(@NotNull Graphics g, @NotNull Icon icon2, int offset) {
        if (g == null) {
            SimpleColoredComponent.$$$reportNull$$$0(38);
        }
        if (icon2 == null) {
            SimpleColoredComponent.$$$reportNull$$$0(39);
        }
        Rectangle area = this.computePaintArea();
        icon2.paintIcon(this, g, offset, area.y + (area.height - icon2.getIconHeight() + 1) / 2);
    }

    protected void applyAdditionalHints(@NotNull Graphics2D g) {
        if (g == null) {
            SimpleColoredComponent.$$$reportNull$$$0(40);
        }
        UISettings.setupAntialiasing(g);
        g.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, this.getClientProperty(RenderingHints.KEY_FRACTIONALMETRICS));
    }

    @Override
    public int getBaseline(int width, int height) {
        this.updateFractionalMetrics();
        super.getBaseline(width, height);
        return SimpleColoredComponent.getTextBaseLine(this.getFontMetrics(this.getFont()), height);
    }

    public boolean isTransparentIconBackground() {
        return this.myTransparentIconBackground;
    }

    public void setTransparentIconBackground(boolean transparentIconBackground) {
        this.myTransparentIconBackground = transparentIconBackground;
    }

    public static int getTextBaseLine(@NotNull FontMetrics metrics, int height) {
        if (metrics == null) {
            SimpleColoredComponent.$$$reportNull$$$0(41);
        }
        return (height - metrics.getHeight()) / 2 + metrics.getAscent() + (SystemInfo.isJetBrainsJvm ? metrics.getLeading() : 0);
    }

    @NotNull
    private String logSwingPath() {
        StringBuilder buffer = new StringBuilder("Components hierarchy:\n");
        for (Container c = this; c != null; c = c.getParent()) {
            buffer.append('\n');
            buffer.append(c);
        }
        String string = buffer.toString();
        if (string == null) {
            SimpleColoredComponent.$$$reportNull$$$0(42);
        }
        return string;
    }

    protected void setBorderInsets(Insets insets) {
        this.myBorder = new JBEmptyBorder(insets);
        this.revalidateAndRepaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    public CharSequence getCharSequence(boolean mainOnly) {
        List<ColoredFragment> list2 = this.myFragments;
        // MONITORENTER : list2
        int count = this.myFragments.size();
        if (count == 0) {
            // MONITOREXIT : list2
            return "";
        }
        if (mainOnly && this.myMainTextLastIndex > -1 && this.myMainTextLastIndex + 1 < this.myFragments.size()) {
            count = this.myMainTextLastIndex + 1;
        }
        StringBuilder sb = new StringBuilder(this.myFragments.get(0).text);
        int i = 1;
        while (true) {
            if (i >= count) {
                String string = sb.toString();
                // MONITOREXIT : list2
                if (string != null) return string;
                SimpleColoredComponent.$$$reportNull$$$0(44);
                return string;
            }
            sb.append(this.myFragments.get(i).text);
            ++i;
        }
    }

    @Override
    public String toString() {
        return this.getCharSequence(false).toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void change(@NotNull Runnable runnable2, boolean autoInvalidate) {
        if (runnable2 == null) {
            SimpleColoredComponent.$$$reportNull$$$0(45);
        }
        boolean old = this.myAutoInvalidate;
        this.myAutoInvalidate = autoInvalidate;
        try {
            runnable2.run();
        }
        finally {
            this.myAutoInvalidate = old;
        }
    }

    @Override
    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleSimpleColoredComponent();
        }
        return this.accessibleContext;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 16: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 45: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 16: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 45: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ui/SimpleColoredComponent";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 11: 
            case 18: 
            case 19: 
            case 20: 
            case 24: 
            case 27: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fragment";
                break;
            }
            case 4: 
            case 6: 
            case 8: 
            case 10: 
            case 12: 
            case 25: 
            case 28: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attributes";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ipad";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "font";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "label";
                break;
            }
            case 23: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 31: 
            case 33: 
            case 35: 
            case 38: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "g";
                break;
            }
            case 32: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "icon";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bgColor";
                break;
            }
            case 37: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "metrics";
                break;
            }
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "iterator";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 16: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 45: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ui/SimpleColoredComponent";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "append";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getIpad";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "computePreferredSize";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getBaseFont";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "formatToLabel";
                break;
            }
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "logSwingPath";
                break;
            }
            case 43: 
            case 44: {
                objectArray = objectArray2;
                objectArray2[1] = "getCharSequence";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "append";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "_append";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "setIpad";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "computeTextWidth";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getTextRenderer";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "doDrawString";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "computeStringWidth";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "formatToLabel";
                break;
            }
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "formatText";
                break;
            }
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "formatLink";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "convertFragment";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "doPaintIcon";
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "doPaintFragmentBackground";
                break;
            }
            case 35: 
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "drawTextAttributes";
                break;
            }
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "paintIcon";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "applyAdditionalHints";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "getTextBaseLine";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "change";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 16: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 45: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class SimpleTextRenderer
    implements TextRenderer {
        private final String myText;
        private final float myWidth;

        private SimpleTextRenderer(String text2, float width) {
            this.myText = text2;
            this.myWidth = width;
        }

        @Override
        public float getWidth() {
            return this.myWidth;
        }

        @Override
        public void draw(Graphics2D g2, float x, float y) {
            g2.drawString(this.myText, x, y);
        }
    }

    private static class LayoutTextRenderer
    implements TextRenderer {
        private final TextLayout myLayout;

        private LayoutTextRenderer(TextLayout layout) {
            this.myLayout = layout;
        }

        @Override
        public float getWidth() {
            return this.myLayout.getAdvance();
        }

        @Override
        public void draw(Graphics2D g2, float x, float y) {
            this.myLayout.draw(g2, x, y);
        }
    }

    private static interface TextRenderer {
        public float getWidth();

        public void draw(Graphics2D var1, float var2, float var3);
    }

    private static class ColoredFragment {
        @NotNull
        private volatile String text;
        @NotNull
        volatile SimpleTextAttributes attributes;
        @Nullable
        volatile Object tag;
        @Nullable
        private volatile TextRenderer renderer;
        volatile int padding;
        volatile int alignment;

        ColoredFragment(@NotNull String text2, @NotNull SimpleTextAttributes attributes) {
            if (text2 == null) {
                ColoredFragment.$$$reportNull$$$0(0);
            }
            if (attributes == null) {
                ColoredFragment.$$$reportNull$$$0(1);
            }
            this.text = text2;
            this.attributes = attributes;
        }

        private void setText(@NotNull String text2) {
            if (text2 == null) {
                ColoredFragment.$$$reportNull$$$0(2);
            }
            if (!this.text.equals(text2)) {
                this.text = text2;
                this.invalidateLayout();
            }
        }

        void invalidateLayout() {
            this.renderer = null;
        }

        @NotNull
        private TextRenderer getAndCacheRenderer(Font font, FontRenderContext frc) {
            TextRenderer renderer = this.renderer;
            if (renderer == null) {
                String text2 = this.text;
                renderer = SimpleColoredComponent.needFontFallback(font, text2) ? new LayoutTextRenderer(SimpleColoredComponent.createTextLayout(text2, font, frc)) : new SimpleTextRenderer(text2, (float)font.getStringBounds(text2, frc).getWidth());
                this.renderer = renderer;
            }
            TextRenderer textRenderer = renderer;
            if (textRenderer == null) {
                ColoredFragment.$$$reportNull$$$0(3);
            }
            return textRenderer;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "attributes";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ui/SimpleColoredComponent$ColoredFragment";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ui/SimpleColoredComponent$ColoredFragment";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getAndCacheRenderer";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "setText";
                    break;
                }
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private class MyIterator
    implements ColoredIterator {
        int myIndex = -1;
        int myOffset;
        int myEndOffset;

        private MyIterator() {
        }

        @Override
        public int getOffset() {
            return this.myOffset;
        }

        @Override
        public int getEndOffset() {
            return this.myEndOffset;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        @Override
        @NotNull
        public String getFragment() {
            List list2 = SimpleColoredComponent.this.myFragments;
            // MONITORENTER : list2
            String string = ((ColoredFragment)SimpleColoredComponent.this.myFragments.get(this.myIndex)).text;
            // MONITOREXIT : list2
            if (string != null) return string;
            MyIterator.$$$reportNull$$$0(0);
            return string;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        @Override
        @NotNull
        public SimpleTextAttributes getTextAttributes() {
            List list2 = SimpleColoredComponent.this.myFragments;
            // MONITORENTER : list2
            SimpleTextAttributes simpleTextAttributes = ((ColoredFragment)((SimpleColoredComponent)SimpleColoredComponent.this).myFragments.get((int)this.myIndex)).attributes;
            // MONITOREXIT : list2
            if (simpleTextAttributes != null) return simpleTextAttributes;
            MyIterator.$$$reportNull$$$0(1);
            return simpleTextAttributes;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @Nullable
        public Object getTag() {
            List list2 = SimpleColoredComponent.this.myFragments;
            synchronized (list2) {
                return ((ColoredFragment)((SimpleColoredComponent)SimpleColoredComponent.this).myFragments.get((int)this.myIndex)).tag;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int split(int offset, @NotNull SimpleTextAttributes attributes) {
            if (attributes == null) {
                MyIterator.$$$reportNull$$$0(2);
            }
            List list2 = SimpleColoredComponent.this.myFragments;
            synchronized (list2) {
                if (offset < 0 || offset > this.myEndOffset - this.myOffset) {
                    throw new IllegalArgumentException(offset + " is not within [0, " + (this.myEndOffset - this.myOffset) + "]");
                }
                ColoredFragment oldFragment = (ColoredFragment)SimpleColoredComponent.this.myFragments.get(this.myIndex);
                if (offset == this.myEndOffset - this.myOffset) {
                    oldFragment.attributes = attributes;
                } else if (offset > 0) {
                    String text2 = this.getFragment();
                    ColoredFragment newFragment = new ColoredFragment(text2.substring(offset), oldFragment.attributes);
                    oldFragment.setText(text2.substring(0, offset));
                    oldFragment.attributes = attributes;
                    newFragment.tag = oldFragment;
                    SimpleColoredComponent.this.myFragments.add(this.myIndex + 1, newFragment);
                    ++this.myIndex;
                }
                this.myOffset += offset;
                return this.myOffset;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean hasNext() {
            List list2 = SimpleColoredComponent.this.myFragments;
            synchronized (list2) {
                return this.myIndex + 1 < SimpleColoredComponent.this.myFragments.size();
            }
        }

        @Override
        public String next() {
            ++this.myIndex;
            this.myOffset = this.myEndOffset;
            String text2 = this.getFragment();
            this.myEndOffset += text2.length();
            return text2;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setFragment(@NotNull String text2) {
            if (text2 == null) {
                MyIterator.$$$reportNull$$$0(3);
            }
            List list2 = SimpleColoredComponent.this.myFragments;
            synchronized (list2) {
                ((ColoredFragment)SimpleColoredComponent.this.myFragments.get(this.myIndex)).setText(text2);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setTag(@Nullable Object tag2) {
            List list2 = SimpleColoredComponent.this.myFragments;
            synchronized (list2) {
                ((ColoredFragment)((SimpleColoredComponent)SimpleColoredComponent.this).myFragments.get((int)this.myIndex)).tag = tag2;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setTextAttributes(@NotNull SimpleTextAttributes attributes) {
            if (attributes == null) {
                MyIterator.$$$reportNull$$$0(4);
            }
            List list2 = SimpleColoredComponent.this.myFragments;
            synchronized (list2) {
                ((ColoredFragment)((SimpleColoredComponent)SimpleColoredComponent.this).myFragments.get((int)this.myIndex)).attributes = attributes;
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ui/SimpleColoredComponent$MyIterator";
                    break;
                }
                case 2: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "attributes";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFragment";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTextAttributes";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ui/SimpleColoredComponent$MyIterator";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "split";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "setFragment";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "setTextAttributes";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static interface ColoredIterator
    extends Iterator<String> {
        public int getOffset();

        public int getEndOffset();

        @NotNull
        public String getFragment();

        @NotNull
        public SimpleTextAttributes getTextAttributes();

        @Nullable
        public Object getTag();

        public int split(int var1, @NotNull SimpleTextAttributes var2);

        public void setFragment(@NotNull String var1);

        public void setTag(@Nullable Object var1);

        public void setTextAttributes(@NotNull SimpleTextAttributes var1);
    }

    public static class BrowserLauncherTag
    implements Runnable {
        private final String myUrl;

        public BrowserLauncherTag(@NotNull String url) {
            if (url == null) {
                BrowserLauncherTag.$$$reportNull$$$0(0);
            }
            this.myUrl = url;
        }

        @Override
        public void run() {
            BrowserUtil.browse(this.myUrl);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "com/intellij/ui/SimpleColoredComponent$BrowserLauncherTag", "<init>"));
        }
    }

    protected class AccessibleSimpleColoredComponent
    extends JComponent.AccessibleJComponent {
        protected AccessibleSimpleColoredComponent() {
            super(SimpleColoredComponent.this);
        }

        @Override
        public String getAccessibleName() {
            return SimpleColoredComponent.this.getCharSequence(false).toString();
        }

        @Override
        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.LABEL;
        }
    }
}

