/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.diagnostic.Activity;
import com.intellij.diagnostic.StartUpMeasurer;
import com.intellij.openapi.application.ex.ApplicationInfoEx;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.ui.ProgressSlidePainter;
import com.intellij.ui.ScreenUtil;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.ui.scale.ScaleContext;
import com.intellij.util.ImageLoader;
import com.intellij.util.ui.JBImageIcon;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.StartupUiUtil;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Window;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class Splash
extends Window {
    private static final float JBUI_INIT_SCALE = JBUIScale.scale(1.0f);
    private final ApplicationInfoEx myInfo;
    private final int myWidth;
    private final int myHeight;
    private final int myProgressHeight;
    private final int myProgressY;
    private double myProgress;
    private int myProgressLastPosition;
    private final Icon myProgressTail;
    private final ProgressSlidePainter myProgressSlidePainter;
    private final Image myImage;

    public Splash(@NotNull ApplicationInfoEx info) {
        if (info == null) {
            Splash.$$$reportNull$$$0(0);
        }
        super((Frame)null);
        this.myProgressLastPosition = 0;
        this.myInfo = info;
        this.myProgressSlidePainter = new ProgressSlidePainter(this.myInfo);
        this.myProgressHeight = Splash.uiScale(info.getProgressHeight());
        this.myProgressY = Splash.uiScale(info.getProgressY());
        this.myProgressTail = Splash.getProgressTailIcon(info);
        this.setFocusableWindowState(false);
        this.myImage = Splash.loadImage(info.getSplashImageUrl());
        this.myWidth = this.myImage.getWidth(null);
        this.myHeight = this.myImage.getHeight(null);
        Dimension size = new Dimension(this.myWidth, this.myHeight);
        this.setAutoRequestFocus(false);
        this.setSize(size);
        this.setLocationInTheCenterOfScreen();
    }

    @Nullable
    private static Icon getProgressTailIcon(@NotNull ApplicationInfoEx info) {
        if (info == null) {
            Splash.$$$reportNull$$$0(1);
        }
        String progressTailIconName = info.getProgressTailIcon();
        JBImageIcon progressTail = null;
        if (progressTailIconName != null) {
            try {
                Image image = ImageLoader.loadFromUrl(Splash.class.getResource(progressTailIconName));
                if (image != null) {
                    progressTail = new JBImageIcon(image);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return progressTail;
    }

    public void initAndShow(Boolean visible) {
        this.myProgressSlidePainter.startPreloading();
        StartUpMeasurer.addInstantEvent("splash shown");
        Activity activity = StartUpMeasurer.startActivity("splash set visible");
        this.setVisible(visible);
        activity.end();
        if (visible.booleanValue()) {
            this.paint(this.getGraphics());
            this.toFront();
        }
    }

    @Override
    public void dispose() {
        super.dispose();
    }

    @NotNull
    private static Image loadImage(@NotNull String path2) {
        Image result2;
        if (path2 == null) {
            Splash.$$$reportNull$$$0(2);
        }
        if ((result2 = ImageLoader.loadFromUrl(path2, Splash.class, 1, null, ScaleContext.create())) == null) {
            throw new IllegalStateException("Cannot find image: " + path2);
        }
        Image image = result2;
        if (image == null) {
            Splash.$$$reportNull$$$0(3);
        }
        return image;
    }

    @Override
    public void paint(Graphics g) {
        if (this.myProgress < 0.1 || !this.myProgressSlidePainter.hasSlides) {
            StartupUiUtil.drawImage(g, this.myImage, 0, 0, null);
        } else {
            this.paintProgress(g);
        }
    }

    private void setLocationInTheCenterOfScreen() {
        Rectangle bounds2 = this.getGraphicsConfiguration().getBounds();
        if (SystemInfo.isWindows) {
            JBInsets.removeFrom(bounds2, ScreenUtil.getScreenInsets(this.getGraphicsConfiguration()));
        }
        this.setLocation(StartupUiUtil.getCenterPoint(bounds2, this.getSize()));
    }

    public void showProgress(double progress2) {
        if (this.myInfo.getProgressColor() == null) {
            return;
        }
        if (progress2 - this.myProgress > 0.01 || progress2 > 0.99) {
            this.myProgress = progress2;
            Graphics graphics = this.getGraphics();
            if (graphics != null) {
                this.paintProgress(graphics);
            }
        }
    }

    private void paintProgress(@Nullable Graphics g) {
        Color color;
        if (g == null) {
            return;
        }
        if (this.myProgressSlidePainter.hasSlides) {
            this.myProgressSlidePainter.paintSlides(g, this.myProgress);
        }
        if ((color = this.myInfo.getProgressColor()) == null) {
            return;
        }
        int progressWidth = (int)((double)this.myWidth * this.myProgress);
        int currentWidth = progressWidth - this.myProgressLastPosition;
        if (currentWidth == 0) {
            return;
        }
        g.setColor(color);
        int y = this.myProgressSlidePainter.hasSlides ? this.myHeight - this.myProgressHeight : this.myProgressY;
        g.fillRect(this.myProgressLastPosition, y, currentWidth, this.myProgressHeight);
        if (this.myProgressTail != null) {
            int tx = (int)((float)currentWidth - (float)this.myProgressTail.getIconWidth() / JBUI_INIT_SCALE / 2.0f * JBUI_INIT_SCALE);
            int ty = (int)((float)this.myProgressY - (float)(this.myProgressTail.getIconHeight() - this.myProgressHeight) / JBUI_INIT_SCALE / 2.0f * JBUI_INIT_SCALE);
            this.myProgressTail.paintIcon(this, g, tx, ty);
        }
        this.myProgressLastPosition = progressWidth;
    }

    private static int uiScale(int i) {
        return (int)((float)i * JBUI_INIT_SCALE);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ui/Splash";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ui/Splash";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "loadImage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getProgressTailIcon";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "loadImage";
                break;
            }
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

