/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.ui.ComponentUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.ItemRemovable;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TableUtil {
    private TableUtil() {
    }

    @NotNull
    public static List<Object[]> removeSelectedItems(@NotNull JTable table) {
        if (table == null) {
            TableUtil.$$$reportNull$$$0(0);
        }
        return TableUtil.removeSelectedItems(table, null);
    }

    public static void selectRows(@NotNull JTable table, int @NotNull [] viewRows) {
        if (table == null) {
            TableUtil.$$$reportNull$$$0(1);
        }
        if (viewRows == null) {
            TableUtil.$$$reportNull$$$0(2);
        }
        ListSelectionModel selectionModel = table.getSelectionModel();
        selectionModel.clearSelection();
        int count = table.getRowCount();
        for (int row : viewRows) {
            if (row < 0 || row >= count) continue;
            selectionModel.addSelectionInterval(row, row);
        }
    }

    public static void scrollSelectionToVisible(@NotNull JTable table) {
        if (table == null) {
            TableUtil.$$$reportNull$$$0(3);
        }
        ListSelectionModel selectionModel = table.getSelectionModel();
        int maxSelectionIndex = selectionModel.getMaxSelectionIndex();
        int minSelectionIndex = selectionModel.getMinSelectionIndex();
        int maxColumnSelectionIndex = Math.max(0, table.getColumnModel().getSelectionModel().getMinSelectionIndex());
        int minColumnSelectionIndex = Math.max(0, table.getColumnModel().getSelectionModel().getMaxSelectionIndex());
        if (maxSelectionIndex == -1) {
            return;
        }
        Rectangle minCellRect = table.getCellRect(minSelectionIndex, minColumnSelectionIndex, false);
        Rectangle maxCellRect = table.getCellRect(maxSelectionIndex, maxColumnSelectionIndex, false);
        Point selectPoint = minCellRect.getLocation();
        int allHeight = maxCellRect.y + maxCellRect.height - minCellRect.y;
        allHeight = Math.min(allHeight, table.getHeight());
        table.scrollRectToVisible(new Rectangle(selectPoint, new Dimension(minCellRect.width / 2, allHeight)));
    }

    @NotNull
    public static List<Object[]> removeSelectedItems(@NotNull JTable table, @Nullable ItemChecker applyable) {
        TableModel model;
        if (table == null) {
            TableUtil.$$$reportNull$$$0(4);
        }
        if (!((model = table.getModel()) instanceof ItemRemovable)) {
            throw new RuntimeException("model must be instance of ItemRemovable");
        }
        if (table.getSelectionModel().isSelectionEmpty()) {
            return new ArrayList<Object[]>(0);
        }
        final SmartList removedItems = new SmartList();
        final ItemRemovable itemRemovable = (ItemRemovable)((Object)model);
        final int columnCount = model.getColumnCount();
        TableUtil.doRemoveSelectedItems(table, new ItemRemovable(){

            @Override
            public void removeRow(int index) {
                Object[] row = new Object[columnCount];
                for (int column = 0; column < columnCount; ++column) {
                    row[column] = model.getValueAt(index, column);
                }
                removedItems.add(row);
                itemRemovable.removeRow(index);
            }
        }, applyable);
        List<Object[]> list2 = ContainerUtil.reverse(removedItems);
        if (list2 == null) {
            TableUtil.$$$reportNull$$$0(5);
        }
        return list2;
    }

    public static boolean doRemoveSelectedItems(@NotNull JTable table, @NotNull ItemRemovable itemRemovable, @Nullable ItemChecker applyable) {
        if (table == null) {
            TableUtil.$$$reportNull$$$0(6);
        }
        if (itemRemovable == null) {
            TableUtil.$$$reportNull$$$0(7);
        }
        if (table.isEditing()) {
            table.getCellEditor().stopCellEditing();
        }
        ListSelectionModel selectionModel = table.getSelectionModel();
        int minSelectionIndex = selectionModel.getMinSelectionIndex();
        int maxSelectionIndex = selectionModel.getMaxSelectionIndex();
        if (minSelectionIndex == -1 || maxSelectionIndex == -1) {
            return false;
        }
        TableModel model = table.getModel();
        boolean removed = false;
        for (int index = maxSelectionIndex; index >= 0; --index) {
            int modelIndex = table.convertRowIndexToModel(index);
            if (!selectionModel.isSelectedIndex(index) || applyable != null && !applyable.isOperationApplyable(model, modelIndex)) continue;
            itemRemovable.removeRow(modelIndex);
            removed = true;
        }
        if (!removed) {
            return false;
        }
        int count = model.getRowCount();
        if (count == 0) {
            table.clearSelection();
        } else if (selectionModel.getMinSelectionIndex() == -1) {
            if (minSelectionIndex >= model.getRowCount()) {
                selectionModel.setSelectionInterval(model.getRowCount() - 1, model.getRowCount() - 1);
            } else {
                selectionModel.setSelectionInterval(minSelectionIndex, minSelectionIndex);
            }
        }
        return true;
    }

    public static int moveSelectedItemsUp(@NotNull JTable table) {
        if (table == null) {
            TableUtil.$$$reportNull$$$0(8);
        }
        if (table.isEditing()) {
            table.getCellEditor().stopCellEditing();
        }
        TableModel model = table.getModel();
        ListSelectionModel selectionModel = table.getSelectionModel();
        int counter = 0;
        for (int row = 0; row < model.getRowCount(); ++row) {
            if (!selectionModel.isSelectedIndex(row)) continue;
            ++counter;
            for (int column = 0; column < model.getColumnCount(); ++column) {
                Object temp = model.getValueAt(row, column);
                model.setValueAt(model.getValueAt(row - 1, column), row, column);
                model.setValueAt(temp, row - 1, column);
            }
            selectionModel.removeSelectionInterval(row, row);
            selectionModel.addSelectionInterval(row - 1, row - 1);
        }
        Rectangle cellRect = table.getCellRect(selectionModel.getMinSelectionIndex(), 0, true);
        if (cellRect != null) {
            table.scrollRectToVisible(cellRect);
        }
        table.repaint();
        return counter;
    }

    public static int moveSelectedItemsDown(@NotNull JTable table) {
        if (table == null) {
            TableUtil.$$$reportNull$$$0(9);
        }
        if (table.isEditing()) {
            table.getCellEditor().stopCellEditing();
        }
        TableModel model = table.getModel();
        ListSelectionModel selectionModel = table.getSelectionModel();
        int counter = 0;
        for (int row = model.getRowCount() - 1; row >= 0; --row) {
            if (!selectionModel.isSelectedIndex(row)) continue;
            ++counter;
            for (int column = 0; column < model.getColumnCount(); ++column) {
                Object temp = model.getValueAt(row, column);
                model.setValueAt(model.getValueAt(row + 1, column), row, column);
                model.setValueAt(temp, row + 1, column);
            }
            selectionModel.removeSelectionInterval(row, row);
            selectionModel.addSelectionInterval(row + 1, row + 1);
        }
        Rectangle cellRect = table.getCellRect(selectionModel.getMaxSelectionIndex(), 0, true);
        if (cellRect != null) {
            table.scrollRectToVisible(cellRect);
        }
        table.repaint();
        return counter;
    }

    public static void editCellAt(@NotNull JTable table, int row, int column) {
        Component component2;
        if (table == null) {
            TableUtil.$$$reportNull$$$0(10);
        }
        if (table.editCellAt(row, column) && (component2 = table.getEditorComponent()) != null) {
            component2.requestFocus();
        }
    }

    public static void stopEditing(@NotNull JTable table) {
        if (table == null) {
            TableUtil.$$$reportNull$$$0(11);
        }
        if (table.isEditing()) {
            TableCellEditor editor;
            TableCellEditor cellEditor = table.getCellEditor();
            if (cellEditor != null) {
                cellEditor.stopCellEditing();
            }
            int row = table.getSelectedRow();
            int column = table.getSelectedColumn();
            if (row >= 0 && column >= 0 && (editor = table.getCellEditor(row, column)) != null) {
                editor.stopCellEditing();
            }
        }
    }

    public static void ensureSelectionExists(@NotNull JTable table) {
        if (table == null) {
            TableUtil.$$$reportNull$$$0(12);
        }
        if (table.getSelectedRow() != -1 || table.getRowCount() == 0) {
            return;
        }
        table.setRowSelectionInterval(0, 0);
    }

    public static void setupCheckboxColumn(@NotNull JTable table, int columnIndex) {
        if (table == null) {
            TableUtil.$$$reportNull$$$0(13);
        }
        TableColumnModel cModel = table.getColumnModel();
        TableUtil.setupCheckboxColumn(cModel.getColumn(columnIndex), cModel.getColumnMargin());
    }

    @Deprecated
    public static void setupCheckboxColumn(@NotNull TableColumn column) {
        if (column == null) {
            TableUtil.$$$reportNull$$$0(14);
        }
        TableUtil.setupCheckboxColumn(column, 0);
    }

    public static void setupCheckboxColumn(@NotNull TableColumn column, int additionalWidth) {
        if (column == null) {
            TableUtil.$$$reportNull$$$0(15);
        }
        int checkboxWidth = new JCheckBox().getPreferredSize().width + additionalWidth;
        column.setResizable(false);
        column.setPreferredWidth(checkboxWidth);
        column.setMaxWidth(checkboxWidth);
        column.setMinWidth(checkboxWidth);
    }

    public static void updateScroller(@NotNull JTable table) {
        JScrollPane scrollPane;
        if (table == null) {
            TableUtil.$$$reportNull$$$0(16);
        }
        if ((scrollPane = ComponentUtil.getParentOfType(JScrollPane.class, table)) != null) {
            scrollPane.revalidate();
            scrollPane.repaint();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "table";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "viewRows";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ui/TableUtil";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "itemRemovable";
                break;
            }
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "column";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ui/TableUtil";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "removeSelectedItems";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "removeSelectedItems";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "selectRows";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "scrollSelectionToVisible";
                break;
            }
            case 5: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "doRemoveSelectedItems";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "moveSelectedItemsUp";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "moveSelectedItemsDown";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "editCellAt";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "stopEditing";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "ensureSelectionExists";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "setupCheckboxColumn";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "updateScroller";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static interface ItemChecker {
        public boolean isOperationApplyable(@NotNull TableModel var1, int var2);
    }
}

