/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.ui.Gray;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.JBLabel;
import com.intellij.util.ui.JBEmptyBorder;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.border.Border;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TitledSeparator
extends JPanel {
    public static final int TOP_INSET = 7;
    public static final int BOTTOM_INSET = 5;
    public static final int SEPARATOR_LEFT_INSET = 6;
    public static final int SEPARATOR_RIGHT_INSET = 0;
    private static final Color ENABLED_SEPARATOR_FOREGROUND = JBColor.namedColor("Group.separatorColor", new JBColor(Gray.xCD, Gray.x51));
    private static final Color DISABLED_SEPARATOR_FOREGROUND = JBColor.namedColor("Group.disabledSeparatorColor", ENABLED_SEPARATOR_FOREGROUND);
    protected final JBLabel myLabel = new JBLabel();
    protected final JSeparator mySeparator = new JSeparator(0);
    private String originalText;

    @NotNull
    public static Border createEmptyBorder() {
        JBEmptyBorder jBEmptyBorder = JBUI.Borders.empty(7, 0, 5, 0);
        if (jBEmptyBorder == null) {
            TitledSeparator.$$$reportNull$$$0(0);
        }
        return jBEmptyBorder;
    }

    public TitledSeparator() {
        this("");
    }

    public TitledSeparator(@Nls(capitalization=Nls.Capitalization.Title) String text2) {
        this(text2, null);
    }

    public TitledSeparator(@Nls(capitalization=Nls.Capitalization.Title) String text2, @Nullable JComponent labelFor) {
        this.mySeparator.setForeground(ENABLED_SEPARATOR_FOREGROUND);
        this.setLayout(new GridBagLayout());
        this.add((Component)this.myLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 1.0, 17, 0, JBUI.emptyInsets(), 0, 0));
        this.add((Component)this.mySeparator, new GridBagConstraints(1, 0, 0, 1, 1.0, 1.0, 10, 2, JBUI.insets(2, 6, 0, 0), 0, 0));
        this.setBorder(TitledSeparator.createEmptyBorder());
        this.setText(text2);
        this.setLabelFor(labelFor);
        this.setOpaque(false);
    }

    public String getText() {
        return this.originalText;
    }

    public void setText(@Nls(capitalization=Nls.Capitalization.Title) String text2) {
        this.originalText = text2;
        this.myLabel.setText(text2 != null && text2.startsWith("<html>") ? text2 : UIUtil.replaceMnemonicAmpersand(this.originalText));
    }

    public void setTitleFont(Font font) {
        this.myLabel.setFont(font);
    }

    public Font getTitleFont() {
        return this.myLabel.getFont();
    }

    public JLabel getLabel() {
        return this.myLabel;
    }

    public JSeparator getSeparator() {
        return this.mySeparator;
    }

    public Component getLabelFor() {
        return this.myLabel.getLabelFor();
    }

    public void setLabelFor(Component labelFor) {
        this.myLabel.setLabelFor(labelFor);
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.myLabel.setEnabled(enabled);
        this.mySeparator.setEnabled(enabled);
        this.mySeparator.setForeground(enabled ? ENABLED_SEPARATOR_FOREGROUND : DISABLED_SEPARATOR_FOREGROUND);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/TitledSeparator", "createEmptyBorder"));
    }
}

