/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.ui.SpeedSearchBase;
import com.intellij.ui.TableUtil;
import com.intellij.ui.TreeSpeedSearch;
import com.intellij.ui.treeStructure.treetable.TreeTable;
import com.intellij.util.containers.Convertor;
import javax.swing.JTable;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;

public class TreeTableSpeedSearch
extends SpeedSearchBase<TreeTable> {
    private static final Convertor<TreePath, String> TO_STRING = object -> {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)object.getLastPathComponent();
        return node.toString();
    };
    private final Convertor<? super TreePath, String> myToStringConvertor;

    public TreeTableSpeedSearch(TreeTable tree, Convertor<? super TreePath, String> toStringConvertor) {
        super(tree);
        this.myToStringConvertor = toStringConvertor;
    }

    public TreeTableSpeedSearch(TreeTable tree) {
        this(tree, TreeSpeedSearch.NODE_DESCRIPTOR_TOSTRING);
    }

    @Override
    protected boolean isSpeedSearchEnabled() {
        return !((TreeTable)this.getComponent()).isEditing() && super.isSpeedSearchEnabled();
    }

    @Override
    protected void selectElement(Object element2, String selectedText) {
        TreePath treePath = (TreePath)element2;
        int row = ((TreeTable)this.myComponent).getTree().getRowForPath(treePath);
        TableUtil.selectRows((JTable)this.myComponent, new int[]{((TreeTable)this.myComponent).convertRowIndexToView(row)});
        TableUtil.scrollSelectionToVisible((JTable)this.myComponent);
    }

    @Override
    protected int getSelectedIndex() {
        int[] selectionRows = ((TreeTable)this.myComponent).getTree().getSelectionRows();
        return selectionRows == null || selectionRows.length == 0 ? -1 : selectionRows[0];
    }

    @Override
    protected Object @NotNull [] getAllElements() {
        Object[] paths = new TreePath[((TreeTable)this.myComponent).getTree().getRowCount()];
        for (int i = 0; i < paths.length; ++i) {
            paths[i] = ((TreeTable)this.myComponent).getTree().getPathForRow(i);
        }
        if (paths == null) {
            TreeTableSpeedSearch.$$$reportNull$$$0(0);
        }
        return paths;
    }

    @Override
    protected String getElementText(Object element2) {
        TreePath path2 = (TreePath)element2;
        String string = this.myToStringConvertor.convert(path2);
        if (string == null) {
            return TO_STRING.convert(path2);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/TreeTableSpeedSearch", "getAllElements"));
    }
}

