/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.openapi.actionSystem.ActionToolbarPosition;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.AnActionButtonRunnable;
import com.intellij.ui.CommonActionsPanel;
import com.intellij.ui.RowsDnDSupport;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.treeStructure.SimpleNode;
import com.intellij.util.ui.EditableModel;
import com.intellij.util.ui.EditableTreeModel;
import com.intellij.util.ui.ElementProducer;
import com.intellij.util.ui.tree.TreeUtil;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Arrays;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.Nullable;

class TreeToolbarDecorator
extends ToolbarDecorator {
    private final JTree myTree;
    @Nullable
    private final ElementProducer<?> myProducer;

    TreeToolbarDecorator(JTree tree, @Nullable ElementProducer<?> producer) {
        this.myTree = tree;
        this.myProducer = producer;
        this.myUpActionEnabled = this.myDownActionEnabled = this.myTree.getModel() instanceof EditableTreeModel;
        this.myRemoveActionEnabled = this.myDownActionEnabled;
        this.myAddActionEnabled = this.myDownActionEnabled;
        if (this.myTree.getModel() instanceof EditableTreeModel) {
            this.createDefaultTreeActions();
        }
        this.myTree.getSelectionModel().addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                TreeToolbarDecorator.this.updateButtons();
            }
        });
        this.myTree.addPropertyChangeListener("enabled", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                TreeToolbarDecorator.this.updateButtons();
            }
        });
    }

    private void createDefaultTreeActions() {
        final EditableTreeModel model = (EditableTreeModel)((Object)this.myTree.getModel());
        this.myAddAction = new AnActionButtonRunnable(){

            @Override
            public void run(AnActionButton button2) {
                Object element2;
                TreePath path2 = TreeToolbarDecorator.this.myTree.getSelectionPath();
                DefaultMutableTreeNode selected2 = path2 == null ? (DefaultMutableTreeNode)TreeToolbarDecorator.this.myTree.getModel().getRoot() : (DefaultMutableTreeNode)path2.getLastPathComponent();
                Object selectedNode = selected2.getUserObject();
                TreeToolbarDecorator.this.myTree.stopEditing();
                if (model instanceof DefaultTreeModel && TreeToolbarDecorator.this.myProducer != null) {
                    element2 = TreeToolbarDecorator.this.myProducer.createElement();
                    if (element2 == null) {
                        return;
                    }
                } else {
                    element2 = null;
                }
                DefaultMutableTreeNode parent = selected2;
                if (selectedNode instanceof SimpleNode && ((SimpleNode)selectedNode).isAlwaysLeaf() || !selected2.getAllowsChildren()) {
                    parent = (DefaultMutableTreeNode)selected2.getParent();
                }
                if (parent != null) {
                    parent.insert(new DefaultMutableTreeNode(element2), parent.getChildCount());
                }
                TreePath createdPath = model.addNode(new TreePath(parent.getPath()));
                if (path2 != null) {
                    TreeUtil.selectPath(TreeToolbarDecorator.this.myTree, createdPath);
                    IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus(TreeToolbarDecorator.this.myTree, true));
                }
            }
        };
        this.myRemoveAction = new AnActionButtonRunnable(){

            @Override
            public void run(AnActionButton button2) {
                TreeToolbarDecorator.this.myTree.stopEditing();
                if (TreeToolbarDecorator.this.myTree.getSelectionModel().getSelectionMode() == 1) {
                    TreePath path2 = TreeToolbarDecorator.this.myTree.getSelectionPath();
                    if (path2 != null) {
                        model.removeNode(path2);
                    }
                } else {
                    TreePath[] paths = TreeToolbarDecorator.this.myTree.getSelectionPaths();
                    if (paths != null && paths.length > 0) {
                        model.removeNodes(Arrays.asList(paths));
                    }
                }
            }
        };
    }

    @Override
    public ToolbarDecorator initPosition() {
        return this.setToolbarPosition(SystemInfo.isMac ? ActionToolbarPosition.BOTTOM : ActionToolbarPosition.TOP);
    }

    @Override
    protected JComponent getComponent() {
        return this.myTree;
    }

    @Override
    protected void updateButtons() {
        this.getActionsPanel().setEnabled(CommonActionsPanel.Buttons.REMOVE, this.myTree.getSelectionPath() != null);
    }

    @Override
    public ToolbarDecorator setVisibleRowCount(int rowCount) {
        this.myTree.setVisibleRowCount(rowCount);
        return this;
    }

    @Override
    protected boolean isModelEditable() {
        return this.myTree.getModel() instanceof EditableModel;
    }

    @Override
    protected void installDnDSupport() {
        RowsDnDSupport.install(this.myTree, (EditableModel)((Object)this.myTree.getModel()));
    }
}

