/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.ui.ListSpeedSearch;
import com.intellij.ui.SelectionSaver;
import com.intellij.ui.SmartExpander;
import com.intellij.ui.TreeExpandableItemsHandler;
import com.intellij.ui.TreeSpeedSearch;
import com.intellij.ui.TreeUIHelper;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.EditSourceOnDoubleClickHandler;
import com.intellij.util.EditSourceOnEnterKeyHandler;
import com.intellij.util.containers.Convertor;
import javax.swing.JList;
import javax.swing.JTree;
import javax.swing.tree.TreePath;

public class TreeUIHelperImpl
extends TreeUIHelper {
    public void installToolTipHandler(JTree tree) {
        if (tree instanceof Tree) {
            return;
        }
        new TreeExpandableItemsHandler(tree);
    }

    public void installEditSourceOnDoubleClick(JTree tree) {
        EditSourceOnDoubleClickHandler.install(tree);
    }

    public void installTreeSpeedSearch(JTree tree) {
        new TreeSpeedSearch(tree);
    }

    public void installTreeSpeedSearch(JTree tree, Convertor<? super TreePath, String> convertor, boolean canExpand) {
        new TreeSpeedSearch(tree, convertor, canExpand);
    }

    public void installListSpeedSearch(JList<?> list2) {
        new ListSpeedSearch(list2);
    }

    public <T> void installListSpeedSearch(JList<T> list2, Convertor<? super T, String> convertor) {
        new ListSpeedSearch<Object>(list2, convertor::convert);
    }

    public void installEditSourceOnEnterKeyHandler(JTree tree) {
        EditSourceOnEnterKeyHandler.install(tree);
    }

    public void installSmartExpander(JTree tree) {
        SmartExpander.installOn(tree);
    }

    public void installSelectionSaver(JTree tree) {
        SelectionSaver.installOn(tree);
    }
}

