/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.awt;

import com.intellij.ui.awt.RelativePoint;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;

public class RelativeRectangle {
    private final RelativePoint myPoint;
    private final Dimension myDimension;

    public RelativeRectangle() {
        this(new RelativePoint(new JLabel(), new Point()), new Dimension());
    }

    public RelativeRectangle(MouseEvent event, Dimension size) {
        this(event.getComponent(), new Rectangle(event.getPoint(), size));
    }

    public RelativeRectangle(JComponent component2) {
        this(new RelativePoint(component2.getParent(), component2.getBounds().getLocation()), component2.getBounds().getSize());
    }

    public RelativeRectangle(Component component2, Rectangle rectangle) {
        this(new RelativePoint(component2, rectangle.getLocation()), rectangle.getSize());
    }

    public RelativeRectangle(RelativePoint point, Dimension dimension) {
        this.myDimension = dimension;
        this.myPoint = point;
    }

    public Dimension getDimension() {
        return this.myDimension;
    }

    public RelativePoint getPoint() {
        return this.myPoint;
    }

    public RelativePoint getMaxPoint() {
        return new RelativePoint(this.myPoint.getComponent(), new Point(this.myPoint.getPoint().x + this.myDimension.width, this.myPoint.getPoint().y + this.myDimension.height));
    }

    public Rectangle getRectangleOn(Component target2) {
        return new Rectangle(this.getPoint().getPoint(target2), this.getDimension());
    }

    public Rectangle getScreenRectangle() {
        return new Rectangle(this.getPoint().getScreenPoint(), this.getDimension());
    }

    public static RelativeRectangle fromScreen(JComponent target2, Rectangle screenRectangle) {
        Point relativePoint = screenRectangle.getLocation();
        SwingUtilities.convertPointFromScreen(relativePoint, target2);
        return new RelativeRectangle(new RelativePoint(target2, relativePoint), screenRectangle.getSize());
    }

    public Component getComponent() {
        return this.getPoint().getComponent();
    }

    public boolean contains(RelativePoint relativePoint) {
        return this.getScreenRectangle().contains(relativePoint.getScreenPoint());
    }
}

