/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.classFilter;

import com.intellij.ide.util.TreeClassChooser;
import com.intellij.ide.util.TreeClassChooserFactory;
import com.intellij.java.JavaBundle;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.GlobalSearchScope;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.jetbrains.annotations.Nullable;

class ClassFilterEditorAddDialog
extends DialogWrapper {
    private final Project myProject;
    private TextFieldWithBrowseButton myClassName;
    @Nullable
    private final String myHelpId;

    ClassFilterEditorAddDialog(Project project2, @Nullable String helpId) {
        super(project2, true);
        this.myProject = project2;
        this.myHelpId = helpId;
        this.setTitle(JavaBundle.message("class.filter.editor.add.dialog.title", new Object[0]));
        this.init();
    }

    @Override
    protected JComponent createCenterPanel() {
        JPanel panel2 = new JPanel(new GridBagLayout());
        JLabel header = new JLabel(JavaBundle.message("label.class.filter.editor.add.dialog.filter.pattern", new Object[0]));
        this.myClassName = new TextFieldWithBrowseButton(new JTextField(35));
        JLabel iconLabel = new JLabel(Messages.getQuestionIcon());
        panel2.add((Component)header, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 18, 2, new Insets(5, 10, 0, 0), 0, 0));
        panel2.add((Component)this.myClassName, new GridBagConstraints(1, 1, 1, 1, 1.0, 1.0, 18, 2, new Insets(5, 10, 0, 0), 0, 0));
        panel2.add((Component)iconLabel, new GridBagConstraints(0, 0, 1, 2, 0.0, 1.0, 18, 0, new Insets(15, 0, 0, 0), 0, 0));
        this.myClassName.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PsiDirectory containingDirectory;
                PsiFile containingFile;
                PsiClass currentClass = ClassFilterEditorAddDialog.this.getSelectedClass();
                TreeClassChooser chooser = TreeClassChooserFactory.getInstance(ClassFilterEditorAddDialog.this.myProject).createNoInnerClassesScopeChooser(JavaBundle.message("class.filter.editor.choose.class.title", new Object[0]), GlobalSearchScope.allScope(ClassFilterEditorAddDialog.this.myProject), null, null);
                if (currentClass != null && (containingFile = currentClass.getContainingFile()) != null && (containingDirectory = containingFile.getContainingDirectory()) != null) {
                    chooser.selectDirectory(containingDirectory);
                }
                chooser.showDialog();
                PsiClass selectedClass = chooser.getSelected();
                if (selectedClass != null) {
                    ClassFilterEditorAddDialog.this.myClassName.setText(selectedClass.getQualifiedName());
                }
            }
        });
        this.myClassName.setEnabled(this.myProject != null);
        return panel2;
    }

    private PsiClass getSelectedClass() {
        PsiManager psiManager = PsiManager.getInstance(this.myProject);
        String classQName = this.myClassName.getText();
        if ("".equals(classQName)) {
            return null;
        }
        return JavaPsiFacade.getInstance(psiManager.getProject()).findClass(classQName, GlobalSearchScope.allScope(this.myProject));
    }

    @Override
    public JComponent getPreferredFocusedComponent() {
        return this.myClassName.getTextField();
    }

    public String getPattern() {
        return this.myClassName.getText();
    }

    @Override
    protected String getDimensionServiceKey() {
        return "#com.intellij.debugger.ui.breakpoints.BreakpointsConfigurationDialogFactory.BreakpointsConfigurationDialog.AddFieldBreakpointDialog";
    }

    @Override
    @Nullable
    protected String getHelpId() {
        return this.myHelpId;
    }
}

