/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.colorpicker;

import com.google.common.annotations.VisibleForTesting;
import com.intellij.ui.colorpicker.AlphaSliderComponent;
import com.intellij.ui.colorpicker.ColorAdjustPanelKt;
import com.intellij.ui.colorpicker.ColorIndicator;
import com.intellij.ui.colorpicker.ColorPickerBuilderKt;
import com.intellij.ui.colorpicker.ColorPickerModel;
import com.intellij.ui.colorpicker.ColorPipetteButton;
import com.intellij.ui.colorpicker.ColorPipetteProvider;
import com.intellij.ui.colorpicker.HueSliderComponent;
import com.intellij.ui.colorpicker.SliderComponent;
import com.intellij.ui.picker.ColorListener;
import com.intellij.util.ui.JBUI;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.plaf.basic.BasicButtonUI;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u001a\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\b\u0010\"\u001a\u0004\u0018\u00010#H\u0016R\u001c\u0010\b\u001a\u00020\t8\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\n\u0010\u000b\u001a\u0004\b\f\u0010\rR\u001c\u0010\u000e\u001a\u00020\u000f8\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0010\u0010\u000b\u001a\u0004\b\u0011\u0010\u0012R\u001c\u0010\u0013\u001a\u00020\u00148\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0015\u0010\u000b\u001a\u0004\b\u0016\u0010\u0017R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0018\u001a\u00020\u00198BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001c\u0010\u001d\u001a\u0004\b\u001a\u0010\u001bR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lcom/intellij/ui/colorpicker/ColorAdjustPanel;", "Ljavax/swing/JPanel;", "Lcom/intellij/ui/picker/ColorListener;", "model", "Lcom/intellij/ui/colorpicker/ColorPickerModel;", "pipetteProvider", "Lcom/intellij/ui/colorpicker/ColorPipetteProvider;", "(Lcom/intellij/ui/colorpicker/ColorPickerModel;Lcom/intellij/ui/colorpicker/ColorPipetteProvider;)V", "alphaSlider", "Lcom/intellij/ui/colorpicker/AlphaSliderComponent;", "alphaSlider$annotations", "()V", "getAlphaSlider", "()Lcom/intellij/ui/colorpicker/AlphaSliderComponent;", "colorIndicator", "Lcom/intellij/ui/colorpicker/ColorIndicator;", "colorIndicator$annotations", "getColorIndicator", "()Lcom/intellij/ui/colorpicker/ColorIndicator;", "hueSlider", "Lcom/intellij/ui/colorpicker/HueSliderComponent;", "hueSlider$annotations", "getHueSlider", "()Lcom/intellij/ui/colorpicker/HueSliderComponent;", "pipetteButton", "Lcom/intellij/ui/colorpicker/ColorPipetteButton;", "getPipetteButton", "()Lcom/intellij/ui/colorpicker/ColorPipetteButton;", "pipetteButton$delegate", "Lkotlin/Lazy;", "colorChanged", "", "color", "Ljava/awt/Color;", "source", "", "intellij.platform.ide.impl"})
public final class ColorAdjustPanel
extends JPanel
implements ColorListener {
    private final Lazy pipetteButton$delegate;
    @NotNull
    private final ColorIndicator colorIndicator;
    @NotNull
    private final HueSliderComponent hueSlider;
    @NotNull
    private final AlphaSliderComponent alphaSlider;
    private final ColorPickerModel model;
    private final ColorPipetteProvider pipetteProvider;

    private final ColorPipetteButton getPipetteButton() {
        Lazy lazy = this.pipetteButton$delegate;
        ColorAdjustPanel colorAdjustPanel = this;
        Object var3_3 = null;
        boolean bl = false;
        return (ColorPipetteButton)lazy.getValue();
    }

    @VisibleForTesting
    public static /* synthetic */ void colorIndicator$annotations() {
    }

    @NotNull
    public final ColorIndicator getColorIndicator() {
        return this.colorIndicator;
    }

    @VisibleForTesting
    public static /* synthetic */ void hueSlider$annotations() {
    }

    @NotNull
    public final HueSliderComponent getHueSlider() {
        return this.hueSlider;
    }

    @VisibleForTesting
    public static /* synthetic */ void alphaSlider$annotations() {
    }

    @NotNull
    public final AlphaSliderComponent getAlphaSlider() {
        return this.alphaSlider;
    }

    @Override
    public void colorChanged(@NotNull Color color, @Nullable Object source) {
        Intrinsics.checkParameterIsNotNull((Object)color, (String)"color");
        if (Intrinsics.areEqual((Object)this.colorIndicator.getColor(), (Object)color) ^ true) {
            this.colorIndicator.setColor(color);
        }
        float hue = Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), null)[0];
        int hueDegree = Math.round(hue * (float)360);
        int n = ((Number)this.hueSlider.getValue()).intValue() - hueDegree;
        boolean bl = false;
        if (Math.abs(n) != 360) {
            this.hueSlider.setValue(hueDegree);
        }
        this.alphaSlider.setSliderBackgroundColor(color);
        if (((Number)this.alphaSlider.getValue()).intValue() != color.getAlpha()) {
            this.alphaSlider.setValue(color.getAlpha());
        }
        this.repaint();
    }

    public ColorAdjustPanel(@NotNull ColorPickerModel model, @NotNull ColorPipetteProvider pipetteProvider) {
        ColorIndicator colorIndicator;
        Intrinsics.checkParameterIsNotNull((Object)model, (String)"model");
        Intrinsics.checkParameterIsNotNull((Object)pipetteProvider, (String)"pipetteProvider");
        super(new GridBagLayout());
        this.model = model;
        this.pipetteProvider = pipetteProvider;
        this.pipetteButton$delegate = LazyKt.lazy((Function0)((Function0)new Function0<ColorPipetteButton>(this){
            final /* synthetic */ ColorAdjustPanel this$0;

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final ColorPipetteButton invoke() {
                void var1_1;
                ColorPipetteButton colorPipetteButton = new ColorPipetteButton(ColorAdjustPanel.access$getModel$p(this.this$0), ColorAdjustPanel.access$getPipetteProvider$p(this.this$0).createPipette(this.this$0));
                boolean bl = false;
                boolean bl2 = false;
                ColorPipetteButton $this$with = colorPipetteButton;
                boolean bl3 = false;
                $this$with.setBorder(ColorAdjustPanelKt.access$getPIPETTE_BUTTON_BORDER$p());
                $this$with.setBackground(ColorPickerBuilderKt.getPICKER_BACKGROUND_COLOR());
                $this$with.setUI(new BasicButtonUI());
                $this$with.setFocusable(false);
                $this$with.setPreferredSize(ColorAdjustPanelKt.access$getCOLOR_INDICATOR_SIZE$p());
                return var1_1;
            }
            {
                this.this$0 = colorAdjustPanel;
                super(0);
            }
        }));
        JComponent jComponent = new ColorIndicator(null, 1, null);
        ColorAdjustPanel colorAdjustPanel = this;
        boolean bl = false;
        boolean bl2 = false;
        ColorIndicator $this$apply = jComponent;
        boolean bl3 = false;
        $this$apply.setBorder(ColorAdjustPanelKt.access$getCOLOR_INDICATOR_BORDER$p());
        $this$apply.setPreferredSize(ColorAdjustPanelKt.access$getCOLOR_INDICATOR_SIZE$p());
        colorAdjustPanel.colorIndicator = colorIndicator = jComponent;
        jComponent = new HueSliderComponent();
        colorAdjustPanel = this;
        bl = false;
        bl2 = false;
        $this$apply = jComponent;
        boolean bl4 = false;
        $this$apply.setBorder(ColorAdjustPanelKt.access$getHUE_SLIDER_BORDER$p());
        $this$apply.setBackground(ColorPickerBuilderKt.getPICKER_BACKGROUND_COLOR());
        ((SliderComponent)((Object)$this$apply)).addListener((Function1)new Function1<Integer, Unit>(this){
            final /* synthetic */ ColorAdjustPanel this$0;
            {
                this.this$0 = colorAdjustPanel;
                super(1);
            }

            public final void invoke(int it) {
                float hue = (float)it / 360.0f;
                float[] hsbValues = Color.RGBtoHSB(ColorAdjustPanel.access$getModel$p(this.this$0).getColor().getRed(), ColorAdjustPanel.access$getModel$p(this.this$0).getColor().getGreen(), ColorAdjustPanel.access$getModel$p(this.this$0).getColor().getBlue(), null);
                int rgb = Color.HSBtoRGB(hue, hsbValues[1], hsbValues[2]);
                int argb = ColorAdjustPanel.access$getModel$p(this.this$0).getColor().getAlpha() << 24 | rgb & 0xFFFFFF;
                Color newColor = new Color(argb, true);
                ColorAdjustPanel.access$getModel$p(this.this$0).setColor(newColor, this.this$0);
            }
        });
        colorIndicator = jComponent;
        colorAdjustPanel.hueSlider = colorIndicator;
        jComponent = new AlphaSliderComponent();
        colorAdjustPanel = this;
        bl = false;
        bl2 = false;
        $this$apply = jComponent;
        boolean bl5 = false;
        $this$apply.setBorder(ColorAdjustPanelKt.access$getALPHA_SLIDER_BORDER$p());
        $this$apply.setBackground(ColorPickerBuilderKt.getPICKER_BACKGROUND_COLOR());
        ((SliderComponent)((Object)$this$apply)).addListener((Function1)new Function1<Integer, Unit>(this){
            final /* synthetic */ ColorAdjustPanel this$0;
            {
                this.this$0 = colorAdjustPanel;
                super(1);
            }

            public final void invoke(int it) {
                ColorAdjustPanel.access$getModel$p(this.this$0).setColor(new Color(ColorAdjustPanel.access$getModel$p(this.this$0).getColor().getRed(), ColorAdjustPanel.access$getModel$p(this.this$0).getColor().getGreen(), ColorAdjustPanel.access$getModel$p(this.this$0).getColor().getBlue(), it), this.this$0);
            }
        });
        colorIndicator = jComponent;
        colorAdjustPanel.alphaSlider = colorIndicator;
        this.setBorder(ColorAdjustPanelKt.access$getPANEL_BORDER$p());
        this.setBackground(ColorPickerBuilderKt.getPICKER_BACKGROUND_COLOR());
        this.setPreferredSize(ColorAdjustPanelKt.access$getPANEL_PREFERRED_SIZE$p());
        GridBagConstraints c = new GridBagConstraints();
        if (ColorAdjustPanelKt.access$canPickupColorFromDisplay()) {
            c.gridx = 0;
            c.gridy = 0;
            c.weightx = 0.12;
            this.add((Component)this.getPipetteButton(), c);
        }
        c.gridx = 1;
        c.gridy = 0;
        c.weightx = 0.12;
        this.add((Component)this.colorIndicator, c);
        c.fill = 1;
        c.gridx = 2;
        c.gridy = 0;
        c.weightx = 0.76;
        JPanel sliderPanel = new JPanel();
        sliderPanel.setLayout(new BoxLayout(sliderPanel, 1));
        sliderPanel.setBorder(JBUI.Borders.empty());
        sliderPanel.setBackground(ColorPickerBuilderKt.getPICKER_BACKGROUND_COLOR());
        sliderPanel.add(this.hueSlider);
        sliderPanel.add(this.alphaSlider);
        this.add((Component)sliderPanel, c);
        this.model.addListener(this);
    }

    public static final /* synthetic */ ColorPickerModel access$getModel$p(ColorAdjustPanel $this) {
        return $this.model;
    }

    public static final /* synthetic */ ColorPipetteProvider access$getPipetteProvider$p(ColorAdjustPanel $this) {
        return $this.pipetteProvider;
    }
}

