/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.colorpicker;

import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.ui.colorpicker.ColorPipette;
import com.intellij.ui.colorpicker.GraphicalColorPipetteKt;
import com.intellij.util.ui.ImageUtil;
import com.intellij.util.ui.JBUI;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.PointerInfo;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Robot;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JRootPane;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\b\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u001e\u001a\u00020\u001fH\u0002J8\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020%2\u0006\u0010'\u001a\u00020%2\u0006\u0010(\u001a\u00020%2\u0006\u0010)\u001a\u00020%H\u0016J\u0006\u0010*\u001a\u00020\u001fJ\b\u0010+\u001a\u00020\u001fH\u0002J\b\u0010,\u001a\u00020\u001fH\u0002R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u000f\u001a\u00070\u000e\u00a2\u0006\u0002\b\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0011\u001a\u00070\u000e\u00a2\u0006\u0002\b\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0016\u001a\u0004\u0018\u00010\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0018\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006-"}, d2={"Lcom/intellij/ui/colorpicker/PickerDialog;", "Ljava/awt/image/ImageObserver;", "parent", "Ljavax/swing/JComponent;", "callback", "Lcom/intellij/ui/colorpicker/ColorPipette$Callback;", "(Ljavax/swing/JComponent;Lcom/intellij/ui/colorpicker/ColorPipette$Callback;)V", "getCallback", "()Lcom/intellij/ui/colorpicker/ColorPipette$Callback;", "captureRect", "Ljava/awt/Rectangle;", "center", "Ljava/awt/Point;", "image", "Ljava/awt/image/BufferedImage;", "magnifierImage", "Lorg/jetbrains/annotations/NotNull;", "maskImage", "getParent", "()Ljavax/swing/JComponent;", "picker", "Ljava/awt/Dialog;", "previousColor", "Ljava/awt/Color;", "previousLoc", "robot", "Ljava/awt/Robot;", "timer", "Ljavax/swing/Timer;", "zoomRect", "cancelPipette", "", "imageUpdate", "", "img", "Ljava/awt/Image;", "flags", "", "x", "y", "width", "height", "pick", "pickDone", "updatePipette", "intellij.platform.ide.impl"})
final class PickerDialog
implements ImageObserver {
    private final Timer timer;
    private final Point center;
    private final Rectangle zoomRect;
    private final Rectangle captureRect;
    private final BufferedImage maskImage;
    private final BufferedImage magnifierImage;
    private final BufferedImage image;
    private final Robot robot;
    private Color previousColor;
    private Point previousLoc;
    private final Dialog picker;
    @NotNull
    private final JComponent parent;
    @NotNull
    private final ColorPipette.Callback callback;

    public final void pick() {
        this.picker.setVisible(true);
        this.timer.start();
        WindowManager.getInstance().setAlphaModeRatio(this.picker, SystemInfo.isMac ? 0.95f : 0.99f);
    }

    @Override
    public boolean imageUpdate(@NotNull Image img, int flags, int x, int y, int width, int height) {
        Intrinsics.checkParameterIsNotNull((Object)img, (String)"img");
        return false;
    }

    private final void cancelPipette() {
        this.timer.stop();
        this.picker.setVisible(false);
        this.picker.dispose();
        this.callback.cancel();
    }

    private final void pickDone() {
        PointerInfo pointerInfo;
        this.timer.stop();
        PointerInfo pointerInfo2 = pointerInfo = MouseInfo.getPointerInfo();
        Intrinsics.checkExpressionValueIsNotNull((Object)pointerInfo2, (String)"pointerInfo");
        Point location2 = pointerInfo2.getLocation();
        Color pickedColor = this.robot.getPixelColor(location2.x, location2.y);
        this.picker.setVisible(false);
        Color color = pickedColor;
        Intrinsics.checkExpressionValueIsNotNull((Object)color, (String)"pickedColor");
        this.callback.picked(color);
    }

    private final void updatePipette() {
        if (this.picker.isShowing()) {
            PointerInfo pointerInfo;
            PointerInfo pointerInfo2 = pointerInfo = MouseInfo.getPointerInfo();
            Intrinsics.checkExpressionValueIsNotNull((Object)pointerInfo2, (String)"pointerInfo");
            Point mouseLoc = pointerInfo2.getLocation();
            this.picker.setLocation(mouseLoc.x - this.picker.getWidth() / 2, mouseLoc.y - this.picker.getHeight() / 2);
            Color pickedColor = this.robot.getPixelColor(mouseLoc.x, mouseLoc.y);
            if (Intrinsics.areEqual((Object)this.previousLoc, (Object)mouseLoc) ^ true || Intrinsics.areEqual((Object)this.previousColor, (Object)pickedColor) ^ true) {
                this.previousLoc = mouseLoc;
                this.previousColor = pickedColor;
                int halfPixelNumber = 5;
                this.captureRect.setBounds(mouseLoc.x - halfPixelNumber, mouseLoc.y - halfPixelNumber, 11, 11);
                BufferedImage capture = this.robot.createScreenCapture(this.captureRect);
                Graphics graphics = this.image.getGraphics();
                if (graphics == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.awt.Graphics2D");
                }
                Graphics2D graphics2 = (Graphics2D)graphics;
                graphics2.setComposite(AlphaComposite.Src);
                graphics2.setColor(GraphicalColorPipetteKt.access$getTRANSPARENT_COLOR$p());
                graphics2.fillRect(0, 0, this.image.getWidth(), this.image.getHeight());
                graphics2.drawImage(capture, this.zoomRect.x, this.zoomRect.y, this.zoomRect.width, this.zoomRect.height, this);
                graphics2.setComposite(AlphaComposite.DstOut);
                graphics2.drawImage(this.maskImage, this.zoomRect.x, this.zoomRect.y, this.zoomRect.width, this.zoomRect.height, this);
                graphics2.setComposite(AlphaComposite.SrcOver);
                graphics2.drawImage((Image)this.magnifierImage, 0, 0, this);
                graphics2.setComposite(AlphaComposite.SrcOver);
                graphics2.setColor(GraphicalColorPipetteKt.access$getPIPETTE_BORDER_COLOR$p());
                graphics2.drawRect(0, 0, 63, 63);
                graphics2.setColor(GraphicalColorPipetteKt.access$getINDICATOR_BOUND_COLOR$p());
                graphics2.drawRect(29, 29, 5, 5);
                this.picker.setCursor(this.parent.getToolkit().createCustomCursor(this.image, this.center, "GraphicalColorPicker"));
                Color color = pickedColor;
                Intrinsics.checkExpressionValueIsNotNull((Object)color, (String)"pickedColor");
                this.callback.update(color);
            }
        }
    }

    @NotNull
    public final JComponent getParent() {
        return this.parent;
    }

    @NotNull
    public final ColorPipette.Callback getCallback() {
        return this.callback;
    }

    public PickerDialog(@NotNull JComponent parent, @NotNull ColorPipette.Callback callback2) {
        Graphics2D maskG;
        BufferedImage image;
        Intrinsics.checkParameterIsNotNull((Object)parent, (String)"parent");
        Intrinsics.checkParameterIsNotNull((Object)callback2, (String)"callback");
        this.parent = parent;
        this.callback = callback2;
        this.timer = new Timer(33, new ActionListener(this){
            final /* synthetic */ PickerDialog this$0;

            public final void actionPerformed(ActionEvent it) {
                PickerDialog.access$updatePipette(this.this$0);
            }
            {
                this.this$0 = pickerDialog;
            }
        });
        this.center = new Point(32, 32);
        this.zoomRect = new Rectangle(0, 0, 64, 64);
        this.captureRect = new Rectangle();
        BufferedImage bufferedImage = ImageUtil.createImage(64, 64, 2);
        Intrinsics.checkExpressionValueIsNotNull((Object)bufferedImage, (String)"ImageUtil.createImage(ZO\u2026feredImage.TYPE_INT_ARGB)");
        this.maskImage = bufferedImage;
        BufferedImage bufferedImage2 = ImageUtil.createImage(64, 64, 2);
        Intrinsics.checkExpressionValueIsNotNull((Object)bufferedImage2, (String)"ImageUtil.createImage(ZO\u2026feredImage.TYPE_INT_ARGB)");
        this.magnifierImage = bufferedImage2;
        PickerDialog pickerDialog = this;
        PickerDialog pickerDialog2 = this;
        boolean bl = false;
        boolean bl2 = false;
        PickerDialog it = pickerDialog;
        boolean bl3 = false;
        BufferedImage bufferedImage3 = image = this.parent.getGraphicsConfiguration().createCompatibleImage(64, 64, 3);
        Intrinsics.checkExpressionValueIsNotNull((Object)bufferedImage3, (String)"image");
        Graphics graphics = bufferedImage3.getGraphics();
        if (graphics == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.awt.Graphics2D");
        }
        Object graphics2d = (Graphics2D)graphics;
        ((Graphics2D)graphics2d).setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR);
        ((Graphics2D)graphics2d).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        Object object = image;
        pickerDialog2.image = object;
        this.robot = new Robot();
        pickerDialog = this;
        pickerDialog2 = this;
        bl = false;
        bl2 = false;
        it = pickerDialog;
        boolean bl4 = false;
        Window owner = SwingUtilities.getWindowAncestor(this.parent);
        graphics2d = owner;
        JDialog pickerFrame = graphics2d instanceof Dialog ? new JDialog((Dialog)owner) : (graphics2d instanceof Frame ? new JDialog((Frame)owner) : new JDialog(new JFrame()));
        pickerFrame.setUndecorated(true);
        pickerFrame.setAlwaysOnTop(true);
        pickerFrame.setSize(new Dimension(64, 64));
        pickerFrame.setDefaultCloseOperation(2);
        JRootPane rootPane = pickerFrame.getRootPane();
        rootPane.putClientProperty("Window.shadow", false);
        JRootPane jRootPane = rootPane;
        Intrinsics.checkExpressionValueIsNotNull((Object)jRootPane, (String)"rootPane");
        jRootPane.setBorder(JBUI.Borders.empty());
        MouseAdapter mouseAdapter2 = new MouseAdapter(this){
            final /* synthetic */ PickerDialog this$0;
            {
                this.this$0 = pickerDialog;
            }

            public void mouseReleased(@NotNull MouseEvent e) {
                block1: {
                    block0: {
                        Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
                        e.consume();
                        if (!SwingUtilities.isLeftMouseButton(e)) break block0;
                        PickerDialog.access$pickDone(this.this$0);
                        break block1;
                    }
                    if (!SwingUtilities.isRightMouseButton(e)) break block1;
                    PickerDialog.access$cancelPipette(this.this$0);
                }
            }

            public void mouseMoved(@NotNull MouseEvent e) {
                Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
                PickerDialog.access$updatePipette(this.this$0);
            }
        };
        pickerFrame.addMouseListener(mouseAdapter2);
        pickerFrame.addMouseMotionListener(mouseAdapter2);
        pickerFrame.addKeyListener(new KeyAdapter(this){
            final /* synthetic */ PickerDialog this$0;
            {
                this.this$0 = pickerDialog;
            }

            public void keyPressed(@NotNull KeyEvent e) {
                Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
                switch (e.getKeyCode()) {
                    case 27: {
                        PickerDialog.access$cancelPipette(this.this$0);
                        break;
                    }
                    case 10: {
                        PickerDialog.access$pickDone(this.this$0);
                    }
                }
            }
        });
        object = pickerFrame;
        pickerDialog2.picker = (Dialog)object;
        Graphics2D graphics2D = maskG = this.maskImage.createGraphics();
        Intrinsics.checkExpressionValueIsNotNull((Object)graphics2D, (String)"maskG");
        graphics2D.setColor(Color.BLUE);
        maskG.fillRect(0, 0, 64, 64);
        maskG.setColor(Color.RED);
        maskG.setComposite(AlphaComposite.SrcOut);
        maskG.fillRect(0, 0, 64, 64);
        maskG.dispose();
    }

    public static final /* synthetic */ void access$updatePipette(PickerDialog $this) {
        $this.updatePipette();
    }

    public static final /* synthetic */ void access$pickDone(PickerDialog $this) {
        $this.pickDone();
    }

    public static final /* synthetic */ void access$cancelPipette(PickerDialog $this) {
        $this.cancelPipette();
    }
}

