/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.colorpicker;

import com.intellij.ui.ColorUtil;
import com.intellij.ui.colorpicker.ColorPickerModel;
import com.intellij.ui.colorpicker.SaturationBrightnessComponentKt;
import com.intellij.ui.colorpicker.SaturationBrightnessImageProducer;
import com.intellij.ui.colorpicker.UtilsKt;
import com.intellij.ui.picker.ColorListener;
import com.intellij.util.ui.GraphicsUtil;
import com.intellij.util.ui.JBDimension;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sun.awt.image.ToolkitImage;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u001a\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0016J\u000e\u0010\u0019\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u001bJ\b\u0010\u001c\u001a\u00020\u001dH\u0016J\b\u0010\u001e\u001a\u00020\u001dH\u0016J\u0010\u0010\u001f\u001a\u00020\u00142\u0006\u0010 \u001a\u00020!H\u0002J\u0010\u0010\"\u001a\u00020\u00142\u0006\u0010#\u001a\u00020$H\u0014J(\u0010%\u001a\u00020\u00142\u0006\u0010&\u001a\u00020\u000b2\u0006\u0010'\u001a\u00020\u000b2\u0006\u0010(\u001a\u00020\u000b2\u0006\u0010)\u001a\u00020\u0007H\u0002R\u001e\u0010\b\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u0007@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001e\u0010\f\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u000b@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u001e\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u000b@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000eR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u000b@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u000e\u00a8\u0006*"}, d2={"Lcom/intellij/ui/colorpicker/SaturationBrightnessComponent;", "Ljavax/swing/JComponent;", "Lcom/intellij/ui/picker/ColorListener;", "myModel", "Lcom/intellij/ui/colorpicker/ColorPickerModel;", "(Lcom/intellij/ui/colorpicker/ColorPickerModel;)V", "<set-?>", "", "alpha", "getAlpha", "()I", "", "brightness", "getBrightness", "()F", "hue", "getHue", "saturation", "getSaturation", "colorChanged", "", "color", "Ljava/awt/Color;", "source", "", "getColorByPoint", "p", "Ljava/awt/Point;", "getMinimumSize", "Ljava/awt/Dimension;", "getPreferredSize", "handleMouseEvent", "e", "Ljava/awt/event/MouseEvent;", "paintComponent", "g", "Ljava/awt/Graphics;", "setHSBAValue", "h", "s", "b", "a", "intellij.platform.ide.impl"})
public final class SaturationBrightnessComponent
extends JComponent
implements ColorListener {
    private float brightness;
    private float hue;
    private float saturation;
    private int alpha;
    private final ColorPickerModel myModel;

    public final float getBrightness() {
        return this.brightness;
    }

    public final float getHue() {
        return this.hue;
    }

    public final float getSaturation() {
        return this.saturation;
    }

    public final int getAlpha() {
        return this.alpha;
    }

    private final void handleMouseEvent(MouseEvent e) {
        Point point = e.getPoint();
        Intrinsics.checkExpressionValueIsNotNull((Object)point, (String)"e.point");
        this.myModel.setColor(this.getColorByPoint(point), this);
    }

    @NotNull
    public final Color getColorByPoint(@NotNull Point p) {
        Intrinsics.checkParameterIsNotNull((Object)p, (String)"p");
        int x = Math.max(0, Math.min(p.x, this.getSize().width));
        int y = Math.max(0, Math.min(p.y, this.getSize().height));
        float saturation = (float)x / (float)this.getSize().width;
        float brightness = 1.0f - (float)y / (float)this.getSize().height;
        int argb = UtilsKt.ahsbToArgb(this.alpha, this.hue, saturation, brightness);
        Color newColor = new Color(argb, true);
        return newColor;
    }

    @Override
    @NotNull
    public Dimension getPreferredSize() {
        JBDimension jBDimension = JBUI.size(300, 150);
        Intrinsics.checkExpressionValueIsNotNull((Object)jBDimension, (String)"JBUI.size(PICKER_PREFERRED_WIDTH, 150)");
        return jBDimension;
    }

    @Override
    @NotNull
    public Dimension getMinimumSize() {
        JBDimension jBDimension = JBUI.size(150, 140);
        Intrinsics.checkExpressionValueIsNotNull((Object)jBDimension, (String)"JBUI.size(150, 140)");
        return jBDimension;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    protected void paintComponent(@NotNull Graphics g) {
        Intrinsics.checkParameterIsNotNull((Object)g, (String)"g");
        component = new Rectangle(0, 0, this.getSize().width, this.getSize().height);
        image = this.createImage(new SaturationBrightnessImageProducer(this.getSize().width, this.getSize().height, this.hue));
        g.setColor(UIUtil.getPanelBackground());
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        g.drawImage(image, component.x, component.y, null);
        knobX = Math.round(this.saturation * (float)component.width);
        knobY = Math.round((float)component.height * (1.0f - this.brightness));
        if (!(image instanceof ToolkitImage)) ** GOTO lbl-1000
        v0 = ((ToolkitImage)image).getBufferedImage();
        Intrinsics.checkExpressionValueIsNotNull((Object)v0, (String)"image.bufferedImage");
        if (v0.getWidth() <= knobX) ** GOTO lbl-1000
        v1 = ((ToolkitImage)image).getBufferedImage();
        Intrinsics.checkExpressionValueIsNotNull((Object)v1, (String)"image.bufferedImage");
        if (v1.getHeight() > knobY) {
            rgb = ((ToolkitImage)image).getBufferedImage().getRGB(knobX, knobY);
            g.setColor(ColorUtil.isDark(new Color(rgb)) != false ? Color.WHITE : Color.BLACK);
        } else lbl-1000:
        // 3 sources

        {
            g.setColor(SaturationBrightnessComponentKt.access$getKNOB_COLOR$p());
        }
        config = GraphicsUtil.setupAAPainting(g);
        g.drawOval(knobX - JBUI.scale(4), knobY - JBUI.scale(4), JBUI.scale(8), JBUI.scale(8));
        g.drawOval(knobX - JBUI.scale(3), knobY - JBUI.scale(3), JBUI.scale(6), JBUI.scale(6));
        config.restore();
    }

    @Override
    public void colorChanged(@NotNull Color color, @Nullable Object source) {
        Intrinsics.checkParameterIsNotNull((Object)color, (String)"color");
        float[] hsbValues = Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), null);
        this.setHSBAValue(hsbValues[0], hsbValues[1], hsbValues[2], color.getAlpha());
    }

    private final void setHSBAValue(float h, float s, float b, int a) {
        this.hue = h;
        this.saturation = s;
        this.brightness = b;
        this.alpha = a;
        this.repaint();
    }

    public SaturationBrightnessComponent(@NotNull ColorPickerModel myModel) {
        Intrinsics.checkParameterIsNotNull((Object)myModel, (String)"myModel");
        this.myModel = myModel;
        this.brightness = 1.0f;
        this.hue = 1.0f;
        this.setOpaque(false);
        this.setBackground(Color.WHITE);
        MouseAdapter mouseAdapter2 = new MouseAdapter(this){
            final /* synthetic */ SaturationBrightnessComponent this$0;

            public void mousePressed(@NotNull MouseEvent e) {
                Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
                SaturationBrightnessComponent.access$handleMouseEvent(this.this$0, e);
            }

            public void mouseDragged(@NotNull MouseEvent e) {
                Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
                SaturationBrightnessComponent.access$handleMouseEvent(this.this$0, e);
            }
            {
                this.this$0 = $outer;
            }
        };
        this.addMouseListener(mouseAdapter2);
        this.addMouseMotionListener(mouseAdapter2);
        this.myModel.addListener(this);
    }

    public static final /* synthetic */ void access$handleMouseEvent(SaturationBrightnessComponent $this, MouseEvent e) {
        $this.handleMouseEvent(e);
    }
}

