/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.colorpicker;

import com.intellij.ui.colorpicker.SliderComponent$$special$;
import com.intellij.ui.colorpicker.SliderComponentKt;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBDimension;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.io.Serializable;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000r\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\r\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\b&\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003B\r\u0012\u0006\u0010\u0004\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0005J\u001a\u0010(\u001a\u00020\u00172\u0012\u0010)\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u00170\u0016J\u0010\u0010*\u001a\u00020\u00172\u0006\u0010+\u001a\u00020\u0007H\u0002J\u0018\u0010,\u001a\u00020\u00172\u0006\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u00020\u0007H\u0002J\b\u00100\u001a\u00020\u0017H\u0002J\b\u00101\u001a\u000202H\u0016J\b\u00103\u001a\u000202H\u0016J\b\u00104\u001a\u000202H\u0016J\b\u00105\u001a\u000206H\u0016J\u0015\u00107\u001a\u00028\u00002\u0006\u0010\u000e\u001a\u00020\u0007H$\u00a2\u0006\u0002\u00108J\u0010\u00109\u001a\u00020\u00172\u0006\u0010:\u001a\u00020;H\u0014J\u0010\u0010<\u001a\u00020\u00172\u0006\u0010-\u001a\u00020.H$J\u0010\u0010=\u001a\u00020\u00172\u0006\u0010>\u001a\u00020?H\u0002J\u0016\u0010@\u001a\u00020\u00172\f\u0010A\u001a\b\u0012\u0004\u0012\u00020\u00170BH\u0002J\u0010\u0010C\u001a\u00020\u00172\u0006\u0010D\u001a\u00020EH\u0016J\u0015\u0010F\u001a\u00028\u00002\u0006\u0010+\u001a\u00020\u0007H$\u00a2\u0006\u0002\u00108J\u0015\u0010G\u001a\u00020\u00072\u0006\u0010$\u001a\u00028\u0000H$\u00a2\u0006\u0002\u0010HR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u00028\u0000X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\tR\u0014\u0010\n\u001a\u00020\u0007X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR$\u0010\u000e\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u00078F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u000f\u0010\f\"\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0012\u001a\u00020\u0007X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\fRj\u0010\u0014\u001a^\u0012$\u0012\"\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u0017 \u0018*\u0010\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u0017\u0018\u00010\u00160\u0016 \u0018*-\u0012$\u0012\"\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u0017 \u0018*\u0010\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u0017\u0018\u00010\u00160\u00160\u001a\u00a2\u0006\u0002\b\u00190\u0015\u00a2\u0006\u0002\b\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001d\u001a\u00020\u0007X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\fR\u0011\u0010\u001f\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b \u0010\fR\u0014\u0010!\u001a\u00020\u0007X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010\fR$\u0010$\u001a\u00028\u00002\u0006\u0010#\u001a\u00028\u00008F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b%\u0010&\"\u0004\b'\u0010\u0005\u00a8\u0006I"}, d2={"Lcom/intellij/ui/colorpicker/SliderComponent;", "T", "", "Ljavax/swing/JComponent;", "initialValue", "(Ljava/lang/Number;)V", "_knobPosition", "", "_value", "Ljava/lang/Number;", "bottomPadding", "getBottomPadding", "()I", "newPointerValue", "knobPosition", "getKnobPosition", "setKnobPosition", "(I)V", "leftPadding", "getLeftPadding", "listeners", "", "Lkotlin/Function1;", "", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "", "polygonToDraw", "Ljava/awt/Polygon;", "rightPadding", "getRightPadding", "sliderWidth", "getSliderWidth", "topPadding", "getTopPadding", "newValue", "value", "getValue", "()Ljava/lang/Number;", "setValue", "addListener", "listener", "doSlide", "shift", "drawKnob", "g2d", "Ljava/awt/Graphics2D;", "x", "fireValueChanged", "getMaximumSize", "Ljava/awt/Dimension;", "getMinimumSize", "getPreferredSize", "isFocusable", "", "knobPositionToValue", "(I)Ljava/lang/Number;", "paintComponent", "g", "Ljava/awt/Graphics;", "paintSlider", "processMouse", "e", "Ljava/awt/event/MouseEvent;", "runAndUpdateIfNeeded", "task", "Lkotlin/Function0;", "setToolTipText", "text", "", "slide", "valueToKnobPosition", "(Ljava/lang/Number;)I", "intellij.platform.ide.impl"})
public abstract class SliderComponent<T extends Number>
extends JComponent {
    private final int leftPadding;
    private final int rightPadding;
    private final int topPadding;
    private final int bottomPadding;
    private int _knobPosition;
    private T _value;
    private final Polygon polygonToDraw;
    private final List<Function1<T, Unit>> listeners;

    protected final int getLeftPadding() {
        return this.leftPadding;
    }

    protected final int getRightPadding() {
        return this.rightPadding;
    }

    protected final int getTopPadding() {
        return this.topPadding;
    }

    protected final int getBottomPadding() {
        return this.bottomPadding;
    }

    public final int getKnobPosition() {
        return this._knobPosition;
    }

    public final void setKnobPosition(int newPointerValue) {
        this._knobPosition = newPointerValue;
        this._value = this.knobPositionToValue(newPointerValue);
    }

    @NotNull
    public final T getValue() {
        return this._value;
    }

    public final void setValue(@NotNull T newValue) {
        Intrinsics.checkParameterIsNotNull(newValue, (String)"newValue");
        this._value = newValue;
        this._knobPosition = this.valueToKnobPosition(newValue);
    }

    public final int getSliderWidth() {
        int n = 0;
        int n2 = this.getWidth() - this.leftPadding - this.rightPadding;
        boolean bl = false;
        return Math.max(n, n2);
    }

    private final void runAndUpdateIfNeeded(Function0<Unit> task2) {
        T oldValue = this.getValue();
        task2.invoke();
        this.repaint();
        if (Intrinsics.areEqual(oldValue, this.getValue()) ^ true) {
            this.fireValueChanged();
        }
    }

    private final void processMouse(MouseEvent e) {
        this.runAndUpdateIfNeeded((Function0<Unit>)((Function0)new Function0<Unit>(this, e){
            final /* synthetic */ SliderComponent this$0;
            final /* synthetic */ MouseEvent $e;

            public final void invoke() {
                int newKnobPosition = Math.max(0, Math.min(this.$e.getX() - this.this$0.getLeftPadding(), this.this$0.getSliderWidth()));
                this.this$0.setKnobPosition(newKnobPosition);
            }
            {
                this.this$0 = sliderComponent;
                this.$e = mouseEvent;
                super(0);
            }
        }));
    }

    public final void addListener(@NotNull Function1<? super T, Unit> listener2) {
        Intrinsics.checkParameterIsNotNull(listener2, (String)"listener");
        this.listeners.add(listener2);
    }

    private final void fireValueChanged() {
        Iterable $this$forEach$iv = this.listeners;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Function1 it = (Function1)element$iv;
            boolean bl = false;
            it.invoke(this.getValue());
        }
    }

    @NotNull
    protected abstract T knobPositionToValue(int var1);

    protected abstract int valueToKnobPosition(@NotNull T var1);

    private final void doSlide(int shift) {
        this.setValue(this.slide(shift));
    }

    @NotNull
    protected abstract T slide(int var1);

    @Override
    @NotNull
    public Dimension getPreferredSize() {
        JBDimension jBDimension = JBUI.size(100, 22);
        Intrinsics.checkExpressionValueIsNotNull((Object)jBDimension, (String)"JBUI.size(100, 22)");
        return jBDimension;
    }

    @Override
    @NotNull
    public Dimension getMinimumSize() {
        JBDimension jBDimension = JBUI.size(50, 22);
        Intrinsics.checkExpressionValueIsNotNull((Object)jBDimension, (String)"JBUI.size(50, 22)");
        return jBDimension;
    }

    @Override
    @NotNull
    public Dimension getMaximumSize() {
        return new Dimension(Integer.MAX_VALUE, this.getPreferredSize().height);
    }

    @Override
    public boolean isFocusable() {
        return true;
    }

    @Override
    public void setToolTipText(@NotNull String text2) {
        Intrinsics.checkParameterIsNotNull((Object)text2, (String)"text");
    }

    @Override
    protected void paintComponent(@NotNull Graphics g) {
        Intrinsics.checkParameterIsNotNull((Object)g, (String)"g");
        Graphics2D g2d = (Graphics2D)g;
        if (this.isFocusOwner()) {
            Color color = UIUtil.getFocusedFillColor();
            if (color == null) {
                color = Color.BLUE.brighter();
            }
            g2d.setColor(color);
            int left = this.leftPadding - 3;
            int top = this.topPadding - 3;
            int width = this.getWidth() - left - this.rightPadding + 3;
            int height = this.getHeight() - top - this.bottomPadding + 3;
            g2d.fillRoundRect(left, top, width, height, 5, 5);
        }
        this.paintSlider(g2d);
        this.drawKnob(g2d, this.leftPadding + this.valueToKnobPosition(this.getValue()));
    }

    protected abstract void paintSlider(@NotNull Graphics2D var1);

    private final void drawKnob(Graphics2D g2d, int x) {
        Object originalAntialiasing = g2d.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        Stroke originalStroke = g2d.getStroke();
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int knobLeft = x - 2;
        int knobTop = this.topPadding / 2;
        int knobWidth = 5;
        int knobHeight = this.getHeight() - (this.topPadding + this.bottomPadding) / 2;
        g2d.setColor(SliderComponentKt.access$getKNOB_COLOR$p());
        g2d.fillRoundRect(knobLeft, knobTop, knobWidth, knobHeight, 5, 5);
        g2d.setColor(SliderComponentKt.access$getKNOB_BORDER_COLOR$p());
        g2d.setStroke(SliderComponentKt.access$getKNOB_BORDER_STROKE$p());
        g2d.drawRoundRect(knobLeft, knobTop, knobWidth, knobHeight, 5, 5);
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, originalAntialiasing);
        g2d.setStroke(originalStroke);
    }

    public SliderComponent(@NotNull T initialValue) {
        Intrinsics.checkParameterIsNotNull(initialValue, (String)"initialValue");
        this.leftPadding = SliderComponentKt.access$getDEFAULT_HORIZONTAL_PADDING$p();
        this.rightPadding = SliderComponentKt.access$getDEFAULT_HORIZONTAL_PADDING$p();
        this.topPadding = SliderComponentKt.access$getDEFAULT_VERTICAL_PADDING$p();
        this.bottomPadding = SliderComponentKt.access$getDEFAULT_VERTICAL_PADDING$p();
        this._value = initialValue;
        this.polygonToDraw = new Polygon();
        List list2 = ContainerUtil.createLockFreeCopyOnWriteList();
        Intrinsics.checkExpressionValueIsNotNull(list2, (String)"ContainerUtil.createLock\u2026nWriteList<(T) -> Unit>()");
        this.listeners = list2;
        this.addMouseMotionListener(new MouseAdapter(){

            @Override
            public void mouseDragged(@NotNull MouseEvent e) {
                Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
                this.processMouse(e);
                e.consume();
            }
        });
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(@NotNull MouseEvent e) {
                Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
                this.processMouse(e);
                e.consume();
            }
        });
        this.addMouseWheelListener(new MouseWheelListener(){

            @Override
            public final void mouseWheelMoved(final MouseWheelEvent e) {
                this.runAndUpdateIfNeeded((Function0<Unit>)((Function0)new Function0<Unit>(){

                    public final void invoke() {
                        int n;
                        MouseWheelEvent mouseWheelEvent = e;
                        Intrinsics.checkExpressionValueIsNotNull((Object)mouseWheelEvent, (String)"e");
                        if (mouseWheelEvent.getScrollType() == 0) {
                            MouseWheelEvent mouseWheelEvent2 = e;
                            Intrinsics.checkExpressionValueIsNotNull((Object)mouseWheelEvent2, (String)"e");
                            int n2 = mouseWheelEvent2.getUnitsToScroll();
                            MouseWheelEvent mouseWheelEvent3 = e;
                            Intrinsics.checkExpressionValueIsNotNull((Object)mouseWheelEvent3, (String)"e");
                            n = n2 * mouseWheelEvent3.getScrollAmount();
                        } else {
                            MouseWheelEvent mouseWheelEvent4 = e;
                            Intrinsics.checkExpressionValueIsNotNull((Object)mouseWheelEvent4, (String)"e");
                            if (mouseWheelEvent4.getWheelRotation() < 0) {
                                MouseWheelEvent mouseWheelEvent5 = e;
                                Intrinsics.checkExpressionValueIsNotNull((Object)mouseWheelEvent5, (String)"e");
                                n = -mouseWheelEvent5.getScrollAmount();
                            } else {
                                MouseWheelEvent mouseWheelEvent6 = e;
                                Intrinsics.checkExpressionValueIsNotNull((Object)mouseWheelEvent6, (String)"e");
                                n = mouseWheelEvent6.getScrollAmount();
                            }
                        }
                        int amount = n;
                        int newKnobPosition = Math.max(0, Math.min(_knobPosition + amount, this.getSliderWidth()));
                        this.setKnobPosition(newKnobPosition);
                    }
                }));
                e.consume();
            }
        });
        this.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(@Nullable FocusEvent e) {
                this.repaint();
            }

            @Override
            public void focusLost(@Nullable FocusEvent e) {
                this.repaint();
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(@Nullable ComponentEvent e) {
                this.repaint();
            }
        });
        Serializable serializable = this.getActionMap();
        boolean bl = false;
        boolean bl2 = false;
        ActionMap $this$with = serializable;
        boolean bl3 = false;
        $this$with.put("actionSlideLeft", new AbstractAction(this){
            final /* synthetic */ SliderComponent this$0;
            {
                this.this$0 = sliderComponent;
            }

            public void actionPerformed(@NotNull ActionEvent e) {
                Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
                SliderComponent.access$runAndUpdateIfNeeded(this.this$0, (Function0)new Function0<Unit>(this){
                    final /* synthetic */ $special$$inlined$with$lambda$1 this$0;
                    {
                        this.this$0 = var1_1;
                        super(0);
                    }

                    public final void invoke() {
                        SliderComponent.access$doSlide(this.this$0.this$0, -1);
                    }
                });
            }
        });
        $this$with.put("actionSlideLeftStep", new AbstractAction(this){
            final /* synthetic */ SliderComponent this$0;
            {
                this.this$0 = sliderComponent;
            }

            public void actionPerformed(@NotNull ActionEvent e) {
                Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
                SliderComponent.access$runAndUpdateIfNeeded(this.this$0, (Function0)new Function0<Unit>(this){
                    final /* synthetic */ $special$$inlined$with$lambda$2 this$0;
                    {
                        this.this$0 = var1_1;
                        super(0);
                    }

                    public final void invoke() {
                        SliderComponent.access$doSlide(this.this$0.this$0, -10);
                    }
                });
            }
        });
        $this$with.put("actionSlideRight", new AbstractAction(this){
            final /* synthetic */ SliderComponent this$0;
            {
                this.this$0 = sliderComponent;
            }

            public void actionPerformed(@NotNull ActionEvent e) {
                Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
                SliderComponent.access$runAndUpdateIfNeeded(this.this$0, (Function0)new Function0<Unit>(this){
                    final /* synthetic */ $special$$inlined$with$lambda$3 this$0;
                    {
                        this.this$0 = var1_1;
                        super(0);
                    }

                    public final void invoke() {
                        SliderComponent.access$doSlide(this.this$0.this$0, 1);
                    }
                });
            }
        });
        $this$with.put("actionSlideRightStep", new AbstractAction(this){
            final /* synthetic */ SliderComponent this$0;
            {
                this.this$0 = sliderComponent;
            }

            public void actionPerformed(@NotNull ActionEvent e) {
                Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
                SliderComponent.access$runAndUpdateIfNeeded(this.this$0, (Function0)new Function0<Unit>(this){
                    final /* synthetic */ $special$$inlined$with$lambda$4 this$0;
                    {
                        this.this$0 = var1_1;
                        super(0);
                    }

                    public final void invoke() {
                        SliderComponent.access$doSlide(this.this$0.this$0, 10);
                    }
                });
            }
        });
        serializable = this.getInputMap(0);
        bl = false;
        bl2 = false;
        $this$with = serializable;
        boolean bl4 = false;
        ((InputMap)((Object)$this$with)).put(KeyStroke.getKeyStroke(37, 0), "actionSlideLeft");
        ((InputMap)((Object)$this$with)).put(KeyStroke.getKeyStroke(37, 512), "actionSlideLeftStep");
        ((InputMap)((Object)$this$with)).put(KeyStroke.getKeyStroke(39, 0), "actionSlideRight");
        ((InputMap)((Object)$this$with)).put(KeyStroke.getKeyStroke(39, 512), "actionSlideRightStep");
    }

    public static final /* synthetic */ void access$set_knobPosition$p(SliderComponent $this, int n) {
        $this._knobPosition = n;
    }

    public static final /* synthetic */ void access$doSlide(SliderComponent $this, int shift) {
        $this.doSlide(shift);
    }
}

