/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.components;

import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.ComponentWithExpandableItems;
import com.intellij.ui.ExpandableItemsHandler;
import com.intellij.ui.ExpandableItemsHandlerFactory;
import com.intellij.ui.ExpandedItemListCellRendererWrapper;
import com.intellij.ui.ScreenUtil;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.components.SelectionAwareListCellRenderer;
import com.intellij.ui.components.WideSelectionListUI;
import com.intellij.util.NotNullFunction;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.AsyncProcessIcon;
import com.intellij.util.ui.ComponentWithEmptyText;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBSwingUtilities;
import com.intellij.util.ui.StatusText;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import javax.swing.plaf.ListUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicListUI;
import javax.swing.text.JTextComponent;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JBList<E>
extends JList<E>
implements ComponentWithEmptyText,
ComponentWithExpandableItems<Integer> {
    private StatusText myEmptyText;
    private ExpandableItemsHandler<Integer> myExpandableItemsHandler;
    @Nullable
    private AsyncProcessIcon myBusyIcon;
    private boolean myBusy;

    public JBList() {
        this.init();
    }

    public JBList(@NotNull ListModel<E> dataModel) {
        if (dataModel == null) {
            JBList.$$$reportNull$$$0(0);
        }
        super(dataModel);
        this.init();
    }

    public JBList(E ... listData) {
        if (listData == null) {
            JBList.$$$reportNull$$$0(1);
        }
        super(JBList.createDefaultListModel(listData));
        this.init();
    }

    @NotNull
    public static <T> DefaultListModel<T> createDefaultListModel(T ... items) {
        if (items == null) {
            JBList.$$$reportNull$$$0(2);
        }
        return JBList.createDefaultListModel(Arrays.asList(items));
    }

    @NotNull
    public static <T> DefaultListModel<T> createDefaultListModel(@NotNull Iterable<? extends T> items) {
        if (items == null) {
            JBList.$$$reportNull$$$0(3);
        }
        DefaultListModel<T> model = new DefaultListModel<T>();
        for (T item : items) {
            model.add(model.getSize(), item);
        }
        DefaultListModel<T> defaultListModel = model;
        if (defaultListModel == null) {
            JBList.$$$reportNull$$$0(4);
        }
        return defaultListModel;
    }

    public JBList(@NotNull Collection<? extends E> items) {
        if (items == null) {
            JBList.$$$reportNull$$$0(5);
        }
        this((ListModel<? extends E>)JBList.createDefaultListModel(items));
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        if (!ScreenUtil.isStandardAddRemoveNotify(this)) {
            return;
        }
        if (this.myBusyIcon != null) {
            this.remove(this.myBusyIcon);
            Disposer.dispose(this.myBusyIcon);
            this.myBusyIcon = null;
        }
    }

    @Override
    public void doLayout() {
        super.doLayout();
        if (this.myBusyIcon != null) {
            this.myBusyIcon.updateLocation(this);
        }
    }

    @Override
    protected Graphics getComponentGraphics(Graphics graphics) {
        return JBSwingUtilities.runGlobalCGTransform(this, super.getComponentGraphics(graphics));
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        if (this.myBusyIcon != null) {
            this.myBusyIcon.updateLocation(this);
        }
    }

    @Override
    public void repaint(long tm, int x, int y, int width, int height) {
        if (width > 0 && height > 0) {
            ListUI ui = this.getUI();
            if (ui instanceof WideSelectionListUI && 0 == this.getLayoutOrientation()) {
                x = 0;
                width = this.getWidth();
            }
            super.repaint(tm, x, y, width, height);
        }
    }

    @Override
    public void setUI(ListUI ui) {
        Class<?> type;
        if (ui != null && Registry.is("ide.wide.selection.list.ui", true) && (type = ui.getClass()) == BasicListUI.class) {
            ui = new WideSelectionListUI();
        }
        super.setUI(ui);
    }

    public void setPaintBusy(boolean paintBusy) {
        if (this.myBusy == paintBusy) {
            return;
        }
        this.myBusy = paintBusy;
        this.updateBusy();
    }

    private void updateBusy() {
        if (this.myBusy && this.myBusyIcon == null) {
            this.myBusyIcon = new AsyncProcessIcon(this.toString());
            this.myBusyIcon.setOpaque(false);
            this.myBusyIcon.setPaintPassiveIcon(false);
            this.add(this.myBusyIcon);
        }
        if (this.myBusyIcon != null) {
            if (this.myBusy) {
                this.myBusyIcon.resume();
            } else {
                this.myBusyIcon.suspend();
                SwingUtilities.invokeLater(() -> {
                    if (this.myBusyIcon != null) {
                        this.repaint();
                    }
                });
            }
            if (this.myBusyIcon != null) {
                this.myBusyIcon.updateLocation(this);
            }
        }
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        this.myEmptyText.paint(this, g);
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension s = this.getEmptyText().getPreferredSize();
        JBInsets.addTo(s, this.getInsets());
        Dimension size = super.getPreferredSize();
        return new Dimension(Math.max(s.width, size.width), Math.max(s.height, size.height));
    }

    private void init() {
        this.setSelectionBackground(UIUtil.getListSelectionBackground(true));
        this.setSelectionForeground(UIUtil.getListSelectionForeground(true));
        this.installDefaultCopyAction();
        this.myEmptyText = new StatusText(this){

            @Override
            protected boolean isStatusVisible() {
                return JBList.this.isEmpty();
            }
        };
        this.myExpandableItemsHandler = this.createExpandableItemsHandler();
        this.setCellRenderer(new DefaultListCellRenderer());
    }

    private void installDefaultCopyAction() {
        Action copy2 = this.getActionMap().get("copy");
        if (copy2 == null || copy2 instanceof UIResource) {
            AbstractAction newCopy = new AbstractAction(){

                @Override
                public boolean isEnabled() {
                    return JBList.this.getSelectedIndex() != -1;
                }

                @Override
                public void actionPerformed(ActionEvent e) {
                    JBList.this.doCopyToClipboardAction();
                }
            };
            this.getActionMap().put("copy", newCopy);
        }
    }

    protected void doCopyToClipboardAction() {
        ArrayList<String> selected2 = new ArrayList<String>();
        for (int index : this.getSelectedIndices()) {
            Object value2 = this.getModel().getElementAt(index);
            String text2 = this.itemToText(index, value2);
            ContainerUtil.addIfNotNull(selected2, text2);
        }
        if (selected2.size() > 0) {
            String text3 = StringUtil.join(selected2, "\n");
            CopyPasteManager.getInstance().setContents(new StringSelection(text3));
        }
    }

    @Nullable
    private String itemToText(int index, E value2) {
        ListCellRenderer<E> renderer = this.getCellRenderer();
        Component c = renderer == null ? null : renderer.getListCellRendererComponent(this, value2, index, true, true);
        SimpleColoredComponent coloredComponent = null;
        if (c instanceof JComponent) {
            coloredComponent = UIUtil.findComponentOfType((JComponent)c, SimpleColoredComponent.class);
        }
        return coloredComponent != null ? coloredComponent.getCharSequence(true).toString() : (c instanceof JTextComponent ? ((JTextComponent)c).getText() : (value2 != null ? value2.toString() : null));
    }

    public boolean isEmpty() {
        return this.getItemsCount() == 0;
    }

    public int getItemsCount() {
        ListModel model = this.getModel();
        return model == null ? 0 : model.getSize();
    }

    @Override
    @NotNull
    public StatusText getEmptyText() {
        StatusText statusText = this.myEmptyText;
        if (statusText == null) {
            JBList.$$$reportNull$$$0(6);
        }
        return statusText;
    }

    public void setEmptyText(@NotNull @Nls String text2) {
        if (text2 == null) {
            JBList.$$$reportNull$$$0(7);
        }
        this.myEmptyText.setText(text2);
    }

    @Override
    @NotNull
    public ExpandableItemsHandler<Integer> getExpandableItemsHandler() {
        ExpandableItemsHandler<Integer> expandableItemsHandler = this.myExpandableItemsHandler;
        if (expandableItemsHandler == null) {
            JBList.$$$reportNull$$$0(8);
        }
        return expandableItemsHandler;
    }

    @NotNull
    protected ExpandableItemsHandler<Integer> createExpandableItemsHandler() {
        ExpandableItemsHandler<Integer> expandableItemsHandler = ExpandableItemsHandlerFactory.install(this);
        if (expandableItemsHandler == null) {
            JBList.$$$reportNull$$$0(9);
        }
        return expandableItemsHandler;
    }

    @Override
    public void setExpandableItemsEnabled(boolean enabled) {
        this.myExpandableItemsHandler.setEnabled(enabled);
    }

    @Override
    public void setCellRenderer(@NotNull ListCellRenderer<? super E> cellRenderer) {
        if (cellRenderer == null) {
            JBList.$$$reportNull$$$0(10);
        }
        if (this.myExpandableItemsHandler == null) {
            super.setCellRenderer(cellRenderer);
            return;
        }
        super.setCellRenderer(new ExpandedItemListCellRendererWrapper<E>(cellRenderer, this.myExpandableItemsHandler));
    }

    public <T> void installCellRenderer(@NotNull NotNullFunction<? super T, ? extends JComponent> fun) {
        if (fun == null) {
            JBList.$$$reportNull$$$0(11);
        }
        this.setCellRenderer(new SelectionAwareListCellRenderer<T>(fun));
    }

    public void setDataProvider(@NotNull DataProvider provider) {
        if (provider == null) {
            JBList.$$$reportNull$$$0(12);
        }
        DataManager.registerDataProvider(this, provider);
    }

    public void disableEmptyText() {
        this.getEmptyText().setText("");
    }

    @Override
    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleJBList();
        }
        return this.accessibleContext;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 6: 
            case 8: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 6: 
            case 8: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataModel";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listData";
                break;
            }
            case 2: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "items";
                break;
            }
            case 4: 
            case 6: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ui/components/JBList";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cellRenderer";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fun";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ui/components/JBList";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createDefaultListModel";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getEmptyText";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getExpandableItemsHandler";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "createExpandableItemsHandler";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createDefaultListModel";
                break;
            }
            case 4: 
            case 6: 
            case 8: 
            case 9: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "setEmptyText";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "setCellRenderer";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "installCellRenderer";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "setDataProvider";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 6: 
            case 8: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    protected class AccessibleJBList
    extends JList.AccessibleJList {
        protected AccessibleJBList() {
            super(JBList.this);
        }

        @Override
        public Accessible getAccessibleAt(Point p) {
            return this.getAccessibleChild(JBList.this.locationToIndex(p));
        }

        @Override
        public Accessible getAccessibleChild(int i) {
            if (i < 0 || i >= JBList.this.getModel().getSize()) {
                return null;
            }
            return new AccessibleJBListChild(JBList.this, i);
        }

        @Override
        public AccessibleRole getAccessibleRole() {
            return UIUtil.invokeAndWaitIfNeeded(() -> super.getAccessibleRole());
        }

        /*
         * Signature claims super is javax.swing.JList$AccessibleJList.AccessibleJListChild, not javax.swing.JList$AccessibleJList$AccessibleJListChild - discarding signature.
         */
        protected class AccessibleJBListChild
        extends JList.AccessibleJList.AccessibleJListChild {
            public AccessibleJBListChild(JBList<E> parent, int indexInParent) {
                super(AccessibleJBList.this, parent, indexInParent);
            }

            @Override
            public AccessibleRole getAccessibleRole() {
                return UIUtil.invokeAndWaitIfNeeded(() -> super.getAccessibleRole());
            }
        }
    }

    public static class StripedListCellRenderer
    extends DefaultListCellRenderer {
        @Override
        public Component getListCellRendererComponent(JList list2, Object value2, int index, boolean isSelected, boolean cellHasFocus) {
            super.getListCellRendererComponent((JList<?>)list2, value2, index, isSelected, cellHasFocus);
            if (!isSelected && index % 2 == 0) {
                this.setBackground(UIUtil.getDecoratedRowColor());
            }
            return this;
        }
    }
}

