/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.components;

import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.ui.ComponentUtil;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.components.DefaultScrollBarUI;
import com.intellij.ui.components.JBScrollBar;
import com.intellij.ui.components.JBViewport;
import com.intellij.ui.components.ScrollBarPainter;
import com.intellij.ui.components.ScrollSettings;
import com.intellij.ui.components.ScrollSource;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.ui.ButtonlessScrollBarUI;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.MouseEventAdapter;
import com.intellij.util.ui.MouseWheelSmoothScroll;
import com.intellij.util.ui.RegionPainter;
import com.intellij.util.ui.TouchScrollUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.lang.reflect.Field;
import java.util.function.Supplier;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.ScrollPaneLayout;
import javax.swing.Scrollable;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.LineBorder;
import javax.swing.plaf.ScrollBarUI;
import javax.swing.plaf.ScrollPaneUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicScrollBarUI;
import javax.swing.plaf.basic.BasicScrollPaneUI;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JBScrollPane
extends JScrollPane {
    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2020.2")
    public static final Key<Boolean> BRIGHTNESS_FROM_VIEW = Key.create("JB_SCROLL_PANE_BRIGHTNESS_FROM_VIEW");
    public static final Key<Boolean> IGNORE_SCROLLBAR_IN_INSETS = Key.create("IGNORE_SCROLLBAR_IN_INSETS");
    private static final Logger LOG = Logger.getInstance(JBScrollPane.class);
    private ScrollSource myScrollSource = ScrollSource.UNKNOWN;
    private double myWheelRotation;
    private int myViewportBorderWidth = -1;
    private volatile boolean myBackgroundRequested;
    private static final int SCROLL_MODIFIERS = -1106;

    public JBScrollPane(int viewportWidth) {
        this.init(false);
        this.myViewportBorderWidth = viewportWidth;
        this.updateViewportBorder();
    }

    public JBScrollPane() {
        this.init();
    }

    public JBScrollPane(Component view) {
        super(view);
        this.init();
    }

    public JBScrollPane(int vsbPolicy, int hsbPolicy) {
        super(vsbPolicy, hsbPolicy);
        this.init();
    }

    public JBScrollPane(Component view, int vsbPolicy, int hsbPolicy) {
        super(view, vsbPolicy, hsbPolicy);
        this.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Color getBackground() {
        JViewport child2;
        Color color = super.getBackground();
        if (!this.myBackgroundRequested && EventQueue.isDispatchThread() && ScrollSettings.isBackgroundFromView() && (!this.isBackgroundSet() || color instanceof UIResource) && (child2 = this.getViewport()) != null) {
            try {
                this.myBackgroundRequested = true;
                Color color2 = child2.getBackground();
                return color2;
            }
            finally {
                this.myBackgroundRequested = false;
            }
        }
        return color;
    }

    static Color getViewBackground(JScrollPane pane2) {
        if (pane2 == null) {
            return null;
        }
        JViewport viewport = pane2.getViewport();
        if (viewport == null) {
            return null;
        }
        Component view = viewport.getView();
        if (view == null) {
            return null;
        }
        return view.getBackground();
    }

    public static JScrollPane findScrollPane(Component c) {
        Container vp;
        if (c == null) {
            return null;
        }
        if (!(c instanceof JViewport) && (vp = c.getParent()) instanceof JViewport) {
            c = vp;
        }
        if (!((c = c.getParent()) instanceof JScrollPane)) {
            return null;
        }
        return (JScrollPane)c;
    }

    private void init() {
        this.init(true);
    }

    private void init(boolean setupCorners) {
        this.setLayout(new Layout());
        if (setupCorners) {
            this.setupCorners();
        }
    }

    protected void setupCorners() {
        this.setBorder(IdeBorderFactory.createBorder());
        this.setCorner("UPPER_RIGHT_CORNER", new Corner("UPPER_RIGHT_CORNER"));
        this.setCorner("UPPER_LEFT_CORNER", new Corner("UPPER_LEFT_CORNER"));
        this.setCorner("LOWER_RIGHT_CORNER", new Corner("LOWER_RIGHT_CORNER"));
        this.setCorner("LOWER_LEFT_CORNER", new Corner("LOWER_LEFT_CORNER"));
    }

    @Override
    public void setUI(ScrollPaneUI ui) {
        super.setUI(ui);
        this.updateViewportBorder();
        if (ui instanceof BasicScrollPaneUI) {
            try {
                Field field = BasicScrollPaneUI.class.getDeclaredField("mouseScrollListener");
                field.setAccessible(true);
                Object value2 = field.get(ui);
                if (value2 instanceof MouseWheelListener) {
                    MouseWheelListener oldListener = (MouseWheelListener)value2;
                    JBMouseWheelListener newListener = new JBMouseWheelListener(oldListener);
                    field.set(ui, newListener);
                    this.removeMouseWheelListener(oldListener);
                    this.addMouseWheelListener(newListener);
                }
            }
            catch (Exception exception) {
                LOG.warn(exception);
            }
        }
    }

    @Override
    public boolean isOptimizedDrawingEnabled() {
        return JBScrollPane.isOptimizedDrawingEnabledFor(this.getVerticalScrollBar()) && JBScrollPane.isOptimizedDrawingEnabledFor(this.getHorizontalScrollBar());
    }

    private static boolean isOptimizedDrawingEnabledFor(JScrollBar bar) {
        return bar == null || !bar.isVisible() || bar.isOpaque() && bar.isOptimizedDrawingEnabled();
    }

    private void updateViewportBorder() {
        if (this.getViewportBorder() instanceof ViewportBorder) {
            this.setViewportBorder(new ViewportBorder(this.myViewportBorderWidth >= 0 ? this.myViewportBorderWidth : 1));
        }
    }

    public static ViewportBorder createIndentBorder() {
        return new ViewportBorder(2);
    }

    @Override
    public JScrollBar createVerticalScrollBar() {
        return new JBScrollBar(1);
    }

    @Override
    @NotNull
    public JScrollBar createHorizontalScrollBar() {
        return new JBScrollBar(0);
    }

    @Override
    protected JViewport createViewport() {
        return new JBViewport();
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2020.2")
    protected boolean isOverlaidScrollbar(@Nullable JScrollBar scrollbar) {
        ScrollBarUI vsbUI = scrollbar == null ? null : scrollbar.getUI();
        return vsbUI instanceof ButtonlessScrollBarUI && !((ButtonlessScrollBarUI)vsbUI).alwaysShowTrack();
    }

    public static boolean canBePreprocessed(@NotNull MouseEvent e, @NotNull JScrollBar bar) {
        if (e == null) {
            JBScrollPane.$$$reportNull$$$0(0);
        }
        if (bar == null) {
            JBScrollPane.$$$reportNull$$$0(1);
        }
        if (e.getID() == 503 || e.getID() == 501) {
            ScrollBarUI ui = bar.getUI();
            if (ui instanceof BasicScrollBarUI) {
                BasicScrollBarUI bui = (BasicScrollBarUI)ui;
                try {
                    Rectangle rect = (Rectangle)ReflectionUtil.getDeclaredMethod(BasicScrollBarUI.class, "getThumbBounds", ArrayUtil.EMPTY_CLASS_ARRAY).invoke((Object)bui, new Object[0]);
                    Point point = SwingUtilities.convertPoint(e.getComponent(), e.getX(), e.getY(), bar);
                    return !rect.contains(point);
                }
                catch (Exception e1) {
                    return true;
                }
            }
            if (ui instanceof DefaultScrollBarUI) {
                DefaultScrollBarUI dui = (DefaultScrollBarUI)ui;
                Point point = e.getLocationOnScreen();
                SwingUtilities.convertPointFromScreen(point, bar);
                return !dui.isThumbContains(point.x, point.y);
            }
        }
        return true;
    }

    @Override
    protected void processMouseWheelEvent(MouseWheelEvent e) {
        boolean hasAbsoluteDelta = ScrollSettings.isPixelPerfectEnabled();
        this.myScrollSource = hasAbsoluteDelta ? ScrollSource.TOUCHPAD : ScrollSource.MOUSE_WHEEL;
        this.myWheelRotation = e.getPreciseWheelRotation();
        super.processMouseWheelEvent(e);
        this.myScrollSource = ScrollSource.UNKNOWN;
    }

    int getInitialDelay(boolean valueIsAdjusting) {
        ScrollSource source = valueIsAdjusting ? ScrollSource.SCROLLBAR : this.myScrollSource;
        return source.getInterpolationDelay(this.myWheelRotation);
    }

    public static boolean isScrollEvent(@NotNull MouseWheelEvent event) {
        boolean ignore;
        if (event == null) {
            JBScrollPane.$$$reportNull$$$0(2);
        }
        if (event.isConsumed()) {
            return false;
        }
        boolean bl = ignore = event.getWheelRotation() == 0;
        if (ignore && (ScrollSettings.isPixelPerfectEnabled() || ScrollSettings.isHighPrecisionEnabled())) {
            double rotation = event.getPreciseWheelRotation();
            ignore = rotation == 0.0 || !Double.isFinite(rotation);
        }
        return !ignore && 0 == (0xFFFFFBAE & event.getModifiers());
    }

    @ApiStatus.Experimental
    public static RegionPainter<Float> getThumbPainter(@NotNull Supplier<? extends Component> supplier) {
        if (supplier == null) {
            JBScrollPane.$$$reportNull$$$0(3);
        }
        return new ScrollBarPainter.Thumb(supplier, SystemInfo.isMac);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bar";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "supplier";
                break;
            }
        }
        objectArray2[1] = "com/intellij/ui/components/JBScrollPane";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "canBePreprocessed";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isScrollEvent";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getThumbPainter";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    protected static class Layout
    extends ScrollPaneLayout {
        private static final Insets EMPTY_INSETS = JBUI.emptyInsets();

        protected Layout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            Rectangle lower;
            Dimension viewPreferredSize;
            Border border;
            boolean hsbOnTop;
            JScrollPane pane2 = (JScrollPane)parent;
            Rectangle bounds2 = new Rectangle(pane2.getWidth(), pane2.getHeight());
            JBInsets.removeFrom(bounds2, pane2.getInsets());
            Object property = pane2.getClientProperty(Flip.class);
            Flip flip = property instanceof Flip ? (Flip)((Object)property) : Flip.NONE;
            boolean bl = hsbOnTop = flip == Flip.BOTH || flip == Flip.VERTICAL;
            boolean vsbOnLeft = pane2.getComponentOrientation().isLeftToRight() ? flip == Flip.BOTH || flip == Flip.HORIZONTAL : flip == Flip.NONE || flip == Flip.VERTICAL;
            Rectangle rowHeadBounds = new Rectangle(bounds2.x, 0, 0, 0);
            if (this.rowHead != null && this.rowHead.isVisible()) {
                rowHeadBounds.width = Layout.min(bounds2.width, this.rowHead.getPreferredSize().width);
                bounds2.width -= rowHeadBounds.width;
                if (vsbOnLeft) {
                    rowHeadBounds.x += bounds2.width;
                } else {
                    bounds2.x += rowHeadBounds.width;
                }
            }
            Rectangle colHeadBounds = new Rectangle(0, bounds2.y, 0, 0);
            if (this.colHead != null && this.colHead.isVisible()) {
                colHeadBounds.height = Layout.min(bounds2.height, this.colHead.getPreferredSize().height);
                bounds2.height -= colHeadBounds.height;
                if (hsbOnTop) {
                    colHeadBounds.y += bounds2.height;
                } else {
                    bounds2.y += colHeadBounds.height;
                }
            }
            Insets insets = (border = pane2.getViewportBorder()) == null ? null : border.getBorderInsets(parent);
            JBInsets.removeFrom(bounds2, insets);
            if (insets == null) {
                insets = EMPTY_INSETS;
            }
            boolean isEmpty = bounds2.width < 0 || bounds2.height < 0;
            Component view = this.viewport == null ? null : this.viewport.getView();
            Dimension dimension = viewPreferredSize = view == null ? new Dimension() : view.getPreferredSize();
            if (view instanceof JComponent && !view.isPreferredSizeSet()) {
                JBInsets.removeFrom(viewPreferredSize, JBViewport.getViewInsets((JComponent)view));
            }
            Dimension viewportExtentSize = this.viewport == null ? new Dimension() : this.viewport.toViewCoordinates(bounds2.getSize());
            Point viewLocation = new Point();
            if (view != null) {
                viewLocation = view.getLocation(viewLocation);
            }
            boolean vsbOpaque = false;
            boolean vsbNeeded = false;
            int vsbPolicy = pane2.getVerticalScrollBarPolicy();
            if (!isEmpty && vsbPolicy != 21) {
                vsbNeeded = vsbPolicy == 22 || Layout.isVerticalScrollBarNeeded(view, viewLocation, viewPreferredSize, viewportExtentSize);
            }
            Rectangle vsbBounds = new Rectangle(0, bounds2.y - insets.top, 0, 0);
            if (this.vsb != null) {
                if (Layout.isAlwaysOpaque(view)) {
                    this.vsb.setOpaque(true);
                }
                vsbOpaque = this.vsb.isOpaque();
                if (vsbNeeded) {
                    this.adjustForVSB(bounds2, insets, vsbBounds, vsbOpaque, vsbOnLeft);
                    if (vsbOpaque && this.viewport != null) {
                        viewportExtentSize = this.viewport.toViewCoordinates(bounds2.getSize());
                    }
                }
            }
            boolean hsbOpaque = false;
            boolean hsbNeeded = false;
            int hsbPolicy = pane2.getHorizontalScrollBarPolicy();
            if (!isEmpty && hsbPolicy != 31) {
                hsbNeeded = hsbPolicy == 32 || Layout.isHorizontalScrollBarNeeded(view, viewLocation, viewPreferredSize, viewportExtentSize);
            }
            Rectangle hsbBounds = new Rectangle(bounds2.x - insets.left, 0, 0, 0);
            if (this.hsb != null) {
                if (Layout.isAlwaysOpaque(view)) {
                    this.hsb.setOpaque(true);
                }
                hsbOpaque = this.hsb.isOpaque();
                if (hsbNeeded) {
                    this.adjustForHSB(bounds2, insets, hsbBounds, hsbOpaque, hsbOnTop);
                    if (this.vsb != null && !vsbNeeded && vsbPolicy != 21) {
                        if (!hsbOpaque) {
                            viewPreferredSize.height += hsbBounds.height;
                        } else if (this.viewport != null) {
                            viewportExtentSize = this.viewport.toViewCoordinates(bounds2.getSize());
                        }
                        vsbNeeded = Layout.isScrollBarNeeded(viewLocation.y, viewPreferredSize.height, viewportExtentSize.height);
                        if (vsbNeeded) {
                            this.adjustForVSB(bounds2, insets, vsbBounds, vsbOpaque, vsbOnLeft);
                        }
                    }
                }
            }
            if (this.viewport != null) {
                this.viewport.setBounds(bounds2);
                if (!isEmpty && view instanceof Scrollable) {
                    boolean hsbNeededNew;
                    boolean vsbNeededNew;
                    viewportExtentSize = this.viewport.toViewCoordinates(bounds2.getSize());
                    boolean vsbNeededOld = vsbNeeded;
                    if (this.vsb != null && vsbPolicy == 20 && vsbNeeded != (vsbNeededNew = Layout.isVerticalScrollBarNeeded(view, viewLocation, viewPreferredSize, viewportExtentSize))) {
                        vsbNeeded = vsbNeededNew;
                        if (vsbNeeded) {
                            this.adjustForVSB(bounds2, insets, vsbBounds, vsbOpaque, vsbOnLeft);
                        } else if (vsbOpaque) {
                            bounds2.width += vsbBounds.width;
                        }
                        if (vsbOpaque) {
                            viewportExtentSize = this.viewport.toViewCoordinates(bounds2.getSize());
                        }
                    }
                    boolean hsbNeededOld = hsbNeeded;
                    if (this.hsb != null && hsbPolicy == 30 && hsbNeeded != (hsbNeededNew = Layout.isHorizontalScrollBarNeeded(view, viewLocation, viewPreferredSize, viewportExtentSize))) {
                        hsbNeeded = hsbNeededNew;
                        if (hsbNeeded) {
                            this.adjustForHSB(bounds2, insets, hsbBounds, hsbOpaque, hsbOnTop);
                        } else if (hsbOpaque) {
                            bounds2.height += hsbBounds.height;
                        }
                        if (hsbOpaque && this.vsb != null && !vsbNeeded && vsbPolicy != 21) {
                            viewportExtentSize = this.viewport.toViewCoordinates(bounds2.getSize());
                            vsbNeeded = Layout.isScrollBarNeeded(viewLocation.y, viewPreferredSize.height, viewportExtentSize.height);
                            if (vsbNeeded) {
                                this.adjustForVSB(bounds2, insets, vsbBounds, vsbOpaque, vsbOnLeft);
                            }
                        }
                    }
                    if (hsbNeededOld != hsbNeeded || vsbNeededOld != vsbNeeded) {
                        this.viewport.setBounds(bounds2);
                    }
                }
            }
            rowHeadBounds.y = bounds2.y - insets.top;
            rowHeadBounds.height = bounds2.height + insets.top + insets.bottom;
            boolean fillLowerCorner = false;
            if (this.rowHead != null) {
                if (hsbOpaque) {
                    Component corner = hsbOnTop ? (vsbOnLeft ? this.upperRight : this.upperLeft) : (vsbOnLeft ? this.lowerRight : this.lowerLeft);
                    boolean bl2 = fillLowerCorner = corner == null && UIManager.getBoolean("ScrollPane.fillLowerCorner");
                    if (!fillLowerCorner && ScrollSettings.isHeaderOverCorner(this.viewport)) {
                        if (hsbOnTop) {
                            rowHeadBounds.y -= hsbBounds.height;
                        }
                        rowHeadBounds.height += hsbBounds.height;
                    }
                }
                this.rowHead.setBounds(rowHeadBounds);
                this.rowHead.putClientProperty(Alignment.class, (Object)(vsbOnLeft ? Alignment.RIGHT : Alignment.LEFT));
            }
            colHeadBounds.x = bounds2.x - insets.left;
            colHeadBounds.width = bounds2.width + insets.left + insets.right;
            boolean fillUpperCorner = false;
            if (this.colHead != null) {
                if (vsbOpaque) {
                    Component corner = vsbOnLeft ? (hsbOnTop ? this.lowerLeft : this.upperLeft) : (hsbOnTop ? this.lowerRight : this.upperRight);
                    boolean bl3 = fillUpperCorner = corner == null && UIManager.getBoolean("ScrollPane.fillUpperCorner");
                    if (!fillUpperCorner && ScrollSettings.isHeaderOverCorner(this.viewport)) {
                        if (vsbOnLeft) {
                            colHeadBounds.x -= vsbBounds.width;
                        }
                        colHeadBounds.width += vsbBounds.width;
                    }
                }
                this.colHead.setBounds(colHeadBounds);
                this.colHead.putClientProperty(Alignment.class, (Object)(hsbOnTop ? Alignment.BOTTOM : Alignment.TOP));
            }
            int overlapWidth = 0;
            int overlapHeight = 0;
            if (vsbNeeded && !vsbOpaque && hsbNeeded && !hsbOpaque) {
                overlapWidth = vsbBounds.width;
            }
            vsbBounds.y = bounds2.y - insets.top;
            vsbBounds.height = bounds2.height + insets.top + insets.bottom;
            if (this.vsb != null) {
                this.vsb.setVisible(vsbNeeded);
                if (vsbNeeded) {
                    if (fillUpperCorner) {
                        if (!hsbOnTop) {
                            vsbBounds.y -= colHeadBounds.height;
                        }
                        vsbBounds.height += colHeadBounds.height;
                    }
                    int overlapY = !hsbOnTop ? 0 : overlapHeight;
                    this.vsb.setBounds(vsbBounds.x, vsbBounds.y + overlapY, vsbBounds.width, vsbBounds.height - overlapHeight);
                    this.vsb.putClientProperty(Alignment.class, (Object)(vsbOnLeft ? Alignment.LEFT : Alignment.RIGHT));
                }
                if (!vsbOpaque) {
                    if (!vsbOnLeft) {
                        vsbBounds.x += vsbBounds.width;
                    }
                    vsbBounds.width = 0;
                }
            }
            hsbBounds.x = bounds2.x - insets.left;
            hsbBounds.width = bounds2.width + insets.left + insets.right;
            if (this.hsb != null) {
                this.hsb.setVisible(hsbNeeded);
                if (hsbNeeded) {
                    if (fillLowerCorner) {
                        if (!vsbOnLeft) {
                            hsbBounds.x -= rowHeadBounds.width;
                        }
                        hsbBounds.width += rowHeadBounds.width;
                    }
                    int overlapX = !vsbOnLeft ? 0 : overlapWidth;
                    this.hsb.setBounds(hsbBounds.x + overlapX, hsbBounds.y, hsbBounds.width - overlapWidth, hsbBounds.height);
                    this.hsb.putClientProperty(Alignment.class, (Object)(hsbOnTop ? Alignment.TOP : Alignment.BOTTOM));
                }
                if (!hsbOpaque) {
                    if (!hsbOnTop) {
                        hsbBounds.y += hsbBounds.height;
                    }
                    hsbBounds.height = 0;
                }
            }
            Rectangle left = vsbOnLeft ? vsbBounds : rowHeadBounds;
            Rectangle right = vsbOnLeft ? rowHeadBounds : vsbBounds;
            Rectangle upper = hsbOnTop ? hsbBounds : colHeadBounds;
            Rectangle rectangle = lower = hsbOnTop ? colHeadBounds : hsbBounds;
            if (this.lowerLeft != null) {
                Rectangle lowerLeftBounds = new Rectangle(left.x, left.y + left.height, 0, 0);
                if (left.width > 0 && lower.height > 0) {
                    Layout.updateCornerBounds(lowerLeftBounds, lower.x, lower.y + lower.height);
                }
                this.lowerLeft.setBounds(lowerLeftBounds);
            }
            if (this.lowerRight != null) {
                Rectangle lowerRightBounds = new Rectangle(lower.x + lower.width, right.y + right.height, 0, 0);
                if (right.width > 0 && lower.height > 0) {
                    Layout.updateCornerBounds(lowerRightBounds, right.x + right.width, lower.y + lower.height);
                }
                this.lowerRight.setBounds(lowerRightBounds);
            }
            if (this.upperLeft != null) {
                Rectangle upperLeftBounds = new Rectangle(left.x, upper.y, 0, 0);
                if (left.width > 0 && upper.height > 0) {
                    Layout.updateCornerBounds(upperLeftBounds, upper.x, left.y);
                }
                this.upperLeft.setBounds(upperLeftBounds);
            }
            if (this.upperRight != null) {
                Rectangle upperRightBounds = new Rectangle(upper.x + upper.width, upper.y, 0, 0);
                if (right.width > 0 && upper.height > 0) {
                    Layout.updateCornerBounds(upperRightBounds, right.x + right.width, right.y);
                }
                this.upperRight.setBounds(upperRightBounds);
            }
            if (!vsbOpaque && vsbNeeded || !hsbOpaque && hsbNeeded) {
                Layout.fixComponentZOrder(this.vsb, 0);
                Layout.fixComponentZOrder(this.viewport, -1);
            }
        }

        private static boolean tracksViewportWidth(Component view) {
            return view instanceof Scrollable && ((Scrollable)((Object)view)).getScrollableTracksViewportWidth();
        }

        private static boolean tracksViewportHeight(Component view) {
            return view instanceof Scrollable && ((Scrollable)((Object)view)).getScrollableTracksViewportHeight();
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            Component view;
            Dimension result2 = new Dimension();
            JScrollPane pane2 = (JScrollPane)parent;
            JBInsets.addTo(result2, pane2.getInsets());
            Border border = pane2.getViewportBorder();
            if (border != null) {
                JBInsets.addTo(result2, border.getBorderInsets(parent));
            }
            int vsbPolicy = pane2.getVerticalScrollBarPolicy();
            int hsbPolicy = pane2.getHorizontalScrollBarPolicy();
            if (this.viewport != null && (view = this.viewport.getView()) != null) {
                Dimension viewPreferredSize;
                Point viewLocation = view.getLocation();
                Dimension viewportExtentSize = this.viewport.getPreferredSize();
                if (viewportExtentSize == null) {
                    viewportExtentSize = new Dimension();
                }
                if ((viewPreferredSize = view.getPreferredSize()) == null) {
                    viewPreferredSize = new Dimension();
                }
                if (view instanceof JComponent && !view.isPreferredSizeSet()) {
                    JBInsets.removeFrom(viewPreferredSize, JBViewport.getViewInsets((JComponent)view));
                }
                result2.width += viewportExtentSize.width;
                result2.height += viewportExtentSize.height;
                if (vsbPolicy == 20 && Layout.isVerticalScrollBarNeeded(view, viewLocation, viewPreferredSize, viewportExtentSize)) {
                    vsbPolicy = 22;
                }
                if (hsbPolicy == 30 && Layout.isHorizontalScrollBarNeeded(view, viewLocation, viewPreferredSize, viewportExtentSize)) {
                    hsbPolicy = 32;
                }
            }
            if (this.vsb != null && vsbPolicy == 22) {
                result2.width += this.vsb.getPreferredSize().width;
            }
            if (this.hsb != null && hsbPolicy == 32) {
                result2.height += this.hsb.getPreferredSize().height;
            }
            if (this.rowHead != null && this.rowHead.isVisible()) {
                result2.width += this.rowHead.getPreferredSize().width;
            }
            if (this.colHead != null && this.colHead.isVisible()) {
                result2.height += this.colHead.getPreferredSize().height;
            }
            return result2;
        }

        private static boolean isAlwaysOpaque(Component view) {
            return !SystemInfo.isMac && ScrollSettings.isNotSupportedYet(view);
        }

        private static void updateCornerBounds(Rectangle bounds2, int x, int y) {
            bounds2.width = Math.abs(bounds2.x - x);
            bounds2.height = Math.abs(bounds2.y - y);
            bounds2.x = Math.min(bounds2.x, x);
            bounds2.y = Math.min(bounds2.y, y);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static void fixComponentZOrder(Component component2, int index) {
            if (component2 != null) {
                Container parent = component2.getParent();
                Object object = parent.getTreeLock();
                synchronized (object) {
                    if (index < 0) {
                        index += parent.getComponentCount();
                    }
                    parent.setComponentZOrder(component2, index);
                }
            }
        }

        private void adjustForVSB(Rectangle bounds2, Insets insets, Rectangle vsbBounds, boolean vsbOpaque, boolean vsbOnLeft) {
            int n = vsbBounds.width = !this.vsb.isEnabled() ? 0 : Layout.min(bounds2.width, this.vsb.getPreferredSize().width);
            if (vsbOnLeft) {
                vsbBounds.x = bounds2.x - insets.left;
                if (vsbOpaque) {
                    bounds2.x += vsbBounds.width;
                }
            } else {
                vsbBounds.x = bounds2.x + bounds2.width + insets.right - vsbBounds.width;
            }
            if (vsbOpaque) {
                bounds2.width -= vsbBounds.width;
            }
        }

        private void adjustForHSB(Rectangle bounds2, Insets insets, Rectangle hsbBounds, boolean hsbOpaque, boolean hsbOnTop) {
            int n = hsbBounds.height = !this.hsb.isEnabled() ? 0 : Layout.min(bounds2.height, this.hsb.getPreferredSize().height);
            if (hsbOnTop) {
                hsbBounds.y = bounds2.y - insets.top;
                if (hsbOpaque) {
                    bounds2.y += hsbBounds.height;
                }
            } else {
                hsbBounds.y = bounds2.y + bounds2.height + insets.bottom - hsbBounds.height;
            }
            if (hsbOpaque) {
                bounds2.height -= hsbBounds.height;
            }
        }

        private static int min(int one, int two) {
            return Math.max(0, Math.min(one, two));
        }

        private static boolean isScrollBarNeeded(int location2, int preferredSize, int extentSize) {
            return preferredSize > extentSize || location2 != 0;
        }

        private static boolean isHorizontalScrollBarNeeded(Component view, Point location2, Dimension preferredSize, Dimension extentSize) {
            return Layout.isScrollBarNeeded(location2.x, preferredSize.width, extentSize.width) && !Layout.tracksViewportWidth(view);
        }

        private static boolean isVerticalScrollBarNeeded(Component view, Point location2, Dimension preferredSize, Dimension extentSize) {
            return Layout.isScrollBarNeeded(location2.y, preferredSize.height, extentSize.height) && !Layout.tracksViewportHeight(view);
        }
    }

    public static enum Alignment {
        TOP,
        LEFT,
        RIGHT,
        BOTTOM;


        public static Alignment get(JComponent component2) {
            if (component2 != null) {
                Object property = component2.getClientProperty(Alignment.class);
                if (property instanceof Alignment) {
                    return (Alignment)((Object)property);
                }
                Container parent = component2.getParent();
                if (parent instanceof JScrollPane) {
                    JScrollPane pane2 = (JScrollPane)parent;
                    if (component2 == pane2.getColumnHeader()) {
                        return TOP;
                    }
                    if (component2 == pane2.getHorizontalScrollBar()) {
                        return BOTTOM;
                    }
                    boolean ltr = pane2.getComponentOrientation().isLeftToRight();
                    if (component2 == pane2.getVerticalScrollBar()) {
                        return ltr ? RIGHT : LEFT;
                    }
                    if (component2 == pane2.getRowHeader()) {
                        return ltr ? LEFT : RIGHT;
                    }
                }
                if (component2 instanceof JScrollBar) {
                    JScrollBar bar = (JScrollBar)component2;
                    switch (bar.getOrientation()) {
                        case 0: {
                            return BOTTOM;
                        }
                        case 1: {
                            return bar.getComponentOrientation().isLeftToRight() ? RIGHT : LEFT;
                        }
                    }
                }
            }
            return null;
        }
    }

    public static enum Flip {
        NONE,
        VERTICAL,
        HORIZONTAL,
        BOTH;

    }

    private static class ViewportBorder
    extends LineBorder {
        ViewportBorder(int thickness) {
            super(null, thickness);
        }

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            this.updateColor(c);
            super.paintBorder(c, g, x, y, width, height);
        }

        private void updateColor(Component c) {
            if (!(c instanceof JScrollPane)) {
                return;
            }
            this.lineColor = JBScrollPane.getViewBackground((JScrollPane)c);
        }
    }

    private static class Corner
    extends JPanel {
        private final String myPos;

        Corner(String pos) {
            this.myPos = pos;
            ScrollBarPainter.setBackground(this);
        }

        @Override
        protected void paintComponent(Graphics g) {
            g.setColor(this.getBackground());
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
        }
    }

    private static class JBMouseWheelListener
    implements MouseWheelListener {
        private final MouseWheelListener myDelegate;
        private MouseWheelSmoothScroll mySmoothScroll;

        private JBMouseWheelListener(MouseWheelListener delegate) {
            this.myDelegate = delegate;
        }

        @Override
        public void mouseWheelMoved(MouseWheelEvent event) {
            boolean isScrollEvent = JBScrollPane.isScrollEvent(event);
            boolean isScrollPaneEvent = event.getSource() instanceof JScrollPane;
            if (isScrollEvent && isScrollPaneEvent) {
                boolean isAdjustedDeltaZero;
                JScrollPane pane2 = (JScrollPane)event.getSource();
                JScrollBar bar = event.isShiftDown() ? pane2.getHorizontalScrollBar() : pane2.getVerticalScrollBar();
                boolean isWheelScrollEnabled = pane2.isWheelScrollingEnabled();
                boolean isBarVisible = bar != null && bar.isVisible();
                boolean bl = isAdjustedDeltaZero = bar instanceof JBScrollBar && ((JBScrollBar)bar).getDeltaAdjusted(event) == 0.0;
                if (isWheelScrollEnabled && isBarVisible && !isAdjustedDeltaZero) {
                    if (UISettings.getShadowInstance().getAnimatedScrolling() || TouchScrollUtil.isTouchScroll(event)) {
                        if (this.mySmoothScroll == null) {
                            this.mySmoothScroll = MouseWheelSmoothScroll.create(() -> ScrollSettings.isEligibleFor(pane2));
                        }
                        this.mySmoothScroll.processMouseWheelEvent(event, this.myDelegate::mouseWheelMoved);
                    } else if (!(bar instanceof JBScrollBar) || !((JBScrollBar)bar).handleMouseWheelEvent(event)) {
                        this.myDelegate.mouseWheelMoved(event);
                    }
                }
                if (!event.isConsumed()) {
                    MouseEventAdapter.redispatch(event, ComponentUtil.getParentOfType(JScrollPane.class, pane2.getParent()));
                }
            }
        }
    }
}

