/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.components;

import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.Pair;
import com.intellij.ui.JBCardLayout;
import com.intellij.ui.components.JBPanel;
import java.awt.Component;
import java.util.ArrayList;

public class JBSlidingPanel
extends JBPanel {
    private final ArrayList<Pair<String, Component>> mySlides = new ArrayList();
    private int mySelectedIndex = -1;

    public JBSlidingPanel() {
        this.setLayout(new JBCardLayout());
    }

    @Override
    public JBCardLayout getLayout() {
        return (JBCardLayout)super.getLayout();
    }

    @Override
    public Component add(String name, Component comp) {
        this.mySlides.add(Pair.create(name, comp));
        if (this.mySelectedIndex == -1) {
            this.mySelectedIndex = 0;
        }
        return super.add(name, comp);
    }

    public ActionCallback goLeft() {
        if (this.mySelectedIndex == 0) {
            return ActionCallback.REJECTED;
        }
        --this.mySelectedIndex;
        return this.applySlide(JBCardLayout.SwipeDirection.BACKWARD);
    }

    public ActionCallback swipe(String id2, JBCardLayout.SwipeDirection direction) {
        ActionCallback done = new ActionCallback();
        this.getLayout().swipe(this, id2, direction, () -> done.setDone());
        return done;
    }

    public ActionCallback goRight() {
        if (this.mySelectedIndex == this.mySlides.size() - 1) {
            return ActionCallback.REJECTED;
        }
        ++this.mySelectedIndex;
        return this.applySlide(JBCardLayout.SwipeDirection.FORWARD);
    }

    private ActionCallback applySlide(JBCardLayout.SwipeDirection direction) {
        ActionCallback callback2 = new ActionCallback();
        this.getLayout().swipe(this, (String)this.mySlides.get((int)this.mySelectedIndex).first, direction, () -> callback2.setDone());
        return callback2;
    }

    @Override
    @Deprecated
    public Component add(Component comp) {
        throw new AddMethodIsNotSupportedException();
    }

    @Override
    @Deprecated
    public Component add(Component comp, int index) {
        throw new AddMethodIsNotSupportedException();
    }

    @Override
    @Deprecated
    public void add(Component comp, Object constraints) {
        throw new AddMethodIsNotSupportedException();
    }

    @Override
    @Deprecated
    public void add(Component comp, Object constraints, int index) {
        throw new AddMethodIsNotSupportedException();
    }

    private static class AddMethodIsNotSupportedException
    extends RuntimeException {
        AddMethodIsNotSupportedException() {
            super("Use add(String, Component) method");
        }
    }
}

