/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.components;

import com.intellij.ui.ScreenUtil;
import com.intellij.util.ui.JBSwingUtilities;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTabbedPane;
import javax.swing.border.EmptyBorder;
import org.intellij.lang.annotations.JdkConstants;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JBTabbedPane
extends JTabbedPane
implements HierarchyListener {
    public static final String LABEL_FROM_TABBED_PANE = "JBTabbedPane.labelFromTabbedPane";
    private Insets myTabComponentInsets = UIUtil.PANEL_SMALL_INSETS;

    public JBTabbedPane() {
    }

    public JBTabbedPane(@JdkConstants.TabPlacement int tabPlacement) {
        super(tabPlacement);
    }

    public JBTabbedPane(@JdkConstants.TabPlacement int tabPlacement, @JdkConstants.TabLayoutPolicy int tabLayoutPolicy) {
        super(tabPlacement, tabLayoutPolicy);
    }

    @Override
    public void setComponentAt(int index, Component component2) {
        super.setComponentAt(index, component2);
        component2.addHierarchyListener(this);
        this.setInsets(component2);
        this.revalidate();
        this.repaint();
    }

    @Override
    public void insertTab(@Nls(capitalization=Nls.Capitalization.Title) String title, Icon icon2, Component component2, @Nls(capitalization=Nls.Capitalization.Sentence) String tip, int index) {
        super.insertTab(title, icon2, component2, tip, index);
        JLabel label2 = new JLabel(title);
        label2.setIcon(icon2);
        label2.setBorder(new EmptyBorder(1, 1, 1, 1));
        label2.setFont(this.getFont());
        this.setTabComponentAt(index, label2);
        label2.putClientProperty(LABEL_FROM_TABBED_PANE, Boolean.TRUE);
        component2.addHierarchyListener(this);
        this.setInsets(component2);
        this.revalidate();
        this.repaint();
    }

    @Override
    public void setSelectedIndex(int index) {
        super.setSelectedIndex(index);
        this.revalidate();
        this.repaint();
    }

    private void setInsets(Component component2) {
        if (component2 instanceof JComponent && this.myTabComponentInsets != null) {
            UIUtil.addInsets((JComponent)component2, this.getInsetsForTabComponent());
        }
    }

    @Deprecated
    @NotNull
    protected Insets getInsetsForTabComponent() {
        Insets insets = this.myTabComponentInsets;
        if (insets == null) {
            JBTabbedPane.$$$reportNull$$$0(0);
        }
        return insets;
    }

    @Nullable
    public Insets getTabComponentInsets() {
        return this.myTabComponentInsets;
    }

    public void setTabComponentInsets(@Nullable Insets tabInsets) {
        this.myTabComponentInsets = tabInsets;
    }

    @Override
    public void hierarchyChanged(HierarchyEvent e) {
        this.repaint();
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        if (!ScreenUtil.isStandardAddRemoveNotify(this)) {
            return;
        }
        for (int i = 0; i < this.getTabCount(); ++i) {
            this.getComponentAt(i).removeHierarchyListener(this);
        }
    }

    @Override
    protected Graphics getComponentGraphics(Graphics graphics) {
        return JBSwingUtilities.runGlobalCGTransform(this, super.getComponentGraphics(graphics));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/components/JBTabbedPane", "getInsetsForTabComponent"));
    }
}

