/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.components;

import com.intellij.ui.TextAccessor;
import com.intellij.ui.components.TextComponentEmptyText;
import com.intellij.util.BooleanFunction;
import com.intellij.util.ui.ComponentWithEmptyText;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.StatusText;
import com.intellij.util.ui.UIUtil;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import javax.swing.JTextField;
import javax.swing.plaf.TextUI;
import org.jetbrains.annotations.NotNull;

public class JBTextField
extends JTextField
implements ComponentWithEmptyText,
TextAccessor {
    private TextComponentEmptyText myEmptyText;

    public JBTextField() {
        this.init();
    }

    public JBTextField(int columns) {
        super(columns);
        this.init();
    }

    public JBTextField(String text2) {
        super(text2);
        this.init();
    }

    public JBTextField(String text2, int columns) {
        super(text2, columns);
        this.init();
    }

    private void init() {
        UIUtil.addUndoRedoActions(this);
        this.myEmptyText = new TextComponentEmptyText(this){

            @Override
            protected boolean isStatusVisible() {
                Object function = JBTextField.this.getClientProperty("StatusVisibleFunction");
                if (function instanceof BooleanFunction) {
                    return ((BooleanFunction)function).fun(JBTextField.this);
                }
                return super.isStatusVisible();
            }

            @Override
            protected Rectangle getTextComponentBound() {
                return JBTextField.this.getEmptyTextComponentBounds(super.getTextComponentBound());
            }
        };
    }

    protected Rectangle getEmptyTextComponentBounds(Rectangle bounds2) {
        return bounds2;
    }

    public void setTextToTriggerEmptyTextStatus(String t) {
        this.myEmptyText.setTextToTriggerStatus(t);
    }

    @Override
    public void setText(String t) {
        super.setText(t);
        UIUtil.resetUndoRedoActions(this);
    }

    @Override
    @NotNull
    public StatusText getEmptyText() {
        TextComponentEmptyText textComponentEmptyText = this.myEmptyText;
        if (textComponentEmptyText == null) {
            JBTextField.$$$reportNull$$$0(0);
        }
        return textComponentEmptyText;
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (!this.myEmptyText.getStatusTriggerText().isEmpty() && this.myEmptyText.isStatusVisible()) {
            g.setColor(this.getBackground());
            Rectangle rect = new Rectangle(this.getSize());
            JBInsets.removeFrom(rect, this.getInsets());
            JBInsets.removeFrom(rect, this.getMargin());
            ((Graphics2D)g).fill(rect);
            g.setColor(this.getForeground());
        }
        this.myEmptyText.paintStatusText(g);
    }

    @Override
    public String getToolTipText(MouseEvent event) {
        TextUI ui = this.getUI();
        String text2 = ui == null ? null : ui.getToolTipText(this, event.getPoint());
        return text2 != null ? text2 : this.getToolTipText();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/components/JBTextField", "getEmptyText"));
    }
}

