/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.components;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.ui.ComponentUtil;
import com.intellij.ui.components.DefaultScrollBarUI;
import com.intellij.ui.mac.foundation.Foundation;
import com.intellij.ui.mac.foundation.ID;
import com.intellij.util.Alarm;
import com.intellij.util.NotNullProducer;
import com.intellij.util.ui.UIUtil;
import com.sun.jna.Callback;
import com.sun.jna.Pointer;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.MouseEvent;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.JComponent;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.plaf.ScrollBarUI;
import org.jetbrains.annotations.NotNull;

final class MacScrollBarUI
extends DefaultScrollBarUI {
    private static final List<Reference<MacScrollBarUI>> UI = new ArrayList<Reference<MacScrollBarUI>>();
    private final Alarm myAlarm = new Alarm();
    private boolean myTrackHovered;
    private static final AtomicReference<AWTEventListener> MOVEMENT_LISTENER = new AtomicReference<1>(new AWTEventListener(){

        @Override
        public void eventDispatched(AWTEvent event) {
            JScrollPane pane2;
            Object source;
            if (event != null && 503 == event.getID() && (source = event.getSource()) instanceof Component && (pane2 = ComponentUtil.getParentOfType(JScrollPane.class, (Component)source)) != null) {
                this.pauseThumbAnimation(pane2.getHorizontalScrollBar());
                this.pauseThumbAnimation(pane2.getVerticalScrollBar());
            }
        }

        private void pauseThumbAnimation(JScrollBar bar) {
            ScrollBarUI object;
            ScrollBarUI scrollBarUI = object = bar == null ? null : bar.getUI();
            if (object instanceof MacScrollBarUI) {
                MacScrollBarUI ui = (MacScrollBarUI)object;
                if (0.0f < ui.myThumb.animator.myValue) {
                    ui.onThumbMove();
                }
            }
        }
    });

    MacScrollBarUI() {
        super(14, 14, 11);
    }

    @Override
    boolean isAbsolutePositioning(MouseEvent event) {
        return Behavior.JumpToSpot == Behavior.CURRENT.get();
    }

    @Override
    boolean isTrackClickable() {
        return MacScrollBarUI.isOpaque(this.myScrollBar) || this.myTrack.animator.myValue > 0.0f && this.myThumb.animator.myValue > 0.0f;
    }

    @Override
    boolean isTrackExpandable() {
        return !MacScrollBarUI.isOpaque(this.myScrollBar);
    }

    @Override
    void onTrackHover(boolean hover) {
        this.myTrackHovered = hover;
        if (this.myScrollBar != null && MacScrollBarUI.isOpaque(this.myScrollBar)) {
            this.myTrack.animator.start(hover);
            this.myThumb.animator.start(hover);
        } else if (hover) {
            this.myTrack.animator.start(true);
        } else {
            this.myThumb.animator.start(false);
        }
    }

    @Override
    void onThumbHover(boolean hover) {
    }

    @Override
    void paintTrack(Graphics2D g, JComponent c) {
        if (this.myTrack.animator.myValue > 0.0f && this.myThumb.animator.myValue > 0.0f || MacScrollBarUI.isOpaque(c)) {
            super.paintTrack(g, c);
        }
    }

    @Override
    void paintThumb(Graphics2D g, JComponent c) {
        if (MacScrollBarUI.isOpaque(c)) {
            this.paint(this.myThumb, g, c, true);
        } else if (this.myThumb.animator.myValue > 0.0f) {
            this.paint(this.myThumb, g, c, false);
        }
    }

    @Override
    void onThumbMove() {
        if (this.myScrollBar != null && this.myScrollBar.isShowing() && !MacScrollBarUI.isOpaque(this.myScrollBar)) {
            if (!this.myTrackHovered && this.myThumb.animator.myValue == 0.0f) {
                this.myTrack.animator.rewind(false);
            }
            this.myThumb.animator.rewind(true);
            this.myAlarm.cancelAllRequests();
            if (!this.myTrackHovered) {
                this.myAlarm.addRequest(() -> this.myThumb.animator.start(false), 700);
            }
        }
    }

    @Override
    public void installUI(JComponent c) {
        super.installUI(c);
        this.updateStyle((Style)((Object)Style.CURRENT.get()));
        MacScrollBarUI.processReferences(this, null, null);
        AWTEventListener listener2 = MOVEMENT_LISTENER.getAndSet(null);
        if (listener2 != null) {
            Toolkit.getDefaultToolkit().addAWTEventListener(listener2, 32L);
        }
    }

    @Override
    public void uninstallUI(JComponent c) {
        MacScrollBarUI.processReferences(null, this, null);
        this.myAlarm.cancelAllRequests();
        super.uninstallUI(c);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void processReferences(MacScrollBarUI toAdd, MacScrollBarUI toRemove2, List<? super MacScrollBarUI> list2) {
        List<Reference<MacScrollBarUI>> list3 = UI;
        synchronized (list3) {
            Iterator<Reference<MacScrollBarUI>> iterator2 = UI.iterator();
            while (iterator2.hasNext()) {
                Reference<MacScrollBarUI> reference2 = iterator2.next();
                MacScrollBarUI ui = reference2.get();
                if (ui == null || ui == toRemove2) {
                    iterator2.remove();
                    continue;
                }
                if (list2 == null) continue;
                list2.add(ui);
            }
            if (toAdd != null) {
                UI.add(new WeakReference<MacScrollBarUI>(toAdd));
            }
        }
    }

    private void updateStyle(Style style) {
        if (this.myScrollBar != null) {
            this.myScrollBar.setOpaque(style != Style.Overlay);
            this.myScrollBar.revalidate();
            this.myScrollBar.repaint();
            this.onThumbMove();
        }
    }

    private static ID createDelegate(String name, Pointer pointer, Callback callback2) {
        ID delegateClass = Foundation.allocateObjcClassPair(Foundation.getObjcClass("NSObject"), name);
        if (!ID.NIL.equals((Object)delegateClass)) {
            if (!Foundation.addMethod(delegateClass, pointer, callback2, "v@")) {
                throw new RuntimeException("Cannot add observer method");
            }
            Foundation.registerObjcClassPair(delegateClass);
        }
        return Foundation.invoke(name, "new", new Object[0]);
    }

    private static <T> T callMac(NotNullProducer<? extends T> producer) {
        if (SystemInfo.isMac) {
            Foundation.NSAutoreleasePool pool = new Foundation.NSAutoreleasePool();
            try {
                T t = producer.produce();
                return t;
            }
            catch (Throwable throwable) {
                Logger.getInstance(MacScrollBarUI.class).warn(throwable);
            }
            finally {
                pool.drain();
            }
        }
        return null;
    }

    private static abstract class Native<T>
    implements Callback,
    Runnable,
    NotNullProducer<T> {
        private T myValue;

        Native() {
            Logger.getInstance(MacScrollBarUI.class).debug("initialize ", this);
            MacScrollBarUI.callMac(() -> this.initialize());
            UIUtil.invokeLaterIfNeeded(this);
        }

        abstract ID initialize();

        T get() {
            return this.myValue;
        }

        public void callback(ID self, Pointer selector, ID event) {
            Logger.getInstance(MacScrollBarUI.class).debug("update ", this);
            UIUtil.invokeLaterIfNeeded(this);
        }

        @Override
        public void run() {
            this.myValue = MacScrollBarUI.callMac(this);
        }
    }

    private static enum Style {
        Legacy,
        Overlay;

        private static final Native<Style> CURRENT;

        static {
            CURRENT = new Native<Style>(){

                @Override
                public void run() {
                    Style newStyle;
                    Style oldStyle = (Style)((Object)this.get());
                    if (!Registry.is("ide.mac.disableMacScrollbars", false) && SystemInfo.isMacOSMountainLion) {
                        super.run();
                    }
                    if ((newStyle = (Style)((Object)this.get())) != oldStyle) {
                        ArrayList list2 = new ArrayList();
                        MacScrollBarUI.processReferences(null, null, list2);
                        for (MacScrollBarUI ui : list2) {
                            ui.updateStyle(newStyle);
                        }
                    }
                }

                @Override
                @NotNull
                public Style produce() {
                    ID style = Foundation.invoke(Foundation.getObjcClass("NSScroller"), "preferredScrollerStyle", new Object[0]);
                    Style value2 = 1 == style.intValue() ? Overlay : Legacy;
                    Logger.getInstance(MacScrollBarUI.class).debug("scroll bar style ", new Object[]{value2, " from ", style});
                    Style style2 = value2;
                    if (style2 == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return style2;
                }

                public String toString() {
                    return "scroll bar style";
                }

                @Override
                ID initialize() {
                    return Foundation.invoke(Foundation.invoke("NSNotificationCenter", "defaultCenter", new Object[0]), "addObserver:selector:name:object:", new Object[]{MacScrollBarUI.createDelegate("JBScrollBarStyleObserver", Foundation.createSelector("handleScrollerStyleChanged:"), this), Foundation.createSelector("handleScrollerStyleChanged:"), Foundation.nsString("NSPreferredScrollerStyleDidChangeNotification"), ID.NIL});
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/components/MacScrollBarUI$Style$1", "produce"));
                }
            };
        }
    }

    private static enum Behavior {
        NextPage,
        JumpToSpot;

        private static final Native<Behavior> CURRENT;

        static {
            CURRENT = new Native<Behavior>(){

                @Override
                @NotNull
                public Behavior produce() {
                    ID defaults = Foundation.invoke("NSUserDefaults", "standardUserDefaults", new Object[0]);
                    Foundation.invoke(defaults, "synchronize", new Object[0]);
                    ID behavior = Foundation.invoke(defaults, "boolForKey:", new Object[]{Foundation.nsString("AppleScrollerPagingBehavior")});
                    Behavior value2 = 1 == behavior.intValue() ? JumpToSpot : NextPage;
                    Logger.getInstance(MacScrollBarUI.class).debug("scroll bar behavior ", new Object[]{value2, " from ", behavior});
                    Behavior behavior2 = value2;
                    if (behavior2 == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return behavior2;
                }

                public String toString() {
                    return "scroll bar behavior";
                }

                @Override
                ID initialize() {
                    return Foundation.invoke(Foundation.invoke("NSDistributedNotificationCenter", "defaultCenter", new Object[0]), "addObserver:selector:name:object:", new Object[]{MacScrollBarUI.createDelegate("JBScrollBarBehaviorObserver", Foundation.createSelector("handleBehaviorChanged:"), this), Foundation.createSelector("handleBehaviorChanged:"), Foundation.nsString("AppleNoRedisplayAppearancePreferenceChanged"), ID.NIL, 2});
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/components/MacScrollBarUI$Behavior$1", "produce"));
                }
            };
        }
    }
}

