/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.components;

import com.intellij.ui.Gray;
import com.intellij.ui.JBColor;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.util.Locale;
import javax.swing.JComponent;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicToggleButtonUI;

public class OnOffButton
extends JToggleButton {
    private String myOnText = "ON";
    private String myOffText = "OFF";

    public OnOffButton() {
        this.setBorder(null);
        this.setOpaque(false);
    }

    public String getOnText() {
        return this.myOnText;
    }

    public void setOnText(String onText) {
        this.myOnText = onText;
    }

    public String getOffText() {
        return this.myOffText;
    }

    public void setOffText(String offText) {
        this.myOffText = offText;
    }

    @Override
    public String getUIClassID() {
        return "OnOffButtonUI";
    }

    @Override
    public void updateUI() {
        Object uiClassName = UIManager.get(this.getUIClassID());
        this.setUI(uiClassName == null ? DefaultOnOffButtonUI.createUI(this) : UIManager.getUI(this));
    }

    private static class DefaultOnOffButtonUI
    extends BasicToggleButtonUI {
        private static final Color BORDER_COLOR = JBColor.namedColor("ToggleButton.borderColor", new JBColor(Gray._192, Gray._80));
        private static final Color BUTTON_COLOR = JBColor.namedColor("ToggleButton.buttonColor", new JBColor(Gray._200, Gray._100));
        private static final Color ON_BACKGROUND = JBColor.namedColor("ToggleButton.onBackground", new JBColor(new Color(74, 146, 73), new Color(77, 105, 76)));
        private static final Color ON_FOREGROUND = JBColor.namedColor("ToggleButton.onForeground", new JBColor(() -> UIUtil.getListForeground(true, true)));
        private static final Color OFF_BACKGROUND = JBColor.namedColor("ToggleButton.offBackground", new JBColor(() -> UIUtil.getPanelBackground()));
        private static final Color OFF_FOREGROUND = JBColor.namedColor("ToggleButton.offForeground", new JBColor(() -> UIUtil.getLabelDisabledForeground()));

        private DefaultOnOffButtonUI() {
        }

        public static ComponentUI createUI(JComponent c) {
            c.setAlignmentY(0.5f);
            return new DefaultOnOffButtonUI();
        }

        @Override
        public Dimension getPreferredSize(JComponent c) {
            int vGap = JBUIScale.scale(3);
            OnOffButton button2 = (OnOffButton)c;
            String text2 = button2.getOffText().length() > button2.getOnText().length() ? button2.getOffText() : button2.getOnText();
            text2 = text2.toUpperCase(Locale.getDefault());
            FontMetrics fm = c.getFontMetrics(c.getFont());
            int w = fm.stringWidth(text2);
            int h = fm.getHeight();
            w = (int)((double)w + 1.25 * (double)(h += 2 * vGap));
            return new Dimension(w, h);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void paint(Graphics g, JComponent c) {
            if (!(c instanceof OnOffButton)) {
                return;
            }
            int toggleArc = JBUIScale.scale(3);
            int buttonArc = JBUIScale.scale(5);
            int vGap = JBUIScale.scale(3);
            int hGap = JBUIScale.scale(3);
            OnOffButton button2 = (OnOffButton)c;
            Dimension size = button2.getSize();
            int w = size.width - 2 * vGap;
            int h = size.height - 2 * hGap;
            if (h % 2 == 1) {
                --h;
            }
            Graphics2D g2 = (Graphics2D)g.create();
            try {
                g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                int xOff = (button2.getWidth() - w) / 2;
                int yOff = (button2.getHeight() - h) / 2;
                g2.translate(xOff, yOff);
                boolean selected2 = button2.isSelected();
                g2.setColor(selected2 ? ON_BACKGROUND : OFF_BACKGROUND);
                g2.fillRoundRect(0, 0, w, h, buttonArc, buttonArc);
                int knobWidth = w - SwingUtilities.computeStringWidth(g2.getFontMetrics(), button2.getOffText()) - JBUIScale.scale(2);
                knobWidth = Math.min(knobWidth, h);
                int textAscent = g2.getFontMetrics().getAscent();
                Rectangle viewRect = new Rectangle();
                Rectangle textRect = new Rectangle();
                Rectangle iconRect = new Rectangle();
                g2.setColor(BUTTON_COLOR);
                if (selected2) {
                    g2.fillRoundRect(w - knobWidth, 0, knobWidth, h, toggleArc, toggleArc);
                    viewRect.setBounds(0, 0, w - knobWidth, h);
                    SwingUtilities.layoutCompoundLabel(g2.getFontMetrics(), button2.getOnText(), null, 0, 0, 0, 0, viewRect, iconRect, textRect, 0);
                    g2.setColor(ON_FOREGROUND);
                    g2.drawString(button2.getOnText(), textRect.x, textRect.y + textAscent);
                } else {
                    g2.fillRoundRect(0, 0, knobWidth, h, toggleArc, toggleArc);
                    viewRect.setBounds(knobWidth, 0, w - knobWidth, h);
                    SwingUtilities.layoutCompoundLabel(g2.getFontMetrics(), button2.getOffText(), null, 0, 0, 0, 0, viewRect, iconRect, textRect, 0);
                    g2.setColor(OFF_FOREGROUND);
                    g2.drawString(button2.getOffText(), textRect.x, textRect.y + textAscent);
                }
                g2.setColor(BORDER_COLOR);
                g2.drawRoundRect(0, 0, w, h, buttonArc, buttonArc);
            }
            finally {
                g2.dispose();
            }
        }

        @Override
        public Dimension getMinimumSize(JComponent c) {
            return this.getPreferredSize(c);
        }

        @Override
        public Dimension getMaximumSize(JComponent c) {
            return this.getPreferredSize(c);
        }
    }
}

