/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.components;

import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.editor.colors.ColorKey;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.JBColor;
import com.intellij.ui.MixedColorProducer;
import com.intellij.ui.components.DefaultScrollBarUI;
import com.intellij.ui.components.TwoWayAnimator;
import com.intellij.ui.paint.RectanglePainter;
import com.intellij.util.ui.RegionPainter;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class ScrollBarPainter
implements RegionPainter<Float> {
    final Rectangle bounds;
    final TwoWayAnimator animator;
    private static final ColorKey BACKGROUND = ScrollBarPainter.key(-657931, -12631484, "ScrollBar.background");
    private static final ColorKey TRACK_OPAQUE_BACKGROUND = SystemInfo.isMac ? ScrollBarPainter.key(0x808080, 0x808080, "ScrollBar.Mac.trackColor") : ScrollBarPainter.key(0x808080, 0x808080, "ScrollBar.trackColor");
    private static final ColorKey TRACK_OPAQUE_HOVERED_BACKGROUND = SystemInfo.isMac ? ScrollBarPainter.key(0x808080, 0x808080, "ScrollBar.Mac.hoverTrackColor") : ScrollBarPainter.key(0x808080, 0x808080, "ScrollBar.hoverTrackColor");
    private static final ColorKey TRACK_BACKGROUND = SystemInfo.isMac ? ScrollBarPainter.key(0x808080, 0x808080, "ScrollBar.Mac.Transparent.trackColor") : ScrollBarPainter.key(0x808080, 0x808080, "ScrollBar.Transparent.trackColor");
    private static final ColorKey TRACK_HOVERED_BACKGROUND = SystemInfo.isMac ? ScrollBarPainter.key(444629120, 444629120, "ScrollBar.Mac.Transparent.hoverTrackColor") : ScrollBarPainter.key(444629120, 444629120, "ScrollBar.Transparent.hoverTrackColor");
    private static final ColorKey THUMB_OPAQUE_FOREGROUND = SystemInfo.isMac ? ScrollBarPainter.key(0x33000000, 1495672358, "ScrollBar.Mac.thumbBorderColor") : ScrollBarPainter.key(0x33595959, 1194866744, "ScrollBar.thumbBorderColor");
    private static final ColorKey THUMB_OPAQUE_BACKGROUND = SystemInfo.isMac ? ScrollBarPainter.key(0x33000000, 1501593728, "ScrollBar.Mac.thumbColor") : ScrollBarPainter.key(0x33737373, 1202103974, "ScrollBar.thumbColor");
    private static final ColorKey THUMB_OPAQUE_HOVERED_FOREGROUND = SystemInfo.isMac ? ScrollBarPainter.key(Integer.MIN_VALUE, -1943656922, "ScrollBar.Mac.hoverThumbBorderColor") : ScrollBarPainter.key(1197037913, 1496856632, "ScrollBar.hoverThumbBorderColor");
    private static final ColorKey THUMB_OPAQUE_HOVERED_BACKGROUND = SystemInfo.isMac ? ScrollBarPainter.key(Integer.MIN_VALUE, -1937735552, "ScrollBar.Mac.hoverThumbColor") : ScrollBarPainter.key(0x47737373, 1504093862, "ScrollBar.hoverThumbColor");
    private static final ColorKey THUMB_FOREGROUND = SystemInfo.isMac ? ScrollBarPainter.key(0, 0x262626, "ScrollBar.Mac.Transparent.thumbBorderColor") : ScrollBarPainter.key(0x33595959, 1194866744, "ScrollBar.Transparent.thumbBorderColor");
    private static final ColorKey THUMB_BACKGROUND = SystemInfo.isMac ? ScrollBarPainter.key(0, 0x808080, "ScrollBar.Mac.Transparent.thumbColor") : ScrollBarPainter.key(0x33737373, 1202103974, "ScrollBar.Transparent.thumbColor");
    private static final ColorKey THUMB_HOVERED_FOREGROUND = SystemInfo.isMac ? ScrollBarPainter.key(Integer.MIN_VALUE, -1943656922, "ScrollBar.Mac.Transparent.hoverThumbBorderColor") : ScrollBarPainter.key(1197037913, 1496856632, "ScrollBar.Transparent.hoverThumbBorderColor");
    private static final ColorKey THUMB_HOVERED_BACKGROUND = SystemInfo.isMac ? ScrollBarPainter.key(Integer.MIN_VALUE, -1937735552, "ScrollBar.Mac.Transparent.hoverThumbColor") : ScrollBarPainter.key(0x47737373, 1504093862, "ScrollBar.Transparent.hoverThumbColor");
    private static final List<ColorKey> CONTRAST_ELEMENTS_KEYS = Arrays.asList(THUMB_OPAQUE_FOREGROUND, THUMB_OPAQUE_BACKGROUND, THUMB_OPAQUE_HOVERED_FOREGROUND, THUMB_OPAQUE_HOVERED_BACKGROUND, THUMB_FOREGROUND, THUMB_BACKGROUND, THUMB_HOVERED_FOREGROUND, THUMB_HOVERED_BACKGROUND);
    private static final int LIGHT_ALPHA = SystemInfo.isMac ? 120 : 160;
    private static final int DARK_ALPHA = SystemInfo.isMac ? 255 : 180;

    ScrollBarPainter(final @NotNull Supplier<? extends Component> supplier) {
        if (supplier == null) {
            ScrollBarPainter.$$$reportNull$$$0(0);
        }
        this.bounds = new Rectangle();
        this.animator = new TwoWayAnimator(this.getClass().getName(), 11, 150, 125, 300, 125){

            @Override
            void onValueUpdate() {
                Component component2 = (Component)supplier.get();
                if (component2 != null) {
                    component2.repaint();
                }
            }
        };
    }

    @NotNull
    private static ColorKey key(int light, int dark, @NotNull String name) {
        if (name == null) {
            ScrollBarPainter.$$$reportNull$$$0(1);
        }
        ColorKey colorKey = ColorKey.createColorKey(name, JBColor.namedColor(name, new JBColor(new Color(light, true), new Color(dark, true))));
        if (colorKey == null) {
            ScrollBarPainter.$$$reportNull$$$0(2);
        }
        return colorKey;
    }

    @NotNull
    private static Color getColor(@Nullable Component component2, @NotNull ColorKey key) {
        boolean useContrastScrollbars;
        Function<ColorKey, Color> function;
        Color color;
        if (key == null) {
            ScrollBarPainter.$$$reportNull$$$0(3);
        }
        Color color2 = color = (function = UIUtil.getClientProperty((Object)component2, ColorKey.FUNCTION_KEY)) == null ? null : function.apply(key);
        if (color == null) {
            color = key.getDefaultColor();
        }
        if (useContrastScrollbars = UISettings.getShadowInstance().getUseContrastScrollbars()) {
            color = ScrollBarPainter.updateTransparency(color, key);
        }
        Color color3 = color;
        if (color3 == null) {
            ScrollBarPainter.$$$reportNull$$$0(4);
        }
        return color3;
    }

    private static Color updateTransparency(Color color, ColorKey key) {
        if (!CONTRAST_ELEMENTS_KEYS.contains(key)) {
            return color;
        }
        int alpha = Registry.intValue("contrast.scrollbars.alpha.level");
        alpha = alpha > 0 ? Integer.min(alpha, 255) : (UIUtil.isUnderDarcula() ? DARK_ALPHA : LIGHT_ALPHA);
        return ColorUtil.toAlpha(color, alpha);
    }

    static Color getColor(@NotNull Supplier<? extends Component> supplier, @NotNull ColorKey key) {
        if (supplier == null) {
            ScrollBarPainter.$$$reportNull$$$0(5);
        }
        if (key == null) {
            ScrollBarPainter.$$$reportNull$$$0(6);
        }
        return new JBColor(() -> ScrollBarPainter.getColor((Component)supplier.get(), key));
    }

    static Color getColor(@NotNull Supplier<? extends Component> supplier, @NotNull ColorKey transparent, @NotNull ColorKey opaque) {
        if (supplier == null) {
            ScrollBarPainter.$$$reportNull$$$0(7);
        }
        if (transparent == null) {
            ScrollBarPainter.$$$reportNull$$$0(8);
        }
        if (opaque == null) {
            ScrollBarPainter.$$$reportNull$$$0(9);
        }
        return new JBColor(() -> {
            Component component2;
            return ScrollBarPainter.getColor(component2, (component2 = (Component)supplier.get()) != null && DefaultScrollBarUI.isOpaque(component2) ? opaque : transparent);
        });
    }

    static void setBackground(@NotNull Component component2) {
        if (component2 == null) {
            ScrollBarPainter.$$$reportNull$$$0(10);
        }
        component2.setBackground(new JBColor(() -> ScrollBarPainter.getColor(component2, BACKGROUND)));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "supplier";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ui/components/ScrollBarPainter";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "transparent";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "opaque";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ui/components/ScrollBarPainter";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "key";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getColor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "key";
                break;
            }
            case 2: 
            case 4: {
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getColor";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "setBackground";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static final class Thumb
    extends ScrollBarPainter {
        private final MixedColorProducer fillProducer;
        private final MixedColorProducer drawProducer;

        Thumb(@NotNull Supplier<? extends Component> supplier, boolean opaque) {
            if (supplier == null) {
                Thumb.$$$reportNull$$$0(0);
            }
            super(supplier);
            this.fillProducer = new MixedColorProducer(opaque ? Thumb.getColor(supplier, THUMB_OPAQUE_BACKGROUND) : Thumb.getColor(supplier, THUMB_BACKGROUND, THUMB_OPAQUE_BACKGROUND), opaque ? Thumb.getColor(supplier, THUMB_OPAQUE_HOVERED_BACKGROUND) : Thumb.getColor(supplier, THUMB_HOVERED_BACKGROUND, THUMB_OPAQUE_HOVERED_BACKGROUND));
            this.drawProducer = new MixedColorProducer(opaque ? Thumb.getColor(supplier, THUMB_OPAQUE_FOREGROUND) : Thumb.getColor(supplier, THUMB_FOREGROUND, THUMB_OPAQUE_FOREGROUND), opaque ? Thumb.getColor(supplier, THUMB_OPAQUE_HOVERED_FOREGROUND) : Thumb.getColor(supplier, THUMB_HOVERED_FOREGROUND, THUMB_OPAQUE_HOVERED_FOREGROUND));
        }

        @Override
        public void paint(@NotNull Graphics2D g, int x, int y, int width, int height, @Nullable Float value2) {
            if (g == null) {
                Thumb.$$$reportNull$$$0(1);
            }
            double mixer = value2 == null ? 0.0 : value2.doubleValue();
            Color fill = this.fillProducer.produce(mixer);
            Color draw = this.drawProducer.produce(mixer);
            if (fill.getRGB() == draw.getRGB()) {
                draw = null;
            }
            int arc = 0;
            if (SystemInfo.isMac) {
                int margin = draw == null ? 2 : 1;
                x += margin;
                y += margin;
                arc = Math.min(width -= margin + margin, height -= margin + margin);
            }
            RectanglePainter.paint(g, x, y, width, height, arc, fill, draw);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "supplier";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "g";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/ui/components/ScrollBarPainter$Thumb";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "paint";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    static final class Track
    extends ScrollBarPainter {
        private final MixedColorProducer fillProducer;

        Track(@NotNull Supplier<? extends Component> supplier) {
            if (supplier == null) {
                Track.$$$reportNull$$$0(0);
            }
            super(supplier);
            this.fillProducer = new MixedColorProducer(Track.getColor(supplier, TRACK_BACKGROUND, TRACK_OPAQUE_BACKGROUND), Track.getColor(supplier, TRACK_HOVERED_BACKGROUND, TRACK_OPAQUE_HOVERED_BACKGROUND));
        }

        @Override
        public void paint(@NotNull Graphics2D g, int x, int y, int width, int height, @Nullable Float value2) {
            double mixer;
            Color fill;
            if (g == null) {
                Track.$$$reportNull$$$0(1);
            }
            if (0 >= (fill = this.fillProducer.produce(mixer = value2 == null ? 0.0 : value2.doubleValue())).getAlpha()) {
                return;
            }
            g.setPaint(fill);
            RectanglePainter.FILL.paint(g, x, y, width, height, null);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "supplier";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "g";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/ui/components/ScrollBarPainter$Track";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "paint";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

