/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.components;

import com.intellij.ide.PowerSaveMode;
import com.intellij.ide.RemoteDesktopService;
import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.registry.Registry;
import java.awt.Component;
import java.awt.Container;
import java.awt.Window;
import javax.swing.JDialog;
import javax.swing.JScrollBar;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.RootPaneContainer;

final class ScrollSettings {
    ScrollSettings() {
    }

    static boolean isEligibleFor(Component component2) {
        if (component2 == null || !component2.isShowing()) {
            return false;
        }
        Application application = ApplicationManager.getApplication();
        if (application == null || application.isUnitTestMode()) {
            return false;
        }
        if (PowerSaveMode.isEnabled()) {
            return false;
        }
        if (RemoteDesktopService.isRemoteSession()) {
            return false;
        }
        UISettings settings = UISettings.getInstanceOrNull();
        return settings != null && settings.getSmoothScrolling();
    }

    static boolean isHighPrecisionEnabled() {
        return Registry.is("idea.true.smooth.scrolling.high.precision", true);
    }

    static boolean isPixelPerfectEnabled() {
        return Registry.is("idea.true.smooth.scrolling.pixel.perfect", true);
    }

    static boolean isDebugEnabled() {
        return Registry.is("idea.true.smooth.scrolling.debug", false);
    }

    static boolean isBackgroundFromView() {
        return Registry.is("ide.scroll.background.auto", true);
    }

    static boolean isHeaderOverCorner(JViewport viewport) {
        Component view = viewport == null ? null : viewport.getView();
        return !ScrollSettings.isNotSupportedYet(view) && Registry.is("ide.scroll.layout.header.over.corner", true);
    }

    static boolean isNotSupportedYet(Component view) {
        return view instanceof JTable;
    }

    static boolean isGapNeededForAnyComponent() {
        return Registry.is("ide.scroll.align.component", true);
    }

    static boolean isHorizontalGapNeededOnMac() {
        return Registry.is("mac.scroll.horizontal.gap", false);
    }

    static boolean isThumbSmallIfOpaque() {
        return Registry.is("ide.scroll.thumb.small.if.opaque", false);
    }

    static boolean isInterpolationEligibleFor(JScrollBar scrollbar) {
        String name;
        Component[] subComponents;
        Window window = (Window)scrollbar.getTopLevelAncestor();
        if (window instanceof JDialog && "Commit Changes".equals(((JDialog)window).getTitle())) {
            return false;
        }
        if (!(window instanceof RootPaneContainer)) {
            return true;
        }
        Component[] components = ((RootPaneContainer)((Object)window)).getContentPane().getComponents();
        if (components.length == 1 && components[0].getClass().getName().contains("DiffWindow")) {
            return false;
        }
        return components.length != 2 || !(components[0] instanceof Container) || (subComponents = ((Container)components[0]).getComponents()).length != 1 || !(name = subComponents[0].getClass().getName()).contains("DiffWindow") && !name.contains("MergeWindow");
    }
}

