/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.components;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.ColoredItem;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.ui.BackgroundSupplier;
import com.intellij.ui.components.JBList;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.list.ListCellBackgroundSupplier;
import com.intellij.ui.paint.RectanglePainter;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.ListSelectionModel;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicListUI;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class WideSelectionListUI
extends BasicListUI {
    private static final Logger LOG = Logger.getInstance(WideSelectionListUI.class);
    private Rectangle myPaintBounds;

    @Override
    public void paint(Graphics g, JComponent c) {
        this.myPaintBounds = 0 != this.list.getLayoutOrientation() ? null : g.getClipBounds();
        super.paint(g, c);
    }

    protected void paintCell(Graphics g, int row, Rectangle rowBounds, ListCellRenderer renderer, ListModel model, ListSelectionModel selectionModel, int leadSelectionIndex) {
        if (0 > row || row >= model.getSize()) {
            return;
        }
        boolean selected2 = selectionModel.isSelectedIndex(row);
        Rectangle paintBounds = this.myPaintBounds;
        if (paintBounds != null) {
            Component component2;
            boolean focused = row == leadSelectionIndex && (!this.list.isFocusable() || this.list.hasFocus());
            Object value2 = model.getElementAt(row);
            Color background = WideSelectionListUI.getBackground(this.list, value2, row);
            if (background != null) {
                g.setColor(background);
                g.fillRect(rowBounds.x, rowBounds.y, rowBounds.width, rowBounds.height);
            }
            if ((component2 = renderer.getListCellRendererComponent(this.list, value2, row, selected2, focused)) != null) {
                if (this.rendererPane != component2.getParent()) {
                    this.rendererPane.add(component2);
                }
                g.setClip(paintBounds.x, paintBounds.y, paintBounds.width, paintBounds.height);
                WideSelectionListUI.paintRenderer(g, rowBounds.x, rowBounds.y, rowBounds.width, rowBounds.height, this.list, component2);
                g.clipRect(rowBounds.x, rowBounds.y, rowBounds.width, rowBounds.height);
            }
        }
        try {
            super.paintCell(g, row, rowBounds, renderer, model, selectionModel, leadSelectionIndex);
        }
        catch (ArrayIndexOutOfBoundsException exception) {
            LOG.error("model asynchronously modified: " + model.getClass() + " in " + this.list, exception);
        }
        if (!SystemInfo.isMac && g instanceof Graphics2D && row == leadSelectionIndex && this.list.hasFocus()) {
            int x = rowBounds.x;
            int width = rowBounds.width;
            if (0 == this.list.getLayoutOrientation()) {
                x = 0;
                width = this.list.getWidth();
                Container parent = this.list.getParent();
                if (parent instanceof JViewport) {
                    x = -this.list.getX();
                    width = parent.getWidth();
                }
            }
            if (!selected2) {
                g.setColor(UIUtil.getListSelectionBackground(true));
                g.setClip(x, rowBounds.y, width, rowBounds.height);
                RectanglePainter.DRAW.paint((Graphics2D)g, x, rowBounds.y, width, rowBounds.height, 0);
            } else if (WideSelectionListUI.isLeadSelectionNeeded(this.list, row)) {
                g.setColor(UIUtil.getListBackground());
                g.setClip(x, rowBounds.y, width, rowBounds.height);
                RectanglePainter.DRAW.paint((Graphics2D)g, x + 1, rowBounds.y + 1, width - 2, rowBounds.height - 2, 0);
            }
        }
    }

    private static boolean isLeadSelectionNeeded(@NotNull JList list2, int row) {
        if (list2 == null) {
            WideSelectionListUI.$$$reportNull$$$0(0);
        }
        return list2.getMinSelectionIndex() < list2.getMaxSelectionIndex() && list2.isSelectedIndex(row - 1) && list2.isSelectedIndex(row + 1);
    }

    @Nullable
    private static Color getBackground(@NotNull JList<Object> list2, @Nullable Object value2, int row) {
        BackgroundSupplier supplier;
        Color background;
        Color background2;
        if (list2 == null) {
            WideSelectionListUI.$$$reportNull$$$0(1);
        }
        if (value2 instanceof ColoredItem && (background2 = ((ColoredItem)value2).getColor()) != null) {
            return background2;
        }
        if (value2 instanceof BackgroundSupplier && (background = (supplier = (BackgroundSupplier)value2).getElementBackground(row)) != null) {
            return background;
        }
        if (list2 instanceof ListCellBackgroundSupplier && (background2 = ((ListCellBackgroundSupplier)((Object)list2)).getCellBackground(value2, row)) != null) {
            return background2;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void paintRenderer(Graphics g, int x, int y, int width, int height, Component owner, Component renderer) {
        g.clipRect(0, y, owner.getWidth(), height);
        WideSelectionListUI.paintBackground(g, y, height, owner, renderer);
        if (renderer instanceof Container) {
            Component[] children2;
            Container container2 = (Container)renderer;
            Component[] componentArray = container2.getTreeLock();
            synchronized (componentArray) {
                children2 = container2.getComponents();
            }
            if (children2.length > 0) {
                renderer.setBounds(x, y, width, height);
                renderer.validate();
                for (Component child2 : children2) {
                    if (0 != child2.getX() || width != child2.getWidth() || 0 >= child2.getHeight()) continue;
                    WideSelectionListUI.paintBackground(g, y + child2.getY(), child2.getHeight(), owner, child2);
                }
            }
        }
    }

    private static void paintBackground(Graphics g, int y, int height, Component owner, Component child2) {
        Color color;
        if (child2.isOpaque() && (color = child2.getBackground()) != null && !color.equals(owner.getBackground())) {
            g.setColor(color);
            g.fillRect(0, y, owner.getWidth(), height);
        }
    }

    public Rectangle getCellBounds(JList list2, int index1, int index2) {
        Rectangle bounds2 = super.getCellBounds(list2, index1, index2);
        if (bounds2 != null && index1 == index2 && list2 instanceof JBList && 0 == list2.getLayoutOrientation() && ((JBList)list2).getExpandableItemsHandler().getExpandedItems().contains(index1)) {
            JScrollBar bar;
            JScrollPane pane2 = JBScrollPane.findScrollPane(list2);
            JScrollBar jScrollBar = bar = pane2 == null ? null : pane2.getVerticalScrollBar();
            if (bar != null && !bar.isOpaque()) {
                bounds2.width += bar.getWidth();
            }
        }
        return bounds2;
    }

    @Override
    protected void updateLayoutState() {
        block10: {
            int fixedCellWidth;
            if (this.list.getLayoutOrientation() != 0) {
                super.updateLayoutState();
                return;
            }
            int fixedCellHeight = this.list.getFixedCellHeight();
            this.cellWidth = fixedCellWidth = this.list.getFixedCellWidth();
            if (fixedCellHeight != -1) {
                this.cellHeight = fixedCellHeight;
                this.cellHeights = null;
            } else {
                this.cellHeight = -1;
                this.cellHeights = new int[this.list.getModel().getSize()];
            }
            if (fixedCellWidth != -1 && fixedCellHeight != -1) break block10;
            ListModel dataModel = this.list.getModel();
            int dataModelSize = dataModel.getSize();
            ListCellRenderer renderer = this.list.getCellRenderer();
            if (renderer != null) {
                for (int index = 0; index < dataModelSize; ++index) {
                    Object value2 = dataModel.getElementAt(index);
                    Component c = renderer.getListCellRendererComponent(this.list, value2, index, false, false);
                    this.rendererPane.add(c);
                    Dimension cellSize = UIUtil.updateListRowHeight(c.getPreferredSize());
                    if (fixedCellWidth == -1) {
                        this.cellWidth = Math.max(cellSize.width, this.cellWidth);
                    }
                    if (fixedCellHeight != -1) continue;
                    this.cellHeights[index] = cellSize.height;
                }
            } else {
                if (this.cellWidth == -1) {
                    this.cellWidth = 0;
                }
                if (this.cellHeights == null) {
                    this.cellHeights = new int[dataModelSize];
                }
                for (int index = 0; index < dataModelSize; ++index) {
                    this.cellHeights[index] = 0;
                }
            }
        }
    }

    public static ComponentUI createUI(JComponent list2) {
        return new WideSelectionListUI();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "list";
        objectArray2[1] = "com/intellij/ui/components/WideSelectionListUI";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isLeadSelectionNeeded";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getBackground";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

