/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.components.fields;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Pair;
import com.intellij.ui.ComponentUtil;
import com.intellij.ui.Expandable;
import com.intellij.ui.ScreenUtil;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.components.fields.ExtendableTextComponent;
import com.intellij.util.Function;
import com.intellij.util.Functions;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ComponentListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.EventHandler;
import java.util.Collections;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.AncestorListener;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public abstract class ExpandableSupport<Source extends JComponent>
implements Expandable {
    private final Source source;
    private final Function<? super String, String> onShow;
    private final Function<? super String, String> onHide;
    private JBPopup popup;
    private String title;
    private String comment;

    public ExpandableSupport(@NotNull Source source, Function<? super String, String> onShow, Function<? super String, String> onHide) {
        if (source == null) {
            ExpandableSupport.$$$reportNull$$$0(0);
        }
        this.source = source;
        this.onShow = onShow != null ? onShow : Functions.identity();
        this.onHide = onHide != null ? onHide : Functions.identity();
        ((JComponent)source).putClientProperty(Expandable.class, this);
        ((JComponent)source).addAncestorListener(EventHandler.create(AncestorListener.class, this, "collapse"));
        ((Component)source).addComponentListener(EventHandler.create(ComponentListener.class, this, "collapse"));
    }

    @NotNull
    protected abstract Content prepare(@NotNull Source var1, @NotNull Function<? super String, String> var2);

    public final String getTitle() {
        return this.title;
    }

    public final void setTitle(String title) {
        this.title = title;
    }

    public final String getComment() {
        return this.comment;
    }

    public final void setComment(String comment) {
        this.comment = comment;
    }

    @Override
    public final boolean isExpanded() {
        return this.popup != null;
    }

    @Override
    public final void collapse() {
        if (this.popup != null) {
            this.popup.cancel();
        }
    }

    @Override
    public final void expand() {
        if (this.popup != null || !((Component)this.source).isEnabled()) {
            return;
        }
        Content content2 = this.prepare(this.source, this.onShow);
        JComponent component2 = content2.getContentComponent();
        Dimension size = component2.getPreferredSize();
        if (size.width - 50 < ((JComponent)this.source).getWidth()) {
            size.width = ((JComponent)this.source).getWidth();
        }
        if (size.height < 2 * ((JComponent)this.source).getHeight()) {
            size.height = 2 * ((JComponent)this.source).getHeight();
        }
        Point location2 = new Point(0, 0);
        SwingUtilities.convertPointToScreen(location2, this.source);
        Rectangle screen = ScreenUtil.getScreenRectangle(this.source);
        int bottom = screen.y - location2.y + screen.height;
        if (bottom < size.height) {
            int top = location2.y - screen.y + ((JComponent)this.source).getHeight();
            if (top < bottom) {
                size.height = bottom;
            } else {
                if (size.height > top) {
                    size.height = top;
                }
                location2.y -= size.height - ((JComponent)this.source).getHeight();
            }
        }
        component2.setPreferredSize(size);
        this.popup = JBPopupFactory.getInstance().createComponentPopupBuilder(component2, content2.getFocusableComponent()).setMayBeParent(true).setFocusable(true).setRequestFocus(true).setTitle(this.title).setAdText(this.comment).setLocateByContent(true).setCancelOnWindowDeactivation(false).setKeyboardActions(Collections.singletonList(Pair.create(event -> {
            this.collapse();
            Window window = ComponentUtil.getWindow(this.source);
            if (window != null) {
                window.dispatchEvent(new KeyEvent((Component)this.source, 401, System.currentTimeMillis(), 2, 10, '\r'));
            }
        }, KeyStroke.getKeyStroke(10, 2)))).setCancelCallback(() -> {
            try {
                content2.cancel(this.onHide);
                this.popup = null;
                return true;
            }
            catch (Exception ignore) {
                return false;
            }
        }).createPopup();
        this.popup.show(new RelativePoint(location2));
    }

    @NotNull
    public ExtendableTextComponent.Extension createCollapseExtension() {
        ExtendableTextComponent.Extension extension = ExtendableTextComponent.Extension.create(AllIcons.General.CollapseComponent, AllIcons.General.CollapseComponentHover, KeymapUtil.createTooltipText("Collapse", "CollapseExpandableComponent"), this::collapse);
        if (extension == null) {
            ExpandableSupport.$$$reportNull$$$0(1);
        }
        return extension;
    }

    @NotNull
    public ExtendableTextComponent.Extension createExpandExtension() {
        ExtendableTextComponent.Extension extension = ExtendableTextComponent.Extension.create(AllIcons.General.ExpandComponent, AllIcons.General.ExpandComponentHover, KeymapUtil.createTooltipText("Expand", "ExpandExpandableComponent"), this::expand);
        if (extension == null) {
            ExpandableSupport.$$$reportNull$$$0(2);
        }
        return extension;
    }

    @NotNull
    public static JLabel createLabel(final @NotNull ExtendableTextComponent.Extension extension) {
        if (extension == null) {
            ExpandableSupport.$$$reportNull$$$0(3);
        }
        return new JLabel(extension.getIcon(false)){
            {
                super(x0);
                this.setToolTipText(extension.getTooltip());
                this.setCursor(Cursor.getPredefinedCursor(12));
                this.addMouseListener(new MouseAdapter(){

                    @Override
                    public void mouseEntered(MouseEvent event) {
                        this.setIcon(extension.getIcon(true));
                    }

                    @Override
                    public void mouseExited(MouseEvent event) {
                        this.setIcon(extension.getIcon(false));
                    }

                    @Override
                    public void mouseClicked(MouseEvent event) {
                        Runnable action2 = extension.getActionOnClick();
                        if (action2 != null) {
                            action2.run();
                        }
                    }
                });
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ui/components/fields/ExpandableSupport";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extension";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ui/components/fields/ExpandableSupport";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createCollapseExtension";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createExpandExtension";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createLabel";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    protected static interface Content {
        @NotNull
        public JComponent getContentComponent();

        public JComponent getFocusableComponent();

        public void cancel(@NotNull Function<? super String, String> var1);
    }
}

