/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.components.fields.valueEditors;

import com.intellij.openapi.util.InvalidDataException;
import com.intellij.ui.components.fields.valueEditors.TextFieldValueEditor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.JTextField;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CommaSeparatedIntegersValueEditor
extends TextFieldValueEditor<List<Integer>> {
    private final int myMinValue;
    private final int myMaxValue;

    public CommaSeparatedIntegersValueEditor(@NotNull JTextField field, @Nullable String valueName, int minValue, int maxValue) {
        if (field == null) {
            CommaSeparatedIntegersValueEditor.$$$reportNull$$$0(0);
        }
        super(field, valueName, Collections.emptyList());
        this.myMinValue = minValue;
        this.myMaxValue = maxValue;
    }

    @Override
    @NotNull
    public List<Integer> parseValue(@Nullable String text2) throws InvalidDataException {
        if (text2 == null || text2.isEmpty()) {
            List<Integer> list2 = Collections.emptyList();
            if (list2 == null) {
                CommaSeparatedIntegersValueEditor.$$$reportNull$$$0(1);
            }
            return list2;
        }
        String[] chunks = text2.split("\\s*,\\s*");
        ArrayList<Integer> values2 = new ArrayList<Integer>(chunks.length);
        for (String chunk : chunks) {
            try {
                int value2 = Integer.parseInt(chunk);
                if (value2 < this.myMinValue || value2 > this.myMaxValue) {
                    throw new InvalidDataException("Value " + value2 + " is out of range " + this.myMinValue + ".." + this.myMaxValue);
                }
                values2.add(value2);
            }
            catch (NumberFormatException nfe) {
                throw new InvalidDataException("Value '" + chunk + "' is not an integer number");
            }
        }
        Collections.sort(values2);
        ArrayList<Integer> arrayList = values2;
        if (arrayList == null) {
            CommaSeparatedIntegersValueEditor.$$$reportNull$$$0(2);
        }
        return arrayList;
    }

    @Override
    public String valueToString(@NotNull List<Integer> valueList) {
        if (valueList == null) {
            CommaSeparatedIntegersValueEditor.$$$reportNull$$$0(3);
        }
        return CommaSeparatedIntegersValueEditor.intListToString(valueList);
    }

    @Override
    public boolean isValid(@NotNull List<Integer> value2) {
        if (value2 == null) {
            CommaSeparatedIntegersValueEditor.$$$reportNull$$$0(4);
        }
        return true;
    }

    public static String intListToString(@NotNull List<Integer> valueList) {
        if (valueList == null) {
            CommaSeparatedIntegersValueEditor.$$$reportNull$$$0(5);
        }
        StringBuilder sb = new StringBuilder();
        for (Integer value2 : valueList) {
            if (sb.length() != 0) {
                sb.append(", ");
            }
            sb.append(value2);
        }
        return sb.toString();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "field";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ui/components/fields/valueEditors/CommaSeparatedIntegersValueEditor";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "valueList";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ui/components/fields/valueEditors/CommaSeparatedIntegersValueEditor";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "parseValue";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "valueToString";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isValid";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "intListToString";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

