/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.components.labels;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.ui.components.labels.LinkLabel;
import com.intellij.ui.components.labels.LinkListener;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.InputEvent;
import javax.swing.Icon;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ActionLink
extends LinkLabel<Object>
implements DataProvider {
    private static final EmptyIcon ICON = JBUI.scale(EmptyIcon.create(0, 12));
    private final AnAction myAction;
    private InputEvent myEvent;
    private Color myVisitedColor;
    private Color myActiveColor;
    private Color myNormalColor;

    public ActionLink(@Nls(capitalization=Nls.Capitalization.Title) String text2, @NotNull AnAction action2) {
        if (action2 == null) {
            ActionLink.$$$reportNull$$$0(0);
        }
        this(text2, (Icon)ICON, action2);
    }

    public ActionLink(@Nls(capitalization=Nls.Capitalization.Title) String text2, Icon icon2, @NotNull AnAction action2) {
        if (action2 == null) {
            ActionLink.$$$reportNull$$$0(1);
        }
        this(text2, icon2, action2, null, "unknown");
    }

    public ActionLink(@Nls(capitalization=Nls.Capitalization.Title) String text2, Icon icon2, @NotNull AnAction action2, final @Nullable Runnable onDone, final @NotNull String place) {
        if (action2 == null) {
            ActionLink.$$$reportNull$$$0(2);
        }
        if (place == null) {
            ActionLink.$$$reportNull$$$0(3);
        }
        super(text2, icon2);
        this.setListener(new LinkListener<Object>(){

            @Override
            public void linkSelected(LinkLabel aSource, Object aLinkData) {
                ActionUtil.invokeAction(ActionLink.this.myAction, ActionLink.this, place, ActionLink.this.myEvent, onDone);
            }
        }, null);
        this.myAction = action2;
    }

    @Override
    public void doClick(InputEvent e) {
        this.myEvent = e;
        super.doClick();
    }

    @Override
    protected Color getVisited() {
        return this.myVisitedColor == null ? super.getVisited() : this.myVisitedColor;
    }

    public Color getActiveColor() {
        return this.myActiveColor == null ? super.getActive() : this.myActiveColor;
    }

    @Override
    protected Color getTextColor() {
        return this.myUnderline ? this.getActiveColor() : this.getNormal();
    }

    @Override
    protected Color getNormal() {
        return this.myNormalColor == null ? super.getNormal() : this.myNormalColor;
    }

    public void setVisitedColor(Color visitedColor) {
        this.myVisitedColor = visitedColor;
    }

    public void setActiveColor(Color activeColor) {
        this.myActiveColor = activeColor;
    }

    public void setNormalColor(Color normalColor) {
        this.myNormalColor = normalColor;
    }

    @Override
    public Object getData(@NotNull @NonNls String dataId) {
        if (dataId == null) {
            ActionLink.$$$reportNull$$$0(4);
        }
        if (PlatformDataKeys.DOMINANT_HINT_AREA_RECTANGLE.is(dataId)) {
            Point p = SwingUtilities.getRoot(this).getLocationOnScreen();
            return new Rectangle(p.x, p.y + this.getHeight(), 0, 0);
        }
        if (PlatformDataKeys.CONTEXT_MENU_POINT.is(dataId)) {
            return SwingUtilities.convertPoint(this, 0, this.getHeight(), UIUtil.getRootPane(this));
        }
        return this.myAction instanceof DataProvider ? ((DataProvider)((Object)this.myAction)).getData(dataId) : null;
    }

    public AnAction getAction() {
        return this.myAction;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataId";
                break;
            }
        }
        objectArray2[1] = "com/intellij/ui/components/labels/ActionLink";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "getData";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

