/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.components.labels;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.ui.popup.IPopupChooserBuilder;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.components.labels.LinkLabel;
import com.intellij.ui.popup.util.PopupState;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.Consumer;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.List;
import java.util.function.Function;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.plaf.metal.MetalLabelUI;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DropDownLink<T>
extends LinkLabel<Object> {
    private final PopupState myPopupState;
    private T chosenItem;

    public DropDownLink(@NotNull T value2, @NotNull Runnable clickAction) {
        if (value2 == null) {
            DropDownLink.$$$reportNull$$$0(0);
        }
        if (clickAction == null) {
            DropDownLink.$$$reportNull$$$0(1);
        }
        super(value2.toString(), AllIcons.General.LinkDropTriangle, (s, d) -> clickAction.run());
        this.myPopupState = new PopupState();
        this.chosenItem = value2;
        this.init();
    }

    public DropDownLink(@NotNull T value2, @NotNull Function<? super DropDownLink, ? extends JBPopup> popupBuilder) {
        if (value2 == null) {
            DropDownLink.$$$reportNull$$$0(2);
        }
        if (popupBuilder == null) {
            DropDownLink.$$$reportNull$$$0(3);
        }
        super(value2.toString(), AllIcons.General.LinkDropTriangle);
        this.myPopupState = new PopupState();
        this.chosenItem = value2;
        this.setListener((linkLabel, d) -> {
            if (this.myPopupState.isRecentlyHidden()) {
                return;
            }
            JBPopup popup2 = (JBPopup)popupBuilder.apply((DropDownLink)linkLabel);
            Point showPoint = new Point(0, this.getHeight() + JBUIScale.scale(4));
            popup2.addListener(this.myPopupState);
            popup2.show(new RelativePoint(this, showPoint));
        }, null);
        this.init();
    }

    public DropDownLink(@NotNull T initialItem, @NotNull List<T> items, @Nullable Consumer<? super T> itemChosenAction, boolean updateLabel) {
        if (initialItem == null) {
            DropDownLink.$$$reportNull$$$0(4);
        }
        if (items == null) {
            DropDownLink.$$$reportNull$$$0(5);
        }
        this(initialItem, (? super DropDownLink linkLabel) -> {
            IPopupChooserBuilder<Object> popupBuilder = JBPopupFactory.getInstance().createPopupChooserBuilder(items).setRenderer(new LinkCellRenderer((JComponent)linkLabel)).setItemChosenCallback(t -> {
                linkLabel.chosenItem = t;
                if (updateLabel) {
                    linkLabel.setText(t.toString());
                }
                if (itemChosenAction != null) {
                    itemChosenAction.consume(t);
                }
            });
            return popupBuilder.createPopup();
        });
    }

    private void init() {
        this.setIconTextGap(JBUIScale.scale(1));
        this.setHorizontalAlignment(10);
        this.setHorizontalTextPosition(10);
        this.setUI(new MetalLabelUI(){

            @Override
            protected String layoutCL(JLabel label2, FontMetrics fontMetrics, String text2, Icon icon2, Rectangle viewR, Rectangle iconR, Rectangle textR) {
                String result2 = super.layoutCL(label2, fontMetrics, text2, icon2, viewR, iconR, textR);
                iconR.y += JBUIScale.scale(1);
                return result2;
            }
        });
    }

    public T getChosenItem() {
        return this.chosenItem;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "value";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "clickAction";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[0] = "popupBuilder";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[0] = "initialItem";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[0] = "items";
                break;
            }
        }
        objectArray[1] = "com/intellij/ui/components/labels/DropDownLink";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class LinkCellRenderer<T>
    extends JLabel
    implements ListCellRenderer<T> {
        private final JComponent owner;

        private LinkCellRenderer(JComponent owner) {
            this.owner = owner;
            this.setBorder(JBUI.Borders.empty(0, 5, 0, 10));
        }

        @Override
        public Dimension getPreferredSize() {
            return this.recomputeSize(super.getPreferredSize());
        }

        @Override
        public Dimension getMinimumSize() {
            return this.recomputeSize(super.getMinimumSize());
        }

        private Dimension recomputeSize(@NotNull Dimension size) {
            if (size == null) {
                LinkCellRenderer.$$$reportNull$$$0(0);
            }
            size.height = Math.max(size.height, JBUIScale.scale(22));
            size.width = Math.max(size.width, this.owner.getPreferredSize().width);
            return size;
        }

        @Override
        public Component getListCellRendererComponent(JList<? extends T> list2, T value2, int index, boolean isSelected, boolean cellHasFocus) {
            this.setText(value2.toString());
            this.setEnabled(list2.isEnabled());
            this.setOpaque(true);
            this.setBackground(isSelected ? list2.getSelectionBackground() : UIManager.getColor("Label.background"));
            this.setForeground(isSelected ? list2.getSelectionForeground() : list2.getForeground());
            return this;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "size", "com/intellij/ui/components/labels/DropDownLink$LinkCellRenderer", "recomputeSize"));
        }
    }
}

