/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.components.panels;

import com.intellij.util.ui.JBInsets;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager2;
import java.util.ArrayList;

public final class HorizontalLayout
implements LayoutManager2 {
    public static final String LEFT = "LEFT";
    public static final String RIGHT = "RIGHT";
    public static final String CENTER = "CENTER";
    private final ArrayList<Component> myLeft = new ArrayList();
    private final ArrayList<Component> myRight = new ArrayList();
    private final ArrayList<Component> myCenter = new ArrayList();
    private final int myAlignment;
    private final int myGap;

    public HorizontalLayout(int gap) {
        this.myGap = gap;
        this.myAlignment = -1;
    }

    public HorizontalLayout(int gap, int alignment) {
        this.myGap = gap;
        switch (alignment) {
            case 0: 
            case 1: 
            case 3: {
                this.myAlignment = alignment;
                break;
            }
            default: {
                throw new IllegalArgumentException("unsupported alignment: " + alignment);
            }
        }
    }

    @Override
    public void addLayoutComponent(Component component2, Object constraints) {
        if (constraints != null && !(constraints instanceof String)) {
            throw new IllegalArgumentException("unsupported constraints: " + constraints);
        }
        this.addLayoutComponent((String)constraints, component2);
    }

    @Override
    public Dimension maximumLayoutSize(Container target2) {
        return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    @Override
    public float getLayoutAlignmentX(Container target2) {
        return 0.5f;
    }

    @Override
    public float getLayoutAlignmentY(Container target2) {
        return 0.5f;
    }

    @Override
    public void invalidateLayout(Container target2) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addLayoutComponent(String name, Component component2) {
        Object object = component2.getTreeLock();
        synchronized (object) {
            if (name == null || LEFT.equalsIgnoreCase(name)) {
                this.myLeft.add(component2);
            } else if (CENTER.equalsIgnoreCase(name)) {
                this.myCenter.add(component2);
            } else if (RIGHT.equalsIgnoreCase(name)) {
                this.myRight.add(component2);
            } else {
                throw new IllegalArgumentException("unsupported name: " + name);
            }
        }
    }

    @Override
    public void removeLayoutComponent(Component component2) {
        this.myLeft.remove(component2);
        this.myRight.remove(component2);
        this.myCenter.remove(component2);
    }

    @Override
    public Dimension preferredLayoutSize(Container container2) {
        return this.getPreferredSize(container2, true);
    }

    @Override
    public Dimension minimumLayoutSize(Container container2) {
        return this.getPreferredSize(container2, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void layoutContainer(Container container2) {
        Object object = container2.getTreeLock();
        synchronized (object) {
            Dimension left = this.getPreferredSize(this.myLeft);
            Dimension right = this.getPreferredSize(this.myRight);
            Dimension center = this.getPreferredSize(this.myCenter);
            Insets insets = container2.getInsets();
            int width = container2.getWidth() - insets.left - insets.right;
            int height = container2.getHeight() - insets.top - insets.bottom;
            int leftX = 0;
            if (left != null) {
                leftX = this.myGap + this.layout(this.myLeft, 0, height, insets);
            }
            int rightX = width;
            if (right != null) {
                rightX -= right.width;
            }
            if (rightX < leftX) {
                rightX = leftX;
            }
            if (center != null) {
                int centerRightX;
                int centerX = (width - center.width) / 2;
                if (centerX > leftX && (centerRightX = centerX + center.width + this.myGap + this.myGap) > rightX) {
                    centerX = rightX - center.width - this.myGap - this.myGap;
                }
                if (centerX < leftX) {
                    centerX = leftX;
                }
                if (rightX < (centerX = this.myGap + this.layout(this.myCenter, centerX, height, insets))) {
                    rightX = centerX;
                }
            }
            if (right != null) {
                this.layout(this.myRight, rightX, height, insets);
            }
        }
    }

    private int layout(ArrayList<Component> list2, int x, int height, Insets insets) {
        for (Component component2 : list2) {
            if (!component2.isVisible()) continue;
            Dimension size = component2.getPreferredSize();
            int y = 0;
            if (this.myAlignment == -1) {
                size.height = height;
            } else if (this.myAlignment != 1) {
                y = height - size.height;
                if (this.myAlignment == 0) {
                    y /= 2;
                }
            }
            component2.setBounds(x + insets.left, y + insets.top, size.width, size.height);
            x += size.width + this.myGap;
        }
        return x;
    }

    private static Dimension join(Dimension result2, int gap, Dimension size) {
        if (size == null) {
            return result2;
        }
        if (result2 == null) {
            return new Dimension(size);
        }
        result2.width += gap + size.width;
        if (result2.height < size.height) {
            result2.height = size.height;
        }
        return result2;
    }

    private Dimension getPreferredSize(ArrayList<Component> list2) {
        Dimension result2 = null;
        for (Component component2 : list2) {
            if (!component2.isVisible()) continue;
            result2 = HorizontalLayout.join(result2, this.myGap, component2.getPreferredSize());
        }
        return result2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Dimension getPreferredSize(Container container2, boolean aligned) {
        Object object = container2.getTreeLock();
        synchronized (object) {
            Dimension left = this.getPreferredSize(this.myLeft);
            Dimension right = this.getPreferredSize(this.myRight);
            Dimension center = this.getPreferredSize(this.myCenter);
            Dimension result2 = HorizontalLayout.join(HorizontalLayout.join(HorizontalLayout.join(null, this.myGap + this.myGap, left), this.myGap + this.myGap, center), this.myGap + this.myGap, right);
            if (result2 == null) {
                result2 = new Dimension();
            } else if (aligned && center != null) {
                int leftWidth = left == null ? 0 : left.width;
                int rightWidth = right == null ? 0 : right.width;
                result2.width += Math.abs(leftWidth - rightWidth);
            }
            JBInsets.addTo(result2, container2.getInsets());
            return result2;
        }
    }
}

