/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.components.panels;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.ui.JBInsets;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager2;
import java.awt.Rectangle;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;

public class StatelessCardLayout
implements LayoutManager2 {
    public static final StatelessCardLayout INSTANCE = new StatelessCardLayout();

    @NotNull
    public static JPanel wrap(Component component2) {
        JPanel panel2 = new JPanel(INSTANCE);
        if (component2 != null) {
            panel2.add(component2);
        }
        panel2.setOpaque(false);
        JPanel jPanel = panel2;
        if (jPanel == null) {
            StatelessCardLayout.$$$reportNull$$$0(0);
        }
        return jPanel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void show(Component visible) {
        Container container2;
        if (visible != null && !visible.isVisible() && (container2 = visible.getParent()) != null) {
            Object object = container2.getTreeLock();
            synchronized (object) {
                for (Component component2 : container2.getComponents()) {
                    component2.setVisible(component2 == visible);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Component getComponent(Container container2) {
        Object object = container2.getTreeLock();
        synchronized (object) {
            for (Component component2 : container2.getComponents()) {
                if (!component2.isVisible()) continue;
                return component2;
            }
        }
        return null;
    }

    private static Dimension getSize(Container container2, Dimension size) {
        Insets insets = container2.getInsets();
        if (insets != null) {
            int height;
            int width = size.width + insets.left + insets.right;
            if (size.width < width) {
                size.width = width;
            }
            if (size.height < (height = size.height + insets.top + insets.bottom)) {
                size.height = height;
            }
        }
        return size;
    }

    @Override
    public void addLayoutComponent(String name, Component component2) {
        this.addLayoutComponent(component2, name);
    }

    @Override
    public void addLayoutComponent(Component component2, Object constraints) {
        if (constraints != null) {
            throw new IllegalArgumentException("unsupported constraints: " + constraints);
        }
        Container container2 = component2.getParent();
        component2.setVisible(container2 != null && 0 < container2.getComponentCount());
    }

    @Override
    public void removeLayoutComponent(Component component2) {
    }

    @Override
    public void invalidateLayout(Container container2) {
    }

    @Override
    public float getLayoutAlignmentX(Container container2) {
        Component component2 = StatelessCardLayout.getComponent(container2);
        return component2 != null ? component2.getAlignmentX() : 0.5f;
    }

    @Override
    public float getLayoutAlignmentY(Container container2) {
        Component component2 = StatelessCardLayout.getComponent(container2);
        return component2 != null ? component2.getAlignmentY() : 0.5f;
    }

    @Override
    public Dimension preferredLayoutSize(Container container2) {
        Component component2 = StatelessCardLayout.getComponent(container2);
        return StatelessCardLayout.getSize(container2, component2 != null ? component2.getPreferredSize() : new Dimension());
    }

    @Override
    public Dimension minimumLayoutSize(Container container2) {
        Component component2 = StatelessCardLayout.getComponent(container2);
        return StatelessCardLayout.getSize(container2, component2 != null ? component2.getMinimumSize() : new Dimension());
    }

    @Override
    public Dimension maximumLayoutSize(Container container2) {
        Component component2 = StatelessCardLayout.getComponent(container2);
        return StatelessCardLayout.getSize(container2, component2 != null ? component2.getMaximumSize() : new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void layoutContainer(Container container2) {
        Object object = container2.getTreeLock();
        synchronized (object) {
            boolean logged = false;
            boolean updated = false;
            for (Component component2 : container2.getComponents()) {
                if (!component2.isVisible()) continue;
                if (!updated) {
                    updated = true;
                    Dimension min = component2.getMinimumSize();
                    Dimension max = component2.getMaximumSize();
                    if (max.height < min.height) {
                        max.height = min.height;
                    }
                    Rectangle bounds2 = new Rectangle(container2.getWidth(), container2.getHeight());
                    JBInsets.removeFrom(bounds2, container2.getInsets());
                    if (max.width < min.width) {
                        max.width = min.width;
                    }
                    if (bounds2.width > max.width) {
                        bounds2.x += (int)(0.5f + (float)(bounds2.width - max.width) * component2.getAlignmentX());
                        bounds2.width = max.width;
                    } else if (bounds2.width < min.width) {
                        bounds2.x += (int)(0.5f + (float)(bounds2.width - min.width) * component2.getAlignmentX());
                        bounds2.width = min.width;
                    }
                    if (max.height < min.height) {
                        max.height = min.height;
                    }
                    if (bounds2.height > max.height) {
                        bounds2.y += (int)(0.5f + (float)(bounds2.height - max.height) * component2.getAlignmentY());
                        bounds2.height = max.height;
                    } else if (bounds2.height < min.height) {
                        bounds2.y += (int)(0.5f + (float)(bounds2.height - min.height) * component2.getAlignmentY());
                        bounds2.height = min.height;
                    }
                    component2.setBounds(bounds2);
                    continue;
                }
                component2.setVisible(false);
                if (logged) continue;
                logged = true;
                Logger.getInstance(StatelessCardLayout.class).warn("too many visible components");
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/components/panels/StatelessCardLayout", "wrap"));
    }
}

