/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.content.impl;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.util.AtomicNotNullLazyValue;
import com.intellij.openapi.util.BusyObject;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.ui.LayeredIcon;
import com.intellij.ui.content.AlertIcon;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import com.intellij.util.IconUtil;
import java.awt.Component;
import java.awt.Container;
import java.awt.Rectangle;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ContentImpl
extends UserDataHolderBase
implements Content {
    private String myDisplayName;
    private String myDescription;
    private JComponent myComponent;
    private Icon myIcon;
    private final PropertyChangeSupport myChangeSupport = new PropertyChangeSupport(this);
    private ContentManager myManager;
    private boolean myIsLocked;
    private boolean myPinnable;
    private Icon myLayeredIcon = new LayeredIcon(2);
    private Disposable myDisposer;
    private boolean myShouldDisposeContent = true;
    private String myTabName;
    private String myToolwindowTitle;
    private boolean myCloseable = true;
    private ActionGroup myActions;
    private String myPlace;
    private AlertIcon myAlertIcon;
    private JComponent myActionsContextComponent;
    private JComponent mySearchComponent;
    private Computable<? extends JComponent> myFocusRequest;
    private BusyObject myBusyObject;
    private String mySeparator;
    private Icon myPopupIcon;
    private long myExecutionId;
    private String myHelpId;
    private static final NotNullLazyValue<Icon> emptyPinIcon = AtomicNotNullLazyValue.createValue(() -> {
        Icon icon2 = AllIcons.Nodes.TabPin;
        int width = icon2.getIconWidth();
        return IconUtil.cropIcon((Icon)icon2, (Rectangle)new Rectangle(width / 2, 0, width - width / 2, icon2.getIconHeight()));
    });

    public ContentImpl(JComponent component2, @Nullable @Nls(capitalization=Nls.Capitalization.Title) String displayName, boolean isPinnable) {
        this.myComponent = component2;
        this.myDisplayName = displayName;
        this.myPinnable = isPinnable;
    }

    @Override
    @NotNull
    public JComponent getComponent() {
        JComponent jComponent = this.myComponent;
        if (jComponent == null) {
            ContentImpl.$$$reportNull$$$0(0);
        }
        return jComponent;
    }

    @Override
    public void setComponent(JComponent component2) {
        JComponent oldComponent = this.myComponent;
        this.myComponent = component2;
        this.myChangeSupport.firePropertyChange("component", oldComponent, this.myComponent);
    }

    @Override
    public JComponent getPreferredFocusableComponent() {
        Container traversalRoot;
        if (this.myFocusRequest != null) {
            return this.myFocusRequest.compute();
        }
        if (this.myComponent == null) {
            return null;
        }
        Container container2 = traversalRoot = this.myComponent.isFocusCycleRoot() ? this.myComponent : this.myComponent.getFocusCycleRootAncestor();
        if (traversalRoot == null) {
            return null;
        }
        Component component2 = traversalRoot.getFocusTraversalPolicy().getDefaultComponent(this.myComponent);
        return component2 instanceof JComponent ? (JComponent)component2 : null;
    }

    @Override
    public void setPreferredFocusableComponent(JComponent c) {
        this.setPreferredFocusedComponent(() -> c);
    }

    @Override
    public void setPreferredFocusedComponent(Computable<? extends JComponent> computable) {
        this.myFocusRequest = computable;
    }

    @Override
    public void setIcon(Icon icon2) {
        Icon oldValue = this.getIcon();
        this.myIcon = icon2;
        this.myLayeredIcon = LayeredIcon.create((Icon)this.myIcon, (Icon)AllIcons.Nodes.TabPin);
        this.myChangeSupport.firePropertyChange("icon", oldValue, this.getIcon());
    }

    @Override
    public Icon getIcon() {
        if (this.myIsLocked) {
            return this.myIcon == null ? emptyPinIcon.getValue() : this.myLayeredIcon;
        }
        return this.myIcon;
    }

    @Override
    public void setDisplayName(String displayName) {
        String oldValue = this.myDisplayName;
        this.myDisplayName = displayName;
        this.myChangeSupport.firePropertyChange("displayName", oldValue, this.myDisplayName);
    }

    @Override
    public String getDisplayName() {
        return this.myDisplayName;
    }

    @Override
    public void setTabName(String tabName) {
        this.myTabName = tabName;
    }

    @Override
    public String getTabName() {
        if (this.myTabName != null) {
            return this.myTabName;
        }
        return this.myDisplayName;
    }

    @Override
    public void setToolwindowTitle(String toolwindowTitle) {
        this.myToolwindowTitle = toolwindowTitle;
    }

    @Override
    public String getToolwindowTitle() {
        return this.myToolwindowTitle == null ? this.myDisplayName : this.myToolwindowTitle;
    }

    @Override
    @Nullable
    public Disposable getDisposer() {
        return this.myDisposer;
    }

    @Override
    public void setDisposer(@NotNull Disposable disposer) {
        if (disposer == null) {
            ContentImpl.$$$reportNull$$$0(1);
        }
        this.myDisposer = disposer;
    }

    @Override
    public void setShouldDisposeContent(boolean value2) {
        this.myShouldDisposeContent = value2;
    }

    @Override
    public String getDescription() {
        return this.myDescription;
    }

    @Override
    public void setDescription(String description) {
        String oldValue = this.myDescription;
        this.myDescription = description;
        this.myChangeSupport.firePropertyChange("description", oldValue, this.myDescription);
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.myChangeSupport.addPropertyChangeListener(l);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.myChangeSupport.removePropertyChangeListener(l);
    }

    public void setManager(@Nullable ContentManager manager) {
        this.myManager = manager;
    }

    @Override
    public ContentManager getManager() {
        return this.myManager;
    }

    @Override
    public boolean isSelected() {
        return this.myManager != null && this.myManager.isSelected(this);
    }

    @Override
    public final void release() {
        Disposer.dispose(this);
    }

    @Override
    public boolean isValid() {
        return this.myManager != null;
    }

    @Override
    public boolean isPinned() {
        return this.myIsLocked;
    }

    @Override
    public void setPinned(boolean locked) {
        if (this.isPinnable()) {
            Icon oldIcon = this.getIcon();
            this.myIsLocked = locked;
            Icon newIcon = this.getIcon();
            this.myChangeSupport.firePropertyChange("icon", oldIcon, newIcon);
        }
    }

    @Override
    public boolean isPinnable() {
        return this.myPinnable;
    }

    @Override
    public void setPinnable(boolean pinnable) {
        this.myPinnable = pinnable;
    }

    @Override
    public boolean isCloseable() {
        return this.myCloseable;
    }

    @Override
    public void setCloseable(boolean closeable) {
        if (closeable == this.myCloseable) {
            return;
        }
        boolean old = this.myCloseable;
        this.myCloseable = closeable;
        this.myChangeSupport.firePropertyChange("isClosable", old, closeable);
    }

    @Override
    public void setActions(ActionGroup actions, String place, @Nullable JComponent contextComponent) {
        ActionGroup oldActions = this.myActions;
        this.myActions = actions;
        this.myPlace = place;
        this.myActionsContextComponent = contextComponent;
        this.myChangeSupport.firePropertyChange("actions", oldActions, this.myActions);
    }

    @Override
    public JComponent getActionsContextComponent() {
        return this.myActionsContextComponent;
    }

    @Override
    public ActionGroup getActions() {
        return this.myActions;
    }

    @Override
    public String getPlace() {
        return this.myPlace;
    }

    @NonNls
    public String toString() {
        StringBuilder sb = new StringBuilder("Content name=").append(this.myDisplayName);
        if (this.myIsLocked) {
            sb.append(", pinned");
        }
        if (this.myExecutionId != 0L) {
            sb.append(", executionId=").append(this.myExecutionId);
        }
        return sb.toString();
    }

    @Override
    public void dispose() {
        if (this.myShouldDisposeContent && this.myComponent instanceof Disposable) {
            Disposer.dispose((Disposable)((Object)this.myComponent));
        }
        if (this.myDisposer != null) {
            Disposer.dispose(this.myDisposer);
            this.myDisposer = null;
        }
        this.myFocusRequest = null;
        this.clearUserData();
    }

    @Override
    @Nullable
    public AlertIcon getAlertIcon() {
        return this.myAlertIcon;
    }

    @Override
    public void setAlertIcon(@Nullable AlertIcon icon2) {
        this.myAlertIcon = icon2;
    }

    @Override
    public void fireAlert() {
        this.myChangeSupport.firePropertyChange("alerting", null, (Object)true);
    }

    @Override
    public void setBusyObject(BusyObject object) {
        this.myBusyObject = object;
    }

    @Override
    public String getSeparator() {
        return this.mySeparator;
    }

    @Override
    public void setSeparator(String separator) {
        this.mySeparator = separator;
    }

    @Override
    public void setPopupIcon(Icon icon2) {
        this.myPopupIcon = icon2;
    }

    @Override
    public Icon getPopupIcon() {
        return this.myPopupIcon != null ? this.myPopupIcon : this.getIcon();
    }

    @Override
    public BusyObject getBusyObject() {
        return this.myBusyObject;
    }

    @Override
    public void setSearchComponent(@Nullable JComponent comp) {
        this.mySearchComponent = comp;
    }

    @Override
    public JComponent getSearchComponent() {
        return this.mySearchComponent;
    }

    @Override
    public void setExecutionId(long executionId) {
        this.myExecutionId = executionId;
    }

    @Override
    public long getExecutionId() {
        return this.myExecutionId;
    }

    @Override
    public void setHelpId(String helpId) {
        this.myHelpId = helpId;
    }

    @Override
    @Nullable
    public String getHelpId() {
        return this.myHelpId;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ui/content/impl/ContentImpl";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disposer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ui/content/impl/ContentImpl";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "setDisposer";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

