/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.content.impl;

import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.ui.content.ContentManager;
import com.intellij.ui.content.TabbedContent;
import com.intellij.ui.content.impl.ContentImpl;
import com.intellij.util.ContentUtilEx;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Container;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TabbedContentImpl
extends ContentImpl
implements TabbedContent {
    private final List<Pair<String, JComponent>> myTabs;
    @NotNull
    private String myPrefix;

    public TabbedContentImpl(JComponent component2, @NotNull String displayName, boolean isPinnable, @NotNull String titlePrefix) {
        if (displayName == null) {
            TabbedContentImpl.$$$reportNull$$$0(0);
        }
        if (titlePrefix == null) {
            TabbedContentImpl.$$$reportNull$$$0(1);
        }
        super(component2, displayName, isPinnable);
        this.myTabs = new ArrayList<Pair<String, JComponent>>();
        this.myPrefix = titlePrefix;
        this.addContent(component2, displayName, true);
    }

    @Nullable
    private Pair<String, JComponent> findTab(@NotNull JComponent c) {
        if (c == null) {
            TabbedContentImpl.$$$reportNull$$$0(2);
        }
        for (Pair<String, JComponent> tab : this.myTabs) {
            if (tab.second != c) continue;
            return tab;
        }
        return null;
    }

    @Nullable
    private Pair<String, JComponent> selectedTab() {
        return this.findTab(this.getComponent());
    }

    private int indexOf(@NotNull JComponent c) {
        if (c == null) {
            TabbedContentImpl.$$$reportNull$$$0(3);
        }
        for (int i = 0; i < this.myTabs.size(); ++i) {
            if (this.myTabs.get((int)i).second != c) continue;
            return i;
        }
        return -1;
    }

    private void selectTab(@NotNull Pair<String, JComponent> tab) {
        if (tab == null) {
            TabbedContentImpl.$$$reportNull$$$0(4);
        }
        this.setDisplayName(this.getDisplayName((JComponent)tab.second, true));
        this.setComponent((JComponent)tab.second);
    }

    @Nls
    @NotNull
    private String getDisplayName(@NotNull JComponent c, boolean withPrefix) {
        String displayName;
        if (c == null) {
            TabbedContentImpl.$$$reportNull$$$0(5);
        }
        if ((displayName = ContentUtilEx.getDisplayName(c, withPrefix)) != null) {
            String string = displayName;
            if (string == null) {
                TabbedContentImpl.$$$reportNull$$$0(6);
            }
            return string;
        }
        String tabName = (String)Objects.requireNonNull(this.findTab((JComponent)c)).first;
        if (withPrefix) {
            String string = ContentUtilEx.getFullName(this.myPrefix, tabName);
            if (string == null) {
                TabbedContentImpl.$$$reportNull$$$0(7);
            }
            return string;
        }
        String string = tabName;
        if (string == null) {
            TabbedContentImpl.$$$reportNull$$$0(8);
        }
        return string;
    }

    @Override
    public void addContent(@NotNull JComponent content2, @NotNull String name, boolean selectTab) {
        Pair<String, JComponent> tab;
        if (content2 == null) {
            TabbedContentImpl.$$$reportNull$$$0(9);
        }
        if (name == null) {
            TabbedContentImpl.$$$reportNull$$$0(10);
        }
        if (!this.myTabs.contains(tab = Pair.create(name, content2))) {
            this.myTabs.add(tab);
        }
        if (selectTab && this.getComponent() != content2) {
            this.selectTab(tab);
        }
    }

    @Override
    public void setComponent(JComponent component2) {
        Container parent;
        JComponent currentComponent = this.getComponent();
        Container container2 = parent = currentComponent == null ? null : currentComponent.getParent();
        if (parent != null) {
            parent.remove(currentComponent);
            parent.add(component2);
        }
        super.setComponent(component2);
    }

    @Override
    public void removeContent(@NotNull JComponent content2) {
        int index;
        if (content2 == null) {
            TabbedContentImpl.$$$reportNull$$$0(11);
        }
        if ((index = this.indexOf(content2)) != -1) {
            this.myTabs.remove(index);
            int n = index = index > 0 ? index - 1 : index;
            if (index < this.myTabs.size()) {
                this.selectContent(index);
            }
        }
    }

    @Override
    @Nls
    public String getDisplayName() {
        return this.getDisplayName(this.getComponent(), true);
    }

    @Override
    public void selectContent(int index) {
        this.selectTab(this.myTabs.get(index));
    }

    @Override
    public int getSelectedIndex() {
        return this.indexOf(this.getComponent());
    }

    public boolean findAndSelectContent(@NotNull JComponent contentComponent) {
        Pair<String, JComponent> tab;
        if (contentComponent == null) {
            TabbedContentImpl.$$$reportNull$$$0(12);
        }
        if ((tab = this.findTab(contentComponent)) != null) {
            this.selectTab(tab);
            return true;
        }
        return false;
    }

    @Override
    @NonNls
    public String getTabName() {
        return ContentUtilEx.getFullName(this.myPrefix, (String)Objects.requireNonNull(this.selectedTab()).first);
    }

    @Override
    @NotNull
    public List<Pair<String, JComponent>> getTabs() {
        List<Pair<String, JComponent>> list2 = ContainerUtil.map2List(this.myTabs, pair -> Pair.create(this.getDisplayName((JComponent)pair.second, false), pair.second));
        if (list2 == null) {
            TabbedContentImpl.$$$reportNull$$$0(13);
        }
        return list2;
    }

    @Override
    public String getTitlePrefix() {
        return this.myPrefix;
    }

    @Override
    public void setTitlePrefix(String titlePrefix) {
        this.myPrefix = titlePrefix;
    }

    @Override
    public void split() {
        ArrayList<Pair<String, JComponent>> copy2 = new ArrayList<Pair<String, JComponent>>(this.myTabs);
        int selectedTab = ContentUtilEx.getSelectedTab(this);
        ContentManager manager = Objects.requireNonNull(this.getManager());
        String prefix = this.getTitlePrefix();
        manager.removeContent(this, false);
        ContentUtilEx.setSplitMode(prefix, true);
        for (int i = 0; i < copy2.size(); ++i) {
            boolean select = i == selectedTab;
            JComponent component2 = (JComponent)((Pair)copy2.get((int)i)).second;
            String tabName = (String)((Pair)copy2.get((int)i)).first;
            ContentUtilEx.addTabbedContent(manager, component2, prefix, tabName, select);
        }
        Disposer.dispose(this);
    }

    public boolean updateName(@NotNull JComponent component2) {
        if (component2 == null) {
            TabbedContentImpl.$$$reportNull$$$0(14);
        }
        if (this.findTab(component2) == null) {
            return false;
        }
        if (this.getComponent() == component2) {
            this.setDisplayName(this.getDisplayName(component2, true));
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "displayName";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "titlePrefix";
                break;
            }
            case 2: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "c";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tab";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ui/content/impl/TabbedContentImpl";
                break;
            }
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contentComponent";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ui/content/impl/TabbedContentImpl";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getTabs";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "findTab";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "indexOf";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "selectTab";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getDisplayName";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 13: {
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "addContent";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "removeContent";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "findAndSelectContent";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "updateName";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

