/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.debugger;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.wm.ex.WindowManagerEx;
import com.intellij.ui.JBColor;
import com.intellij.ui.debugger.UiDebuggerExtension;
import com.intellij.ui.tabs.JBTabs;
import com.intellij.ui.tabs.JBTabsFactory;
import com.intellij.ui.tabs.TabInfo;
import com.intellij.ui.tabs.UiDecorator;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jetbrains.annotations.NotNull;

public class UiDebugger
extends JPanel
implements Disposable {
    private final DialogWrapper myDialog;
    private final JBTabs myTabs;
    private final List<UiDebuggerExtension> myExtensions;

    public UiDebugger() {
        Disposer.register(Disposer.get("ui"), this);
        this.myTabs = JBTabsFactory.createTabs(null, this);
        this.myTabs.getPresentation().setInnerInsets(new Insets(4, 0, 0, 0)).setPaintBorder(1, 0, 0, 0).setActiveTabFillIn(JBColor.GRAY).setUiDecorator(new UiDecorator(){

            @Override
            @NotNull
            public UiDecorator.UiDecoration getDecoration() {
                return new UiDecorator.UiDecoration(null, JBUI.insets(4));
            }
        });
        this.myExtensions = UiDebuggerExtension.EP_NAME.getExtensionList();
        this.addToUi(this.myExtensions);
        this.myDialog = new DialogWrapper(null, true){
            {
                this.init();
            }

            @Override
            protected JComponent createCenterPanel() {
                Disposer.register(this.getDisposable(), UiDebugger.this);
                return UiDebugger.this.myTabs.getComponent();
            }

            @Override
            public JComponent getPreferredFocusedComponent() {
                return UiDebugger.this.myTabs.getComponent();
            }

            @Override
            protected String getDimensionServiceKey() {
                return "UiDebugger";
            }

            @Override
            protected JComponent createSouthPanel() {
                JPanel result2 = new JPanel(new BorderLayout());
                result2.add((Component)super.createSouthPanel(), "East");
                final JSlider slider = new JSlider(0, 100);
                slider.setValue(100);
                slider.addChangeListener(new ChangeListener(){

                    @Override
                    public void stateChanged(ChangeEvent e) {
                        int value2 = slider.getValue();
                        float alpha = (float)value2 / 100.0f;
                        Window wnd = SwingUtilities.getWindowAncestor(slider);
                        if (wnd != null) {
                            WindowManagerEx mgr = WindowManagerEx.getInstanceEx();
                            if (value2 == 100) {
                                mgr.setAlphaModeEnabled(wnd, false);
                            } else {
                                mgr.setAlphaModeEnabled(wnd, true);
                                mgr.setAlphaModeRatio(wnd, 1.0f - alpha);
                            }
                        }
                    }
                });
                result2.add((Component)slider, "West");
                return result2;
            }

            @Override
            protected Action @NotNull [] createActions() {
                Action[] actionArray = new Action[]{new AbstractAction("Close"){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        this.doOKAction();
                    }
                }};
                if (actionArray == null) {
                    2.$$$reportNull$$$0(0);
                }
                return actionArray;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/debugger/UiDebugger$2", "createActions"));
            }
        };
        this.myDialog.setModal(false);
        this.myDialog.setTitle("UI Debugger");
        this.myDialog.setResizable(true);
        this.myDialog.show();
    }

    @Override
    public void show() {
        this.myDialog.getPeer().getWindow().toFront();
    }

    private void addToUi(List<UiDebuggerExtension> extensions2) {
        for (UiDebuggerExtension each : extensions2) {
            this.myTabs.addTab(new TabInfo(each.getComponent()).setText(each.getName()));
        }
    }

    @Override
    public void dispose() {
        for (UiDebuggerExtension each : this.myExtensions) {
            each.disposeUiResources();
        }
    }
}

