/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.debugger.extensions;

import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeBundle;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.actionSystem.ex.AnActionListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.debugger.UiDebuggerExtension;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.jetbrains.annotations.NotNull;

public class ActionTracer
implements UiDebuggerExtension,
AnActionListener {
    private static final Logger LOG = Logger.getInstance("ActionTracer");
    private JTextArea myText;
    private JPanel myComponent;
    private Disposable myListenerDisposable;

    @Override
    public JComponent getComponent() {
        if (this.myComponent == null) {
            this.myText = new JTextArea();
            JBScrollPane log = new JBScrollPane(this.myText);
            AnAction clear2 = new AnAction(IdeBundle.messagePointer("action.ActionTracer.Anonymous.text.Clear", new Object[0]), IdeBundle.messagePointer("action.ActionTracer.Anonymous.description.clear.log", new Object[0]), AllIcons.General.Reset){

                @Override
                public void actionPerformed(@NotNull AnActionEvent e) {
                    if (e == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    ActionTracer.this.myText.setText(null);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ui/debugger/extensions/ActionTracer$1", "actionPerformed"));
                }
            };
            this.myComponent = new JPanel(new BorderLayout());
            DefaultActionGroup group = new DefaultActionGroup();
            group.add(clear2);
            this.myComponent.add((Component)ActionManager.getInstance().createActionToolbar("ActionTracer", group, true).getComponent(), "North");
            this.myComponent.add(log);
            this.myListenerDisposable = Disposer.newDisposable();
            ApplicationManager.getApplication().getMessageBus().connect(this.myListenerDisposable).subscribe(AnActionListener.TOPIC, this);
        }
        return this.myComponent;
    }

    @Override
    public String getName() {
        return "Actions";
    }

    @Override
    public void afterActionPerformed(@NotNull AnAction action2, @NotNull DataContext dataContext, @NotNull AnActionEvent event) {
        if (action2 == null) {
            ActionTracer.$$$reportNull$$$0(0);
        }
        if (dataContext == null) {
            ActionTracer.$$$reportNull$$$0(1);
        }
        if (event == null) {
            ActionTracer.$$$reportNull$$$0(2);
        }
        StringBuilder out = new StringBuilder(String.format("%1$tF %1$tT,%1$tL ", System.currentTimeMillis()));
        ActionManager actionManager = ActionManager.getInstance();
        String id2 = actionManager.getId(action2);
        out.append("id=").append(id2);
        if (id2 != null) {
            out.append("; shortcuts:");
            Shortcut[] shortcuts = KeymapUtil.getActiveKeymapShortcuts(id2).getShortcuts();
            for (int i = 0; i < shortcuts.length; ++i) {
                Shortcut shortcut = shortcuts[i];
                out.append(shortcut);
                if (i >= shortcuts.length - 1) continue;
                out.append(",");
            }
        }
        out.append("; class: ").append(action2.getClass().getName());
        out.append("\n");
        Document doc = this.myText.getDocument();
        try {
            doc.insertString(doc.getLength(), out.toString(), null);
            SwingUtilities.invokeLater(() -> {
                int y = (int)this.myText.getBounds().getMaxY();
                this.myText.scrollRectToVisible(new Rectangle(0, y, this.myText.getBounds().width, 0));
            });
        }
        catch (BadLocationException e) {
            LOG.error(e);
        }
    }

    @Override
    public void disposeUiResources() {
        Disposable disposable2 = this.myListenerDisposable;
        if (disposable2 != null) {
            this.myListenerDisposable = null;
            Disposer.dispose(disposable2);
        }
        this.myComponent = null;
        this.myText = null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "action";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "dataContext";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "event";
                break;
            }
        }
        objectArray[1] = "com/intellij/ui/debugger/extensions/ActionTracer";
        objectArray[2] = "afterActionPerformed";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

