/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.jcef;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Ref;
import com.intellij.ui.jcef.DisposeHelper;
import com.intellij.ui.jcef.JBCefApp;
import com.intellij.ui.jcef.JBCefDisposable;
import com.intellij.util.containers.hash.LinkedHashMap;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Vector;
import org.cef.CefClient;
import org.cef.CefSettings;
import org.cef.browser.CefBrowser;
import org.cef.browser.CefFrame;
import org.cef.callback.CefAuthCallback;
import org.cef.callback.CefBeforeDownloadCallback;
import org.cef.callback.CefContextMenuParams;
import org.cef.callback.CefDownloadItem;
import org.cef.callback.CefDownloadItemCallback;
import org.cef.callback.CefDragData;
import org.cef.callback.CefFileDialogCallback;
import org.cef.callback.CefJSDialogCallback;
import org.cef.callback.CefMenuModel;
import org.cef.callback.CefRequestCallback;
import org.cef.handler.CefContextMenuHandler;
import org.cef.handler.CefDialogHandler;
import org.cef.handler.CefDisplayHandler;
import org.cef.handler.CefDownloadHandler;
import org.cef.handler.CefDragHandler;
import org.cef.handler.CefFocusHandler;
import org.cef.handler.CefJSDialogHandler;
import org.cef.handler.CefKeyboardHandler;
import org.cef.handler.CefLifeSpanHandler;
import org.cef.handler.CefLoadHandler;
import org.cef.handler.CefRequestHandler;
import org.cef.handler.CefResourceHandler;
import org.cef.misc.BoolRef;
import org.cef.misc.StringRef;
import org.cef.network.CefRequest;
import org.cef.network.CefResponse;
import org.cef.network.CefURLRequest;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Experimental
public class JBCefClient
implements JBCefDisposable {
    private static final Logger LOG = Logger.getInstance(JBCefClient.class);
    @NotNull
    private final CefClient myCefClient;
    @NotNull
    private final DisposeHelper myDisposeHelper;
    private final HandlerSupport<CefContextMenuHandler> myContextMenuHandler;
    private final HandlerSupport<CefDialogHandler> myDialogHandler;
    private final HandlerSupport<CefDisplayHandler> myDisplayHandler;
    private final HandlerSupport<CefDownloadHandler> myDownloadHandler;
    private final HandlerSupport<CefDragHandler> myDragHandler;
    private final HandlerSupport<CefFocusHandler> myFocusHandler;
    private final HandlerSupport<CefJSDialogHandler> myJSDialogHandler;
    private final HandlerSupport<CefKeyboardHandler> myKeyboardHandler;
    private final HandlerSupport<CefLifeSpanHandler> myLifeSpanHandler;
    private final HandlerSupport<CefLoadHandler> myLoadHandler;
    private final HandlerSupport<CefRequestHandler> myRequestHandler;

    JBCefClient(@NotNull CefClient client) {
        if (client == null) {
            JBCefClient.$$$reportNull$$$0(0);
        }
        this.myDisposeHelper = new DisposeHelper();
        this.myContextMenuHandler = new HandlerSupport();
        this.myDialogHandler = new HandlerSupport();
        this.myDisplayHandler = new HandlerSupport();
        this.myDownloadHandler = new HandlerSupport();
        this.myDragHandler = new HandlerSupport();
        this.myFocusHandler = new HandlerSupport();
        this.myJSDialogHandler = new HandlerSupport();
        this.myKeyboardHandler = new HandlerSupport();
        this.myLifeSpanHandler = new HandlerSupport();
        this.myLoadHandler = new HandlerSupport();
        this.myRequestHandler = new HandlerSupport();
        this.myCefClient = client;
        Disposer.register(JBCefApp.getInstance().getDisposable(), this);
    }

    @NotNull
    public CefClient getCefClient() {
        CefClient cefClient = this.myCefClient;
        if (cefClient == null) {
            JBCefClient.$$$reportNull$$$0(1);
        }
        return cefClient;
    }

    @Override
    public void dispose() {
        this.myDisposeHelper.dispose(() -> {
            try {
                this.myCefClient.dispose();
            }
            catch (Exception e) {
                LOG.warn(e);
            }
        });
    }

    @Override
    public boolean isDisposed() {
        return this.myDisposeHelper.isDisposed();
    }

    public JBCefClient addContextMenuHandler(@NotNull CefContextMenuHandler handler2, @NotNull CefBrowser browser) {
        if (handler2 == null) {
            JBCefClient.$$$reportNull$$$0(2);
        }
        if (browser == null) {
            JBCefClient.$$$reportNull$$$0(3);
        }
        return this.myContextMenuHandler.add(handler2, browser, () -> this.myCefClient.addContextMenuHandler(new CefContextMenuHandler(){

            public void onBeforeContextMenu(CefBrowser browser, CefFrame frame, CefContextMenuParams params, CefMenuModel model) {
                JBCefClient.this.myContextMenuHandler.handle(browser, handler2 -> handler2.onBeforeContextMenu(browser, frame, params, model));
            }

            public boolean onContextMenuCommand(CefBrowser browser, CefFrame frame, CefContextMenuParams params, int commandId, int eventFlags) {
                return JBCefClient.this.myContextMenuHandler.handleNotNull(browser, handler2 -> handler2.onContextMenuCommand(browser, frame, params, commandId, eventFlags));
            }

            public void onContextMenuDismissed(CefBrowser browser, CefFrame frame) {
                JBCefClient.this.myContextMenuHandler.handle(browser, handler2 -> handler2.onContextMenuDismissed(browser, frame));
            }
        }));
    }

    public void removeContextMenuHandler(@NotNull CefContextMenuHandler handler2, @NotNull CefBrowser browser) {
        if (handler2 == null) {
            JBCefClient.$$$reportNull$$$0(4);
        }
        if (browser == null) {
            JBCefClient.$$$reportNull$$$0(5);
        }
        this.myContextMenuHandler.remove(handler2, browser, () -> this.myCefClient.removeContextMenuHandler());
    }

    public JBCefClient addDialogHandler(@NotNull CefDialogHandler handler2, @NotNull CefBrowser browser) {
        if (handler2 == null) {
            JBCefClient.$$$reportNull$$$0(6);
        }
        if (browser == null) {
            JBCefClient.$$$reportNull$$$0(7);
        }
        return this.myDialogHandler.add(handler2, browser, () -> this.myCefClient.addDialogHandler(new CefDialogHandler(){

            public boolean onFileDialog(CefBrowser browser, CefDialogHandler.FileDialogMode mode, String title, String defaultFilePath, Vector<String> acceptFilters, int selectedAcceptFilter, CefFileDialogCallback callback2) {
                return JBCefClient.this.myDialogHandler.handleNotNull(browser, handler2 -> handler2.onFileDialog(browser, mode, title, defaultFilePath, acceptFilters, selectedAcceptFilter, callback2));
            }
        }));
    }

    public void removeDialogHandler(@NotNull CefDialogHandler handler2, @NotNull CefBrowser browser) {
        if (handler2 == null) {
            JBCefClient.$$$reportNull$$$0(8);
        }
        if (browser == null) {
            JBCefClient.$$$reportNull$$$0(9);
        }
        this.myDialogHandler.remove(handler2, browser, () -> this.myCefClient.removeDialogHandler());
    }

    public JBCefClient addDisplayHandler(@NotNull CefDisplayHandler handler2, @NotNull CefBrowser browser) {
        if (handler2 == null) {
            JBCefClient.$$$reportNull$$$0(10);
        }
        if (browser == null) {
            JBCefClient.$$$reportNull$$$0(11);
        }
        return this.myDisplayHandler.add(handler2, browser, () -> this.myCefClient.addDisplayHandler(new CefDisplayHandler(){

            public void onAddressChange(CefBrowser browser, CefFrame frame, String url) {
                JBCefClient.this.myDisplayHandler.handle(browser, handler2 -> handler2.onAddressChange(browser, frame, url));
            }

            public void onTitleChange(CefBrowser browser, String title) {
                JBCefClient.this.myDisplayHandler.handle(browser, handler2 -> handler2.onTitleChange(browser, title));
            }

            public boolean onTooltip(CefBrowser browser, String text2) {
                return JBCefClient.this.myDisplayHandler.handleNotNull(browser, handler2 -> handler2.onTooltip(browser, text2));
            }

            public void onStatusMessage(CefBrowser browser, String value2) {
                JBCefClient.this.myDisplayHandler.handle(browser, handler2 -> handler2.onStatusMessage(browser, value2));
            }

            public boolean onConsoleMessage(CefBrowser browser, CefSettings.LogSeverity level, String message, String source, int line) {
                return JBCefClient.this.myDisplayHandler.handleNotNull(browser, handler2 -> handler2.onConsoleMessage(browser, level, message, source, line));
            }
        }));
    }

    public void removeDisplayHandler(@NotNull CefDisplayHandler handler2, @NotNull CefBrowser browser) {
        if (handler2 == null) {
            JBCefClient.$$$reportNull$$$0(12);
        }
        if (browser == null) {
            JBCefClient.$$$reportNull$$$0(13);
        }
        this.myDisplayHandler.remove(handler2, browser, () -> this.myCefClient.removeDisplayHandler());
    }

    public JBCefClient addDownloadHandler(@NotNull CefDownloadHandler handler2, @NotNull CefBrowser browser) {
        if (handler2 == null) {
            JBCefClient.$$$reportNull$$$0(14);
        }
        if (browser == null) {
            JBCefClient.$$$reportNull$$$0(15);
        }
        return this.myDownloadHandler.add(handler2, browser, () -> this.myCefClient.addDownloadHandler(new CefDownloadHandler(){

            public void onBeforeDownload(CefBrowser browser, CefDownloadItem downloadItem, String suggestedName, CefBeforeDownloadCallback callback2) {
                JBCefClient.this.myDownloadHandler.handle(browser, handler2 -> handler2.onBeforeDownload(browser, downloadItem, suggestedName, callback2));
            }

            public void onDownloadUpdated(CefBrowser browser, CefDownloadItem downloadItem, CefDownloadItemCallback callback2) {
                JBCefClient.this.myDownloadHandler.handle(browser, handler2 -> handler2.onDownloadUpdated(browser, downloadItem, callback2));
            }
        }));
    }

    public void removeDownloadHandle(@NotNull CefDownloadHandler handler2, @NotNull CefBrowser browser) {
        if (handler2 == null) {
            JBCefClient.$$$reportNull$$$0(16);
        }
        if (browser == null) {
            JBCefClient.$$$reportNull$$$0(17);
        }
        this.myDownloadHandler.remove(handler2, browser, () -> this.myCefClient.removeDownloadHandler());
    }

    public JBCefClient addDragHandler(@NotNull CefDragHandler handler2, @NotNull CefBrowser browser) {
        if (handler2 == null) {
            JBCefClient.$$$reportNull$$$0(18);
        }
        if (browser == null) {
            JBCefClient.$$$reportNull$$$0(19);
        }
        return this.myDragHandler.add(handler2, browser, () -> this.myCefClient.addDragHandler(new CefDragHandler(){

            public boolean onDragEnter(CefBrowser browser, CefDragData dragData, int mask) {
                return JBCefClient.this.myDragHandler.handleNotNull(browser, handler2 -> handler2.onDragEnter(browser, dragData, mask));
            }
        }));
    }

    public void removeDragHandler(@NotNull CefDragHandler handler2, @NotNull CefBrowser browser) {
        if (handler2 == null) {
            JBCefClient.$$$reportNull$$$0(20);
        }
        if (browser == null) {
            JBCefClient.$$$reportNull$$$0(21);
        }
        this.myDragHandler.remove(handler2, browser, () -> this.myCefClient.removeDragHandler());
    }

    public JBCefClient addFocusHandler(@NotNull CefFocusHandler handler2, @NotNull CefBrowser browser) {
        if (handler2 == null) {
            JBCefClient.$$$reportNull$$$0(22);
        }
        if (browser == null) {
            JBCefClient.$$$reportNull$$$0(23);
        }
        return this.myFocusHandler.add(handler2, browser, () -> this.myCefClient.addFocusHandler(new CefFocusHandler(){

            public void onTakeFocus(CefBrowser browser, boolean next) {
                JBCefClient.this.myFocusHandler.handle(browser, handler2 -> handler2.onTakeFocus(browser, next));
            }

            public boolean onSetFocus(CefBrowser browser, CefFocusHandler.FocusSource source) {
                return JBCefClient.this.myFocusHandler.handleNotNull(browser, handler2 -> handler2.onSetFocus(browser, source));
            }

            public void onGotFocus(CefBrowser browser) {
                JBCefClient.this.myFocusHandler.handle(browser, handler2 -> handler2.onGotFocus(browser));
            }
        }));
    }

    public void removeFocusHandler(@NotNull CefFocusHandler handler2, @NotNull CefBrowser browser) {
        if (handler2 == null) {
            JBCefClient.$$$reportNull$$$0(24);
        }
        if (browser == null) {
            JBCefClient.$$$reportNull$$$0(25);
        }
        this.myFocusHandler.remove(handler2, browser, () -> this.myCefClient.removeFocusHandler());
    }

    public JBCefClient addJSDialogHandler(@NotNull CefJSDialogHandler handler2, @NotNull CefBrowser browser) {
        if (handler2 == null) {
            JBCefClient.$$$reportNull$$$0(26);
        }
        if (browser == null) {
            JBCefClient.$$$reportNull$$$0(27);
        }
        return this.myJSDialogHandler.add(handler2, browser, () -> this.myCefClient.addJSDialogHandler(new CefJSDialogHandler(){

            public boolean onJSDialog(CefBrowser browser, String origin_url, CefJSDialogHandler.JSDialogType dialog_type, String message_text, String default_prompt_text, CefJSDialogCallback callback2, BoolRef suppress_message) {
                return JBCefClient.this.myJSDialogHandler.handleNotNull(browser, handler2 -> handler2.onJSDialog(browser, origin_url, dialog_type, message_text, default_prompt_text, callback2, suppress_message));
            }

            public boolean onBeforeUnloadDialog(CefBrowser browser, String message_text, boolean is_reload, CefJSDialogCallback callback2) {
                return JBCefClient.this.myJSDialogHandler.handleNotNull(browser, handler2 -> handler2.onBeforeUnloadDialog(browser, message_text, is_reload, callback2));
            }

            public void onResetDialogState(CefBrowser browser) {
                JBCefClient.this.myJSDialogHandler.handle(browser, handler2 -> handler2.onResetDialogState(browser));
            }

            public void onDialogClosed(CefBrowser browser) {
                JBCefClient.this.myJSDialogHandler.handle(browser, handler2 -> handler2.onDialogClosed(browser));
            }
        }));
    }

    public void removeJSDialogHandler(@NotNull CefJSDialogHandler handler2, @NotNull CefBrowser browser) {
        if (handler2 == null) {
            JBCefClient.$$$reportNull$$$0(28);
        }
        if (browser == null) {
            JBCefClient.$$$reportNull$$$0(29);
        }
        this.myJSDialogHandler.remove(handler2, browser, () -> this.myCefClient.removeJSDialogHandler());
    }

    public JBCefClient addKeyboardHandler(@NotNull CefKeyboardHandler handler2, @NotNull CefBrowser browser) {
        if (handler2 == null) {
            JBCefClient.$$$reportNull$$$0(30);
        }
        if (browser == null) {
            JBCefClient.$$$reportNull$$$0(31);
        }
        return this.myKeyboardHandler.add(handler2, browser, () -> this.myCefClient.addKeyboardHandler(new CefKeyboardHandler(){

            public boolean onPreKeyEvent(CefBrowser browser, CefKeyboardHandler.CefKeyEvent event, BoolRef is_keyboard_shortcut) {
                return JBCefClient.this.myKeyboardHandler.handleNotNull(browser, handler2 -> handler2.onPreKeyEvent(browser, event, is_keyboard_shortcut));
            }

            public boolean onKeyEvent(CefBrowser browser, CefKeyboardHandler.CefKeyEvent event) {
                return JBCefClient.this.myKeyboardHandler.handleNotNull(browser, handler2 -> handler2.onKeyEvent(browser, event));
            }
        }));
    }

    public void removeKeyboardHandler(@NotNull CefKeyboardHandler handler2, @NotNull CefBrowser browser) {
        if (handler2 == null) {
            JBCefClient.$$$reportNull$$$0(32);
        }
        if (browser == null) {
            JBCefClient.$$$reportNull$$$0(33);
        }
        this.myKeyboardHandler.remove(handler2, browser, () -> this.myCefClient.removeKeyboardHandler());
    }

    public JBCefClient addLifeSpanHandler(@NotNull CefLifeSpanHandler handler2, @NotNull CefBrowser browser) {
        if (handler2 == null) {
            JBCefClient.$$$reportNull$$$0(34);
        }
        if (browser == null) {
            JBCefClient.$$$reportNull$$$0(35);
        }
        return this.myLifeSpanHandler.add(handler2, browser, () -> this.myCefClient.addLifeSpanHandler(new CefLifeSpanHandler(){

            public boolean onBeforePopup(CefBrowser browser, CefFrame frame, String target_url, String target_frame_name) {
                return JBCefClient.this.myLifeSpanHandler.handleNotNull(browser, handler2 -> handler2.onBeforePopup(browser, frame, target_url, target_frame_name));
            }

            public void onAfterCreated(CefBrowser browser) {
                JBCefClient.this.myLifeSpanHandler.handle(browser, handler2 -> handler2.onAfterCreated(browser));
            }

            public void onAfterParentChanged(CefBrowser browser) {
                JBCefClient.this.myLifeSpanHandler.handle(browser, handler2 -> handler2.onAfterParentChanged(browser));
            }

            public boolean doClose(CefBrowser browser) {
                return JBCefClient.this.myLifeSpanHandler.handleNotNull(browser, handler2 -> handler2.doClose(browser));
            }

            public void onBeforeClose(CefBrowser browser) {
                JBCefClient.this.myLifeSpanHandler.handle(browser, handler2 -> handler2.onBeforeClose(browser));
            }
        }));
    }

    public void removeLifeSpanHandler(@NotNull CefLifeSpanHandler handler2, @NotNull CefBrowser browser) {
        if (handler2 == null) {
            JBCefClient.$$$reportNull$$$0(36);
        }
        if (browser == null) {
            JBCefClient.$$$reportNull$$$0(37);
        }
        this.myLifeSpanHandler.remove(handler2, browser, () -> this.myCefClient.removeLifeSpanHandler());
    }

    public JBCefClient addLoadHandler(@NotNull CefLoadHandler handler2, @NotNull CefBrowser browser) {
        if (handler2 == null) {
            JBCefClient.$$$reportNull$$$0(38);
        }
        if (browser == null) {
            JBCefClient.$$$reportNull$$$0(39);
        }
        return this.myLoadHandler.add(handler2, browser, () -> this.myCefClient.addLoadHandler(new CefLoadHandler(){

            public void onLoadingStateChange(CefBrowser browser, boolean isLoading, boolean canGoBack, boolean canGoForward) {
                JBCefClient.this.myLoadHandler.handle(browser, handler2 -> handler2.onLoadingStateChange(browser, isLoading, canGoBack, canGoForward));
            }

            public void onLoadStart(CefBrowser browser, CefFrame frame, CefRequest.TransitionType transitionType) {
                JBCefClient.this.myLoadHandler.handle(browser, handler2 -> handler2.onLoadStart(browser, frame, transitionType));
            }

            public void onLoadEnd(CefBrowser browser, CefFrame frame, int httpStatusCode) {
                JBCefClient.this.myLoadHandler.handle(browser, handler2 -> handler2.onLoadEnd(browser, frame, httpStatusCode));
            }

            public void onLoadError(CefBrowser browser, CefFrame frame, CefLoadHandler.ErrorCode errorCode, String errorText, String failedUrl) {
                JBCefClient.this.myLoadHandler.handle(browser, handler2 -> handler2.onLoadError(browser, frame, errorCode, errorText, failedUrl));
            }
        }));
    }

    public void removeLoadHandler(@NotNull CefLoadHandler handler2, @NotNull CefBrowser browser) {
        if (handler2 == null) {
            JBCefClient.$$$reportNull$$$0(40);
        }
        if (browser == null) {
            JBCefClient.$$$reportNull$$$0(41);
        }
        this.myLoadHandler.remove(handler2, browser, () -> this.myCefClient.removeLoadHandler());
    }

    public JBCefClient addRequestHandler(@NotNull CefRequestHandler handler2, @NotNull CefBrowser browser) {
        if (handler2 == null) {
            JBCefClient.$$$reportNull$$$0(42);
        }
        if (browser == null) {
            JBCefClient.$$$reportNull$$$0(43);
        }
        return this.myRequestHandler.add(handler2, browser, () -> this.myCefClient.addRequestHandler(new CefRequestHandler(){

            public boolean onBeforeBrowse(CefBrowser browser, CefFrame frame, CefRequest request2, boolean user_gesture, boolean is_redirect) {
                return JBCefClient.this.myRequestHandler.handleNotNull(browser, handler2 -> handler2.onBeforeBrowse(browser, frame, request2, user_gesture, is_redirect));
            }

            public boolean onBeforeResourceLoad(CefBrowser browser, CefFrame frame, CefRequest request2) {
                return JBCefClient.this.myRequestHandler.handleNotNull(browser, handler2 -> handler2.onBeforeResourceLoad(browser, frame, request2));
            }

            public CefResourceHandler getResourceHandler(CefBrowser browser, CefFrame frame, CefRequest request2) {
                return JBCefClient.this.myRequestHandler.handle(browser, handler2 -> handler2.getResourceHandler(browser, frame, request2));
            }

            public void onResourceRedirect(CefBrowser browser, CefFrame frame, CefRequest request2, CefResponse response, StringRef new_url) {
                JBCefClient.this.myRequestHandler.handle(browser, handler2 -> handler2.onResourceRedirect(browser, frame, request2, response, new_url));
            }

            public boolean onResourceResponse(CefBrowser browser, CefFrame frame, CefRequest request2, CefResponse response) {
                return JBCefClient.this.myRequestHandler.handleNotNull(browser, handler2 -> handler2.onResourceResponse(browser, frame, request2, response));
            }

            public void onResourceLoadComplete(CefBrowser browser, CefFrame frame, CefRequest request2, CefResponse response, CefURLRequest.Status status, long receivedContentLength) {
                JBCefClient.this.myRequestHandler.handle(browser, handler2 -> handler2.onResourceLoadComplete(browser, frame, request2, response, status, receivedContentLength));
            }

            public boolean getAuthCredentials(CefBrowser browser, CefFrame frame, boolean isProxy, String host, int port, String realm, String scheme, CefAuthCallback callback2) {
                return JBCefClient.this.myRequestHandler.handleNotNull(browser, handler2 -> handler2.getAuthCredentials(browser, frame, isProxy, host, port, realm, scheme, callback2));
            }

            public boolean onQuotaRequest(CefBrowser browser, String origin_url, long new_size, CefRequestCallback callback2) {
                return JBCefClient.this.myRequestHandler.handleNotNull(browser, handler2 -> handler2.onQuotaRequest(browser, origin_url, new_size, callback2));
            }

            public void onProtocolExecution(CefBrowser browser, String url, BoolRef allow_os_execution) {
                JBCefClient.this.myRequestHandler.handle(browser, handler2 -> handler2.onProtocolExecution(browser, url, allow_os_execution));
            }

            public boolean onCertificateError(CefBrowser browser, CefLoadHandler.ErrorCode cert_error, String request_url, CefRequestCallback callback2) {
                return JBCefClient.this.myRequestHandler.handleNotNull(browser, handler2 -> handler2.onCertificateError(browser, cert_error, request_url, callback2));
            }

            public void onPluginCrashed(CefBrowser browser, String pluginPath) {
                JBCefClient.this.myRequestHandler.handle(browser, handler2 -> handler2.onPluginCrashed(browser, pluginPath));
            }

            public void onRenderProcessTerminated(CefBrowser browser, CefRequestHandler.TerminationStatus status) {
                JBCefClient.this.myRequestHandler.handle(browser, handler2 -> handler2.onRenderProcessTerminated(browser, status));
            }
        }));
    }

    public void removeRequestHandler(@NotNull CefRequestHandler handler2, @NotNull CefBrowser browser) {
        if (handler2 == null) {
            JBCefClient.$$$reportNull$$$0(44);
        }
        if (browser == null) {
            JBCefClient.$$$reportNull$$$0(45);
        }
        this.myRequestHandler.remove(handler2, browser, () -> this.myCefClient.removeRequestHandler());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "client";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ui/jcef/JBCefClient";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 8: 
            case 10: 
            case 12: 
            case 14: 
            case 16: 
            case 18: 
            case 20: 
            case 22: 
            case 24: 
            case 26: 
            case 28: 
            case 30: 
            case 32: 
            case 34: 
            case 36: 
            case 38: 
            case 40: 
            case 42: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "handler";
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 11: 
            case 13: 
            case 15: 
            case 17: 
            case 19: 
            case 21: 
            case 23: 
            case 25: 
            case 27: 
            case 29: 
            case 31: 
            case 33: 
            case 35: 
            case 37: 
            case 39: 
            case 41: 
            case 43: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "browser";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ui/jcef/JBCefClient";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getCefClient";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "addContextMenuHandler";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "removeContextMenuHandler";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "addDialogHandler";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "removeDialogHandler";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "addDisplayHandler";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "removeDisplayHandler";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "addDownloadHandler";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "removeDownloadHandle";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "addDragHandler";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "removeDragHandler";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "addFocusHandler";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "removeFocusHandler";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "addJSDialogHandler";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "removeJSDialogHandler";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "addKeyboardHandler";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "removeKeyboardHandler";
                break;
            }
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "addLifeSpanHandler";
                break;
            }
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "removeLifeSpanHandler";
                break;
            }
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "addLoadHandler";
                break;
            }
            case 40: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "removeLoadHandler";
                break;
            }
            case 42: 
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "addRequestHandler";
                break;
            }
            case 44: 
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "removeRequestHandler";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static interface HandlerRunnable<T> {
        public void handle(T var1);
    }

    private static interface HandlerCallableNotNull<T, R>
    extends HandlerCallable<T, R> {
        @Override
        @NotNull
        public R handle(T var1);
    }

    private static interface HandlerCallable<T, R> {
        @Nullable
        public R handle(T var1);
    }

    private class HandlerSupport<T> {
        private volatile Map<CefBrowser, List<T>> myMap;

        private HandlerSupport() {
        }

        private synchronized void syncInitMap() {
            if (this.myMap == null) {
                this.myMap = Collections.synchronizedMap(new LinkedHashMap());
            }
        }

        private synchronized List<T> syncInitList(@NotNull CefBrowser browser, @NotNull Runnable onInit) {
            List<Object> list2;
            if (browser == null) {
                HandlerSupport.$$$reportNull$$$0(0);
            }
            if (onInit == null) {
                HandlerSupport.$$$reportNull$$$0(1);
            }
            if ((list2 = this.myMap.get(browser)) == null) {
                list2 = Collections.synchronizedList(new LinkedList());
                this.myMap.put(browser, list2);
                onInit.run();
            }
            return list2;
        }

        private synchronized void syncRemoveFromMap(@NotNull List<T> list2, @NotNull CefBrowser browser, @NotNull Runnable onClear) {
            if (list2 == null) {
                HandlerSupport.$$$reportNull$$$0(2);
            }
            if (browser == null) {
                HandlerSupport.$$$reportNull$$$0(3);
            }
            if (onClear == null) {
                HandlerSupport.$$$reportNull$$$0(4);
            }
            if (list2.isEmpty()) {
                this.myMap.remove(browser);
                onClear.run();
            }
        }

        public JBCefClient add(@NotNull T handler2, @NotNull CefBrowser browser, @NotNull Runnable onInit) {
            List<T> list2;
            if (handler2 == null) {
                HandlerSupport.$$$reportNull$$$0(5);
            }
            if (browser == null) {
                HandlerSupport.$$$reportNull$$$0(6);
            }
            if (onInit == null) {
                HandlerSupport.$$$reportNull$$$0(7);
            }
            if (this.myMap == null) {
                this.syncInitMap();
            }
            if ((list2 = this.myMap.get(browser)) == null) {
                list2 = this.syncInitList(browser, onInit);
            }
            list2.add(handler2);
            return JBCefClient.this;
        }

        public void remove(@NotNull T handler2, @NotNull CefBrowser browser, @NotNull Runnable onClear) {
            List<T> list2;
            if (handler2 == null) {
                HandlerSupport.$$$reportNull$$$0(8);
            }
            if (browser == null) {
                HandlerSupport.$$$reportNull$$$0(9);
            }
            if (onClear == null) {
                HandlerSupport.$$$reportNull$$$0(10);
            }
            if (this.myMap != null && (list2 = this.myMap.get(browser)) != null) {
                list2.remove(handler2);
                if (list2.isEmpty()) {
                    this.syncRemoveFromMap(list2, browser, onClear);
                }
            }
        }

        public void clear() {
            if (this.myMap != null) {
                this.myMap.clear();
            }
        }

        @Nullable
        public List<T> get(@NotNull CefBrowser browser) {
            if (browser == null) {
                HandlerSupport.$$$reportNull$$$0(11);
            }
            return this.myMap != null ? this.myMap.get(browser) : null;
        }

        @Nullable
        public <R> R handle(@NotNull CefBrowser browser, @NotNull HandlerCallable<T, R> callable) {
            if (browser == null) {
                HandlerSupport.$$$reportNull$$$0(12);
            }
            if (callable == null) {
                HandlerSupport.$$$reportNull$$$0(13);
            }
            List<Object> list2 = this.get(browser);
            assert (list2 != null);
            Ref<Object> lastResult = new Ref<Object>(null);
            list2.forEach(handler2 -> lastResult.set(callable.handle(handler2)));
            return lastResult.get();
        }

        @NotNull
        public <R> R handleNotNull(@NotNull CefBrowser browser, @NotNull HandlerCallableNotNull<T, R> callable) {
            if (browser == null) {
                HandlerSupport.$$$reportNull$$$0(14);
            }
            if (callable == null) {
                HandlerSupport.$$$reportNull$$$0(15);
            }
            R r = Objects.requireNonNull(this.handle(browser, callable));
            if (r == null) {
                HandlerSupport.$$$reportNull$$$0(16);
            }
            return r;
        }

        public void handle(@NotNull CefBrowser browser, @NotNull HandlerRunnable<T> runnable2) {
            List<Object> list2;
            if (browser == null) {
                HandlerSupport.$$$reportNull$$$0(17);
            }
            if (runnable2 == null) {
                HandlerSupport.$$$reportNull$$$0(18);
            }
            if ((list2 = this.get(browser)) == null) {
                return;
            }
            list2.forEach(handler2 -> runnable2.handle(handler2));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 16: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 16: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "browser";
                    break;
                }
                case 1: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "onInit";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "list";
                    break;
                }
                case 4: 
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "onClear";
                    break;
                }
                case 5: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "handler";
                    break;
                }
                case 13: 
                case 15: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "callable";
                    break;
                }
                case 16: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ui/jcef/JBCefClient$HandlerSupport";
                    break;
                }
                case 18: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "runnable";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ui/jcef/JBCefClient$HandlerSupport";
                    break;
                }
                case 16: {
                    objectArray = objectArray2;
                    objectArray2[1] = "handleNotNull";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "syncInitList";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "syncRemoveFromMap";
                    break;
                }
                case 5: 
                case 6: 
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "add";
                    break;
                }
                case 8: 
                case 9: 
                case 10: {
                    objectArray = objectArray;
                    objectArray[2] = "remove";
                    break;
                }
                case 11: {
                    objectArray = objectArray;
                    objectArray[2] = "get";
                    break;
                }
                case 12: 
                case 13: 
                case 17: 
                case 18: {
                    objectArray = objectArray;
                    objectArray[2] = "handle";
                    break;
                }
                case 14: 
                case 15: {
                    objectArray = objectArray;
                    objectArray[2] = "handleNotNull";
                    break;
                }
                case 16: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 16: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

