/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.jcef;

import com.intellij.openapi.util.Disposer;
import com.intellij.ui.jcef.DisposeHelper;
import com.intellij.ui.jcef.JBCefBrowser;
import com.intellij.ui.jcef.JBCefDisposable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import org.cef.CefClient;
import org.cef.browser.CefBrowser;
import org.cef.browser.CefFrame;
import org.cef.browser.CefMessageRouter;
import org.cef.callback.CefQueryCallback;
import org.cef.handler.CefMessageRouterHandler;
import org.cef.handler.CefMessageRouterHandlerAdapter;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Experimental
public class JBCefJSQuery
implements JBCefDisposable {
    @NotNull
    private final String myJSCallID;
    @NotNull
    private final CefMessageRouter myMsgRouter;
    @NotNull
    private final CefClient myCefClient;
    @NotNull
    private final DisposeHelper myDisposeHelper;
    @NotNull
    private final Map<Function<String, Response>, CefMessageRouterHandler> myHandlerMap;
    @NotNull
    private static final AtomicInteger UNIQUE_ID_COUNTER = new AtomicInteger(0);

    private JBCefJSQuery(@NotNull JBCefBrowser browser, @NotNull String jsCallID) {
        if (browser == null) {
            JBCefJSQuery.$$$reportNull$$$0(0);
        }
        if (jsCallID == null) {
            JBCefJSQuery.$$$reportNull$$$0(1);
        }
        this.myDisposeHelper = new DisposeHelper();
        this.myHandlerMap = Collections.synchronizedMap(new HashMap());
        this.myJSCallID = jsCallID;
        CefMessageRouter.CefMessageRouterConfig config2 = new CefMessageRouter.CefMessageRouterConfig();
        config2.jsQueryFunction = this.myJSCallID;
        config2.jsCancelFunction = this.myJSCallID;
        this.myMsgRouter = CefMessageRouter.create((CefMessageRouter.CefMessageRouterConfig)config2);
        this.myCefClient = browser.getJBCefClient().getCefClient();
        this.myCefClient.addMessageRouter(this.myMsgRouter);
        Disposer.register(browser, this);
    }

    public static JBCefJSQuery create(@NotNull JBCefBrowser browser) {
        if (browser == null) {
            JBCefJSQuery.$$$reportNull$$$0(2);
        }
        return new JBCefJSQuery(browser, "cefQuery_" + browser.hashCode() + "_" + UNIQUE_ID_COUNTER.incrementAndGet());
    }

    public String inject(@Nullable String queryResult) {
        return this.inject(queryResult, "function(response) {}", "function(error_code, error_message) {}");
    }

    public String inject(@Nullable String queryResult, @NotNull String onSuccessCallback, @NotNull String onFailureCallback) {
        if (onSuccessCallback == null) {
            JBCefJSQuery.$$$reportNull$$$0(3);
        }
        if (onFailureCallback == null) {
            JBCefJSQuery.$$$reportNull$$$0(4);
        }
        return "window." + this.myJSCallID + "({request: '' + " + queryResult + ",onSuccess: " + onSuccessCallback + ",onFailure: " + onFailureCallback + "});";
    }

    public void addHandler(final @NotNull Function<String, Response> handler2) {
        if (handler2 == null) {
            JBCefJSQuery.$$$reportNull$$$0(5);
        }
        CefMessageRouterHandlerAdapter cefHandler = new CefMessageRouterHandlerAdapter(){

            public boolean onQuery(CefBrowser browser, CefFrame frame, long query_id, String request2, boolean persistent, CefQueryCallback callback2) {
                Response response = (Response)handler2.apply(request2);
                if (callback2 != null && response != null) {
                    if (response.isSuccess() && response.hasResponse()) {
                        callback2.success(response.response());
                    } else {
                        callback2.failure(response.errCode(), response.errMsg());
                    }
                }
                return true;
            }
        };
        this.myMsgRouter.addHandler((CefMessageRouterHandler)cefHandler, true);
        this.myHandlerMap.put(handler2, (CefMessageRouterHandler)cefHandler);
    }

    public void removeHandler(@NotNull Function<String, Response> handler2) {
        CefMessageRouterHandler cefHandler;
        if (handler2 == null) {
            JBCefJSQuery.$$$reportNull$$$0(6);
        }
        if ((cefHandler = this.myHandlerMap.remove(handler2)) != null) {
            this.myMsgRouter.removeHandler(cefHandler);
        }
    }

    @Override
    public void dispose() {
        this.myDisposeHelper.dispose(() -> {
            this.myCefClient.removeMessageRouter(this.myMsgRouter);
            this.myHandlerMap.clear();
        });
    }

    @Override
    public boolean isDisposed() {
        return this.myDisposeHelper.isDisposed();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "browser";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jsCallID";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "onSuccessCallback";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "onFailureCallback";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "handler";
                break;
            }
        }
        objectArray2[1] = "com/intellij/ui/jcef/JBCefJSQuery";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "create";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "inject";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "addHandler";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "removeHandler";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class Response {
        public static final int ERR_CODE_SUCCESS = 0;
        @Nullable
        private final String myResponse;
        private final int myErrCode;
        @Nullable
        private final String myErrMsg;

        public Response(@Nullable String response) {
            this(response, 0, null);
        }

        public Response(@Nullable String response, int errCode, @Nullable String errMsg) {
            this.myResponse = response;
            this.myErrCode = errCode;
            this.myErrMsg = errMsg;
        }

        @Nullable
        public String response() {
            return this.myResponse;
        }

        public int errCode() {
            return this.myErrCode;
        }

        @Nullable
        public String errMsg() {
            return this.myErrMsg;
        }

        public boolean isSuccess() {
            return this.myErrCode == 0;
        }

        public boolean hasResponse() {
            return this.myResponse != null;
        }
    }
}

