/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.mac;

import com.apple.eawt.AppEvent;
import com.apple.eawt.Application;
import com.apple.eawt.OpenURIHandler;
import com.intellij.diagnostic.LoadingState;
import com.intellij.ide.CommandLineProcessor;
import com.intellij.ide.CommandLineProcessorResult;
import com.intellij.ide.DataManager;
import com.intellij.ide.actions.AboutAction;
import com.intellij.ide.actions.ShowSettingsAction;
import com.intellij.ide.impl.ProjectUtil;
import com.intellij.idea.IdeStarter;
import com.intellij.jna.JnaLoader;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.impl.ApplicationInfoImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.keymap.impl.IdeKeyEventDispatcher;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.util.BuildNumber;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.mac.foundation.Foundation;
import com.intellij.ui.mac.foundation.ID;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.sun.jna.Callback;
import io.netty.handler.codec.http.QueryStringDecoder;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.Nullable;

public final class MacOSApplicationProvider {
    private static final Logger LOG = Logger.getInstance(MacOSApplicationProvider.class);

    private MacOSApplicationProvider() {
    }

    public static void initApplication() {
        if (SystemInfo.isMac) {
            try {
                Worker.initMacApplication();
            }
            catch (Throwable t) {
                LOG.warn(t);
            }
        }
    }

    private static final class Worker {
        private static final AtomicBoolean ENABLED = new AtomicBoolean(true);
        private static Object UPDATE_CALLBACK_REF;

        private Worker() {
        }

        static void initMacApplication() {
            Application application = Application.getApplication();
            application.setAboutHandler(event -> {
                if (LoadingState.COMPONENTS_LOADED.isOccurred()) {
                    AboutAction.perform(Worker.getProject(false));
                }
            });
            application.setPreferencesHandler(event -> {
                if (LoadingState.COMPONENTS_LOADED.isOccurred()) {
                    Project project2 = Objects.requireNonNull(Worker.getProject(true));
                    Worker.submit("Preferences", () -> ShowSettingsAction.perform(project2));
                }
            });
            application.setQuitHandler((event, response) -> {
                if (LoadingState.COMPONENTS_LOADED.isOccurred()) {
                    Worker.submit("Quit", () -> ApplicationManager.getApplication().exit());
                    response.cancelQuit();
                } else {
                    response.performQuit();
                }
            });
            application.setOpenFileHandler(event -> {
                List files2 = event.getFiles();
                if (files2.isEmpty()) {
                    return;
                }
                if (LoadingState.COMPONENTS_LOADED.isOccurred()) {
                    Project project2 = Worker.getProject(false);
                    Worker.submit("OpenFile", () -> ProjectUtil.tryOpenFileList(project2, files2, "MacMenu"));
                } else {
                    IdeStarter.openFilesOnLoading(files2);
                }
            });
            if (JnaLoader.isLoaded()) {
                Worker.installAutoUpdateMenu();
                Worker.installProtocolHandler();
            }
        }

        private static void installAutoUpdateMenu() {
            ID pool = Foundation.invoke("NSAutoreleasePool", "new", new Object[0]);
            ID app = Foundation.invoke("NSApplication", "sharedApplication", new Object[0]);
            ID menu = Foundation.invoke(app, Foundation.createSelector("menu"), new Object[0]);
            ID item = Foundation.invoke(menu, Foundation.createSelector("itemAtIndex:"), 0);
            ID appMenu = Foundation.invoke(item, Foundation.createSelector("submenu"), new Object[0]);
            ID checkForUpdatesClass = Foundation.allocateObjcClassPair(Foundation.getObjcClass("NSMenuItem"), "NSCheckForUpdates");
            Callback impl = new Callback(){

                public void callback(ID self, String selector) {
                    SwingUtilities.invokeLater(() -> {
                        ActionManager actionManager = ActionManager.getInstance();
                        MouseEvent mouseEvent = new MouseEvent(JOptionPane.getRootFrame(), 500, System.currentTimeMillis(), 0, 0, 0, 1, false);
                        actionManager.tryToExecute(actionManager.getAction("CheckForUpdate"), mouseEvent, null, null, false);
                    });
                }
            };
            UPDATE_CALLBACK_REF = impl;
            Foundation.addMethod(checkForUpdatesClass, Foundation.createSelector("checkForUpdates"), impl, "v");
            Foundation.registerObjcClassPair(checkForUpdatesClass);
            ID checkForUpdates2 = Foundation.invoke("NSCheckForUpdates", "alloc", new Object[0]);
            Foundation.invoke(checkForUpdates2, Foundation.createSelector("initWithTitle:action:keyEquivalent:"), new Object[]{Foundation.nsString("Check for Updates..."), Foundation.createSelector("checkForUpdates"), Foundation.nsString("")});
            Foundation.invoke(checkForUpdates2, Foundation.createSelector("setTarget:"), new Object[]{checkForUpdates2});
            Foundation.invoke(appMenu, Foundation.createSelector("insertItem:atIndex:"), new Object[]{checkForUpdates2, 1});
            Foundation.invoke(checkForUpdates2, Foundation.createSelector("release"), new Object[0]);
            Foundation.invoke(pool, Foundation.createSelector("release"), new Object[0]);
        }

        @Nullable
        private static Project getProject(boolean useDefault) {
            Project project2 = CommonDataKeys.PROJECT.getData(DataManager.getInstance().getDataContext());
            if (project2 == null) {
                LOG.debug("MacMenu: no project in data context");
                Project[] projects = ProjectManager.getInstance().getOpenProjects();
                Project project3 = project2 = projects.length > 0 ? projects[0] : null;
                if (project2 == null && useDefault) {
                    LOG.debug("MacMenu: use default project instead");
                    project2 = ProjectManager.getInstance().getDefaultProject();
                }
            }
            LOG.debug("MacMenu: project = ", project2);
            return project2;
        }

        private static void submit(String name, Runnable task2) {
            LOG.debug("MacMenu: on EDT = ", SwingUtilities.isEventDispatchThread(), "; ENABLED = ", ENABLED.get());
            if (!ENABLED.get()) {
                LOG.debug("MacMenu: disabled");
            } else {
                Component component2 = IdeFocusManager.getGlobalInstance().getFocusOwner();
                if (component2 != null && IdeKeyEventDispatcher.isModalContext(component2)) {
                    LOG.debug("MacMenu: component in modal context");
                } else {
                    ENABLED.set(false);
                    ApplicationManager.getApplication().invokeLater(() -> {
                        try {
                            LOG.debug("MacMenu: init ", name);
                            task2.run();
                        }
                        catch (Throwable throwable) {
                            LOG.debug("MacMenu: done ", name);
                            ENABLED.set(true);
                            throw throwable;
                        }
                        LOG.debug("MacMenu: done ", name);
                        ENABLED.set(true);
                    }, ModalityState.NON_MODAL);
                }
            }
        }

        private static void installProtocolHandler() {
            ID mainBundle = Foundation.invoke("NSBundle", "mainBundle", new Object[0]);
            ID urlTypes = Foundation.invoke(mainBundle, "objectForInfoDictionaryKey:", new Object[]{Foundation.nsString("CFBundleURLTypes")});
            if (urlTypes.equals((Object)ID.NIL)) {
                BuildNumber build2 = ApplicationInfoImpl.getShadowInstance().getBuild();
                if (build2 != null && !build2.isSnapshot()) {
                    LOG.warn("No URL bundle (CFBundleURLTypes) is defined in the main bundle.\nTo be able to open external links, specify protocols in the app layout section of the build file.\nExample: args.urlSchemes = [\"your-protocol\"] will handle following links: your-protocol://open?file=file&line=line");
                }
                return;
            }
            Application.getApplication().setOpenURIHandler(new OpenURIHandler(){

                public void openURI(AppEvent.OpenURIEvent event) {
                    Map parameters = new QueryStringDecoder(event.getURI()).parameters();
                    String file2 = (String)ContainerUtil.getFirstItem((List)parameters.get("file"));
                    if (file2 == null) {
                        return;
                    }
                    if (!LoadingState.COMPONENTS_LOADED.isOccurred()) {
                        IdeStarter.openFilesOnLoading(Collections.singletonList(new File(file2)));
                        return;
                    }
                    String line = (String)ContainerUtil.getFirstItem((List)parameters.get("line"));
                    String column = (String)ContainerUtil.getFirstItem((List)parameters.get("column"));
                    SmartList<String> args = new SmartList<String>();
                    if (line != null) {
                        args.add("--line");
                        args.add(line);
                    }
                    if (column != null) {
                        args.add("--column");
                        args.add(column);
                    }
                    args.add(file2);
                    ApplicationManager.getApplication().invokeLater(() -> {
                        CommandLineProcessorResult result2 = CommandLineProcessor.processExternalCommandLine(args, null);
                        result2.showErrorIfFailed();
                    }, ModalityState.NON_MODAL);
                }
            });
        }
    }
}

