/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.mac.touchbar;

import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.ide.DataManager;
import com.intellij.ide.ui.customization.CustomActionsSchema;
import com.intellij.ide.ui.customization.CustomisedActionGroup;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CompactActionGroup;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.actionSystem.Toggleable;
import com.intellij.openapi.actionSystem.impl.Utils;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.impl.LaterInvocator;
import com.intellij.openapi.application.impl.ModalityStateEx;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.MnemonicNavigationFilter;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.wm.impl.welcomeScreen.WelcomePopupAction;
import com.intellij.ui.components.JBOptionButton;
import com.intellij.ui.mac.TouchbarDataKeys;
import com.intellij.ui.mac.touchbar.ItemsContainer;
import com.intellij.ui.mac.touchbar.TBItem;
import com.intellij.ui.mac.touchbar.TBItemAnActionButton;
import com.intellij.ui.mac.touchbar.TBItemButton;
import com.intellij.ui.mac.touchbar.TBItemGroup;
import com.intellij.ui.mac.touchbar.TBItemScrubber;
import com.intellij.ui.mac.touchbar.TouchBar;
import com.intellij.ui.mac.touchbar.TouchBarStats;
import com.intellij.ui.popup.list.ListPopupImpl;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Component;
import java.awt.KeyboardFocusManager;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.ListModel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class BuildUtils {
    private static final boolean SKIP_UPDATE_SLOW_ACTIONS = Boolean.getBoolean("mac.touchbar.skip.update.slow.actions");
    private static final boolean PERSISTENT_LIST_OF_SLOW_ACTIONS = Boolean.getBoolean("mac.touchbar.remember.slow.actions");
    private static final String DIALOG_ACTIONS_CONTEXT = "DialogWrapper.touchbar.actions";
    private static final String ourSmallSeparatorText = "type.small";
    private static final String ourLargeSeparatorText = "type.large";
    private static final String ourFlexibleSeparatorText = "type.flexible";
    private static final int BUTTON_MIN_WIDTH_DLG = 107;
    private static final int BUTTON_BORDER = 16;
    private static final int BUTTON_IMAGE_MARGIN = 2;
    private static final String SLOW_UPDATE_ACTIONS_KEY = "touchbar.slow.update.actions";
    @NotNull
    private static Set<String> ourSlowActions;

    BuildUtils() {
    }

    @NotNull
    static TouchBar buildFromCustomizedGroup(@NotNull String touchbarName, @NotNull ActionGroup customizedGroup, boolean replaceEsc) {
        if (touchbarName == null) {
            BuildUtils.$$$reportNull$$$0(0);
        }
        if (customizedGroup == null) {
            BuildUtils.$$$reportNull$$$0(1);
        }
        @NotNull String groupId2 = BuildUtils.getActionId(customizedGroup);
        TouchBar result2 = new TouchBar(touchbarName, replaceEsc, false, false, customizedGroup, groupId2 + "_");
        String filterPrefix = groupId2 + "_";
        final String defaultOptCtx = groupId2 + "OptionalGroup";
        result2.setDefaultOptionalContextName(defaultOptCtx);
        Customizer customizer = new Customizer(){

            @Override
            public void process(@NotNull INodeInfo ni, @NotNull TBItemAnActionButton butt) {
                if (ni == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (butt == null) {
                    1.$$$reportNull$$$0(1);
                }
                super.process(ni, butt);
                if (defaultOptCtx.equals(ni.getParentGroupID())) {
                    butt.myOptionalContextName = defaultOptCtx;
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "ni";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "butt";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/ui/mac/touchbar/BuildUtils$1";
                objectArray[2] = "process";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        BuildUtils.addActionGroupButtons(result2, customizedGroup, filterPrefix, customizer);
        result2.selectVisibleItemsToShow();
        TouchBar touchBar = result2;
        if (touchBar == null) {
            BuildUtils.$$$reportNull$$$0(2);
        }
        return touchBar;
    }

    @NotNull
    static TouchBar buildFromGroup(@NotNull String touchbarName, @NotNull ActionGroup actions, boolean replaceEsc, boolean emulateESC) {
        TouchbarDataKeys.ActionDesc groupDesc;
        if (touchbarName == null) {
            BuildUtils.$$$reportNull$$$0(3);
        }
        if (actions == null) {
            BuildUtils.$$$reportNull$$$0(4);
        }
        if ((groupDesc = actions.getTemplatePresentation().getClientProperty(TouchbarDataKeys.ACTIONS_DESCRIPTOR_KEY)) != null && !groupDesc.isReplaceEsc()) {
            replaceEsc = false;
        }
        TouchBar result2 = new TouchBar(touchbarName, replaceEsc, false, emulateESC, actions, null);
        BuildUtils.addActionGroup(result2, actions);
        TouchBar touchBar = result2;
        if (touchBar == null) {
            BuildUtils.$$$reportNull$$$0(5);
        }
        return touchBar;
    }

    static void addActionGroup(@NotNull TouchBar result2, @NotNull ActionGroup actions) {
        if (result2 == null) {
            BuildUtils.$$$reportNull$$$0(6);
        }
        if (actions == null) {
            BuildUtils.$$$reportNull$$$0(7);
        }
        @NotNull ModalityStateEx ms = LaterInvocator.getCurrentModalityState();
        @Nullable TouchbarDataKeys.ActionDesc groupDesc = actions.getTemplatePresentation().getClientProperty(TouchbarDataKeys.ACTIONS_DESCRIPTOR_KEY);
        Customizer customizer = new Customizer(groupDesc, (ModalityState)ms);
        BuildUtils.addActionGroup(result2, actions, customizer);
    }

    static void addActionGroup(@NotNull TouchBar result2, @NotNull ActionGroup actions, @NotNull Customizer customizer) {
        if (result2 == null) {
            BuildUtils.$$$reportNull$$$0(8);
        }
        if (actions == null) {
            BuildUtils.$$$reportNull$$$0(9);
        }
        if (customizer == null) {
            BuildUtils.$$$reportNull$$$0(10);
        }
        BuildUtils.addActionGroupButtons(result2, actions, null, customizer);
        result2.selectVisibleItemsToShow();
    }

    static void addActionGroupButtons(@NotNull TouchBar out, @NotNull ActionGroup actionGroup, @Nullable String filterGroupPrefix, @Nullable Customizer customizer) {
        if (out == null) {
            BuildUtils.$$$reportNull$$$0(11);
        }
        if (actionGroup == null) {
            BuildUtils.$$$reportNull$$$0(12);
        }
        GroupVisitor visitor = new GroupVisitor(out, filterGroupPrefix, customizer, out.getStats(), false);
        DataContext dctx = DataManager.getInstance().getDataContext(BuildUtils.getCurrentFocusComponent());
        Utils.expandActionGroup(false, actionGroup, out.getFactory(), dctx, "TouchBarGeneral", visitor);
        if (customizer != null) {
            customizer.finish();
        }
    }

    @Nullable
    static Component getCurrentFocusComponent() {
        KeyboardFocusManager focusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        Component focusOwner = focusManager.getFocusOwner();
        if (focusOwner == null) {
            focusOwner = focusManager.getPermanentFocusOwner();
        }
        if (focusOwner == null) {
            return focusManager.getFocusedWindow();
        }
        return focusOwner;
    }

    static ActionGroup getCustomizedGroup(@NotNull String barId) {
        if (barId == null) {
            BuildUtils.$$$reportNull$$$0(13);
        }
        ActionGroup actGroup = (ActionGroup)CustomActionsSchema.getInstance().getCorrectedAction("TouchBar");
        AnAction[] kids = actGroup.getChildren(null);
        String childGroupId = barId.startsWith("TouchBar") ? barId : "TouchBar" + barId;
        for (AnAction act : kids) {
            String gid;
            if (!(act instanceof ActionGroup) || !(gid = BuildUtils.getActionId(act)).equals(childGroupId)) continue;
            return (ActionGroup)act;
        }
        return null;
    }

    static Map<String, ActionGroup> getAltLayouts(@NotNull ActionGroup context) {
        AnAction[] kids;
        if (context == null) {
            BuildUtils.$$$reportNull$$$0(14);
        }
        @NotNull String ctxId = BuildUtils.getActionId(context);
        HashMap<String, ActionGroup> result2 = new HashMap<String, ActionGroup>();
        for (AnAction act : kids = context.getChildren(null)) {
            String gid;
            if (!(act instanceof ActionGroup) || !(gid = BuildUtils.getActionId(act)).startsWith(ctxId + "_")) continue;
            result2.put(gid.substring(ctxId.length() + 1), (ActionGroup)act);
        }
        return result2;
    }

    static void addDialogButtons(final @NotNull TouchBar out, @Nullable Map<TouchbarDataKeys.DlgButtonDesc, JButton> unorderedButtons, @Nullable Map<Component, ActionGroup> actions) {
        if (out == null) {
            BuildUtils.$$$reportNull$$$0(15);
        }
        @NotNull ModalityStateEx ms = LaterInvocator.getCurrentModalityState();
        boolean hasSouthPanelButtons = unorderedButtons != null && !unorderedButtons.isEmpty();
        final byte[] prio = new byte[]{-1};
        if (hasSouthPanelButtons) {
            for (JButton jb : unorderedButtons.values()) {
                JBOptionButton ob;
                Action[] opts;
                TBItemButton tbb = null;
                if (jb instanceof JBOptionButton && (opts = (ob = (JBOptionButton)jb).getOptions()) != null) {
                    for (Action a : opts) {
                        AnAction anAct;
                        if (a == null || (anAct = BuildUtils._createAnAction(a, ob, true)) == null) continue;
                        prio[0] = (byte)(prio[0] - 1);
                        tbb = out.addAnActionButton(anAct).setShowMode(1).setModality(ms).setComponent(ob).setPriority(prio[0]);
                    }
                }
                if (tbb == null) continue;
                BuildUtils._setDialogLayout(tbb);
            }
        }
        if (actions != null && !actions.isEmpty()) {
            final ActionGroup ag = actions.values().iterator().next();
            TouchbarDataKeys.ActionDesc groupDesc = ag.getTemplatePresentation().getClientProperty(TouchbarDataKeys.ACTIONS_DESCRIPTOR_KEY);
            if (!hasSouthPanelButtons || groupDesc != null && groupDesc.isCombineWithDlgButtons()) {
                final Customizer customizer = new Customizer(groupDesc, ms){

                    @Override
                    public void process(@NotNull INodeInfo ni, @NotNull TBItemAnActionButton butt) {
                        if (ni == null) {
                            2.$$$reportNull$$$0(0);
                        }
                        if (butt == null) {
                            2.$$$reportNull$$$0(1);
                        }
                        super.process(ni, butt);
                        prio[0] = (byte)(prio[0] - 1);
                        butt.setPriority(prio[0]);
                        butt.myOptionalContextName = BuildUtils.DIALOG_ACTIONS_CONTEXT;
                        if (ni.getParentDesc() != null && !ni.getParentDesc().isShowImage()) {
                            butt.setShowMode(1);
                        }
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        Object[] objectArray;
                        Object[] objectArray2 = new Object[3];
                        switch (n) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[0] = "ni";
                                break;
                            }
                            case 1: {
                                objectArray = objectArray2;
                                objectArray2[0] = "butt";
                                break;
                            }
                        }
                        objectArray[1] = "com/intellij/ui/mac/touchbar/BuildUtils$2";
                        objectArray[2] = "process";
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                    }
                };
                BuildUtils.addActionGroup(out, ag, customizer);
                ag.addPropertyChangeListener(new PropertyChangeListener(){

                    @Override
                    public void propertyChange(PropertyChangeEvent evt) {
                        if (!"DefaultActionGroup.children".equals(evt.getPropertyName())) {
                            return;
                        }
                        AnAction[] prevArr = (AnAction[])evt.getOldValue();
                        AnAction[] currArr = (AnAction[])evt.getNewValue();
                        ArrayList prev = new ArrayList();
                        for (AnAction act : prevArr) {
                            BuildUtils._collectActions(act, prev);
                        }
                        ArrayList curr = new ArrayList();
                        for (AnAction act : currArr) {
                            BuildUtils._collectActions(act, curr);
                        }
                        if (prev != null && !prev.isEmpty()) {
                            if (curr != null && !curr.isEmpty()) {
                                if (curr.size() != prev.size()) {
                                    out.getItemsContainer().remove(tbi -> BuildUtils.DIALOG_ACTIONS_CONTEXT.equals(tbi.myOptionalContextName));
                                    BuildUtils.addActionGroup(out, ag, customizer);
                                } else {
                                    out.getItemsContainer().forEachDeep(tbi -> {
                                        if (!(tbi instanceof TBItemAnActionButton)) {
                                            return;
                                        }
                                        TBItemAnActionButton butt = (TBItemAnActionButton)tbi;
                                        int prevIndex = prev.indexOf(butt.getAnAction());
                                        if (prevIndex == -1) {
                                            return;
                                        }
                                        AnAction newAct = (AnAction)curr.get(prevIndex);
                                        butt.setAnAction(newAct);
                                    });
                                }
                            } else {
                                out.getItemsContainer().remove(tbi -> tbi instanceof TBItemAnActionButton && prev.contains(((TBItemAnActionButton)tbi).getAnAction()));
                            }
                        } else {
                            if (curr == null || curr.isEmpty()) {
                                return;
                            }
                            BuildUtils.addActionGroup(out, ag, customizer);
                        }
                        out.updateActionItems();
                    }
                });
            }
        }
        if (hasSouthPanelButtons) {
            TBItemGroup gr = out.addGroup();
            ItemsContainer group = gr.getContainer();
            List<TouchbarDataKeys.DlgButtonDesc> ordered = BuildUtils._extractOrderedButtons(unorderedButtons);
            for (TouchbarDataKeys.DlgButtonDesc desc : ordered) {
                JButton jb = unorderedButtons.get(desc);
                AnAction anAct = BuildUtils._createAnAction(jb.getAction(), jb, false);
                if (anAct == null) continue;
                TBItemAnActionButton tbb = out.createActionButton(anAct);
                tbb.setShowMode(1).setModality(ms).setComponent(jb);
                if (desc.isMainGroup()) {
                    group.addItem(tbb);
                } else {
                    out.getItemsContainer().addItem((TBItem)tbb, gr);
                    prio[0] = (byte)(prio[0] - 1);
                    tbb.setPriority(prio[0]);
                }
                boolean isDefault = desc.isDefault();
                if (!isDefault) {
                    boolean bl = jb.getAction() != null ? jb.getAction().getValue("DefaultAction") != null : (isDefault = jb.isDefaultButton());
                }
                if (isDefault) {
                    tbb.setColored(true);
                }
                BuildUtils._setDialogLayout(tbb);
            }
            out.selectVisibleItemsToShow();
            out.setPrincipal(gr);
        }
    }

    static TouchBar createScrubberBarFromPopup(@NotNull ListPopupImpl listPopup) {
        if (listPopup == null) {
            BuildUtils.$$$reportNull$$$0(16);
        }
        TouchBar result2 = new TouchBar("popup_scrubber_bar" + listPopup, true, false, true, null, null);
        ModalityStateEx ms = LaterInvocator.getCurrentModalityState();
        final TBItemScrubber scrub = result2.addScrubber();
        @NotNull ListPopupStep<Object> listPopupStep = listPopup.getListStep();
        @NotNull List<Object> stepValues = listPopupStep.getValues();
        ArrayList<Integer> disabledItems = new ArrayList<Integer>();
        int currIndex = 0;
        final HashMap<Object, Integer> obj2index = new HashMap<Object, Integer>();
        for (Object obj : stepValues) {
            Icon ic2 = listPopupStep.getIconFor(obj);
            String txt = listPopupStep.getTextFor(obj);
            if (listPopupStep.isMnemonicsNavigationEnabled()) {
                int pos;
                MnemonicNavigationFilter filter2 = listPopupStep.getMnemonicNavigationFilter();
                int n = pos = filter2 == null ? -1 : filter2.getMnemonicPos(obj);
                if (pos != -1) {
                    txt = txt.substring(0, pos) + txt.substring(pos + 1);
                }
            }
            Runnable edtAction = () -> {
                if (obj != null) {
                    listPopup.getList().setSelectedValue(obj, false);
                } else {
                    listPopup.getList().setSelectedIndex(stepValues.indexOf(obj));
                }
                listPopup.handleSelect(true);
            };
            Runnable action2 = () -> ApplicationManager.getApplication().invokeLater(edtAction, ms);
            scrub.addItem(ic2, txt, action2);
            if (!listPopupStep.isSelectable(obj)) {
                disabledItems.add(currIndex);
            }
            obj2index.put(obj, currIndex);
            ++currIndex;
        }
        final ListModel model = listPopup.getList().getModel();
        model.addListDataListener(new ListDataListener(){

            @Override
            public void intervalAdded(ListDataEvent e) {
            }

            @Override
            public void intervalRemoved(ListDataEvent e) {
            }

            @Override
            public void contentsChanged(ListDataEvent e) {
                ArrayList<Integer> visibleIndices = new ArrayList<Integer>();
                for (int c = 0; c < model.getSize(); ++c) {
                    Object visibleItem = model.getElementAt(c);
                    Integer itemId = (Integer)obj2index.get(visibleItem);
                    if (itemId == null) continue;
                    visibleIndices.add(itemId);
                }
                scrub.showItems(visibleIndices, true, true);
            }
        });
        result2.selectVisibleItemsToShow();
        scrub.enableItems(disabledItems, false);
        return result2;
    }

    static TouchBar createStopRunningBar(List<? extends Pair<RunContentDescriptor, Runnable>> stoppableDescriptors) {
        TouchBar tb = new TouchBar("select_running_configuration_to_stop", true, true, true, null, null);
        tb.addButton().setText("Stop All").setAction(() -> stoppableDescriptors.forEach(pair -> ((Runnable)pair.second).run()), true, null);
        TBItemScrubber stopScrubber = tb.addScrubber();
        for (Pair<RunContentDescriptor, Runnable> pair : stoppableDescriptors) {
            stopScrubber.addItem(((RunContentDescriptor)pair.first).getIcon(), ((RunContentDescriptor)pair.first).getDisplayName(), (Runnable)pair.second);
        }
        tb.selectVisibleItemsToShow();
        return tb;
    }

    @NotNull
    static String getActionId(@NotNull AnAction action2) {
        if (action2 == null) {
            BuildUtils.$$$reportNull$$$0(17);
        }
        String actionId = ActionManager.getInstance().getId(action2 instanceof CustomisedActionGroup ? ((CustomisedActionGroup)action2).getOrigin() : action2);
        String string = actionId == null ? action2.toString() : actionId;
        if (string == null) {
            BuildUtils.$$$reportNull$$$0(18);
        }
        return string;
    }

    private static void _setDialogLayout(TBItemButton button2) {
        if (button2 == null) {
            return;
        }
        button2.setLayout(107, 32768, 2, 16);
    }

    private static AnAction _createAnAction(final @Nullable Action action2, final @NotNull JButton fromButton, final boolean useTextFromAction) {
        Object anAct;
        if (fromButton == null) {
            BuildUtils.$$$reportNull$$$0(19);
        }
        Object object = anAct = action2 == null ? null : action2.getValue("AnAction");
        if (anAct == null) {
            return new DumbAwareAction(){
                {
                    this.setEnabledInModalContext(true);
                    if (useTextFromAction) {
                        Object name = action2 == null ? fromButton.getText() : action2.getValue("Name");
                        this.getTemplatePresentation().setText(name instanceof String ? (String)name : "");
                    }
                }

                @Override
                public void actionPerformed(@NotNull AnActionEvent e) {
                    if (e == null) {
                        5.$$$reportNull$$$0(0);
                    }
                    if (action2 == null) {
                        fromButton.doClick();
                        return;
                    }
                    action2.actionPerformed(new ActionEvent(fromButton, 1001, null));
                }

                @Override
                public void update(@NotNull AnActionEvent e) {
                    if (e == null) {
                        5.$$$reportNull$$$0(1);
                    }
                    e.getPresentation().setEnabled(action2 == null ? fromButton.isEnabled() : action2.isEnabled());
                    if (!useTextFromAction) {
                        e.getPresentation().setText((String)DialogWrapper.extractMnemonic((String)fromButton.getText()).second);
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    objectArray2[0] = "e";
                    objectArray2[1] = "com/intellij/ui/mac/touchbar/BuildUtils$5";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "actionPerformed";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[2] = "update";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            };
        }
        if (!(anAct instanceof AnAction)) {
            return null;
        }
        return (AnAction)anAct;
    }

    @Nullable
    private static List<TouchbarDataKeys.DlgButtonDesc> _extractOrderedButtons(@NotNull Map<TouchbarDataKeys.DlgButtonDesc, JButton> unorderedButtons) {
        if (unorderedButtons == null) {
            BuildUtils.$$$reportNull$$$0(20);
        }
        if (unorderedButtons.isEmpty()) {
            return null;
        }
        ArrayList<TouchbarDataKeys.DlgButtonDesc> main2 = new ArrayList<TouchbarDataKeys.DlgButtonDesc>();
        ArrayList<TouchbarDataKeys.DlgButtonDesc> secondary = new ArrayList<TouchbarDataKeys.DlgButtonDesc>();
        for (Map.Entry<TouchbarDataKeys.DlgButtonDesc, JButton> entry : unorderedButtons.entrySet()) {
            TouchbarDataKeys.DlgButtonDesc jbdesc = entry.getKey();
            if (jbdesc == null) continue;
            if (jbdesc.isMainGroup()) {
                main2.add(jbdesc);
                continue;
            }
            secondary.add(jbdesc);
        }
        Comparator<TouchbarDataKeys.DlgButtonDesc> cmp = Comparator.comparingInt(TouchbarDataKeys.DlgButtonDesc::getOrder);
        main2.sort(cmp);
        secondary.sort(cmp);
        return ContainerUtil.concat(secondary, main2);
    }

    private static void _collectActions(@NotNull AnAction act, @NotNull List<? super AnAction> out) {
        if (act == null) {
            BuildUtils.$$$reportNull$$$0(21);
        }
        if (out == null) {
            BuildUtils.$$$reportNull$$$0(22);
        }
        if (act instanceof ActionGroup) {
            AnAction[] children2;
            ActionGroup group = (ActionGroup)act;
            for (AnAction child2 : children2 = group.getChildren(null)) {
                if (child2 == null) continue;
                if (child2 instanceof ActionGroup) {
                    @NotNull ActionGroup childGroup = (ActionGroup)child2;
                    BuildUtils._collectActions(childGroup, out);
                    continue;
                }
                out.add(child2);
            }
        } else {
            out.add(act);
        }
    }

    private static void initSlowActions() {
        String[] muted;
        if (ourSlowActions != null) {
            return;
        }
        ourSlowActions = ConcurrentHashMap.newKeySet();
        if (PERSISTENT_LIST_OF_SLOW_ACTIONS && (muted = PropertiesComponent.getInstance().getValues(SLOW_UPDATE_ACTIONS_KEY)) != null) {
            Collections.addAll(ourSlowActions, muted);
        }
    }

    private static void saveSlowActions() {
        if (PERSISTENT_LIST_OF_SLOW_ACTIONS) {
            PropertiesComponent.getInstance().setValues(SLOW_UPDATE_ACTIONS_KEY, ArrayUtilRt.toStringArray(ourSlowActions));
        }
    }

    private static boolean isSlowUpdateAction(@NotNull String actionId) {
        if (actionId == null) {
            BuildUtils.$$$reportNull$$$0(23);
        }
        BuildUtils.initSlowActions();
        return ourSlowActions.contains(actionId);
    }

    private static boolean isSlowUpdateAction(@NotNull AnAction action2) {
        String actId;
        if (action2 == null) {
            BuildUtils.$$$reportNull$$$0(24);
        }
        if ((actId = ActionManager.getInstance().getId(action2)) == null) {
            return false;
        }
        return BuildUtils.isSlowUpdateAction(actId);
    }

    private static void addSlowUpdateAction(@NotNull AnAction action2) {
        String actId;
        if (action2 == null) {
            BuildUtils.$$$reportNull$$$0(25);
        }
        if ((actId = ActionManager.getInstance().getId(action2)) == null) {
            return;
        }
        BuildUtils.addSlowUpdateAction(actId);
    }

    private static void addSlowUpdateAction(@NotNull String actId) {
        if (actId == null) {
            BuildUtils.$$$reportNull$$$0(26);
        }
        BuildUtils.initSlowActions();
        ourSlowActions.add(actId);
        BuildUtils.saveSlowActions();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 5: 
            case 18: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 5: 
            case 18: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "touchbarName";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "customizedGroup";
                break;
            }
            case 2: 
            case 5: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ui/mac/touchbar/BuildUtils";
                break;
            }
            case 4: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actions";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "customizer";
                break;
            }
            case 11: 
            case 15: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "out";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionGroup";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "barId";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listPopup";
                break;
            }
            case 17: 
            case 24: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fromButton";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "unorderedButtons";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "act";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionId";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ui/mac/touchbar/BuildUtils";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildFromCustomizedGroup";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "buildFromGroup";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildFromCustomizedGroup";
                break;
            }
            case 2: 
            case 5: 
            case 18: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "buildFromGroup";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "addActionGroup";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "addActionGroupButtons";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getCustomizedGroup";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getAltLayouts";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "addDialogButtons";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "createScrubberBarFromPopup";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getActionId";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "_createAnAction";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "_extractOrderedButtons";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "_collectActions";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "isSlowUpdateAction";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "addSlowUpdateAction";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 5: 
            case 18: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static class Customizer {
        private final int myShowMode;
        @Nullable
        private final ModalityState myModality;
        private TBItemAnActionButton myRunConfigurationButton;
        private List<TBItemAnActionButton> myRunnerButtons;

        Customizer(int showMode, @Nullable ModalityState modality) {
            this.myShowMode = showMode;
            this.myModality = modality;
        }

        Customizer(@Nullable TouchbarDataKeys.ActionDesc groupDesc, @Nullable ModalityState modality) {
            this.myShowMode = groupDesc == null || !groupDesc.isShowText() ? 3 : 2;
            this.myModality = modality;
        }

        Customizer() {
            this.myShowMode = 3;
            this.myModality = null;
        }

        void process(@NotNull INodeInfo ni, @NotNull TBItemAnActionButton butt) {
            if (ni == null) {
                Customizer.$$$reportNull$$$0(0);
            }
            if (butt == null) {
                Customizer.$$$reportNull$$$0(1);
            }
            @NotNull String actId = BuildUtils.getActionId(butt.getAnAction());
            boolean isRunConfigPopover = "RunConfiguration".equals(actId);
            boolean isOpenInTerminalAction = "Terminal.OpenInTerminal".equals(actId);
            TouchbarDataKeys.ActionDesc pd = ni.getParentDesc();
            int nodeMode = pd != null && pd.isShowText() ? 2 : this.myShowMode;
            int mode = isRunConfigPopover || isOpenInTerminalAction ? 2 : nodeMode;
            butt.setShowMode(mode).setModality(this.myModality);
            if (ni.isParentCompact()) {
                butt.setHiddenWhenDisabled(true);
            }
            if (isRunConfigPopover) {
                this.myRunConfigurationButton = butt;
            } else if (butt.getAnAction() instanceof WelcomePopupAction) {
                butt.setHasArrowIcon(true);
            } else if ("RunnerActionsTouchbar".equals(ni.getParentGroupID()) || "Stop".equals(actId)) {
                if (this.myRunnerButtons == null) {
                    this.myRunnerButtons = new ArrayList<TBItemAnActionButton>();
                }
                this.myRunnerButtons.add(butt);
            }
            TouchbarDataKeys.ActionDesc actionDesc = butt.getAnAction().getTemplatePresentation().getClientProperty(TouchbarDataKeys.ACTIONS_DESCRIPTOR_KEY);
            if (actionDesc != null && actionDesc.getContextComponent() != null) {
                butt.setComponent(actionDesc.getContextComponent());
            }
        }

        void finish() {
            if (this.myRunConfigurationButton != null && this.myRunnerButtons != null && !this.myRunnerButtons.isEmpty()) {
                this.myRunConfigurationButton.setLinkedButtons(this.myRunnerButtons);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "ni";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "butt";
                    break;
                }
            }
            objectArray[1] = "com/intellij/ui/mac/touchbar/BuildUtils$Customizer";
            objectArray[2] = "process";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    static interface INodeInfo {
        public boolean isParentCompact();

        public String getParentGroupID();

        public TouchbarDataKeys.ActionDesc getParentDesc();
    }

    private static final class InternalNodeWithContainer
    extends GroupVisitor.InternalNode {
        @NotNull
        final ItemsContainer container;

        InternalNodeWithContainer(@NotNull ItemsContainer container2, @NotNull ActionGroup group, @NotNull String groupID, @Nullable TouchbarDataKeys.ActionDesc groupDesc, @Nullable TouchBarStats.AnActionStats stats) {
            if (container2 == null) {
                InternalNodeWithContainer.$$$reportNull$$$0(0);
            }
            if (group == null) {
                InternalNodeWithContainer.$$$reportNull$$$0(1);
            }
            if (groupID == null) {
                InternalNodeWithContainer.$$$reportNull$$$0(2);
            }
            super(group, groupID, groupDesc, stats);
            this.container = container2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "container";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "group";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "groupID";
                    break;
                }
            }
            objectArray[1] = "com/intellij/ui/mac/touchbar/BuildUtils$InternalNodeWithContainer";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    static class GroupVisitor
    implements INodeInfo,
    Utils.ActionGroupVisitor {
        @NotNull
        private final TouchBar myOut;
        @Nullable
        private final String myFilterByPrefix;
        @Nullable
        private final Customizer myCustomizer;
        private final boolean myAllowSkipSlowUpdates;
        private int mySeparatorCounter;
        private final LinkedList<InternalNode> myNodePath;
        private final List<InternalNode> myVisitedNodes;
        private InternalNodeWithContainer myRoot;
        private final Map<AnAction, Long> myAct2StartUpdateNs;
        @Nullable
        private final TouchBarStats myStats;

        GroupVisitor(@NotNull TouchBar out, @Nullable String filterByPrefix, @Nullable Customizer customizer, @Nullable TouchBarStats stats, boolean allowSkipSlowUpdates) {
            if (out == null) {
                GroupVisitor.$$$reportNull$$$0(0);
            }
            this.mySeparatorCounter = 0;
            this.myNodePath = new LinkedList();
            this.myVisitedNodes = new ArrayList<InternalNode>();
            this.myAct2StartUpdateNs = new ConcurrentHashMap<AnAction, Long>();
            this.myOut = out;
            this.myFilterByPrefix = filterByPrefix;
            this.myCustomizer = customizer;
            this.myStats = stats;
            this.myAllowSkipSlowUpdates = allowSkipSlowUpdates;
        }

        @Override
        public Component getCustomComponent(@NotNull AnAction action2) {
            TouchbarDataKeys.ActionDesc actionDesc;
            if (action2 == null) {
                GroupVisitor.$$$reportNull$$$0(1);
            }
            return (actionDesc = action2.getTemplatePresentation().getClientProperty(TouchbarDataKeys.ACTIONS_DESCRIPTOR_KEY)) != null ? actionDesc.getContextComponent() : null;
        }

        @Nullable
        private TouchBarStats.AnActionStats getActionStats(@NotNull String actId) {
            if (actId == null) {
                GroupVisitor.$$$reportNull$$$0(2);
            }
            return this.myStats == null ? null : this.myStats.getActionStats(actId);
        }

        @Override
        public void begin() {
            this.myOut.softClear();
        }

        @Override
        public boolean enterNode(@NotNull ActionGroup groupNode) {
            if (groupNode == null) {
                GroupVisitor.$$$reportNull$$$0(3);
            }
            @NotNull String groupId2 = BuildUtils.getActionId(groupNode);
            if (this.myFilterByPrefix != null && groupId2.startsWith(this.myFilterByPrefix)) {
                return false;
            }
            if (this.myRoot == null) {
                this.myRoot = new InternalNodeWithContainer(this.myOut.getItemsContainer(), groupNode, groupId2, null, this.getActionStats(groupId2));
            }
            TouchbarDataKeys.ActionDesc groupDesc = groupNode.getTemplatePresentation().getClientProperty(TouchbarDataKeys.ACTIONS_DESCRIPTOR_KEY);
            InternalNode node = null;
            if (groupDesc != null && groupDesc.isMainGroup()) {
                @NotNull InternalNodeWithContainer currNode = this._getCurrentNodeContainer();
                TBItemGroup group = this.myOut.createGroup();
                currNode.container.addItem(group);
                this.myOut.setPrincipal(group);
                node = new InternalNodeWithContainer(group.getContainer(), groupNode, groupId2, groupDesc, this.getActionStats(groupId2));
            }
            if (node == null) {
                node = new InternalNode(groupNode, groupId2, groupDesc, this.getActionStats(groupId2));
            }
            this.myNodePath.add(node);
            this.myVisitedNodes.add(node);
            return true;
        }

        @Override
        public void visitLeaf(@NotNull AnAction act) {
            if (act == null) {
                GroupVisitor.$$$reportNull$$$0(4);
            }
            @NotNull InternalNodeWithContainer currNode = this._getCurrentNodeContainer();
            if (act instanceof Separator) {
                Separator sep = (Separator)act;
                int increment = 1;
                if (sep.getText() != null) {
                    if (sep.getText().equals(BuildUtils.ourSmallSeparatorText)) {
                        currNode.container.addSpacing(false);
                    } else if (sep.getText().equals(BuildUtils.ourLargeSeparatorText)) {
                        currNode.container.addSpacing(true);
                    } else if (sep.getText().equals(BuildUtils.ourFlexibleSeparatorText)) {
                        currNode.container.addFlexibleSpacing();
                    }
                } else {
                    this.mySeparatorCounter += increment;
                }
                return;
            }
            if (this.mySeparatorCounter > 0) {
                if (this.mySeparatorCounter == 1) {
                    currNode.container.addSpacing(false);
                } else if (this.mySeparatorCounter == 2) {
                    currNode.container.addSpacing(true);
                } else {
                    currNode.container.addFlexibleSpacing();
                }
                this.mySeparatorCounter = 0;
            }
            TBItemAnActionButton butt = this.myOut.createActionButton(act);
            currNode.container.addItem(butt);
            if (this.myCustomizer != null) {
                this.myCustomizer.process(this, butt);
            }
        }

        @Override
        public void leaveNode() {
            InternalNode leaved = this.myNodePath.removeLast();
            leaved.leaveTimeNs = System.nanoTime();
        }

        @Override
        public boolean beginUpdate(@NotNull AnAction action2, AnActionEvent e) {
            if (action2 == null) {
                GroupVisitor.$$$reportNull$$$0(5);
            }
            if (SKIP_UPDATE_SLOW_ACTIONS && this.myAllowSkipSlowUpdates && BuildUtils.isSlowUpdateAction(action2)) {
                e.getPresentation().setEnabledAndVisible(true);
                if (action2 instanceof Toggleable) {
                    Toggleable.setSelected(e.getPresentation(), false);
                }
                return false;
            }
            this.myAct2StartUpdateNs.put(action2, System.nanoTime());
            return true;
        }

        @Override
        public void endUpdate(@NotNull AnAction action2) {
            if (action2 == null) {
                GroupVisitor.$$$reportNull$$$0(6);
            }
            long updateDurationNs = System.nanoTime() - this.myAct2StartUpdateNs.getOrDefault(action2, 0L);
            boolean isEDT = ApplicationManager.getApplication().isDispatchThread();
            if (isEDT && SKIP_UPDATE_SLOW_ACTIONS && this.myAllowSkipSlowUpdates && updateDurationNs > 30000000L) {
                BuildUtils.addSlowUpdateAction(action2);
            }
            if (this.myStats != null) {
                TouchBarStats.AnActionStats stats = this.myStats.getActionStats(action2);
                stats.onUpdate(updateDurationNs);
            }
        }

        @Override
        public boolean isParentCompact() {
            return !this.myNodePath.isEmpty() && this.myNodePath.getLast().group instanceof CompactActionGroup;
        }

        @Override
        public String getParentGroupID() {
            if (this.myNodePath.isEmpty()) {
                return null;
            }
            return this.myNodePath.getLast().groupID;
        }

        @Override
        public TouchbarDataKeys.ActionDesc getParentDesc() {
            if (this.myNodePath.isEmpty()) {
                return null;
            }
            return this.myNodePath.getLast().groupDesc;
        }

        @NotNull
        private InternalNodeWithContainer _getCurrentNodeContainer() {
            if (this.myNodePath.isEmpty()) {
                InternalNodeWithContainer internalNodeWithContainer = this.myRoot;
                if (internalNodeWithContainer == null) {
                    GroupVisitor.$$$reportNull$$$0(7);
                }
                return internalNodeWithContainer;
            }
            Iterator<InternalNode> di = this.myNodePath.descendingIterator();
            while (di.hasNext()) {
                InternalNode in = di.next();
                if (!(in instanceof InternalNodeWithContainer)) continue;
                InternalNodeWithContainer internalNodeWithContainer = (InternalNodeWithContainer)in;
                if (internalNodeWithContainer == null) {
                    GroupVisitor.$$$reportNull$$$0(8);
                }
                return internalNodeWithContainer;
            }
            InternalNodeWithContainer internalNodeWithContainer = this.myRoot;
            if (internalNodeWithContainer == null) {
                GroupVisitor.$$$reportNull$$$0(9);
            }
            return internalNodeWithContainer;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 7: 
                case 8: 
                case 9: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 7: 
                case 8: 
                case 9: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "out";
                    break;
                }
                case 1: 
                case 5: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "action";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "actId";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "groupNode";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "act";
                    break;
                }
                case 7: 
                case 8: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ui/mac/touchbar/BuildUtils$GroupVisitor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ui/mac/touchbar/BuildUtils$GroupVisitor";
                    break;
                }
                case 7: 
                case 8: 
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "_getCurrentNodeContainer";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "getCustomComponent";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "getActionStats";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "enterNode";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "visitLeaf";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "beginUpdate";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "endUpdate";
                    break;
                }
                case 7: 
                case 8: 
                case 9: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 7: 
                case 8: 
                case 9: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }

        private static class InternalNode {
            @NotNull
            final ActionGroup group;
            @NotNull
            final String groupID;
            @Nullable
            final TouchbarDataKeys.ActionDesc groupDesc;
            @Nullable
            final TouchBarStats.AnActionStats myActionStats;
            final long bornTimeNs;
            long leaveTimeNs;

            InternalNode(@NotNull ActionGroup group, @NotNull String groupID, @Nullable TouchbarDataKeys.ActionDesc groupDesc, @Nullable TouchBarStats.AnActionStats stats) {
                if (group == null) {
                    InternalNode.$$$reportNull$$$0(0);
                }
                if (groupID == null) {
                    InternalNode.$$$reportNull$$$0(1);
                }
                this.group = group;
                this.groupID = groupID;
                this.groupDesc = groupDesc;
                this.myActionStats = stats;
                this.bornTimeNs = System.nanoTime();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "group";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "groupID";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/ui/mac/touchbar/BuildUtils$GroupVisitor$InternalNode";
                objectArray[2] = "<init>";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }
    }
}

