/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.mac.touchbar;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.execution.util.ExecUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.ui.mac.foundation.Foundation;
import com.intellij.ui.mac.foundation.ID;
import com.intellij.ui.mac.touchbar.NSAutoreleaseLock;
import java.io.IOException;

public final class Utils {
    private static final Logger LOG = Logger.getInstance(Utils.class);
    private static final String TB_SERVER_PROCESS = SystemInfo.isMacOSHighSierra ? "TouchBarServer" : "TouchBarAgent";

    public static boolean isTouchBarServerRunning() {
        GeneralCommandLine cmdLine = new GeneralCommandLine(new String[]{"pgrep", TB_SERVER_PROCESS}).withParentEnvironmentType(GeneralCommandLine.ParentEnvironmentType.SYSTEM);
        try {
            ProcessOutput out = ExecUtil.execAndGetOutput((GeneralCommandLine)cmdLine);
            return !out.getStdout().isEmpty();
        }
        catch (ExecutionException e) {
            LOG.error(e);
            return false;
        }
    }

    public static boolean restartTouchBarServer() {
        try {
            GeneralCommandLine cmdLine = new GeneralCommandLine(new String[]{"pkill", TB_SERVER_PROCESS}).withParentEnvironmentType(GeneralCommandLine.ParentEnvironmentType.SYSTEM);
            ProcessOutput out = ExecUtil.sudoAndGetOutput((GeneralCommandLine)cmdLine, (String)"");
            return out.getStderr().isEmpty();
        }
        catch (ExecutionException | IOException e) {
            LOG.error(e);
            return false;
        }
    }

    public static String getAppId() {
        String appId;
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return null;
        }
        try (NSAutoreleaseLock lock = new NSAutoreleaseLock();){
            ID bundle = Foundation.invoke("NSBundle", "mainBundle", new Object[0]);
            ID dict = Foundation.invoke(bundle, "infoDictionary", new Object[0]);
            ID nsAppID = Foundation.invoke(dict, "objectForKey:", new Object[]{Foundation.nsString("CFBundleIdentifier")});
            appId = Foundation.toStringViaUTF8(nsAppID);
        }
        if (appId == null || appId.isEmpty()) {
            LOG.error("can't obtain application id from NSBundle.mainBundle");
        }
        return appId;
    }
}

