/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.messages;

import com.intellij.BundleBase;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.openapi.wm.impl.ModalityHelper;
import com.intellij.ui.mac.MacMessagesEmulation;
import com.intellij.ui.mac.foundation.MacUtil;
import com.intellij.ui.messages.SheetMessage;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import javax.swing.Icon;
import javax.swing.JDialog;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JBMacMessages
extends MacMessagesEmulation {
    @Override
    public int showYesNoCancelDialog(@NotNull String title, String message, @NotNull String defaultButton, String alternateButton, String otherButton, @Nullable Window window, @Nullable DialogWrapper.DoNotAskOption doNotAskOption) {
        int result2;
        if (title == null) {
            JBMacMessages.$$$reportNull$$$0(0);
        }
        if (defaultButton == null) {
            JBMacMessages.$$$reportNull$$$0(1);
        }
        if (window == null) {
            window = JBMacMessages.getForemostWindow(null);
        }
        String defaultButtonCleaned = defaultButton.replace(BundleBase.MNEMONIC_STRING, "");
        String otherButtonCleaned = otherButton.replace(BundleBase.MNEMONIC_STRING, "");
        String alternateButtonCleaned = alternateButton.replace(BundleBase.MNEMONIC_STRING, "");
        SheetMessage sheetMessage = new SheetMessage(window, title, message, UIUtil.getQuestionIcon(), new String[]{defaultButtonCleaned, otherButtonCleaned, alternateButtonCleaned}, doNotAskOption, defaultButton, alternateButton);
        String resultString = sheetMessage.getResult();
        int n = resultString.equals(defaultButtonCleaned) ? 0 : (result2 = resultString.equals(alternateButtonCleaned) ? 1 : 2);
        if (doNotAskOption != null) {
            doNotAskOption.setToBeShown(sheetMessage.toBeShown(), result2);
        }
        return result2;
    }

    @Override
    public int showMessageDialog(@NotNull String title, String message, String @NotNull [] buttons, boolean errorStyle, @Nullable Window window, int defaultOptionIndex, int focusedOptionIndex, @Nullable DialogWrapper.DoNotAskOption doNotAskDialogOption) {
        if (title == null) {
            JBMacMessages.$$$reportNull$$$0(2);
        }
        if (buttons == null) {
            JBMacMessages.$$$reportNull$$$0(3);
        }
        if (window == null) {
            window = JBMacMessages.getForemostWindow(null);
        }
        Icon icon2 = errorStyle ? UIUtil.getErrorIcon() : UIUtil.getInformationIcon();
        String defaultOptionTitle = defaultOptionIndex != -1 ? buttons[defaultOptionIndex] : null;
        String focusedButtonTitle = focusedOptionIndex != -1 ? buttons[focusedOptionIndex] : null;
        SheetMessage sheetMessage = new SheetMessage(window, title, message, icon2, buttons, doNotAskDialogOption, defaultOptionTitle, focusedButtonTitle);
        String result2 = sheetMessage.getResult();
        for (int i = 0; i < buttons.length; ++i) {
            if (!result2.equals(buttons[i])) continue;
            if (doNotAskDialogOption != null) {
                doNotAskDialogOption.setToBeShown(sheetMessage.toBeShown(), i);
            }
            return i;
        }
        return -1;
    }

    @Override
    public void showOkMessageDialog(@NotNull String title, String message, @NotNull String okText, @Nullable Window window) {
        if (title == null) {
            JBMacMessages.$$$reportNull$$$0(4);
        }
        if (okText == null) {
            JBMacMessages.$$$reportNull$$$0(5);
        }
        if (window == null) {
            window = JBMacMessages.getForemostWindow(null);
        }
        new SheetMessage(window, title, message, UIUtil.getInformationIcon(), new String[]{okText}, null, okText, okText);
    }

    @Override
    public void showOkMessageDialog(@NotNull String title, String message, @NotNull String okText) {
        if (title == null) {
            JBMacMessages.$$$reportNull$$$0(6);
        }
        if (okText == null) {
            JBMacMessages.$$$reportNull$$$0(7);
        }
        Window foremostWindow = JBMacMessages.getForemostWindow(null);
        new SheetMessage(foremostWindow, title, message, UIUtil.getInformationIcon(), new String[]{okText}, null, null, okText);
    }

    private static Window getForemostWindow(Window window) {
        Window _window = null;
        IdeFocusManager ideFocusManager = IdeFocusManager.getGlobalInstance();
        Component focusOwner = IdeFocusManager.findInstance().getFocusOwner();
        if (focusOwner != null) {
            _window = SwingUtilities.getWindowAncestor(focusOwner);
        }
        if (_window == null && (focusOwner = ideFocusManager.getLastFocusedFor(ideFocusManager.getLastFocusedIdeWindow())) != null) {
            _window = SwingUtilities.getWindowAncestor(focusOwner);
        }
        if (_window == null) {
            _window = KeyboardFocusManager.getCurrentKeyboardFocusManager().getActiveWindow();
        }
        if (_window == null) {
            _window = WindowManager.getInstance().findVisibleFrame();
        }
        if (_window == null && window != null && (focusOwner = window.getMostRecentFocusOwner()) != null) {
            _window = SwingUtilities.getWindowAncestor(focusOwner);
        }
        if (_window != null && ModalityHelper.isModalBlocked(_window)) {
            _window = ModalityHelper.getModalBlockerFor(_window);
        }
        while (_window != null && MacUtil.getWindowTitle(_window) == null) {
            _window = _window.getOwner();
        }
        while (Registry.is("skip.untitled.windows.for.mac.messages") && _window instanceof JDialog && !((JDialog)_window).isModal()) {
            _window = _window.getOwner();
        }
        return _window;
    }

    @Override
    public int showYesNoDialog(@NotNull String title, String message, @NotNull String yesButton, @NotNull String noButton, @Nullable Window window) {
        SheetMessage sheetMessage;
        if (title == null) {
            JBMacMessages.$$$reportNull$$$0(8);
        }
        if (yesButton == null) {
            JBMacMessages.$$$reportNull$$$0(9);
        }
        if (noButton == null) {
            JBMacMessages.$$$reportNull$$$0(10);
        }
        if (window == null) {
            window = JBMacMessages.getForemostWindow(null);
        }
        return (sheetMessage = new SheetMessage(window, title, message, UIUtil.getQuestionIcon(), new String[]{yesButton, noButton}, null, yesButton, noButton)).getResult().equals(yesButton) ? 0 : 1;
    }

    @Override
    public int showYesNoDialog(@NotNull String title, String message, @NotNull String yesButton, @NotNull String noButton, @Nullable Window window, @Nullable DialogWrapper.DoNotAskOption doNotAskDialogOption) {
        SheetMessage sheetMessage;
        int result2;
        if (title == null) {
            JBMacMessages.$$$reportNull$$$0(11);
        }
        if (yesButton == null) {
            JBMacMessages.$$$reportNull$$$0(12);
        }
        if (noButton == null) {
            JBMacMessages.$$$reportNull$$$0(13);
        }
        if (window == null) {
            window = JBMacMessages.getForemostWindow(null);
        }
        int n = result2 = (sheetMessage = new SheetMessage(window, title, message, UIUtil.getQuestionIcon(), new String[]{yesButton, noButton}, doNotAskDialogOption, yesButton, noButton)).getResult().equals(yesButton) ? 0 : 1;
        if (doNotAskDialogOption != null && (result2 == 0 || doNotAskDialogOption.shouldSaveOptionsOnCancel())) {
            doNotAskDialogOption.setToBeShown(sheetMessage.toBeShown(), result2);
        }
        return result2;
    }

    @Override
    public void showErrorDialog(@NotNull String title, String message, @NotNull String okButton, @Nullable Window window) {
        if (title == null) {
            JBMacMessages.$$$reportNull$$$0(14);
        }
        if (okButton == null) {
            JBMacMessages.$$$reportNull$$$0(15);
        }
        if (window == null) {
            window = JBMacMessages.getForemostWindow(null);
        }
        new SheetMessage(window, title, message, UIUtil.getErrorIcon(), new String[]{okButton}, null, null, okButton);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultButton";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buttons";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "okText";
                break;
            }
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "yesButton";
                break;
            }
            case 10: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "noButton";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "okButton";
                break;
            }
        }
        objectArray2[1] = "com/intellij/ui/messages/JBMacMessages";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "showYesNoCancelDialog";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "showMessageDialog";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "showOkMessageDialog";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[2] = "showYesNoDialog";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[2] = "showErrorDialog";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

