/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.messages;

import com.intellij.credentialStore.CredentialPromptDialog;
import com.intellij.diagnostic.LoadingState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogBuilder;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.DialogWrapperPeer;
import com.intellij.openapi.ui.InputValidator;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.messages.MessageDialog;
import com.intellij.openapi.ui.messages.MessagesService;
import com.intellij.openapi.ui.messages.TwoStepConfirmationDialog;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.ui.InsertPathAction;
import com.intellij.ui.MessageException;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.mac.MacMessages;
import com.intellij.ui.messages.ChooseDialog;
import com.intellij.ui.messages.InputDialogWithCheckbox;
import com.intellij.ui.messages.MoreInfoMessageDialog;
import com.intellij.ui.messages.PasswordInputDialog;
import com.intellij.util.Function;
import com.intellij.util.PairFunction;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Window;
import java.util.Arrays;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.text.JTextComponent;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MessagesServiceImpl
implements MessagesService {
    private static final Logger LOG = Logger.getInstance(MessagesServiceImpl.class);

    @Override
    public int showMessageDialog(@Nullable Project project2, @Nullable Component parentComponent, String message, @Nls(capitalization=Nls.Capitalization.Title) String title, String @NotNull [] options, int defaultOptionIndex, int focusedOptionIndex, @Nullable Icon icon2, @Nullable DialogWrapper.DoNotAskOption doNotAskOption, boolean alwaysUseIdeaUI) {
        if (options == null) {
            MessagesServiceImpl.$$$reportNull$$$0(0);
        }
        if (Messages.isApplicationInUnitTestOrHeadless()) {
            return Messages.getTestImplementation().show(message);
        }
        try {
            if (Messages.canShowMacSheetPanel() && !alwaysUseIdeaUI) {
                WindowManager windowManager;
                WindowManager windowManager2 = windowManager = LoadingState.COMPONENTS_REGISTERED.isOccurred() ? WindowManager.getInstance() : null;
                if (windowManager != null) {
                    Window parentWindow = windowManager.suggestParentWindow(project2);
                    return MacMessages.getInstance().showMessageDialog(title, message, options, false, parentWindow, defaultOptionIndex, focusedOptionIndex, doNotAskOption);
                }
            }
        }
        catch (MessageException windowManager) {
        }
        catch (Exception reportThis) {
            LOG.error(reportThis);
        }
        MessageDialog dialog2 = new MessageDialog(project2, parentComponent, message, title, options, defaultOptionIndex, focusedOptionIndex, icon2, doNotAskOption, false);
        dialog2.show();
        return dialog2.getExitCode();
    }

    @Override
    public int showMoreInfoMessageDialog(Project project2, String message, String title, String moreInfo, String[] options, int defaultOptionIndex, int focusedOptionIndex, Icon icon2) {
        if (Messages.isApplicationInUnitTestOrHeadless()) {
            return Messages.getTestImplementation().show(message);
        }
        try {
            if (Messages.canShowMacSheetPanel() && moreInfo == null) {
                return MacMessages.getInstance().showMessageDialog(title, message, options, false, WindowManager.getInstance().suggestParentWindow(project2), defaultOptionIndex, focusedOptionIndex, null);
            }
        }
        catch (MessageException messageException) {
        }
        catch (Exception reportThis) {
            LOG.error(reportThis);
        }
        MoreInfoMessageDialog dialog2 = new MoreInfoMessageDialog(project2, message, title, moreInfo, options, defaultOptionIndex, focusedOptionIndex, icon2);
        dialog2.show();
        return dialog2.getExitCode();
    }

    @Override
    public int showTwoStepConfirmationDialog(String message, String title, String[] options, String checkboxText, boolean checked, int defaultOptionIndex, int focusedOptionIndex, Icon icon2, PairFunction<? super Integer, ? super JCheckBox, Integer> exitFunc) {
        if (Messages.isApplicationInUnitTestOrHeadless()) {
            return Messages.getTestImplementation().show(message);
        }
        TwoStepConfirmationDialog dialog2 = new TwoStepConfirmationDialog(message, title, options, checkboxText, checked, defaultOptionIndex, focusedOptionIndex, icon2, exitFunc);
        dialog2.show();
        return dialog2.getExitCode();
    }

    @Override
    public String showPasswordDialog(Project project2, String message, String title, Icon icon2, InputValidator validator2) {
        if (Messages.isApplicationInUnitTestOrHeadless()) {
            return Messages.getTestInputImplementation().show(message, validator2);
        }
        PasswordInputDialog dialog2 = project2 != null ? new PasswordInputDialog(project2, message, title, icon2, validator2) : new PasswordInputDialog(message, title, icon2, validator2);
        dialog2.show();
        return dialog2.getInputString();
    }

    @Override
    public char[] showPasswordDialog(@NotNull Component parentComponent, String message, String title, Icon icon2, @Nullable InputValidator validator2) {
        if (parentComponent == null) {
            MessagesServiceImpl.$$$reportNull$$$0(1);
        }
        if (Messages.isApplicationInUnitTestOrHeadless()) {
            return Messages.getTestInputImplementation().show(message, validator2).toCharArray();
        }
        PasswordInputDialog dialog2 = new PasswordInputDialog(parentComponent, message, title, icon2, validator2);
        dialog2.show();
        return dialog2.getExitCode() == 0 ? CredentialPromptDialog.getTrimmedChars(dialog2.getTextField()) : null;
    }

    @Override
    public String showInputDialog(@Nullable Project project2, Component parentComponent, String message, String title, @Nullable Icon icon2, @Nullable String initialValue, @Nullable InputValidator validator2, @Nullable TextRange selection, @Nullable String comment) {
        if (Messages.isApplicationInUnitTestOrHeadless()) {
            return Messages.getTestInputImplementation().show(message, validator2);
        }
        Messages.InputDialog dialog2 = new Messages.InputDialog(project2, message, title, icon2, initialValue, validator2, new String[]{Messages.getOkButton(), Messages.getCancelButton()}, 0, comment);
        JTextComponent field = dialog2.getTextField();
        if (selection != null) {
            field.select(selection.getStartOffset(), selection.getEndOffset());
            field.putClientProperty(DialogWrapperPeer.HAVE_INITIAL_SELECTION, true);
        }
        dialog2.show();
        return dialog2.getInputString();
    }

    @Override
    public String showMultilineInputDialog(Project project2, String message, String title, String initialValue, Icon icon2, @Nullable InputValidator validator2) {
        if (Messages.isApplicationInUnitTestOrHeadless()) {
            return Messages.getTestInputImplementation().show(message, validator2);
        }
        Messages.MultilineInputDialog dialog2 = new Messages.MultilineInputDialog(project2, message, title, icon2, initialValue, validator2, new String[]{Messages.getOkButton(), Messages.getCancelButton()}, 0);
        dialog2.show();
        return dialog2.getInputString();
    }

    @Override
    public Pair<String, Boolean> showInputDialogWithCheckBox(String message, String title, String checkboxText, boolean checked, boolean checkboxEnabled, Icon icon2, String initialValue, InputValidator validator2) {
        if (Messages.isApplicationInUnitTestOrHeadless()) {
            return new Pair<String, Boolean>(Messages.getTestInputImplementation().show(message), checked);
        }
        InputDialogWithCheckbox dialog2 = new InputDialogWithCheckbox(message, title, checkboxText, checked, checkboxEnabled, icon2, initialValue, validator2);
        dialog2.show();
        return Pair.create(dialog2.getInputString(), dialog2.isChecked());
    }

    @Override
    public String showEditableChooseDialog(String message, String title, Icon icon2, String[] values2, String initialValue, InputValidator validator2) {
        if (Messages.isApplicationInUnitTestOrHeadless()) {
            return Messages.getTestInputImplementation().show(message, validator2);
        }
        ChooseDialog dialog2 = new ChooseDialog(message, title, icon2, values2, initialValue);
        dialog2.setValidator(validator2);
        dialog2.getComboBox().setEditable(true);
        dialog2.getComboBox().getEditor().setItem(initialValue);
        dialog2.getComboBox().setSelectedItem(initialValue);
        dialog2.show();
        return dialog2.getInputString();
    }

    @Override
    public int showChooseDialog(@Nullable Project project2, @Nullable Component parentComponent, String message, String title, String[] values2, String initialValue, @Nullable Icon icon2) {
        if (Messages.isApplicationInUnitTestOrHeadless()) {
            return Messages.getTestImplementation().show(message);
        }
        ChooseDialog dialog2 = new ChooseDialog(project2, parentComponent, message, title, icon2, values2, initialValue);
        dialog2.show();
        return dialog2.getSelectedIndex();
    }

    @Override
    public void showTextAreaDialog(JTextField textField2, String title, String dimensionServiceKey, Function<? super String, ? extends List<String>> parser, Function<? super List<String>, String> lineJoiner) {
        if (Messages.isApplicationInUnitTestOrHeadless()) {
            Messages.getTestImplementation().show(title);
            return;
        }
        JTextArea textArea = new JTextArea(10, 50);
        UIUtil.addUndoRedoActions(textArea);
        textArea.setWrapStyleWord(true);
        textArea.setLineWrap(true);
        List<String> lines = parser.fun(textField2.getText());
        textArea.setText(StringUtil.join(lines, "\n"));
        InsertPathAction.copyFromTo(textField2, textArea);
        DialogBuilder builder2 = new DialogBuilder(textField2);
        builder2.setDimensionServiceKey(dimensionServiceKey);
        builder2.setCenterPanel(ScrollPaneFactory.createScrollPane(textArea));
        builder2.setPreferredFocusComponent(textArea);
        String rawText = title;
        if (StringUtil.endsWithChar(rawText, ':')) {
            rawText = rawText.substring(0, rawText.length() - 1);
        }
        builder2.setTitle(rawText);
        builder2.addOkAction();
        builder2.addCancelAction();
        builder2.setOkOperation(() -> {
            textField2.setText((String)lineJoiner.fun(Arrays.asList(StringUtil.splitByLines(textArea.getText()))));
            builder2.getDialogWrapper().close(0);
        });
        builder2.show();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentComponent";
                break;
            }
        }
        objectArray2[1] = "com/intellij/ui/messages/MessagesServiceImpl";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "showMessageDialog";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "showPasswordDialog";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

